// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accounts

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	accountspb "cloud.google.com/go/shopping/merchant/accounts/apiv1beta/accountspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
)

var newAutomaticImprovementsClientHook clientHook

// AutomaticImprovementsCallOptions contains the retry settings for each method of AutomaticImprovementsClient.
type AutomaticImprovementsCallOptions struct {
	GetAutomaticImprovements    []gax.CallOption
	UpdateAutomaticImprovements []gax.CallOption
}

func defaultAutomaticImprovementsGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("merchantapi.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("merchantapi.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("merchantapi.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAutomaticImprovementsCallOptions() *AutomaticImprovementsCallOptions {
	return &AutomaticImprovementsCallOptions{
		GetAutomaticImprovements: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateAutomaticImprovements: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultAutomaticImprovementsRESTCallOptions() *AutomaticImprovementsCallOptions {
	return &AutomaticImprovementsCallOptions{
		GetAutomaticImprovements: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateAutomaticImprovements: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalAutomaticImprovementsClient is an interface that defines the methods available from Merchant API.
type internalAutomaticImprovementsClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetAutomaticImprovements(context.Context, *accountspb.GetAutomaticImprovementsRequest, ...gax.CallOption) (*accountspb.AutomaticImprovements, error)
	UpdateAutomaticImprovements(context.Context, *accountspb.UpdateAutomaticImprovementsRequest, ...gax.CallOption) (*accountspb.AutomaticImprovements, error)
}

// AutomaticImprovementsClient is a client for interacting with Merchant API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service to manage the automatic improvements of an account. The automatic
// improvements of the account can be used to automatically update products,
// improve images and shipping.
type AutomaticImprovementsClient struct {
	// The internal transport-dependent client.
	internalClient internalAutomaticImprovementsClient

	// The call options for this service.
	CallOptions *AutomaticImprovementsCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AutomaticImprovementsClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AutomaticImprovementsClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AutomaticImprovementsClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetAutomaticImprovements retrieves the automatic improvements of an account.
func (c *AutomaticImprovementsClient) GetAutomaticImprovements(ctx context.Context, req *accountspb.GetAutomaticImprovementsRequest, opts ...gax.CallOption) (*accountspb.AutomaticImprovements, error) {
	return c.internalClient.GetAutomaticImprovements(ctx, req, opts...)
}

// UpdateAutomaticImprovements updates the automatic improvements of an account.
func (c *AutomaticImprovementsClient) UpdateAutomaticImprovements(ctx context.Context, req *accountspb.UpdateAutomaticImprovementsRequest, opts ...gax.CallOption) (*accountspb.AutomaticImprovements, error) {
	return c.internalClient.UpdateAutomaticImprovements(ctx, req, opts...)
}

// automaticImprovementsGRPCClient is a client for interacting with Merchant API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type automaticImprovementsGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AutomaticImprovementsClient
	CallOptions **AutomaticImprovementsCallOptions

	// The gRPC API client.
	automaticImprovementsClient accountspb.AutomaticImprovementsServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewAutomaticImprovementsClient creates a new automatic improvements service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service to manage the automatic improvements of an account. The automatic
// improvements of the account can be used to automatically update products,
// improve images and shipping.
func NewAutomaticImprovementsClient(ctx context.Context, opts ...option.ClientOption) (*AutomaticImprovementsClient, error) {
	clientOpts := defaultAutomaticImprovementsGRPCClientOptions()
	if newAutomaticImprovementsClientHook != nil {
		hookOpts, err := newAutomaticImprovementsClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AutomaticImprovementsClient{CallOptions: defaultAutomaticImprovementsCallOptions()}

	c := &automaticImprovementsGRPCClient{
		connPool:                    connPool,
		automaticImprovementsClient: accountspb.NewAutomaticImprovementsServiceClient(connPool),
		CallOptions:                 &client.CallOptions,
		logger:                      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *automaticImprovementsGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *automaticImprovementsGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *automaticImprovementsGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type automaticImprovementsRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing AutomaticImprovementsClient
	CallOptions **AutomaticImprovementsCallOptions

	logger *slog.Logger
}

// NewAutomaticImprovementsRESTClient creates a new automatic improvements service rest client.
//
// Service to manage the automatic improvements of an account. The automatic
// improvements of the account can be used to automatically update products,
// improve images and shipping.
func NewAutomaticImprovementsRESTClient(ctx context.Context, opts ...option.ClientOption) (*AutomaticImprovementsClient, error) {
	clientOpts := append(defaultAutomaticImprovementsRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultAutomaticImprovementsRESTCallOptions()
	c := &automaticImprovementsRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &AutomaticImprovementsClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultAutomaticImprovementsRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://merchantapi.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://merchantapi.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://merchantapi.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *automaticImprovementsRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *automaticImprovementsRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *automaticImprovementsRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *automaticImprovementsGRPCClient) GetAutomaticImprovements(ctx context.Context, req *accountspb.GetAutomaticImprovementsRequest, opts ...gax.CallOption) (*accountspb.AutomaticImprovements, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAutomaticImprovements[0:len((*c.CallOptions).GetAutomaticImprovements):len((*c.CallOptions).GetAutomaticImprovements)], opts...)
	var resp *accountspb.AutomaticImprovements
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.automaticImprovementsClient.GetAutomaticImprovements, req, settings.GRPC, c.logger, "GetAutomaticImprovements")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *automaticImprovementsGRPCClient) UpdateAutomaticImprovements(ctx context.Context, req *accountspb.UpdateAutomaticImprovementsRequest, opts ...gax.CallOption) (*accountspb.AutomaticImprovements, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "automatic_improvements.name", url.QueryEscape(req.GetAutomaticImprovements().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAutomaticImprovements[0:len((*c.CallOptions).UpdateAutomaticImprovements):len((*c.CallOptions).UpdateAutomaticImprovements)], opts...)
	var resp *accountspb.AutomaticImprovements
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.automaticImprovementsClient.UpdateAutomaticImprovements, req, settings.GRPC, c.logger, "UpdateAutomaticImprovements")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetAutomaticImprovements retrieves the automatic improvements of an account.
func (c *automaticImprovementsRESTClient) GetAutomaticImprovements(ctx context.Context, req *accountspb.GetAutomaticImprovementsRequest, opts ...gax.CallOption) (*accountspb.AutomaticImprovements, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAutomaticImprovements[0:len((*c.CallOptions).GetAutomaticImprovements):len((*c.CallOptions).GetAutomaticImprovements)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.AutomaticImprovements{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAutomaticImprovements")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateAutomaticImprovements updates the automatic improvements of an account.
func (c *automaticImprovementsRESTClient) UpdateAutomaticImprovements(ctx context.Context, req *accountspb.UpdateAutomaticImprovementsRequest, opts ...gax.CallOption) (*accountspb.AutomaticImprovements, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAutomaticImprovements()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetAutomaticImprovements().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "automatic_improvements.name", url.QueryEscape(req.GetAutomaticImprovements().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateAutomaticImprovements[0:len((*c.CallOptions).UpdateAutomaticImprovements):len((*c.CallOptions).UpdateAutomaticImprovements)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.AutomaticImprovements{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateAutomaticImprovements")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
