// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package notifications

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	notificationspb "cloud.google.com/go/shopping/merchant/notifications/apiv1beta/notificationspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newNotificationsApiClientHook clientHook

// NotificationsApiCallOptions contains the retry settings for each method of NotificationsApiClient.
type NotificationsApiCallOptions struct {
	GetNotificationSubscription    []gax.CallOption
	CreateNotificationSubscription []gax.CallOption
	UpdateNotificationSubscription []gax.CallOption
	DeleteNotificationSubscription []gax.CallOption
	ListNotificationSubscriptions  []gax.CallOption
}

func defaultNotificationsApiGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("merchantapi.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("merchantapi.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("merchantapi.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultNotificationsApiCallOptions() *NotificationsApiCallOptions {
	return &NotificationsApiCallOptions{
		GetNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListNotificationSubscriptions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultNotificationsApiRESTCallOptions() *NotificationsApiCallOptions {
	return &NotificationsApiCallOptions{
		GetNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		UpdateNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteNotificationSubscription: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListNotificationSubscriptions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalNotificationsApiClient is an interface that defines the methods available from Merchant API.
type internalNotificationsApiClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetNotificationSubscription(context.Context, *notificationspb.GetNotificationSubscriptionRequest, ...gax.CallOption) (*notificationspb.NotificationSubscription, error)
	CreateNotificationSubscription(context.Context, *notificationspb.CreateNotificationSubscriptionRequest, ...gax.CallOption) (*notificationspb.NotificationSubscription, error)
	UpdateNotificationSubscription(context.Context, *notificationspb.UpdateNotificationSubscriptionRequest, ...gax.CallOption) (*notificationspb.NotificationSubscription, error)
	DeleteNotificationSubscription(context.Context, *notificationspb.DeleteNotificationSubscriptionRequest, ...gax.CallOption) error
	ListNotificationSubscriptions(context.Context, *notificationspb.ListNotificationSubscriptionsRequest, ...gax.CallOption) *NotificationSubscriptionIterator
}

// NotificationsApiClient is a client for interacting with Merchant API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service to manage notification subscriptions for merchants
type NotificationsApiClient struct {
	// The internal transport-dependent client.
	internalClient internalNotificationsApiClient

	// The call options for this service.
	CallOptions *NotificationsApiCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *NotificationsApiClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *NotificationsApiClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *NotificationsApiClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetNotificationSubscription gets notification subscriptions for an account.
func (c *NotificationsApiClient) GetNotificationSubscription(ctx context.Context, req *notificationspb.GetNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	return c.internalClient.GetNotificationSubscription(ctx, req, opts...)
}

// CreateNotificationSubscription creates a notification subscription for a merchant. We will allow the
// following types of notification subscriptions to exist together (per
// merchant as a subscriber per event type):
//
// Subscription for all managed accounts + subscription for self
//
// Multiple “partial” subscriptions for managed accounts + subscription
// for self
//
// we will not allow (per merchant as a subscriber per event type):
//
// multiple self subscriptions.
//
// multiple “all managed accounts” subscriptions.
//
// all and partial subscriptions at the same time.
//
// multiple partial subscriptions for the same target account
func (c *NotificationsApiClient) CreateNotificationSubscription(ctx context.Context, req *notificationspb.CreateNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	return c.internalClient.CreateNotificationSubscription(ctx, req, opts...)
}

// UpdateNotificationSubscription updates an existing notification subscription for a merchant.
func (c *NotificationsApiClient) UpdateNotificationSubscription(ctx context.Context, req *notificationspb.UpdateNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	return c.internalClient.UpdateNotificationSubscription(ctx, req, opts...)
}

// DeleteNotificationSubscription deletes a notification subscription for a merchant.
func (c *NotificationsApiClient) DeleteNotificationSubscription(ctx context.Context, req *notificationspb.DeleteNotificationSubscriptionRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteNotificationSubscription(ctx, req, opts...)
}

// ListNotificationSubscriptions gets all the notification subscriptions for a merchant.
func (c *NotificationsApiClient) ListNotificationSubscriptions(ctx context.Context, req *notificationspb.ListNotificationSubscriptionsRequest, opts ...gax.CallOption) *NotificationSubscriptionIterator {
	return c.internalClient.ListNotificationSubscriptions(ctx, req, opts...)
}

// notificationsApiGRPCClient is a client for interacting with Merchant API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type notificationsApiGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing NotificationsApiClient
	CallOptions **NotificationsApiCallOptions

	// The gRPC API client.
	notificationsApiClient notificationspb.NotificationsApiServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewNotificationsApiClient creates a new notifications api service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service to manage notification subscriptions for merchants
func NewNotificationsApiClient(ctx context.Context, opts ...option.ClientOption) (*NotificationsApiClient, error) {
	clientOpts := defaultNotificationsApiGRPCClientOptions()
	if newNotificationsApiClientHook != nil {
		hookOpts, err := newNotificationsApiClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := NotificationsApiClient{CallOptions: defaultNotificationsApiCallOptions()}

	c := &notificationsApiGRPCClient{
		connPool:               connPool,
		notificationsApiClient: notificationspb.NewNotificationsApiServiceClient(connPool),
		CallOptions:            &client.CallOptions,
		logger:                 internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *notificationsApiGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *notificationsApiGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *notificationsApiGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type notificationsApiRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing NotificationsApiClient
	CallOptions **NotificationsApiCallOptions

	logger *slog.Logger
}

// NewNotificationsApiRESTClient creates a new notifications api service rest client.
//
// Service to manage notification subscriptions for merchants
func NewNotificationsApiRESTClient(ctx context.Context, opts ...option.ClientOption) (*NotificationsApiClient, error) {
	clientOpts := append(defaultNotificationsApiRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultNotificationsApiRESTCallOptions()
	c := &notificationsApiRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &NotificationsApiClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultNotificationsApiRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://merchantapi.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://merchantapi.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://merchantapi.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *notificationsApiRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *notificationsApiRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *notificationsApiRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *notificationsApiGRPCClient) GetNotificationSubscription(ctx context.Context, req *notificationspb.GetNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetNotificationSubscription[0:len((*c.CallOptions).GetNotificationSubscription):len((*c.CallOptions).GetNotificationSubscription)], opts...)
	var resp *notificationspb.NotificationSubscription
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notificationsApiClient.GetNotificationSubscription, req, settings.GRPC, c.logger, "GetNotificationSubscription")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notificationsApiGRPCClient) CreateNotificationSubscription(ctx context.Context, req *notificationspb.CreateNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateNotificationSubscription[0:len((*c.CallOptions).CreateNotificationSubscription):len((*c.CallOptions).CreateNotificationSubscription)], opts...)
	var resp *notificationspb.NotificationSubscription
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notificationsApiClient.CreateNotificationSubscription, req, settings.GRPC, c.logger, "CreateNotificationSubscription")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notificationsApiGRPCClient) UpdateNotificationSubscription(ctx context.Context, req *notificationspb.UpdateNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "notification_subscription.name", url.QueryEscape(req.GetNotificationSubscription().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateNotificationSubscription[0:len((*c.CallOptions).UpdateNotificationSubscription):len((*c.CallOptions).UpdateNotificationSubscription)], opts...)
	var resp *notificationspb.NotificationSubscription
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.notificationsApiClient.UpdateNotificationSubscription, req, settings.GRPC, c.logger, "UpdateNotificationSubscription")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *notificationsApiGRPCClient) DeleteNotificationSubscription(ctx context.Context, req *notificationspb.DeleteNotificationSubscriptionRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteNotificationSubscription[0:len((*c.CallOptions).DeleteNotificationSubscription):len((*c.CallOptions).DeleteNotificationSubscription)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.notificationsApiClient.DeleteNotificationSubscription, req, settings.GRPC, c.logger, "DeleteNotificationSubscription")
		return err
	}, opts...)
	return err
}

func (c *notificationsApiGRPCClient) ListNotificationSubscriptions(ctx context.Context, req *notificationspb.ListNotificationSubscriptionsRequest, opts ...gax.CallOption) *NotificationSubscriptionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListNotificationSubscriptions[0:len((*c.CallOptions).ListNotificationSubscriptions):len((*c.CallOptions).ListNotificationSubscriptions)], opts...)
	it := &NotificationSubscriptionIterator{}
	req = proto.Clone(req).(*notificationspb.ListNotificationSubscriptionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notificationspb.NotificationSubscription, string, error) {
		resp := &notificationspb.ListNotificationSubscriptionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.notificationsApiClient.ListNotificationSubscriptions, req, settings.GRPC, c.logger, "ListNotificationSubscriptions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetNotificationSubscriptions(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetNotificationSubscription gets notification subscriptions for an account.
func (c *notificationsApiRESTClient) GetNotificationSubscription(ctx context.Context, req *notificationspb.GetNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/notifications/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetNotificationSubscription[0:len((*c.CallOptions).GetNotificationSubscription):len((*c.CallOptions).GetNotificationSubscription)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &notificationspb.NotificationSubscription{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetNotificationSubscription")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateNotificationSubscription creates a notification subscription for a merchant. We will allow the
// following types of notification subscriptions to exist together (per
// merchant as a subscriber per event type):
//
// Subscription for all managed accounts + subscription for self
//
// Multiple “partial” subscriptions for managed accounts + subscription
// for self
//
// we will not allow (per merchant as a subscriber per event type):
//
// multiple self subscriptions.
//
// multiple “all managed accounts” subscriptions.
//
// all and partial subscriptions at the same time.
//
// multiple partial subscriptions for the same target account
func (c *notificationsApiRESTClient) CreateNotificationSubscription(ctx context.Context, req *notificationspb.CreateNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNotificationSubscription()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/notifications/v1beta/%v/notificationsubscriptions", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateNotificationSubscription[0:len((*c.CallOptions).CreateNotificationSubscription):len((*c.CallOptions).CreateNotificationSubscription)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &notificationspb.NotificationSubscription{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateNotificationSubscription")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateNotificationSubscription updates an existing notification subscription for a merchant.
func (c *notificationsApiRESTClient) UpdateNotificationSubscription(ctx context.Context, req *notificationspb.UpdateNotificationSubscriptionRequest, opts ...gax.CallOption) (*notificationspb.NotificationSubscription, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetNotificationSubscription()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/notifications/v1beta/%v", req.GetNotificationSubscription().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "notification_subscription.name", url.QueryEscape(req.GetNotificationSubscription().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateNotificationSubscription[0:len((*c.CallOptions).UpdateNotificationSubscription):len((*c.CallOptions).UpdateNotificationSubscription)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &notificationspb.NotificationSubscription{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateNotificationSubscription")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteNotificationSubscription deletes a notification subscription for a merchant.
func (c *notificationsApiRESTClient) DeleteNotificationSubscription(ctx context.Context, req *notificationspb.DeleteNotificationSubscriptionRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/notifications/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteNotificationSubscription")
		return err
	}, opts...)
}

// ListNotificationSubscriptions gets all the notification subscriptions for a merchant.
func (c *notificationsApiRESTClient) ListNotificationSubscriptions(ctx context.Context, req *notificationspb.ListNotificationSubscriptionsRequest, opts ...gax.CallOption) *NotificationSubscriptionIterator {
	it := &NotificationSubscriptionIterator{}
	req = proto.Clone(req).(*notificationspb.ListNotificationSubscriptionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notificationspb.NotificationSubscription, string, error) {
		resp := &notificationspb.ListNotificationSubscriptionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/notifications/v1beta/%v/notificationsubscriptions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListNotificationSubscriptions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetNotificationSubscriptions(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
