{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='podFailurePolicyOnExitCodesRequirement', url='', help='"PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check."'),
  '#withContainerName':: d.fn(help='"Restricts the check for exit codes to the container with the specified name. When null, the rule applies to all containers. When specified, it should match one the container or initContainer names in the pod template."', args=[d.arg(name='containerName', type=d.T.string)]),
  withContainerName(containerName): { containerName: containerName },
  '#withOperator':: d.fn(help="\"Represents the relationship between the container exit code(s) and the specified values. Containers completed with success (exit code 0) are excluded from the requirement check. Possible values are:\\n\\n- In: the requirement is satisfied if at least one container exit code\\n  (might be multiple if there are multiple containers not restricted\\n  by the 'containerName' field) is in the set of specified values.\\n- NotIn: the requirement is satisfied if at least one container exit code\\n  (might be multiple if there are multiple containers not restricted\\n  by the 'containerName' field) is not in the set of specified values.\\nAdditional values are considered to be added in the future. Clients should react to an unknown operator by assuming the requirement is not satisfied.\"", args=[d.arg(name='operator', type=d.T.string)]),
  withOperator(operator): { operator: operator },
  '#withValues':: d.fn(help="\"Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.\"", args=[d.arg(name='values', type=d.T.array)]),
  withValues(values): { values: if std.isArray(v=values) then values else [values] },
  '#withValuesMixin':: d.fn(help="\"Specifies the set of values. Each returned container exit code (might be multiple in case of multiple containers) is checked against this set of values with respect to the operator. The list of values must be ordered and must not contain duplicates. Value '0' cannot be used for the In operator. At least one element is required. At most 255 elements are allowed.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='values', type=d.T.array)]),
  withValuesMixin(values): { values+: if std.isArray(v=values) then values else [values] },
  '#mixin': 'ignore',
  mixin: self,
}
