## Release notes for kOps 1.27 series

# Significant changes

* **The default image has been updated to [Ubuntu 22.04 (Jammy)](https://kops.sigs.k8s.io/operations/images/#ubuntu-2204-jammy/)**.

* The default retention duration for the etcd backups is now set to 90 days.
This behaviour can be overridden by setting `spec.etcdClusters[*].manager.backupRetentionDays` in the cluster spec.

* external-dns is now supported in IPv6 clusters.

* Using [swap memory](https://kubernetes.io/blog/2021/08/09/run-nodes-with-swap-alpha/) is now possible by setting `spec.kubelet.memorySwapBehavior`.

## AWS

* As of Kubernetes version 1.27, all nodes will default to running with instance-metadata-service tokens required, with a max hop limit of 1.
Newly created clusters will be configured as necessary to have these settings.

* As of Kubernetes version 1.27, credentials for private ECR repositories will be handled by the out-of-tree credential provider. This is an additional binary that each instance downloads from the assets repository.

* `Karpenter` has been upgraded to version `0.27.x` and the feature flag is no longer necessary.

## GCP

* Improved support for private topology.

* Support for bastions has been added.

## Openstack

* Nodes will now assign floating IPs when they are in a subnet that is of type `Public`. Previously
they would do so when the respective `topology` was set to `public`.

# Breaking changes

## OpenStack

* If storing the state in an S3 bucket, it is now required to either [deactivate gossip support](https://github.com/kubernetes/kops/issues/15684#issuecomment-1645384421) (`--dns=none`) or - for example - provide the credentials via cloud-init. Due to changes in [PR#15646](https://github.com/kubernetes/kops/pull/15646/files#diff-c1c852aea92883d3117fae99c1610c5cdcbc217f5aa3b340f23b5dd02e971d99L136-L145) the `S3_*` variables will not get passed on to the boot script of the [nodes anymore](https://github.com/kubernetes/kops/pull/15691). As a result the `kops-configuration.service` will throw an `EnvAccessKeyNotFound: failed to find credentials in the environment.` error and they will not join the cluster. Deactivating the gossip support will make the nodes contact the API servers for the bootstrap information.

## Other breaking changes

* Support for Kubernetes version 1.21 has been removed.

# Known Issues

* The Amazon VPC CNI is not compatible with Ubuntu 22.04. See [kubernetes/kops#15720](https://github.com/kubernetes/kops/issues/15720) and [aws/amazon-vpc-cni-k8s#2103](https://github.com/aws/amazon-vpc-cni-k8s/issues/2103) for more info.
 
# Deprecations

* Support for Kubernetes version 1.22 is deprecated and will be removed in kOps 1.28.

* Support for Kubernetes version 1.23 is deprecated and will be removed in kOps 1.29.

* Support for Ubuntu 18.04 is deprecated and will be removed in kOps 1.28.

* Canal, and Flannel are deprecated and support will be removed for Kubernetes 1.28 and later.

* Support for AWS Classic Load Balancer for API is deprecated and should not be used for newly created clusters.

* All legacy addons are deprecated in favor of managed addons, including the [metrics server addon](https://github.com/kubernetes/kops/tree/master/addons/metrics-server) and the [autoscaler addon](https://github.com/kubernetes/kops/tree/master/addons/cluster-autoscaler).


