
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create secret dockerconfig

Create a Docker config.

### Synopsis

Create a new Docker config and store it in the state store. Used to configure Docker authentication on each node.

 After creating a dockerconfig secret a /root/.docker/config.json file will be added to newly created nodes. This file will be used by Kubernetes to authenticate to container registries.

 This will also work when using containerd as the container runtime.

```
kops create secret dockerconfig [CLUSTER] -f FILENAME [flags]
```

### Examples

```
  # Create a new Docker config.
  kops create secret dockerconfig -f /path/to/docker/config.json \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Create a docker config via stdin.
  generate-docker-config.sh | kops create secret dockerconfig -f - \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Replace an existing docker config secret.
  kops create secret dockerconfig -f /path/to/docker/config.json --force \
  --name k8s-cluster.example.com --state s3://my-state-store
```

### Options

```
  -f, --filename string   Path to Docker config JSON file
      --force             Force replace the secret if it already exists
  -h, --help              help for dockerconfig
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops create secret](kops_create_secret.md)	 - Create a secret.

