/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	kopsv1alpha2 "k8s.io/kops/pkg/apis/kops/v1alpha2"
	scheme "k8s.io/kops/pkg/client/clientset_generated/clientset/scheme"
)

// KeysetsGetter has a method to return a KeysetInterface.
// A group's client should implement this interface.
type KeysetsGetter interface {
	Keysets(namespace string) KeysetInterface
}

// KeysetInterface has methods to work with Keyset resources.
type KeysetInterface interface {
	Create(ctx context.Context, keyset *kopsv1alpha2.Keyset, opts v1.CreateOptions) (*kopsv1alpha2.Keyset, error)
	Update(ctx context.Context, keyset *kopsv1alpha2.Keyset, opts v1.UpdateOptions) (*kopsv1alpha2.Keyset, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*kopsv1alpha2.Keyset, error)
	List(ctx context.Context, opts v1.ListOptions) (*kopsv1alpha2.KeysetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *kopsv1alpha2.Keyset, err error)
	KeysetExpansion
}

// keysets implements KeysetInterface
type keysets struct {
	*gentype.ClientWithList[*kopsv1alpha2.Keyset, *kopsv1alpha2.KeysetList]
}

// newKeysets returns a Keysets
func newKeysets(c *KopsV1alpha2Client, namespace string) *keysets {
	return &keysets{
		gentype.NewClientWithList[*kopsv1alpha2.Keyset, *kopsv1alpha2.KeysetList](
			"keysets",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *kopsv1alpha2.Keyset { return &kopsv1alpha2.Keyset{} },
			func() *kopsv1alpha2.KeysetList { return &kopsv1alpha2.KeysetList{} },
		),
	}
}
