/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	v1alpha3 "k8s.io/kops/pkg/apis/kops/v1alpha3"
	kopsv1alpha3 "k8s.io/kops/pkg/client/clientset_generated/clientset/typed/kops/v1alpha3"
)

// fakeHosts implements HostInterface
type fakeHosts struct {
	*gentype.FakeClientWithList[*v1alpha3.Host, *v1alpha3.HostList]
	Fake *FakeKopsV1alpha3
}

func newFakeHosts(fake *FakeKopsV1alpha3, namespace string) kopsv1alpha3.HostInterface {
	return &fakeHosts{
		gentype.NewFakeClientWithList[*v1alpha3.Host, *v1alpha3.HostList](
			fake.Fake,
			namespace,
			v1alpha3.SchemeGroupVersion.WithResource("hosts"),
			v1alpha3.SchemeGroupVersion.WithKind("Host"),
			func() *v1alpha3.Host { return &v1alpha3.Host{} },
			func() *v1alpha3.HostList { return &v1alpha3.HostList{} },
			func(dst, src *v1alpha3.HostList) { dst.ListMeta = src.ListMeta },
			func(list *v1alpha3.HostList) []*v1alpha3.Host { return gentype.ToPointerSlice(list.Items) },
			func(list *v1alpha3.HostList, items []*v1alpha3.Host) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
