/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "k8s.io/api/scheduling/v1alpha1"
	schedulingv1alpha1 "k8s.io/client-go/applyconfigurations/scheduling/v1alpha1"
	gentype "k8s.io/client-go/gentype"
	typedschedulingv1alpha1 "k8s.io/client-go/kubernetes/typed/scheduling/v1alpha1"
)

// fakeWorkloads implements WorkloadInterface
type fakeWorkloads struct {
	*gentype.FakeClientWithListAndApply[*v1alpha1.Workload, *v1alpha1.WorkloadList, *schedulingv1alpha1.WorkloadApplyConfiguration]
	Fake *FakeSchedulingV1alpha1
}

func newFakeWorkloads(fake *FakeSchedulingV1alpha1, namespace string) typedschedulingv1alpha1.WorkloadInterface {
	return &fakeWorkloads{
		gentype.NewFakeClientWithListAndApply[*v1alpha1.Workload, *v1alpha1.WorkloadList, *schedulingv1alpha1.WorkloadApplyConfiguration](
			fake.Fake,
			namespace,
			v1alpha1.SchemeGroupVersion.WithResource("workloads"),
			v1alpha1.SchemeGroupVersion.WithKind("Workload"),
			func() *v1alpha1.Workload { return &v1alpha1.Workload{} },
			func() *v1alpha1.WorkloadList { return &v1alpha1.WorkloadList{} },
			func(dst, src *v1alpha1.WorkloadList) { dst.ListMeta = src.ListMeta },
			func(list *v1alpha1.WorkloadList) []*v1alpha1.Workload { return gentype.ToPointerSlice(list.Items) },
			func(list *v1alpha1.WorkloadList, items []*v1alpha1.Workload) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
