## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`

* backtick strings (````) has been an undocumented hack for several years. This release officially sees that hack as deprecated and will be removed in the next release

## Breaking Changes

The following builtins have been removed in this release, having been marked as deprecated for 2 years or longer.

* `die` has been removed because it adds a feature for no purpose. It was original borrowed from Perl but realistically you can do the same with `exit 1` so this removal is to bring the language complexity down.

* the `=` and `let` builtins are now removed. These builtins were created back before expressions were a first class citizen in Murex. Now these serve no purpose and just add clutter to the language specification.

* `tread` is now longer needed due to `read` supporting all `tread`'s use cases.

You can still compile Murex to include these builtins via by including the following compile-time tag: `deprecated_builtins`. However we recommend you use the more modern syntax instead.

## v7.0.0xxx

### Features

* `xml`: new data type support added (**EXPERIMENTAL**) ({{link "read more" "xml"}})
* `pretty`: new flag added `--type` ({{link "read more" "pretty"}})
* core: support added for running Murex scripts against specific versions of Murex
* index: new behavior introduced for v8.0.x
* `runtime`: new flag added `--module-murex-version` ({{link "read more" "runtime"}})
* `get` & `post`: `Body` can now be marshalled into JSON. Even if `Body` was originally a different Content-Type, like XML ({{link "read more" "get"}})
* `onPrompt`: new event interrupt: `command-completion` ({{link "read more" "onPrompt"}})
* readline: VIM command mode ({{link "read more" "terminal-keys"}})
* `$MUREX_HISTORY`: new environmental variable for changing the write location of Murex's history file ({{link "read more" "murex_history"}})
* `$MUREX_CONFIG_DIR`: new environmental variable for changing the write location of all of Murex's config and profiles ({{link "read more" "murex_config_dir"}})
* core: RISC-V 64 CPU support added (**EXPERIMENTAL**)
* `cd`: support added for OSC 7 ANSI escape sequence ({{link "read more" "cd"}})
* `getfile` & `open`: additional type inference logic for `text/plain` Content-Types ((issue #915)[https://github.com/lmorg/murex/issues/915], {{link "read more" "getfile"}})
* core: system profile now loaded after `.murex_preload`
* core: add support for preloading code in modules
* integration: support added for OpenTofu
* integration: support added for Orbstack
* integration: support added for Ollama
* integration: updates for Ttyphoon
* readline: add support for line defaults
* readline: `ctrl`+`n` for next line ((issue #924)[https://github.com/lmorg/murex/discussions/924], {{link "read more" "terminal-keys"}})
* readline: `ctrl`+`p` for previous line ((issue #924)[https://github.com/lmorg/murex/discussions/924], {{link "read more" "terminal-keys"}})
* source: support for loading modules

### Bug Fixes

* readline: fix end of line cursor position bug when using `B` with VIM keys
* readline: don't show preview if no preview is set
* core: file extension checks from HTTP was happening before content-type normalisation
* core: `<fid:var>` was failing to set `$var` with FID

## Special Thanks

Thank yous for this release goes to [tiymat](https://github.com/tiymat), [atagen](https://github.com/atagen) for your testing and feedback.

Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!
