package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_CertExpiry = map[string]string{
	"":        "ceryExpiry contains the bundle name and the expiry date",
	"bundle":  "bundle is the name of the bundle in which the subject certificate resides",
	"subject": "subject is the subject of the certificate",
	"expiry":  "expiry is the date after which the certificate will no longer be valid",
}

func (CertExpiry) SwaggerDoc() map[string]string {
	return map_CertExpiry
}

var map_ContainerRuntimeConfig = map[string]string{
	"": "ContainerRuntimeConfig describes a customized Container Runtime configuration.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (ContainerRuntimeConfig) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfig
}

var map_ContainerRuntimeConfigCondition = map[string]string{
	"":                   "ContainerRuntimeConfigCondition defines the state of the ContainerRuntimeConfig",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are PascalCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (ContainerRuntimeConfigCondition) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigCondition
}

var map_ContainerRuntimeConfigList = map[string]string{
	"": "ContainerRuntimeConfigList is a list of ContainerRuntimeConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (ContainerRuntimeConfigList) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigList
}

var map_ContainerRuntimeConfigSpec = map[string]string{
	"":                          "ContainerRuntimeConfigSpec defines the desired state of ContainerRuntimeConfig",
	"machineConfigPoolSelector": "MachineConfigPoolSelector selects which pools the ContainerRuntimeConfig shoud apply to. A nil selector will result in no pools being selected.",
}

func (ContainerRuntimeConfigSpec) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigSpec
}

var map_ContainerRuntimeConfigStatus = map[string]string{
	"":                   "ContainerRuntimeConfigStatus defines the observed state of a ContainerRuntimeConfig",
	"observedGeneration": "observedGeneration represents the generation observed by the controller.",
	"conditions":         "conditions represents the latest available observations of current state.",
}

func (ContainerRuntimeConfigStatus) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigStatus
}

var map_ContainerRuntimeConfiguration = map[string]string{
	"":               "ContainerRuntimeConfiguration defines the tuneables of the container runtime",
	"pidsLimit":      "pidsLimit specifies the maximum number of processes allowed in a container",
	"logLevel":       "logLevel specifies the verbosity of the logs based on the level it is set to. Options are fatal, panic, error, warn, info, and debug.",
	"logSizeMax":     "logSizeMax specifies the Maximum size allowed for the container log file. Negative numbers indicate that no size limit is imposed. If it is positive, it must be >= 8192 to match/exceed conmon's read buffer.",
	"overlaySize":    "overlaySize specifies the maximum size of a container image. This flag can be used to set quota on the size of container images. (default: 10GB)",
	"defaultRuntime": "defaultRuntime is the name of the OCI runtime to be used as the default.",
}

func (ContainerRuntimeConfiguration) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfiguration
}

var map_ControllerCertificate = map[string]string{
	"":           "ControllerCertificate contains info about a specific cert.",
	"subject":    "subject is the cert subject",
	"signer":     "signer is the  cert Issuer",
	"notBefore":  "notBefore is the lower boundary for validity",
	"notAfter":   "notAfter is the upper boundary for validity",
	"bundleFile": "bundleFile is the larger bundle a cert comes from",
}

func (ControllerCertificate) SwaggerDoc() map[string]string {
	return map_ControllerCertificate
}

var map_ControllerConfig = map[string]string{
	"": "ControllerConfig describes configuration for MachineConfigController. This is currently only used to drive the MachineConfig objects generated by the TemplateController.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (ControllerConfig) SwaggerDoc() map[string]string {
	return map_ControllerConfig
}

var map_ControllerConfigList = map[string]string{
	"": "ControllerConfigList is a list of ControllerConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (ControllerConfigList) SwaggerDoc() map[string]string {
	return map_ControllerConfigList
}

var map_ControllerConfigSpec = map[string]string{
	"":                               "ControllerConfigSpec is the spec for ControllerConfig resource.",
	"clusterDNSIP":                   "clusterDNSIP is the cluster DNS IP address",
	"cloudProviderConfig":            "cloudProviderConfig is the configuration for the given cloud provider",
	"platform":                       "platform is deprecated, use Infra.Status.PlatformStatus.Type instead",
	"etcdDiscoveryDomain":            "etcdDiscoveryDomain is deprecated, use Infra.Status.EtcdDiscoveryDomain instead",
	"kubeAPIServerServingCAData":     "kubeAPIServerServingCAData managed Kubelet to API Server Cert... Rotated automatically",
	"rootCAData":                     "rootCAData specifies the root CA data",
	"cloudProviderCAData":            "cloudProvider specifies the cloud provider CA data",
	"additionalTrustBundle":          "additionalTrustBundle is a certificate bundle that will be added to the nodes trusted certificate store.",
	"imageRegistryBundleUserData":    "imageRegistryBundleUserData is Image Registry Data provided by the user",
	"imageRegistryBundleData":        "imageRegistryBundleData is the ImageRegistryData",
	"pullSecret":                     "pullSecret is the default pull secret that needs to be installed on all machines.",
	"internalRegistryPullSecret":     "internalRegistryPullSecret is the pull secret for the internal registry, used by rpm-ostree to pull images from the internal registry if present",
	"images":                         "images is map of images that are used by the controller to render templates under ./templates/",
	"baseOSContainerImage":           "BaseOSContainerImage is the new-format container image for operating system updates.",
	"baseOSExtensionsContainerImage": "BaseOSExtensionsContainerImage is the matching extensions container for the new-format container",
	"osImageURL":                     "OSImageURL is the old-format container image that contains the OS update payload.",
	"releaseImage":                   "releaseImage is the image used when installing the cluster",
	"proxy":                          "proxy holds the current proxy configuration for the nodes",
	"infra":                          "infra holds the infrastructure details",
	"dns":                            "dns holds the cluster dns details",
	"ipFamilies":                     "ipFamilies indicates the IP families in use by the cluster network",
	"networkType":                    "networkType holds the type of network the cluster is using XXX: this is temporary and will be dropped as soon as possible in favor of a better support to start network related services the proper way. Nobody is also changing this once the cluster is up and running the first time, so, disallow regeneration if this changes.",
	"network":                        "Network contains additional network related information",
}

func (ControllerConfigSpec) SwaggerDoc() map[string]string {
	return map_ControllerConfigSpec
}

var map_ControllerConfigStatus = map[string]string{
	"":                       "ControllerConfigStatus is the status for ControllerConfig",
	"observedGeneration":     "observedGeneration represents the generation observed by the controller.",
	"conditions":             "conditions represents the latest available observations of current state.",
	"controllerCertificates": "controllerCertificates represents the latest available observations of the automatically rotating certificates in the MCO.",
}

func (ControllerConfigStatus) SwaggerDoc() map[string]string {
	return map_ControllerConfigStatus
}

var map_ControllerConfigStatusCondition = map[string]string{
	"":                   "ControllerConfigStatusCondition contains condition information for ControllerConfigStatus",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are PascalCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (ControllerConfigStatusCondition) SwaggerDoc() map[string]string {
	return map_ControllerConfigStatusCondition
}

var map_ImageRegistryBundle = map[string]string{
	"":     "ImageRegistryBundle contains information for writing image registry certificates",
	"file": "file holds the name of the file where the bundle will be written to disk",
	"data": "data holds the contents of the bundle that will be written to the file location",
}

func (ImageRegistryBundle) SwaggerDoc() map[string]string {
	return map_ImageRegistryBundle
}

var map_KubeletConfig = map[string]string{
	"": "KubeletConfig describes a customized Kubelet configuration.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (KubeletConfig) SwaggerDoc() map[string]string {
	return map_KubeletConfig
}

var map_KubeletConfigCondition = map[string]string{
	"":                   "KubeletConfigCondition defines the state of the KubeletConfig",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are PascalCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (KubeletConfigCondition) SwaggerDoc() map[string]string {
	return map_KubeletConfigCondition
}

var map_KubeletConfigList = map[string]string{
	"": "KubeletConfigList is a list of KubeletConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (KubeletConfigList) SwaggerDoc() map[string]string {
	return map_KubeletConfigList
}

var map_KubeletConfigSpec = map[string]string{
	"":                          "KubeletConfigSpec defines the desired state of KubeletConfig",
	"machineConfigPoolSelector": "MachineConfigPoolSelector selects which pools the KubeletConfig shoud apply to. A nil selector will result in no pools being selected.",
	"kubeletConfig":             "kubeletConfig fields are defined in kubernetes upstream. Please refer to the types defined in the version/commit used by OpenShift of the upstream kubernetes. It's important to note that, since the fields of the kubelet configuration are directly fetched from upstream the validation of those values is handled directly by the kubelet. Please refer to the upstream version of the relevant kubernetes for the valid values of these fields. Invalid values of the kubelet configuration fields may render cluster nodes unusable.",
	"tlsSecurityProfile":        "If unset, the default is based on the apiservers.config.openshift.io/cluster resource. Note that only Old and Intermediate profiles are currently supported, and the maximum available minTLSVersion is VersionTLS12.",
}

func (KubeletConfigSpec) SwaggerDoc() map[string]string {
	return map_KubeletConfigSpec
}

var map_KubeletConfigStatus = map[string]string{
	"":                   "KubeletConfigStatus defines the observed state of a KubeletConfig",
	"observedGeneration": "observedGeneration represents the generation observed by the controller.",
	"conditions":         "conditions represents the latest available observations of current state.",
}

func (KubeletConfigStatus) SwaggerDoc() map[string]string {
	return map_KubeletConfigStatus
}

var map_MachineConfig = map[string]string{
	"": "MachineConfig defines the configuration for a machine\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfig) SwaggerDoc() map[string]string {
	return map_MachineConfig
}

var map_MachineConfigList = map[string]string{
	"": "MachineConfigList is a list of MachineConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfigList) SwaggerDoc() map[string]string {
	return map_MachineConfigList
}

var map_MachineConfigPool = map[string]string{
	"": "MachineConfigPool describes a pool of MachineConfigs.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfigPool) SwaggerDoc() map[string]string {
	return map_MachineConfigPool
}

var map_MachineConfigPoolCondition = map[string]string{
	"":                   "MachineConfigPoolCondition contains condition information for an MachineConfigPool.",
	"type":               "type of the condition, currently ('Done', 'Updating', 'Failed').",
	"status":             "status of the condition, one of ('True', 'False', 'Unknown').",
	"lastTransitionTime": "lastTransitionTime is the timestamp corresponding to the last status change of this condition.",
	"reason":             "reason is a brief machine readable explanation for the condition's last transition.",
	"message":            "message is a human readable description of the details of the last transition, complementing reason.",
}

func (MachineConfigPoolCondition) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolCondition
}

var map_MachineConfigPoolList = map[string]string{
	"": "MachineConfigPoolList is a list of MachineConfigPool resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfigPoolList) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolList
}

var map_MachineConfigPoolSpec = map[string]string{
	"":                      "MachineConfigPoolSpec is the spec for MachineConfigPool resource.",
	"machineConfigSelector": "machineConfigSelector specifies a label selector for MachineConfigs. Refer https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ on how label and selectors work.",
	"nodeSelector":          "nodeSelector specifies a label selector for Machines",
	"paused":                "paused specifies whether or not changes to this machine config pool should be stopped. This includes generating new desiredMachineConfig and update of machines.",
	"maxUnavailable":        "maxUnavailable defines either an integer number or percentage of nodes in the pool that can go Unavailable during an update. This includes nodes Unavailable for any reason, including user initiated cordons, failing nodes, etc. The default value is 1.\n\nA value larger than 1 will mean multiple nodes going unavailable during the update, which may affect your workload stress on the remaining nodes. You cannot set this value to 0 to stop updates (it will default back to 1); to stop updates, use the 'paused' property instead. Drain will respect Pod Disruption Budgets (PDBs) such as etcd quorum guards, even if maxUnavailable is greater than one.",
	"configuration":         "The targeted MachineConfig object for the machine config pool.",
	"pinnedImageSets":       "pinnedImageSets specifies a sequence of PinnedImageSetRef objects for the pool. Nodes within this pool will preload and pin images defined in the PinnedImageSet. Before pulling images the MachineConfigDaemon will ensure the total uncompressed size of all the images does not exceed available resources. If the total size of the images exceeds the available resources the controller will report a Degraded status to the MachineConfigPool and not attempt to pull any images. Also to help ensure the kubelet can mitigate storage risk, the pinned_image configuration and subsequent service reload will happen only after all of the images have been pulled for each set. Images from multiple PinnedImageSets are loaded and pinned sequentially as listed. Duplicate and existing images will be skipped.\n\nAny failure to prefetch or pin images will result in a Degraded pool. Resolving these failures is the responsibility of the user. The admin should be proactive in ensuring adequate storage and proper image authentication exists in advance.",
}

func (MachineConfigPoolSpec) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolSpec
}

var map_MachineConfigPoolStatus = map[string]string{
	"":                        "MachineConfigPoolStatus is the status for MachineConfigPool resource.",
	"observedGeneration":      "observedGeneration represents the generation observed by the controller.",
	"configuration":           "configuration represents the current MachineConfig object for the machine config pool.",
	"machineCount":            "machineCount represents the total number of machines in the machine config pool.",
	"updatedMachineCount":     "updatedMachineCount represents the total number of machines targeted by the pool that have the CurrentMachineConfig as their config.",
	"readyMachineCount":       "readyMachineCount represents the total number of ready machines targeted by the pool.",
	"unavailableMachineCount": "unavailableMachineCount represents the total number of unavailable (non-ready) machines targeted by the pool. A node is marked unavailable if it is in updating state or NodeReady condition is false.",
	"degradedMachineCount":    "degradedMachineCount represents the total number of machines marked degraded (or unreconcilable). A node is marked degraded if applying a configuration failed..",
	"conditions":              "conditions represents the latest available observations of current state.",
	"certExpirys":             "certExpirys keeps track of important certificate expiration data",
	"poolSynchronizersStatus": "poolSynchronizersStatus is the status of the machines managed by the pool synchronizers.",
}

func (MachineConfigPoolStatus) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolStatus
}

var map_MachineConfigPoolStatusConfiguration = map[string]string{
	"":       "MachineConfigPoolStatusConfiguration stores the current configuration for the pool, and optionally also stores the list of MachineConfig objects used to generate the configuration.",
	"source": "source is the list of MachineConfig objects that were used to generate the single MachineConfig object specified in `content`.",
}

func (MachineConfigPoolStatusConfiguration) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolStatusConfiguration
}

var map_MachineConfigSpec = map[string]string{
	"":                               "MachineConfigSpec is the spec for MachineConfig",
	"osImageURL":                     "OSImageURL specifies the remote location that will be used to fetch the OS.",
	"baseOSExtensionsContainerImage": "BaseOSExtensionsContainerImage specifies the remote location that will be used to fetch the extensions container matching a new-format OS image",
	"config":                         "Config is a Ignition Config object.",
	"kernelArguments":                "kernelArguments contains a list of kernel arguments to be added",
	"extensions":                     "extensions contains a list of additional features that can be enabled on host",
	"fips":                           "fips controls FIPS mode",
	"kernelType":                     "kernelType contains which kernel we want to be running like default (traditional), realtime, 64k-pages (aarch64 only).",
}

func (MachineConfigSpec) SwaggerDoc() map[string]string {
	return map_MachineConfigSpec
}

var map_NetworkInfo = map[string]string{
	"":             "Network contains network related configuration",
	"mtuMigration": "MTUMigration contains the MTU migration configuration.",
}

func (NetworkInfo) SwaggerDoc() map[string]string {
	return map_NetworkInfo
}

var map_PinnedImageSetRef = map[string]string{
	"name": "name is a reference to the name of a PinnedImageSet.  Must adhere to RFC-1123 (https://tools.ietf.org/html/rfc1123). Made up of one of more period-separated (.) segments, where each segment consists of alphanumeric characters and hyphens (-), must begin and end with an alphanumeric character, and is at most 63 characters in length. The total length of the name must not exceed 253 characters.",
}

func (PinnedImageSetRef) SwaggerDoc() map[string]string {
	return map_PinnedImageSetRef
}

var map_PoolSynchronizerStatus = map[string]string{
	"poolSynchronizerType":    "poolSynchronizerType describes the type of the pool synchronizer.",
	"machineCount":            "machineCount is the number of machines that are managed by the node synchronizer.",
	"updatedMachineCount":     "updatedMachineCount is the number of machines that have been updated by the node synchronizer.",
	"readyMachineCount":       "readyMachineCount is the number of machines managed by the node synchronizer that are in a ready state.",
	"availableMachineCount":   "availableMachineCount is the number of machines managed by the node synchronizer which are available.",
	"unavailableMachineCount": "unavailableMachineCount is the number of machines managed by the node synchronizer but are unavailable.",
	"observedGeneration":      "observedGeneration is the last generation change that has been applied.",
}

func (PoolSynchronizerStatus) SwaggerDoc() map[string]string {
	return map_PoolSynchronizerStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
