// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1 "github.com/openshift/api/config/v1"
	configv1 "github.com/openshift/client-go/config/applyconfigurations/config/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeOperatorHubs implements OperatorHubInterface
type FakeOperatorHubs struct {
	Fake *FakeConfigV1
}

var operatorhubsResource = v1.SchemeGroupVersion.WithResource("operatorhubs")

var operatorhubsKind = v1.SchemeGroupVersion.WithKind("OperatorHub")

// Get takes name of the operatorHub, and returns the corresponding operatorHub object, and an error if there is any.
func (c *FakeOperatorHubs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.OperatorHub, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(operatorhubsResource, name), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}

// List takes label and field selectors, and returns the list of OperatorHubs that match those selectors.
func (c *FakeOperatorHubs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.OperatorHubList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(operatorhubsResource, operatorhubsKind, opts), &v1.OperatorHubList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.OperatorHubList{ListMeta: obj.(*v1.OperatorHubList).ListMeta}
	for _, item := range obj.(*v1.OperatorHubList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested operatorHubs.
func (c *FakeOperatorHubs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(operatorhubsResource, opts))
}

// Create takes the representation of a operatorHub and creates it.  Returns the server's representation of the operatorHub, and an error, if there is any.
func (c *FakeOperatorHubs) Create(ctx context.Context, operatorHub *v1.OperatorHub, opts metav1.CreateOptions) (result *v1.OperatorHub, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(operatorhubsResource, operatorHub), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}

// Update takes the representation of a operatorHub and updates it. Returns the server's representation of the operatorHub, and an error, if there is any.
func (c *FakeOperatorHubs) Update(ctx context.Context, operatorHub *v1.OperatorHub, opts metav1.UpdateOptions) (result *v1.OperatorHub, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(operatorhubsResource, operatorHub), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeOperatorHubs) UpdateStatus(ctx context.Context, operatorHub *v1.OperatorHub, opts metav1.UpdateOptions) (*v1.OperatorHub, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(operatorhubsResource, "status", operatorHub), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}

// Delete takes name of the operatorHub and deletes it. Returns an error if one occurs.
func (c *FakeOperatorHubs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(operatorhubsResource, name, opts), &v1.OperatorHub{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOperatorHubs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(operatorhubsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1.OperatorHubList{})
	return err
}

// Patch applies the patch and returns the patched operatorHub.
func (c *FakeOperatorHubs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.OperatorHub, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(operatorhubsResource, name, pt, data, subresources...), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied operatorHub.
func (c *FakeOperatorHubs) Apply(ctx context.Context, operatorHub *configv1.OperatorHubApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OperatorHub, err error) {
	if operatorHub == nil {
		return nil, fmt.Errorf("operatorHub provided to Apply must not be nil")
	}
	data, err := json.Marshal(operatorHub)
	if err != nil {
		return nil, err
	}
	name := operatorHub.Name
	if name == nil {
		return nil, fmt.Errorf("operatorHub.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(operatorhubsResource, *name, types.ApplyPatchType, data), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeOperatorHubs) ApplyStatus(ctx context.Context, operatorHub *configv1.OperatorHubApplyConfiguration, opts metav1.ApplyOptions) (result *v1.OperatorHub, err error) {
	if operatorHub == nil {
		return nil, fmt.Errorf("operatorHub provided to Apply must not be nil")
	}
	data, err := json.Marshal(operatorHub)
	if err != nil {
		return nil, err
	}
	name := operatorHub.Name
	if name == nil {
		return nil, fmt.Errorf("operatorHub.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(operatorhubsResource, *name, types.ApplyPatchType, data, "status"), &v1.OperatorHub{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1.OperatorHub), err
}
