// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/openshift/api/config/v1alpha1"
	configv1alpha1 "github.com/openshift/client-go/config/applyconfigurations/config/v1alpha1"
	scheme "github.com/openshift/client-go/config/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// InsightsDataGathersGetter has a method to return a InsightsDataGatherInterface.
// A group's client should implement this interface.
type InsightsDataGathersGetter interface {
	InsightsDataGathers() InsightsDataGatherInterface
}

// InsightsDataGatherInterface has methods to work with InsightsDataGather resources.
type InsightsDataGatherInterface interface {
	Create(ctx context.Context, insightsDataGather *v1alpha1.InsightsDataGather, opts v1.CreateOptions) (*v1alpha1.InsightsDataGather, error)
	Update(ctx context.Context, insightsDataGather *v1alpha1.InsightsDataGather, opts v1.UpdateOptions) (*v1alpha1.InsightsDataGather, error)
	UpdateStatus(ctx context.Context, insightsDataGather *v1alpha1.InsightsDataGather, opts v1.UpdateOptions) (*v1alpha1.InsightsDataGather, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.InsightsDataGather, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.InsightsDataGatherList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.InsightsDataGather, err error)
	Apply(ctx context.Context, insightsDataGather *configv1alpha1.InsightsDataGatherApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InsightsDataGather, err error)
	ApplyStatus(ctx context.Context, insightsDataGather *configv1alpha1.InsightsDataGatherApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InsightsDataGather, err error)
	InsightsDataGatherExpansion
}

// insightsDataGathers implements InsightsDataGatherInterface
type insightsDataGathers struct {
	client rest.Interface
}

// newInsightsDataGathers returns a InsightsDataGathers
func newInsightsDataGathers(c *ConfigV1alpha1Client) *insightsDataGathers {
	return &insightsDataGathers{
		client: c.RESTClient(),
	}
}

// Get takes name of the insightsDataGather, and returns the corresponding insightsDataGather object, and an error if there is any.
func (c *insightsDataGathers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.InsightsDataGather, err error) {
	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Get().
		Resource("insightsdatagathers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of InsightsDataGathers that match those selectors.
func (c *insightsDataGathers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.InsightsDataGatherList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.InsightsDataGatherList{}
	err = c.client.Get().
		Resource("insightsdatagathers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested insightsDataGathers.
func (c *insightsDataGathers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("insightsdatagathers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a insightsDataGather and creates it.  Returns the server's representation of the insightsDataGather, and an error, if there is any.
func (c *insightsDataGathers) Create(ctx context.Context, insightsDataGather *v1alpha1.InsightsDataGather, opts v1.CreateOptions) (result *v1alpha1.InsightsDataGather, err error) {
	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Post().
		Resource("insightsdatagathers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(insightsDataGather).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a insightsDataGather and updates it. Returns the server's representation of the insightsDataGather, and an error, if there is any.
func (c *insightsDataGathers) Update(ctx context.Context, insightsDataGather *v1alpha1.InsightsDataGather, opts v1.UpdateOptions) (result *v1alpha1.InsightsDataGather, err error) {
	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Put().
		Resource("insightsdatagathers").
		Name(insightsDataGather.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(insightsDataGather).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *insightsDataGathers) UpdateStatus(ctx context.Context, insightsDataGather *v1alpha1.InsightsDataGather, opts v1.UpdateOptions) (result *v1alpha1.InsightsDataGather, err error) {
	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Put().
		Resource("insightsdatagathers").
		Name(insightsDataGather.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(insightsDataGather).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the insightsDataGather and deletes it. Returns an error if one occurs.
func (c *insightsDataGathers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("insightsdatagathers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *insightsDataGathers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("insightsdatagathers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched insightsDataGather.
func (c *insightsDataGathers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.InsightsDataGather, err error) {
	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Patch(pt).
		Resource("insightsdatagathers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied insightsDataGather.
func (c *insightsDataGathers) Apply(ctx context.Context, insightsDataGather *configv1alpha1.InsightsDataGatherApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InsightsDataGather, err error) {
	if insightsDataGather == nil {
		return nil, fmt.Errorf("insightsDataGather provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(insightsDataGather)
	if err != nil {
		return nil, err
	}
	name := insightsDataGather.Name
	if name == nil {
		return nil, fmt.Errorf("insightsDataGather.Name must be provided to Apply")
	}
	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("insightsdatagathers").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *insightsDataGathers) ApplyStatus(ctx context.Context, insightsDataGather *configv1alpha1.InsightsDataGatherApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.InsightsDataGather, err error) {
	if insightsDataGather == nil {
		return nil, fmt.Errorf("insightsDataGather provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(insightsDataGather)
	if err != nil {
		return nil, err
	}

	name := insightsDataGather.Name
	if name == nil {
		return nil, fmt.Errorf("insightsDataGather.Name must be provided to Apply")
	}

	result = &v1alpha1.InsightsDataGather{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("insightsdatagathers").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
