// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1alpha1 "github.com/openshift/api/operator/v1alpha1"
	operatorv1alpha1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1alpha1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// EtcdBackupsGetter has a method to return a EtcdBackupInterface.
// A group's client should implement this interface.
type EtcdBackupsGetter interface {
	EtcdBackups() EtcdBackupInterface
}

// EtcdBackupInterface has methods to work with EtcdBackup resources.
type EtcdBackupInterface interface {
	Create(ctx context.Context, etcdBackup *v1alpha1.EtcdBackup, opts v1.CreateOptions) (*v1alpha1.EtcdBackup, error)
	Update(ctx context.Context, etcdBackup *v1alpha1.EtcdBackup, opts v1.UpdateOptions) (*v1alpha1.EtcdBackup, error)
	UpdateStatus(ctx context.Context, etcdBackup *v1alpha1.EtcdBackup, opts v1.UpdateOptions) (*v1alpha1.EtcdBackup, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.EtcdBackup, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.EtcdBackupList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.EtcdBackup, err error)
	Apply(ctx context.Context, etcdBackup *operatorv1alpha1.EtcdBackupApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.EtcdBackup, err error)
	ApplyStatus(ctx context.Context, etcdBackup *operatorv1alpha1.EtcdBackupApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.EtcdBackup, err error)
	EtcdBackupExpansion
}

// etcdBackups implements EtcdBackupInterface
type etcdBackups struct {
	client rest.Interface
}

// newEtcdBackups returns a EtcdBackups
func newEtcdBackups(c *OperatorV1alpha1Client) *etcdBackups {
	return &etcdBackups{
		client: c.RESTClient(),
	}
}

// Get takes name of the etcdBackup, and returns the corresponding etcdBackup object, and an error if there is any.
func (c *etcdBackups) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.EtcdBackup, err error) {
	result = &v1alpha1.EtcdBackup{}
	err = c.client.Get().
		Resource("etcdbackups").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of EtcdBackups that match those selectors.
func (c *etcdBackups) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.EtcdBackupList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.EtcdBackupList{}
	err = c.client.Get().
		Resource("etcdbackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested etcdBackups.
func (c *etcdBackups) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("etcdbackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a etcdBackup and creates it.  Returns the server's representation of the etcdBackup, and an error, if there is any.
func (c *etcdBackups) Create(ctx context.Context, etcdBackup *v1alpha1.EtcdBackup, opts v1.CreateOptions) (result *v1alpha1.EtcdBackup, err error) {
	result = &v1alpha1.EtcdBackup{}
	err = c.client.Post().
		Resource("etcdbackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(etcdBackup).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a etcdBackup and updates it. Returns the server's representation of the etcdBackup, and an error, if there is any.
func (c *etcdBackups) Update(ctx context.Context, etcdBackup *v1alpha1.EtcdBackup, opts v1.UpdateOptions) (result *v1alpha1.EtcdBackup, err error) {
	result = &v1alpha1.EtcdBackup{}
	err = c.client.Put().
		Resource("etcdbackups").
		Name(etcdBackup.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(etcdBackup).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *etcdBackups) UpdateStatus(ctx context.Context, etcdBackup *v1alpha1.EtcdBackup, opts v1.UpdateOptions) (result *v1alpha1.EtcdBackup, err error) {
	result = &v1alpha1.EtcdBackup{}
	err = c.client.Put().
		Resource("etcdbackups").
		Name(etcdBackup.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(etcdBackup).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the etcdBackup and deletes it. Returns an error if one occurs.
func (c *etcdBackups) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("etcdbackups").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *etcdBackups) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("etcdbackups").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched etcdBackup.
func (c *etcdBackups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.EtcdBackup, err error) {
	result = &v1alpha1.EtcdBackup{}
	err = c.client.Patch(pt).
		Resource("etcdbackups").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied etcdBackup.
func (c *etcdBackups) Apply(ctx context.Context, etcdBackup *operatorv1alpha1.EtcdBackupApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.EtcdBackup, err error) {
	if etcdBackup == nil {
		return nil, fmt.Errorf("etcdBackup provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(etcdBackup)
	if err != nil {
		return nil, err
	}
	name := etcdBackup.Name
	if name == nil {
		return nil, fmt.Errorf("etcdBackup.Name must be provided to Apply")
	}
	result = &v1alpha1.EtcdBackup{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("etcdbackups").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *etcdBackups) ApplyStatus(ctx context.Context, etcdBackup *operatorv1alpha1.EtcdBackupApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha1.EtcdBackup, err error) {
	if etcdBackup == nil {
		return nil, fmt.Errorf("etcdBackup provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(etcdBackup)
	if err != nil {
		return nil, err
	}

	name := etcdBackup.Name
	if name == nil {
		return nil, fmt.Errorf("etcdBackup.Name must be provided to Apply")
	}

	result = &v1alpha1.EtcdBackup{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("etcdbackups").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
