// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/template/v1"
	templatev1 "github.com/openshift/client-go/template/applyconfigurations/template/v1"
	scheme "github.com/openshift/client-go/template/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TemplateInstancesGetter has a method to return a TemplateInstanceInterface.
// A group's client should implement this interface.
type TemplateInstancesGetter interface {
	TemplateInstances(namespace string) TemplateInstanceInterface
}

// TemplateInstanceInterface has methods to work with TemplateInstance resources.
type TemplateInstanceInterface interface {
	Create(ctx context.Context, templateInstance *v1.TemplateInstance, opts metav1.CreateOptions) (*v1.TemplateInstance, error)
	Update(ctx context.Context, templateInstance *v1.TemplateInstance, opts metav1.UpdateOptions) (*v1.TemplateInstance, error)
	UpdateStatus(ctx context.Context, templateInstance *v1.TemplateInstance, opts metav1.UpdateOptions) (*v1.TemplateInstance, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TemplateInstance, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TemplateInstanceList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TemplateInstance, err error)
	Apply(ctx context.Context, templateInstance *templatev1.TemplateInstanceApplyConfiguration, opts metav1.ApplyOptions) (result *v1.TemplateInstance, err error)
	ApplyStatus(ctx context.Context, templateInstance *templatev1.TemplateInstanceApplyConfiguration, opts metav1.ApplyOptions) (result *v1.TemplateInstance, err error)
	TemplateInstanceExpansion
}

// templateInstances implements TemplateInstanceInterface
type templateInstances struct {
	client rest.Interface
	ns     string
}

// newTemplateInstances returns a TemplateInstances
func newTemplateInstances(c *TemplateV1Client, namespace string) *templateInstances {
	return &templateInstances{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the templateInstance, and returns the corresponding templateInstance object, and an error if there is any.
func (c *templateInstances) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TemplateInstance, err error) {
	result = &v1.TemplateInstance{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("templateinstances").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TemplateInstances that match those selectors.
func (c *templateInstances) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TemplateInstanceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TemplateInstanceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("templateinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested templateInstances.
func (c *templateInstances) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("templateinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a templateInstance and creates it.  Returns the server's representation of the templateInstance, and an error, if there is any.
func (c *templateInstances) Create(ctx context.Context, templateInstance *v1.TemplateInstance, opts metav1.CreateOptions) (result *v1.TemplateInstance, err error) {
	result = &v1.TemplateInstance{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("templateinstances").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(templateInstance).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a templateInstance and updates it. Returns the server's representation of the templateInstance, and an error, if there is any.
func (c *templateInstances) Update(ctx context.Context, templateInstance *v1.TemplateInstance, opts metav1.UpdateOptions) (result *v1.TemplateInstance, err error) {
	result = &v1.TemplateInstance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("templateinstances").
		Name(templateInstance.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(templateInstance).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *templateInstances) UpdateStatus(ctx context.Context, templateInstance *v1.TemplateInstance, opts metav1.UpdateOptions) (result *v1.TemplateInstance, err error) {
	result = &v1.TemplateInstance{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("templateinstances").
		Name(templateInstance.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(templateInstance).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the templateInstance and deletes it. Returns an error if one occurs.
func (c *templateInstances) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("templateinstances").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *templateInstances) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("templateinstances").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched templateInstance.
func (c *templateInstances) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TemplateInstance, err error) {
	result = &v1.TemplateInstance{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("templateinstances").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied templateInstance.
func (c *templateInstances) Apply(ctx context.Context, templateInstance *templatev1.TemplateInstanceApplyConfiguration, opts metav1.ApplyOptions) (result *v1.TemplateInstance, err error) {
	if templateInstance == nil {
		return nil, fmt.Errorf("templateInstance provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(templateInstance)
	if err != nil {
		return nil, err
	}
	name := templateInstance.Name
	if name == nil {
		return nil, fmt.Errorf("templateInstance.Name must be provided to Apply")
	}
	result = &v1.TemplateInstance{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("templateinstances").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *templateInstances) ApplyStatus(ctx context.Context, templateInstance *templatev1.TemplateInstanceApplyConfiguration, opts metav1.ApplyOptions) (result *v1.TemplateInstance, err error) {
	if templateInstance == nil {
		return nil, fmt.Errorf("templateInstance provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(templateInstance)
	if err != nil {
		return nil, err
	}

	name := templateInstance.Name
	if name == nil {
		return nil, fmt.Errorf("templateInstance.Name must be provided to Apply")
	}

	result = &v1.TemplateInstance{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("templateinstances").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
