## v1.16.0

### Additions

- For Ansible-based operators, add default resource limits for the manager. ([#5274](https://github.com/operator-framework/operator-sdk/pull/5274))
- Add annotation to specify the default container. More info [here](https://kubernetes.io/docs/reference/labels-annotations-taints/#kubectl-kubernetes-io-default-container). ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
- Add PHONY targets to Makefile. ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
- Add `# TODO(user): Configure the resources accordingly based on the project requirements.` into the file `config/manager/manager.yaml` to make this requirement clear for users. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/. ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
- For Golang-based projects, added `ignore-not-found` flag to the `uninstall` and `undeploy` Makefile targets.  This change allows `make undeploy` and  `make install` to continue if Kustomize encounters a missing resource. You can invoke this feature by calling `make undeploy ignore-not-found=true`. ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
- Add new optional validator Good Practices. You are able to test your bundle against good practices defined under operator framework solutions by running:
```sh 
$ operator-sdk bundle validate ./bundle --select-optional name=good-practices OR $ operator-sdk bundle validate ./bundle --select-optional suite=operatorframework 
```.
([#5448](https://github.com/operator-framework/operator-sdk/pull/5448))
- Add the deprecated APIs optional checker, `alpha-deprecated-apis`, to the `operatorframework` suite. ([#5407](https://github.com/operator-framework/operator-sdk/pull/5407))

### Changes

- Upgrade OPM version that is used by default to 1.19.1 in the generated Makefile so `make catalog-build` also works on OSX. ([#5099](https://github.com/operator-framework/operator-sdk/pull/5099))
- For Ansible-based operators, bumped the `operator_sdk.util` ansible module to 0.3.1. ([#5462](https://github.com/operator-framework/operator-sdk/pull/5462))
- For a more consistent user experience, ensure that all areas that require to be changed are marked by `TODO(user)`. ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
- For Helm-based Operators, adopted the same default resource limit values used to scaffold Golang-based projects. ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
- For Golang-based Operators, increase the values used in the default scaffold to define the resource limits usage and make clear the need to optimize its values based on the Operator requirements. ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))

### Deprecations

- Deprecation of the Optional(stage: alpha) Community Operator bundle validation. Its checks were moved to the [external validator](https://github.com/redhat-openshift-ecosystem/ocp-olm-catalog-validator/). ([#5414](https://github.com/operator-framework/operator-sdk/pull/5414))

### Bug Fixes

- Optional `OperatorHub.io` validator called by `operator-sdk bundle validate ./bundle --select-optional name=operatorhub` now includes a previously missing category `Modernization & Migration`. ([#5375](https://github.com/operator-framework/operator-sdk/pull/5375))
- Improves the validate bundle spec error message to provide a better explanation when invalid service accounts are found. ([#5375](https://github.com/operator-framework/operator-sdk/pull/5375))
- Improve scaffolding to filter existing multiline code fragments. More info [kubernetes-sigs/kubebuilder#2343](https://github.com/kubernetes-sigs/kubebuilder/pull/2343/files). ([#5330](https://github.com/operator-framework/operator-sdk/pull/5330))
