# Contributing to superfile

Welcome to superfile! This document shall serve as a guide for you to follow in your journey to contributing to this project.
There are many ways to contribute to superfile:
- Reporting Bugs
- Resolving issues
- Adding a theme
- Sharing an idea and working on it
- Working on a feature with other contributors.
- And More…

To get started, take a look at the following sections.

## Issues

### Did you spot a problem in superfile?

Firstly you should check if such an issue was previously opened/closed for your problem on the repository. If it doesn't then you should create a new issue.

### Do you want to solve an issue?

If there is an issue you think you can solve, and want to solve, then you should create a new fork of this repository.
In that repository you should create a new branch for the issue you are working on and commit changes there.
When the issue is solved, and you want it to be integrated into the official repository, you may create a pull request for the same.
The description of the pull request should clearly describe both the issue and the solution along with other necessary information.
The developers will merge after making the necessary changes (if arises a need to do so).

### Do you want to add a new theme?

Firstly check if the theme you want to add is not already added. If it is, then you work may go waste and be left redundant.
If no such theme exists, then you may create your own theme. Following steps will guide you for it:
- As a template, copy an existing theme's TOML file to your theme and then do the customizations. This will reduce errors from your side and make your work easy.
- To tests your theme, go to `~/.config/superfile/config/config.toml` and change description.
- Make the changes you want and finish the theme.
- Then you can open a pull request for the same and follow the steps described in the previous section.

### Do you want to share an idea?

superfile welcomes new ideas. If you have an idea you should first check if a similar or identical idea was presented previously or not, or check thoroughly if the idea is already present in superfile.
To share your idea you can open a discussion in https://github.com/MHNightCat/superfile/discussions
There you can share your idea and if you want to work on it, you can follow the same steps as mentioned in previously.

### Do you want to contribute but don't know how?

Your first resource in this should be https://docs.github.com/en/get-started/exploring-projects-on-github/contributing-to-a-project
This file serves as your guide specifically for this project to help you get your contributions into the project.
If you still have some questions or need help, feel free to open a discussion on the same.

# Thank You 🙏
