package slack

// SCOPES := []string{string} {

// 	"admin.analytics:read" : {
// 		"admin.analytics.getFile",
// 		"admin.analytics.getUsage",
// 		"admin.analytics.listFiles",
// 	}
// }

var scope_mapping = map[string][]string{
	"admin.analytics:read":         {"admin.analytics.getFile"},
	"admin.app_activities:read":    {"admin.apps.activities.list"},
	"admin.apps:write":             {"admin.apps.approve", "admin.apps.clearResolution", "admin.apps.config.set", "admin.apps.requests.cancel", "admin.apps.restrict", "admin.apps.uninstall"},
	"admin.apps:read":              {"admin.apps.approved.list", "admin.apps.config.lookup", "admin.apps.requests.list", "admin.apps.restricted.list"},
	"admin.users:write":            {"admin.auth.policy.assignEntities", "admin.auth.policy.removeEntities", "admin.users.assign", "admin.users.invite", "admin.users.remove", "admin.users.session.clearSettings", "admin.users.session.invalidate", "admin.users.session.reset", "admin.users.session.resetBulk", "admin.users.session.setSettings", "admin.users.setAdmin", "admin.users.setExpiration", "admin.users.setOwner", "admin.users.setRegular"},
	"admin.users:read":             {"admin.auth.policy.getEntities", "admin.users.list", "admin.users.session.getSettings", "admin.users.session.list", "admin.users.unsupportedVersions.export"},
	"admin.barriers:write":         {"admin.barriers.create", "admin.barriers.delete", "admin.barriers.update"},
	"admin.barriers:read":          {"admin.barriers.list"},
	"admin.conversations:write":    {"admin.conversations.archive", "admin.conversations.bulkArchive", "admin.conversations.bulkDelete", "admin.conversations.bulkMove", "admin.conversations.convertToPrivate", "admin.conversations.convertToPublic", "admin.conversations.create", "admin.conversations.delete", "admin.conversations.disconnectShared", "admin.conversations.invite", "admin.conversations.removeCustomRetention", "admin.conversations.rename", "admin.conversations.restrictAccess.addGroup", "admin.conversations.restrictAccess.removeGroup", "admin.conversations.setConversationPrefs", "admin.conversations.setCustomRetention", "admin.conversations.setTeams", "admin.conversations.unarchive"},
	"admin.conversations:read":     {"admin.conversations.ekm.listOriginalConnectedChannelInfo", "admin.conversations.getConversationPrefs", "admin.conversations.getCustomRetention", "admin.conversations.getTeams", "admin.conversations.lookup", "admin.conversations.restrictAccess.listGroups", "admin.conversations.search"},
	"admin.teams:write":            {"admin.emoji.add", "admin.emoji.addAlias", "admin.emoji.remove", "admin.emoji.rename", "admin.teams.create", "admin.teams.settings.setDefaultChannels", "admin.teams.settings.setDescription", "admin.teams.settings.setDiscoverability", "admin.teams.settings.setIcon", "admin.teams.settings.setName", "admin.usergroups.addTeams"},
	"admin.teams:read":             {"admin.emoji.list", "admin.teams.admins.list", "admin.teams.list", "admin.teams.owners.list", "admin.teams.settings.info"},
	"admin.workflows:read":         {"admin.functions.list", "admin.functions.permissions.lookup", "admin.workflows.permissions.lookup", "admin.workflows.search"},
	"admin.workflows:write":        {"admin.functions.permissions.set", "admin.workflows.collaborators.add", "admin.workflows.collaborators.remove", "admin.workflows.unpublish"},
	"admin.invites:write":          {"admin.inviteRequests.approve", "admin.inviteRequests.deny"},
	"admin.invites:read":           {"admin.inviteRequests.approved.list", "admin.inviteRequests.denied.list", "admin.inviteRequests.list"},
	"admin.roles:write":            {"admin.roles.addAssignments", "admin.roles.removeAssignments"},
	"admin.roles:read":             {"admin.roles.listAssignments"},
	"admin.usergroups:write":       {"admin.usergroups.addChannels", "admin.usergroups.removeChannels"},
	"admin.usergroups:read":        {"admin.usergroups.listChannels"},
	"hosting:read":                 {"apps.activities.list"},
	"connections:write":            {"apps.connections.open"},
	"token":                        {"apps.datastore.bulkDelete", "apps.datastore.bulkGet", "apps.datastore.bulkPut", "apps.datastore.delete", "apps.datastore.get", "apps.datastore.put", "apps.datastore.query", "apps.datastore.update"},
	"datastore:read":               {"apps.datastore.count"},
	"authorizations:read":          {"apps.event.authorizations.list"},
	"bot":                          {"auth.revoke", "auth.test", "chat.getPermalink", "chat.scheduledMessages.list", "dialog.open", "functions.completeError", "functions.completeSuccess", "rtm.connect", "rtm.start", "views.open", "views.publish", "views.push", "views.update"},
	"bookmarks:write":              {"bookmarks.add", "bookmarks.edit", "bookmarks.remove"},
	"bookmarks:read":               {"bookmarks.list"},
	"users:read":                   {"bots.info", "users.getPresence", "users.info", "users.list"},
	"calls:write":                  {"calls.add", "calls.end", "calls.participants.add", "calls.participants.remove", "calls.update"},
	"calls:read":                   {"calls.info"},
	"channels:manage":              {"channels.create", "channels.mark", "conversations.archive", "conversations.close", "conversations.create", "conversations.kick", "conversations.leave", "conversations.mark", "conversations.open", "conversations.rename", "conversations.unarchive", "groups.create", "groups.mark", "im.mark", "im.open", "mpim.mark", "mpim.open"},
	"channels:read":                {"channels.info", "conversations.info", "conversations.list", "conversations.members", "groups.info", "im.list", "mpim.list", "users.conversations"},
	"channels:write.invites":       {"channels.invite", "conversations.invite", "groups.invite"},
	"chat:write":                   {"chat.delete", "chat.deleteScheduledMessage", "chat.meMessage", "chat.postEphemeral", "chat.postMessage", "chat.scheduleMessage", "chat.update"},
	"links:write":                  {"chat.unfurl"},
	"conversations.connect:write":  {"conversations.acceptSharedInvite", "conversations.inviteShared"},
	"conversations.connect:manage": {"conversations.approveSharedInvite", "conversations.declineSharedInvite", "conversations.listConnectInvites"},
	"channels:history":             {"conversations.history", "conversations.replies"},
	"channels:join":                {"conversations.join"},
	"channels:write.topic":         {"conversations.setPurpose", "conversations.setTopic"},
	"dnd:write":                    {"dnd.endDnd", "dnd.endSnooze", "dnd.setSnooze"},
	"dnd:read":                     {"dnd.info", "dnd.teamInfo"},
	"emoji:read":                   {"emoji.list"},
	"files:write":                  {"files.comments.delete", "files.completeUploadExternal", "files.delete", "files.getUploadURLExternal", "files.revokePublicURL", "files.sharedPublicURL", "files.upload"},
	"files:read":                   {"files.info", "files.list"},
	"remote_files:write":           {"files.remote.add", "files.remote.remove", "files.remote.update"},
	"remote_files:read":            {"files.remote.info", "files.remote.list"},
	"remote_files:share":           {"files.remote.share"},
	"app_configurations:write":     {"functions.distributions.permissions.add", "functions.distributions.permissions.remove", "functions.distributions.permissions.set"},
	"app_configurations:read":      {"functions.distributions.permissions.list"},
	"conversations":                {"groups.open"},
	"tokens.basic":                 {"migration.exchange"},
	"email":                        {"openid.connect.userInfo"},
	"pins:write":                   {"pins.add", "pins.remove"},
	"pins:read":                    {"pins.list"},
	"reactions:write":              {"reactions.add", "reactions.remove"},
	"reactions:read":               {"reactions.get", "reactions.list"},
	"reminders:write":              {"reminders.add", "reminders.complete", "reminders.delete"},
	"reminders:read":               {"reminders.info", "reminders.list"},
	"search:read":                  {"search.all", "search.files", "search.messages"},
	"stars:write":                  {"stars.add", "stars.remove"},
	"stars:read":                   {"stars.list"},
	"admin":                        {"team.accessLogs", "team.billableInfo", "team.integrationLogs"},
	"team.billing:read":            {"team.billing.info"},
	"team:read":                    {"team.info"},
	"team.preferences:read":        {"team.preferences.list"},
	"users.profile:read":           {"team.profile.get", "users.profile.get"},
	"usergroups:write":             {"usergroups.create", "usergroups.disable", "usergroups.enable", "usergroups.update", "usergroups.users.update"},
	"usergroups:read":              {"usergroups.list", "usergroups.users.list"},
	"users.profile:write":          {"users.deletePhoto", "users.profile.set", "users.setPhoto"},
	"identity.basic":               {"users.identity"},
	"users:read.email":             {"users.lookupByEmail"},
	"users:write":                  {"users.setActive", "users.setPresence"},
	"workflow.steps:execute":       {"workflows.stepCompleted", "workflows.stepFailed", "workflows.updateStep"},
	"triggers:write":               {"workflows.triggers.permissions.add", "workflows.triggers.permissions.remove", "workflows.triggers.permissions.set"},
	"triggers:read":                {"workflows.triggers.permissions.list"},
}
