# -*- coding: utf-8 -*- #
"""Cloud SDK static completion CLI tree."""
# pylint: disable=line-too-long,bad-continuation
STATIC_COMPLETION_CLI_TREE = {
  "commands": {
    "access-approval": {
      "commands": {
        "requests": {
          "commands": {
            "approve": {
              "commands": {},
              "flags": {}
            },
            "dismiss": {
              "commands": {},
              "flags": {}
            },
            "get": {
              "commands": {},
              "flags": {}
            },
            "invalidate": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--folder": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--state": "value"
              }
            }
          },
          "flags": {}
        },
        "service-account": {
          "commands": {
            "get": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            }
          },
          "flags": {}
        },
        "settings": {
          "commands": {
            "delete": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "get": {
              "commands": {},
              "flags": {
                "--folder": "value",
                "--organization": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--active_key_version": "value",
                "--enrolled_services": "value",
                "--folder": "value",
                "--notification_emails": "value",
                "--notification_pubsub_topic": "value",
                "--organization": "value",
                "--prefer_no_broad_approval_requests": "value",
                "--preferred_request_expiration_days": "value",
                "--request_scope_max_width_preference": [
                  "FOLDER",
                  "ORGANIZATION",
                  "PROJECT"
                ],
                "--require_customer_visible_justification": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "access-context-manager": {
      "commands": {
        "authorized-orgs": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--asset_type": [
                  "asset-type-credential-strength",
                  "asset-type-device",
                  "asset-type-unspecified"
                ],
                "--async": "bool",
                "--authorization_direction": [
                  "authorization-direction-from",
                  "authorization-direction-to",
                  "authorization-direction-unspecified"
                ],
                "--authorization_type": [
                  "authorization-type-trust",
                  "authorization-type-unspecified"
                ],
                "--orgs": "value",
                "--policy": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-orgs": "value",
                "--clear-orgs": "bool",
                "--policy": "value",
                "--remove-orgs": "value",
                "--set-orgs": "value"
              }
            }
          },
          "flags": {}
        },
        "cloud-bindings": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--binding-file": "value",
                "--dry-run-level": "value",
                "--group-key": "value",
                "--level": "value",
                "--organization": "value",
                "--session-length": "value",
                "--session-reauth-method": [
                  "login",
                  "password",
                  "security-key"
                ]
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--binding": "value",
                "--organization": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--binding": "value",
                "--organization": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--append": "bool",
                "--binding": "value",
                "--binding-file": "value",
                "--dry-run-level": "value",
                "--level": "value",
                "--organization": "value",
                "--session-length": "value",
                "--session-reauth-method": [
                  "login",
                  "password",
                  "security-key"
                ]
              }
            }
          },
          "flags": {}
        },
        "levels": {
          "commands": {
            "conditions": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--level": "value",
                    "--policy": "value"
                  }
                }
              },
              "flags": {}
            },
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--basic-level-spec": "value",
                "--combine-function": [
                  "and",
                  "or"
                ],
                "--custom-level-spec": "value",
                "--description": "value",
                "--policy": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "replace-all": {
              "commands": {},
              "flags": {
                "--etag": "value",
                "--source-file": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--basic-level-spec": "value",
                "--combine-function": [
                  "and",
                  "or"
                ],
                "--custom-level-spec": "value",
                "--description": "value",
                "--policy": "value",
                "--title": "value"
              }
            }
          },
          "flags": {}
        },
        "perimeters": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--access-levels": "value",
                "--async": "bool",
                "--description": "value",
                "--egress-policies": "value",
                "--enable-vpc-accessible-services": "bool",
                "--ingress-policies": "value",
                "--perimeter-type": [
                  "bridge",
                  "regular"
                ],
                "--policy": "value",
                "--resources": "value",
                "--restricted-services": "value",
                "--title": "value",
                "--vpc-allowed-services": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--policy": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--policy": "value"
              }
            },
            "dry-run": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-levels": "value",
                    "--async": "bool",
                    "--egress-policies": "value",
                    "--enable-vpc-accessible-services": "bool",
                    "--ingress-policies": "value",
                    "--perimeter-access-levels": "value",
                    "--perimeter-description": "value",
                    "--perimeter-egress-policies": "value",
                    "--perimeter-enable-vpc-accessible-services": "bool",
                    "--perimeter-ingress-policies": "value",
                    "--perimeter-resources": "value",
                    "--perimeter-restricted-services": "value",
                    "--perimeter-title": "value",
                    "--perimeter-type": "value",
                    "--perimeter-vpc-allowed-services": "value",
                    "--policy": "value",
                    "--resources": "value",
                    "--restricted-services": "value",
                    "--vpc-allowed-services": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "drop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "enforce": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "enforce-all": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--add-vpc-allowed-services": "value",
                    "--async": "bool",
                    "--clear-access-levels": "bool",
                    "--clear-egress-policies": "bool",
                    "--clear-ingress-policies": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--clear-vpc-allowed-services": "bool",
                    "--enable-vpc-accessible-services": "bool",
                    "--etag": "value",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--remove-vpc-allowed-services": "value",
                    "--set-egress-policies": "value",
                    "--set-ingress-policies": "value"
                  }
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--policy": "value",
                "--sort-by": "value"
              }
            },
            "replace-all": {
              "commands": {},
              "flags": {
                "--etag": "value",
                "--source-file": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-access-levels": "value",
                "--add-resources": "value",
                "--add-restricted-services": "value",
                "--add-vpc-allowed-services": "value",
                "--clear-access-levels": "bool",
                "--clear-egress-policies": "bool",
                "--clear-ingress-policies": "bool",
                "--clear-resources": "bool",
                "--clear-restricted-services": "bool",
                "--clear-vpc-allowed-services": "bool",
                "--description": "value",
                "--enable-vpc-accessible-services": "bool",
                "--etag": "value",
                "--policy": "value",
                "--remove-access-levels": "value",
                "--remove-resources": "value",
                "--remove-restricted-services": "value",
                "--remove-vpc-allowed-services": "value",
                "--set-access-levels": "value",
                "--set-egress-policies": "value",
                "--set-ingress-policies": "value",
                "--set-resources": "value",
                "--set-restricted-services": "value",
                "--title": "value",
                "--type": [
                  "bridge",
                  "regular"
                ]
              }
            }
          },
          "flags": {}
        },
        "policies": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--condition": "value",
                "--condition-from-file": "value",
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--organization": "value",
                "--scopes": "value",
                "--title": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--all": "bool",
                "--condition": "value",
                "--condition-from-file": "value",
                "--member": "value",
                "--role": "dynamic"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--title": "value"
              }
            }
          },
          "flags": {}
        },
        "supported-services": {
          "commands": {
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "active-directory": {
      "commands": {
        "domains": {
          "commands": {
            "backups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--domain": "value",
                    "--labels": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--domain": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--domain": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--domain": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--domain": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "create": {
              "commands": {},
              "flags": {
                "--admin-name": "value",
                "--async": "bool",
                "--authorized-networks": "value",
                "--enable-audit-logs": "bool",
                "--labels": "value",
                "--region": "value",
                "--reserved-ip-range": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool"
              }
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "describe-ldaps-settings": {
              "commands": {},
              "flags": {}
            },
            "extend-schema": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--description": "value",
                "--ldif-file": "value"
              }
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "reset-admin-password": {
              "commands": {},
              "flags": {}
            },
            "restore": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--backup": "value"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {}
            },
            "trusts": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--direction": [
                      "bidirectional",
                      "inbound",
                      "outbound",
                      "trust-direction-unspecified"
                    ],
                    "--handshake-secret": "value",
                    "--selective-authentication": "bool",
                    "--target-dns-ip-addresses": "value",
                    "--target-domain-name": "value",
                    "--type": [
                      "external",
                      "forest",
                      "trust-type-unspecified"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-domain-name": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-dns-ip-addresses": "value",
                    "--target-domain-name": "value"
                  }
                },
                "validate-state": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--target-domain-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--add-authorized-networks": "value",
                "--add-region": "value",
                "--async": "bool",
                "--clear-labels": "bool",
                "--enable-audit-logs": "bool",
                "--remove-authorized-networks": "value",
                "--remove-labels": "value",
                "--remove-region": "value",
                "--update-labels": "value"
              }
            },
            "update-ldaps-settings": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--certificate-password": "value",
                "--certificate-pfx-file": "value",
                "--clear-certificates": "bool"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            }
          },
          "flags": {}
        },
        "peerings": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--authorized-network": "value",
                "--domain": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool"
              }
            },
            "describe": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--clear-labels": "bool",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "ai": {
      "commands": {
        "custom-jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--args": "value",
                "--command": "value",
                "--config": "value",
                "--display-name": "value",
                "--enable-dashboard-access": "bool",
                "--enable-web-access": "bool",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--labels": "value",
                "--network": "value",
                "--persistent-resource-id": "value",
                "--python-package-uris": "value",
                "--region": "value",
                "--service-account": "value",
                "--worker-pool-spec": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "local-run": {
              "commands": {},
              "flags": {
                "--executor-image-uri": "value",
                "--extra-dirs": "value",
                "--extra-packages": "value",
                "--gpu": "bool",
                "--local-package-path": "value",
                "--output-image-uri": "value",
                "--python-module": "value",
                "--requirements": "value",
                "--script": "value",
                "--service-account-key-file": "value"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--region": "dynamic",
                "--task-name": "value"
              }
            }
          },
          "flags": {}
        },
        "endpoints": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--display-name": "value",
                "--encryption-kms-key-name": "value",
                "--endpoint-id": "value",
                "--labels": "value",
                "--network": "value",
                "--region": "value",
                "--request-response-logging-rate": "value",
                "--request-response-logging-table": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "deploy-model": {
              "commands": {},
              "flags": {
                "--accelerator": "value",
                "--autoscaling-metric-specs": "value",
                "--deployed-model-id": "value",
                "--disable-container-logging": "bool",
                "--display-name": "value",
                "--enable-access-logging": "bool",
                "--machine-type": "value",
                "--max-replica-count": "value",
                "--min-replica-count": "value",
                "--model": "value",
                "--region": "dynamic",
                "--reservation-affinity": "value",
                "--service-account": "value",
                "--spot": "bool",
                "--traffic-split": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "direct-predict": {
              "commands": {},
              "flags": {
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "direct-raw-predict": {
              "commands": {},
              "flags": {
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "explain": {
              "commands": {},
              "flags": {
                "--deployed-model-id": "value",
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "raw-predict": {
              "commands": {},
              "flags": {
                "--http-headers": "value",
                "--region": "dynamic",
                "--request": "value"
              }
            },
            "stream-direct-predict": {
              "commands": {},
              "flags": {
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "stream-direct-raw-predict": {
              "commands": {},
              "flags": {
                "--json-request": "value",
                "--region": "dynamic"
              }
            },
            "stream-raw-predict": {
              "commands": {},
              "flags": {
                "--http-headers": "value",
                "--region": "dynamic",
                "--request": "value"
              }
            },
            "undeploy-model": {
              "commands": {},
              "flags": {
                "--deployed-model-id": "value",
                "--region": "dynamic",
                "--traffic-split": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--clear-traffic-split": "bool",
                "--description": "value",
                "--disable-request-response-logging": "bool",
                "--display-name": "value",
                "--region": "dynamic",
                "--remove-labels": "value",
                "--request-response-logging-rate": "value",
                "--request-response-logging-table": "value",
                "--traffic-split": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "hp-tuning-jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--algorithm": [
                  "algorithm-unspecified",
                  "grid-search",
                  "random-search"
                ],
                "--config": "value",
                "--display-name": "value",
                "--enable-dashboard-access": "bool",
                "--enable-web-access": "bool",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--labels": "value",
                "--max-trial-count": "value",
                "--network": "value",
                "--parallel-trial-count": "value",
                "--region": "value",
                "--service-account": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--region": "dynamic",
                "--task-name": "value"
              }
            }
          },
          "flags": {}
        },
        "index-endpoints": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--display-name": "value",
                "--enable-private-service-connect": "bool",
                "--encryption-kms-key-name": "value",
                "--labels": "value",
                "--network": "value",
                "--project-allowlist": "value",
                "--public-endpoint-enabled": "bool",
                "--region": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "deploy-index": {
              "commands": {},
              "flags": {
                "--allowed-issuers": "value",
                "--audiences": "value",
                "--deployed-index-id": "value",
                "--deployment-group": "value",
                "--display-name": "value",
                "--enable-access-logging": "bool",
                "--index": "value",
                "--machine-type": "value",
                "--max-replica-count": "value",
                "--min-replica-count": "value",
                "--psc-automation-configs": "value",
                "--region": "dynamic",
                "--reserved-ip-ranges": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "mutate-deployed-index": {
              "commands": {},
              "flags": {
                "--allowed-issuers": "value",
                "--audiences": "value",
                "--deployed-index-id": "value",
                "--deployment-group": "value",
                "--enable-access-logging": "bool",
                "--machine-type": "value",
                "--max-replica-count": "value",
                "--min-replica-count": "value",
                "--region": "dynamic",
                "--reserved-ip-ranges": "value"
              }
            },
            "undeploy-index": {
              "commands": {},
              "flags": {
                "--deployed-index-id": "value",
                "--region": "dynamic"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--display-name": "value",
                "--region": "dynamic",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "indexes": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--display-name": "value",
                "--encryption-kms-key-name": "value",
                "--index-update-method": [
                  "batch-update",
                  "stream-update"
                ],
                "--labels": "value",
                "--metadata-file": "value",
                "--metadata-schema-uri": "value",
                "--region": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "remove-datapoints": {
              "commands": {},
              "flags": {
                "--datapoint-ids": "value",
                "--datapoints-from-file": "value",
                "--region": "dynamic"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--display-name": "value",
                "--metadata-file": "value",
                "--region": "dynamic",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            },
            "upsert-datapoints": {
              "commands": {},
              "flags": {
                "--datapoints-from-file": "value",
                "--region": "dynamic",
                "--update-mask": "value"
              }
            }
          },
          "flags": {}
        },
        "model-monitoring-jobs": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--analysis-instance-schema": "value",
                "--anomaly-cloud-logging": "bool",
                "--bigquery-uri": "value",
                "--data-format": "value",
                "--dataset": "value",
                "--display-name": "value",
                "--emails": "value",
                "--endpoint": "value",
                "--feature-attribution-thresholds": "value",
                "--feature-thresholds": "value",
                "--gcs-uris": "value",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--labels": "value",
                "--log-ttl": "value",
                "--monitoring-config-from-file": "value",
                "--monitoring-frequency": "value",
                "--notification-channels": "value",
                "--predict-instance-schema": "value",
                "--prediction-sampling-rate": "value",
                "--region": "value",
                "--sample-predict-request": "value",
                "--target-field": "value",
                "--training-sampling-rate": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "pause": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "resume": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--analysis-instance-schema": "value",
                "--anomaly-cloud-logging": "bool",
                "--clear-labels": "bool",
                "--display-name": "value",
                "--emails": "value",
                "--feature-attribution-thresholds": "value",
                "--feature-thresholds": "value",
                "--log-ttl": "value",
                "--monitoring-config-from-file": "value",
                "--monitoring-frequency": "value",
                "--notification-channels": "value",
                "--prediction-sampling-rate": "value",
                "--region": "dynamic",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "models": {
          "commands": {
            "copy": {
              "commands": {},
              "flags": {
                "--destination-model-id": "value",
                "--destination-parent-model": "value",
                "--kms-key-name": "value",
                "--region": "value",
                "--source-model": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "delete-version": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "list-version": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "dynamic",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "upload": {
              "commands": {},
              "flags": {
                "--artifact-uri": "value",
                "--container-args": "value",
                "--container-command": "value",
                "--container-deployment-timeout-seconds": "value",
                "--container-env-vars": "value",
                "--container-grpc-ports": "value",
                "--container-health-probe-exec": "value",
                "--container-health-probe-period-seconds": "value",
                "--container-health-probe-timeout-seconds": "value",
                "--container-health-route": "value",
                "--container-image-uri": "value",
                "--container-ports": "value",
                "--container-predict-route": "value",
                "--container-shared-memory-size-mb": "value",
                "--container-startup-probe-exec": "value",
                "--container-startup-probe-period-seconds": "value",
                "--container-startup-probe-timeout-seconds": "value",
                "--description": "value",
                "--display-name": "value",
                "--explanation-metadata-file": "value",
                "--explanation-method": "value",
                "--explanation-path-count": "value",
                "--explanation-step-count": "value",
                "--labels": "value",
                "--model-id": "value",
                "--parent-model": "value",
                "--region": "value",
                "--smooth-grad-noise-sigma": "value",
                "--smooth-grad-noise-sigma-by-feature": "value",
                "--smooth-grad-noisy-sample-count": "value",
                "--version-aliases": "value",
                "--version-description": "value"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "describe": {
              "commands": {},
              "flags": {
                "--index": "value",
                "--index-endpoint": "value",
                "--region": "dynamic"
              }
            }
          },
          "flags": {}
        },
        "persistent-resources": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--config": "value",
                "--display-name": "value",
                "--enable-custom-service-account": "bool",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--labels": "value",
                "--network": "value",
                "--persistent-resource-id": "value",
                "--region": "value",
                "--resource-pool-spec": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "reboot": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            }
          },
          "flags": {}
        },
        "tensorboards": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--display-name": "value",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--labels": "value",
                "--region": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "dynamic"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--display-name": "value",
                "--region": "dynamic",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "ai-platform": {
      "commands": {
        "jobs": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {
                "--summarize": "bool"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "stream-logs": {
              "commands": {},
              "flags": {
                "--allow-multiline-logs": "bool",
                "--polling-interval": "value",
                "--task-name": "value"
              }
            },
            "submit": {
              "commands": {
                "prediction": {
                  "commands": {},
                  "flags": {
                    "--batch-size": "value",
                    "--data-format": [
                      "text",
                      "tf-record",
                      "tf-record-gzip"
                    ],
                    "--input-paths": "value",
                    "--labels": "value",
                    "--max-worker-count": "value",
                    "--model": "value",
                    "--model-dir": "value",
                    "--output-path": "value",
                    "--region": "value",
                    "--runtime-version": "value",
                    "--signature-name": "value"
                  }
                },
                "training": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--config": "value",
                    "--enable-web-access": "bool",
                    "--job-dir": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--master-accelerator": "value",
                    "--master-image-uri": "value",
                    "--master-machine-type": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--packages": "value",
                    "--parameter-server-accelerator": "value",
                    "--parameter-server-count": "value",
                    "--parameter-server-image-uri": "value",
                    "--parameter-server-machine-type": "value",
                    "--python-version": "value",
                    "--region": "dynamic",
                    "--runtime-version": "value",
                    "--scale-tier": [
                      "basic",
                      "basic-gpu",
                      "basic-tpu",
                      "custom",
                      "premium-1",
                      "standard-1"
                    ],
                    "--service-account": "value",
                    "--staging-bucket": "value",
                    "--stream-logs": "bool",
                    "--use-chief-in-tf-config": "value",
                    "--worker-accelerator": "value",
                    "--worker-count": "value",
                    "--worker-image-uri": "value",
                    "--worker-machine-type": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "local": {
          "commands": {
            "predict": {
              "commands": {},
              "flags": {
                "--framework": [
                  "scikit-learn",
                  "tensorflow",
                  "xgboost"
                ],
                "--json-instances": "value",
                "--json-request": "value",
                "--model-dir": "value",
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "train": {
              "commands": {},
              "flags": {
                "--distributed": "bool",
                "--evaluator-count": "value",
                "--job-dir": "value",
                "--module-name": "value",
                "--package-path": "value",
                "--parameter-server-count": "value",
                "--start-port": "value",
                "--worker-count": "value"
              }
            }
          },
          "flags": {}
        },
        "models": {
          "commands": {
            "add-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--role": "dynamic"
              }
            },
            "create": {
              "commands": {},
              "flags": {
                "--description": "value",
                "--enable-logging": "bool",
                "--labels": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--regions": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "get-iam-policy": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "remove-iam-policy-binding": {
              "commands": {},
              "flags": {
                "--member": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--role": "value"
              }
            },
            "set-iam-policy": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--description": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "wait": {
              "commands": {},
              "flags": {
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            }
          },
          "flags": {}
        },
        "predict": {
          "commands": {},
          "flags": {
            "--json-instances": "value",
            "--json-request": "value",
            "--model": "value",
            "--region": [
              "asia-east1",
              "asia-northeast1",
              "asia-southeast1",
              "australia-southeast1",
              "europe-west1",
              "europe-west2",
              "europe-west3",
              "europe-west4",
              "global",
              "northamerica-northeast1",
              "us-central1",
              "us-east1",
              "us-east4",
              "us-west1"
            ],
            "--signature-name": "value",
            "--text-instances": "value"
          }
        },
        "versions": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--accelerator": "value",
                "--async": "bool",
                "--config": "value",
                "--description": "value",
                "--framework": [
                  "scikit-learn",
                  "tensorflow",
                  "xgboost"
                ],
                "--labels": "value",
                "--machine-type": "value",
                "--max-nodes": "value",
                "--metric-targets": "value",
                "--min-nodes": "value",
                "--model": "value",
                "--origin": "value",
                "--python-version": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--runtime-version": "value",
                "--staging-bucket": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--model": "value",
                "--page-size": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "set-default": {
              "commands": {},
              "flags": {
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ]
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--clear-labels": "bool",
                "--config": "value",
                "--description": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--remove-labels": "value",
                "--update-labels": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "alloydb": {
      "commands": {
        "backups": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--cluster": "value",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--region": "value",
                "--tags": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--region": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            }
          },
          "flags": {}
        },
        "clusters": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--allocated-ip-range-name": "value",
                "--async": "bool",
                "--automated-backup-days-of-week": "value",
                "--automated-backup-encryption-key": "dynamic",
                "--automated-backup-encryption-key-keyring": "dynamic",
                "--automated-backup-encryption-key-location": "dynamic",
                "--automated-backup-encryption-key-project": "dynamic",
                "--automated-backup-retention-count": "value",
                "--automated-backup-retention-period": "value",
                "--automated-backup-start-times": "value",
                "--automated-backup-window": "value",
                "--continuous-backup-encryption-key": "dynamic",
                "--continuous-backup-encryption-key-keyring": "dynamic",
                "--continuous-backup-encryption-key-location": "dynamic",
                "--continuous-backup-encryption-key-project": "dynamic",
                "--continuous-backup-recovery-window-days": "value",
                "--database-version": [
                  "POSTGRES_14",
                  "POSTGRES_15",
                  "POSTGRES_16"
                ],
                "--disable-automated-backup": "bool",
                "--enable-continuous-backup": "bool",
                "--enable-private-service-connect": "bool",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--maintenance-window-day": [
                  "MONDAY",
                  "TUESDAY",
                  "WEDNESDAY",
                  "THURSDAY",
                  "FRIDAY",
                  "SATURDAY",
                  "SUNDAY"
                ],
                "--maintenance-window-hour": "value",
                "--network": "value",
                "--password": "value",
                "--region": "value",
                "--subscription-type": [
                  "STANDARD",
                  "TRIAL"
                ],
                "--tags": "value"
              }
            },
            "create-secondary": {
              "commands": {},
              "flags": {
                "--allocated-ip-range-name": "value",
                "--async": "bool",
                "--automated-backup-days-of-week": "value",
                "--automated-backup-encryption-key": "dynamic",
                "--automated-backup-encryption-key-keyring": "dynamic",
                "--automated-backup-encryption-key-location": "dynamic",
                "--automated-backup-encryption-key-project": "dynamic",
                "--automated-backup-retention-count": "value",
                "--automated-backup-retention-period": "value",
                "--automated-backup-start-times": "value",
                "--automated-backup-window": "value",
                "--continuous-backup-encryption-key": "dynamic",
                "--continuous-backup-encryption-key-keyring": "dynamic",
                "--continuous-backup-encryption-key-location": "dynamic",
                "--continuous-backup-encryption-key-project": "dynamic",
                "--continuous-backup-recovery-window-days": "value",
                "--enable-automated-backup": "bool",
                "--enable-continuous-backup": "bool",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--primary-cluster": "value",
                "--region": "value",
                "--tags": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--force": "bool",
                "--region": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "export": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--clean-target-objects": "bool",
                "--csv": "bool",
                "--database": "value",
                "--escape-character": "value",
                "--field-delimiter": "value",
                "--gcs-uri": "value",
                "--if-exist-target-objects": "bool",
                "--quote-character": "value",
                "--region": "value",
                "--schema-only": "bool",
                "--select-query": "value",
                "--sql": "bool",
                "--tables": "value"
              }
            },
            "import": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--columns": "value",
                "--csv": "bool",
                "--database": "value",
                "--escape-character": "value",
                "--field-delimiter": "value",
                "--gcs-uri": "value",
                "--quote-character": "value",
                "--region": "value",
                "--sql": "bool",
                "--table": "value",
                "--user": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "promote": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--region": "value"
              }
            },
            "restore": {
              "commands": {},
              "flags": {
                "--allocated-ip-range-name": "value",
                "--async": "bool",
                "--backup": "value",
                "--enable-private-service-connect": "bool",
                "--kms-key": "dynamic",
                "--kms-keyring": "dynamic",
                "--kms-location": "dynamic",
                "--kms-project": "dynamic",
                "--network": "value",
                "--point-in-time": "value",
                "--region": "value",
                "--source-cluster": "value",
                "--tags": "value"
              }
            },
            "switchover": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--region": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--automated-backup-days-of-week": "value",
                "--automated-backup-encryption-key": "dynamic",
                "--automated-backup-encryption-key-keyring": "dynamic",
                "--automated-backup-encryption-key-location": "dynamic",
                "--automated-backup-encryption-key-project": "dynamic",
                "--automated-backup-retention-count": "value",
                "--automated-backup-retention-period": "value",
                "--automated-backup-start-times": "value",
                "--automated-backup-window": "value",
                "--clear-automated-backup": "bool",
                "--clear-continuous-backup-encryption-key": "bool",
                "--continuous-backup-encryption-key": "dynamic",
                "--continuous-backup-encryption-key-keyring": "dynamic",
                "--continuous-backup-encryption-key-location": "dynamic",
                "--continuous-backup-encryption-key-project": "dynamic",
                "--continuous-backup-recovery-window-days": "value",
                "--disable-automated-backup": "bool",
                "--enable-continuous-backup": "bool",
                "--maintenance-window-any": "bool",
                "--maintenance-window-day": [
                  "MONDAY",
                  "TUESDAY",
                  "WEDNESDAY",
                  "THURSDAY",
                  "FRIDAY",
                  "SATURDAY",
                  "SUNDAY"
                ],
                "--maintenance-window-hour": "value",
                "--region": "value",
                "--subscription-type": [
                  "STANDARD",
                  "TRIAL"
                ]
              }
            },
            "upgrade": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--region": "value"
              }
            }
          },
          "flags": {}
        },
        "instances": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--allowed-psc-projects": "value",
                "--assign-inbound-public-ip": "value",
                "--async": "bool",
                "--authorized-external-networks": "value",
                "--availability-type": [
                  "REGIONAL",
                  "ZONAL"
                ],
                "--cluster": "value",
                "--cpu-count": [
                  1,
                  2,
                  4,
                  8,
                  16,
                  32,
                  48,
                  64,
                  72,
                  96,
                  128
                ],
                "--database-flags": "value",
                "--insights-config-query-plans-per-minute": "value",
                "--insights-config-query-string-length": "value",
                "--insights-config-record-application-tags": "bool",
                "--insights-config-record-client-address": "bool",
                "--instance-type": [
                  "PRIMARY",
                  "READ_POOL"
                ],
                "--machine-type": [
                  "c4a-highmem-1",
                  "c4a-highmem-16-lssd",
                  "c4a-highmem-32-lssd",
                  "c4a-highmem-4-lssd",
                  "c4a-highmem-48-lssd",
                  "c4a-highmem-64-lssd",
                  "c4a-highmem-72-lssd",
                  "c4a-highmem-8-lssd",
                  "n2-highmem-128",
                  "n2-highmem-16",
                  "n2-highmem-2",
                  "n2-highmem-32",
                  "n2-highmem-4",
                  "n2-highmem-64",
                  "n2-highmem-8",
                  "n2-highmem-96"
                ],
                "--outbound-public-ip": "bool",
                "--psc-network-attachment-uri": "value",
                "--read-pool-node-count": "value",
                "--region": "value",
                "--require-connectors": "bool",
                "--ssl-mode": [
                  "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
                  "ENCRYPTED_ONLY"
                ]
              }
            },
            "create-secondary": {
              "commands": {},
              "flags": {
                "--allowed-psc-projects": "value",
                "--assign-inbound-public-ip": "value",
                "--async": "bool",
                "--authorized-external-networks": "value",
                "--availability-type": [
                  "REGIONAL",
                  "ZONAL"
                ],
                "--cluster": "value",
                "--database-flags": "value",
                "--outbound-public-ip": "bool",
                "--psc-network-attachment-uri": "value",
                "--region": "value",
                "--require-connectors": "bool",
                "--ssl-mode": [
                  "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
                  "ENCRYPTED_ONLY"
                ]
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--cluster": "value",
                "--region": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--region": "value",
                "--view": [
                  "basic",
                  "full"
                ]
              }
            },
            "failover": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--cluster": "value",
                "--region": "value"
              }
            },
            "inject-fault": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--cluster": "value",
                "--fault-type": [
                  "stop-vm"
                ],
                "--region": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "restart": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--cluster": "value",
                "--node-ids": "value",
                "--region": "value"
              }
            },
            "update": {
              "commands": {},
              "flags": {
                "--allowed-psc-projects": "value",
                "--assign-inbound-public-ip": "value",
                "--async": "bool",
                "--authorized-external-networks": "value",
                "--availability-type": [
                  "REGIONAL",
                  "ZONAL"
                ],
                "--clear-psc-network-attachment-uri": "bool",
                "--cluster": "value",
                "--cpu-count": [
                  1,
                  2,
                  4,
                  8,
                  16,
                  32,
                  48,
                  64,
                  72,
                  96,
                  128
                ],
                "--database-flags": "value",
                "--insights-config-query-plans-per-minute": "value",
                "--insights-config-query-string-length": "value",
                "--insights-config-record-application-tags": "bool",
                "--insights-config-record-client-address": "bool",
                "--machine-type": [
                  "c4a-highmem-1",
                  "c4a-highmem-16-lssd",
                  "c4a-highmem-32-lssd",
                  "c4a-highmem-4-lssd",
                  "c4a-highmem-48-lssd",
                  "c4a-highmem-64-lssd",
                  "c4a-highmem-72-lssd",
                  "c4a-highmem-8-lssd",
                  "n2-highmem-128",
                  "n2-highmem-16",
                  "n2-highmem-2",
                  "n2-highmem-32",
                  "n2-highmem-4",
                  "n2-highmem-64",
                  "n2-highmem-8",
                  "n2-highmem-96"
                ],
                "--outbound-public-ip": "bool",
                "--psc-network-attachment-uri": "value",
                "--read-pool-node-count": "value",
                "--region": "value",
                "--require-connectors": "bool",
                "--ssl-mode": [
                  "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
                  "ENCRYPTED_ONLY"
                ]
              }
            }
          },
          "flags": {}
        },
        "operations": {
          "commands": {
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            }
          },
          "flags": {}
        },
        "users": {
          "commands": {
            "create": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--db-roles": "value",
                "--keep-extra-roles": "value",
                "--password": "value",
                "--region": "value",
                "--superuser": "value",
                "--type": [
                  "BUILT_IN",
                  "IAM_BASED"
                ]
              }
            },
            "delete": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--region": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "set-password": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--password": "value",
                "--region": "value"
              }
            },
            "set-roles": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--db-roles": "value",
                "--keep-extra-roles": "value",
                "--region": "value"
              }
            },
            "set-superuser": {
              "commands": {},
              "flags": {
                "--cluster": "value",
                "--region": "value",
                "--superuser": "value"
              }
            }
          },
          "flags": {}
        }
      },
      "flags": {}
    },
    "alpha": {
      "commands": {
        "access-approval": {
          "commands": {
            "requests": {
              "commands": {
                "approve": {
                  "commands": {},
                  "flags": {}
                },
                "dismiss": {
                  "commands": {},
                  "flags": {}
                },
                "get": {
                  "commands": {},
                  "flags": {}
                },
                "invalidate": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--state": "value"
                  }
                }
              },
              "flags": {}
            },
            "settings": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "get": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--active_key_version": "value",
                    "--enrolled_services": "value",
                    "--folder": "value",
                    "--notification_emails": "value",
                    "--notification_pubsub_topic": "value",
                    "--organization": "value",
                    "--prefer_no_broad_approval_requests": "value",
                    "--preferred_request_expiration_days": "value",
                    "--request_scope_max_width_preference": [
                      "FOLDER",
                      "ORGANIZATION",
                      "PROJECT"
                    ],
                    "--require_customer_visible_justification": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "access-context-manager": {
          "commands": {
            "authorized-orgs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--asset_type": [
                      "asset-type-credential-strength",
                      "asset-type-device",
                      "asset-type-unspecified"
                    ],
                    "--async": "bool",
                    "--authorization_direction": [
                      "authorization-direction-from",
                      "authorization-direction-to",
                      "authorization-direction-unspecified"
                    ],
                    "--authorization_type": [
                      "authorization-type-trust",
                      "authorization-type-unspecified"
                    ],
                    "--orgs": "value",
                    "--policy": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-orgs": "value",
                    "--clear-orgs": "bool",
                    "--policy": "value",
                    "--remove-orgs": "value",
                    "--set-orgs": "value"
                  }
                }
              },
              "flags": {}
            },
            "cloud-bindings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--binding-file": "value",
                    "--dry-run-level": "value",
                    "--group-key": "value",
                    "--level": "value",
                    "--organization": "value",
                    "--restricted-client-application-client-ids": "value",
                    "--restricted-client-application-names": "value",
                    "--session-length": "value",
                    "--session-reauth-method": [
                      "login",
                      "password",
                      "security-key"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--binding": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--binding": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--append": "bool",
                    "--binding": "value",
                    "--binding-file": "value",
                    "--dry-run-level": "value",
                    "--level": "value",
                    "--organization": "value",
                    "--restricted-client-application-client-ids": "value",
                    "--restricted-client-application-names": "value",
                    "--session-length": "value",
                    "--session-reauth-method": [
                      "login",
                      "password",
                      "security-key"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "levels": {
              "commands": {
                "conditions": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--level": "value",
                        "--policy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--policy": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--custom-level-spec": "value",
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "replace-all": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--source-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--basic-level-spec": "value",
                    "--combine-function": [
                      "and",
                      "or"
                    ],
                    "--custom-level-spec": "value",
                    "--description": "value",
                    "--policy": "value",
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "perimeters": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--policy": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-levels": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--egress-policies": "value",
                    "--enable-vpc-accessible-services": "bool",
                    "--ingress-policies": "value",
                    "--perimeter-type": [
                      "bridge",
                      "regular"
                    ],
                    "--policy": "value",
                    "--resources": "value",
                    "--restricted-services": "value",
                    "--title": "value",
                    "--vpc-allowed-services": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--policy": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--policy": "value"
                  }
                },
                "dry-run": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--access-levels": "value",
                        "--async": "bool",
                        "--egress-policies": "value",
                        "--enable-vpc-accessible-services": "bool",
                        "--ingress-policies": "value",
                        "--perimeter-access-levels": "value",
                        "--perimeter-description": "value",
                        "--perimeter-egress-policies": "value",
                        "--perimeter-enable-vpc-accessible-services": "bool",
                        "--perimeter-ingress-policies": "value",
                        "--perimeter-resources": "value",
                        "--perimeter-restricted-services": "value",
                        "--perimeter-title": "value",
                        "--perimeter-type": "value",
                        "--perimeter-vpc-allowed-services": "value",
                        "--policy": "value",
                        "--resources": "value",
                        "--restricted-services": "value",
                        "--vpc-allowed-services": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--policy": "value"
                      }
                    },
                    "drop": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--policy": "value"
                      }
                    },
                    "enforce": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--policy": "value"
                      }
                    },
                    "enforce-all": {
                      "commands": {},
                      "flags": {
                        "--etag": "value",
                        "--policy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--policy": "value",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-access-levels": "value",
                        "--add-resources": "value",
                        "--add-restricted-services": "value",
                        "--add-vpc-allowed-services": "value",
                        "--async": "bool",
                        "--clear-access-levels": "bool",
                        "--clear-egress-policies": "bool",
                        "--clear-ingress-policies": "bool",
                        "--clear-resources": "bool",
                        "--clear-restricted-services": "bool",
                        "--clear-vpc-allowed-services": "bool",
                        "--enable-vpc-accessible-services": "bool",
                        "--etag": "value",
                        "--policy": "value",
                        "--remove-access-levels": "value",
                        "--remove-resources": "value",
                        "--remove-restricted-services": "value",
                        "--remove-vpc-allowed-services": "value",
                        "--set-egress-policies": "value",
                        "--set-ingress-policies": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--policy": "value",
                    "--sort-by": "value"
                  }
                },
                "replace-all": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--source-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-access-levels": "value",
                    "--add-resources": "value",
                    "--add-restricted-services": "value",
                    "--add-vpc-allowed-services": "value",
                    "--clear-access-levels": "bool",
                    "--clear-egress-policies": "bool",
                    "--clear-ingress-policies": "bool",
                    "--clear-resources": "bool",
                    "--clear-restricted-services": "bool",
                    "--clear-vpc-allowed-services": "bool",
                    "--description": "value",
                    "--enable-vpc-accessible-services": "bool",
                    "--etag": "value",
                    "--policy": "value",
                    "--remove-access-levels": "value",
                    "--remove-resources": "value",
                    "--remove-restricted-services": "value",
                    "--remove-vpc-allowed-services": "value",
                    "--set-access-levels": "value",
                    "--set-egress-policies": "value",
                    "--set-ingress-policies": "value",
                    "--set-resources": "value",
                    "--set-restricted-services": "value",
                    "--title": "value",
                    "--type": [
                      "bridge",
                      "regular"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "policies": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--organization": "value",
                    "--scopes": "value",
                    "--title": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--title": "value"
                  }
                }
              },
              "flags": {}
            },
            "supported-services": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "active-directory": {
          "commands": {
            "domains": {
              "commands": {
                "backups": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--domain": "value",
                        "--labels": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--domain": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--domain": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--domain": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--domain": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-name": "value",
                    "--async": "bool",
                    "--authorized-networks": "value",
                    "--enable-audit-logs": "bool",
                    "--labels": "value",
                    "--region": "value",
                    "--reserved-ip-range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "describe-ldaps-settings": {
                  "commands": {},
                  "flags": {}
                },
                "extend-schema": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--ldif-file": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "migration": {
                  "commands": {
                    "check-permissions": {
                      "commands": {},
                      "flags": {}
                    },
                    "disable": {
                      "commands": {},
                      "flags": {
                        "--async": "bool"
                      }
                    },
                    "enable": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--disable-sid-filtering-domains": "value",
                        "--onprem-domains": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "reset-admin-password": {
                  "commands": {},
                  "flags": {}
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "sql-integrations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--domain": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--domain": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "trusts": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--direction": [
                          "bidirectional",
                          "inbound",
                          "outbound",
                          "trust-direction-unspecified"
                        ],
                        "--handshake-secret": "value",
                        "--selective-authentication": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value",
                        "--type": [
                          "external",
                          "forest",
                          "trust-type-unspecified"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-dns-ip-addresses": "value",
                        "--target-domain-name": "value"
                      }
                    },
                    "validate-state": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--target-domain-name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-authorized-networks": "value",
                    "--add-region": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--enable-audit-logs": "bool",
                    "--remove-authorized-networks": "value",
                    "--remove-labels": "value",
                    "--remove-region": "value",
                    "--update-labels": "value"
                  }
                },
                "update-ldaps-settings": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--certificate-password": "value",
                    "--certificate-pfx-file": "value",
                    "--clear-certificates": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "peerings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--authorized-network": "value",
                    "--domain": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ai": {
          "commands": {
            "custom-jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--args": "value",
                    "--command": "value",
                    "--config": "value",
                    "--display-name": "value",
                    "--enable-dashboard-access": "bool",
                    "--enable-web-access": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--network": "value",
                    "--persistent-resource-id": "value",
                    "--python-package-uris": "value",
                    "--region": "value",
                    "--service-account": "value",
                    "--worker-pool-spec": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "local-run": {
                  "commands": {},
                  "flags": {
                    "--executor-image-uri": "value",
                    "--extra-dirs": "value",
                    "--extra-packages": "value",
                    "--gpu": "bool",
                    "--local-package-path": "value",
                    "--output-image-uri": "value",
                    "--python-module": "value",
                    "--requirements": "value",
                    "--script": "value",
                    "--service-account-key-file": "value"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--region": "dynamic",
                    "--task-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "endpoints": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--encryption-kms-key-name": "value",
                    "--endpoint-id": "value",
                    "--gdce-zone": "value",
                    "--labels": "value",
                    "--network": "value",
                    "--region": "value",
                    "--request-response-logging-rate": "value",
                    "--request-response-logging-table": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "deploy-model": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--autoscaling-metric-specs": "value",
                    "--deployed-model-id": "value",
                    "--display-name": "value",
                    "--enable-access-logging": "bool",
                    "--enable-container-logging": "bool",
                    "--machine-type": "value",
                    "--max-replica-count": "value",
                    "--min-replica-count": "value",
                    "--model": "value",
                    "--multihost-gpu-node-count": "value",
                    "--region": "dynamic",
                    "--reservation-affinity": "value",
                    "--service-account": "value",
                    "--shared-resources": "dynamic",
                    "--shared-resources-region": "dynamic",
                    "--spot": "bool",
                    "--tpu-topology": "value",
                    "--traffic-split": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "direct-predict": {
                  "commands": {},
                  "flags": {
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "direct-raw-predict": {
                  "commands": {},
                  "flags": {
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "explain": {
                  "commands": {},
                  "flags": {
                    "--deployed-model-id": "value",
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--list-model-garden-endpoints-only": "bool",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "predict": {
                  "commands": {},
                  "flags": {
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "raw-predict": {
                  "commands": {},
                  "flags": {
                    "--http-headers": "value",
                    "--region": "dynamic",
                    "--request": "value"
                  }
                },
                "stream-direct-predict": {
                  "commands": {},
                  "flags": {
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "stream-direct-raw-predict": {
                  "commands": {},
                  "flags": {
                    "--json-request": "value",
                    "--region": "dynamic"
                  }
                },
                "stream-raw-predict": {
                  "commands": {},
                  "flags": {
                    "--http-headers": "value",
                    "--region": "dynamic",
                    "--request": "value"
                  }
                },
                "undeploy-model": {
                  "commands": {},
                  "flags": {
                    "--deployed-model-id": "value",
                    "--region": "dynamic",
                    "--traffic-split": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--clear-traffic-split": "bool",
                    "--description": "value",
                    "--disable-request-response-logging": "bool",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--request-response-logging-rate": "value",
                    "--request-response-logging-table": "value",
                    "--traffic-split": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "hp-tuning-jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--algorithm": [
                      "algorithm-unspecified",
                      "grid-search",
                      "random-search"
                    ],
                    "--config": "value",
                    "--display-name": "value",
                    "--enable-dashboard-access": "bool",
                    "--enable-web-access": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--max-trial-count": "value",
                    "--network": "value",
                    "--parallel-trial-count": "value",
                    "--region": "value",
                    "--service-account": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--region": "dynamic",
                    "--task-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "index-endpoints": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--enable-private-service-connect": "bool",
                    "--encryption-kms-key-name": "value",
                    "--labels": "value",
                    "--network": "value",
                    "--project-allowlist": "value",
                    "--public-endpoint-enabled": "bool",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "deploy-index": {
                  "commands": {},
                  "flags": {
                    "--allowed-issuers": "value",
                    "--audiences": "value",
                    "--deployed-index-id": "value",
                    "--deployment-group": "value",
                    "--display-name": "value",
                    "--enable-access-logging": "bool",
                    "--index": "value",
                    "--machine-type": "value",
                    "--max-replica-count": "value",
                    "--min-replica-count": "value",
                    "--psc-automation-configs": "value",
                    "--region": "dynamic",
                    "--reserved-ip-ranges": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "mutate-deployed-index": {
                  "commands": {},
                  "flags": {
                    "--allowed-issuers": "value",
                    "--audiences": "value",
                    "--deployed-index-id": "value",
                    "--deployment-group": "value",
                    "--enable-access-logging": "bool",
                    "--machine-type": "value",
                    "--max-replica-count": "value",
                    "--min-replica-count": "value",
                    "--region": "dynamic",
                    "--reserved-ip-ranges": "value"
                  }
                },
                "undeploy-index": {
                  "commands": {},
                  "flags": {
                    "--deployed-index-id": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "indexes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--encryption-kms-key-name": "value",
                    "--index-update-method": [
                      "batch-update",
                      "stream-update"
                    ],
                    "--labels": "value",
                    "--metadata-file": "value",
                    "--metadata-schema-uri": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-datapoints": {
                  "commands": {},
                  "flags": {
                    "--datapoint-ids": "value",
                    "--datapoints-from-file": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--metadata-file": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                },
                "upsert-datapoints": {
                  "commands": {},
                  "flags": {
                    "--datapoints-from-file": "value",
                    "--region": "dynamic",
                    "--update-mask": "value"
                  }
                }
              },
              "flags": {}
            },
            "model-garden": {
              "commands": {
                "models": {
                  "commands": {
                    "deploy": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--accept-eula": "bool",
                        "--asynchronous": "bool",
                        "--container-args": "value",
                        "--container-command": "value",
                        "--container-deployment-timeout-seconds": "value",
                        "--container-env-vars": "value",
                        "--container-grpc-ports": "value",
                        "--container-health-probe-exec": "value",
                        "--container-health-probe-period-seconds": "value",
                        "--container-health-probe-timeout-seconds": "value",
                        "--container-health-route": "value",
                        "--container-image-uri": "value",
                        "--container-ports": "value",
                        "--container-predict-route": "value",
                        "--container-shared-memory-size-mb": "value",
                        "--container-startup-probe-exec": "value",
                        "--container-startup-probe-period-seconds": "value",
                        "--container-startup-probe-timeout-seconds": "value",
                        "--enable-fast-tryout": "bool",
                        "--endpoint-display-name": "value",
                        "--hugging-face-access-token": "value",
                        "--machine-type": "value",
                        "--model": "value",
                        "--region": "value",
                        "--reservation-affinity": "value",
                        "--spot": "bool",
                        "--use-dedicated-endpoint": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--list-supported-hugging-face-models": "bool",
                        "--model-filter": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list-deployment-config": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--hugging-face-access-token": "value",
                        "--model": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "model-monitoring-jobs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--analysis-instance-schema": "value",
                    "--anomaly-cloud-logging": "bool",
                    "--bigquery-uri": "value",
                    "--data-format": "value",
                    "--dataset": "value",
                    "--display-name": "value",
                    "--emails": "value",
                    "--endpoint": "value",
                    "--feature-attribution-thresholds": "value",
                    "--feature-thresholds": "value",
                    "--gcs-uris": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--log-ttl": "value",
                    "--monitoring-config-from-file": "value",
                    "--monitoring-frequency": "value",
                    "--notification-channels": "value",
                    "--predict-instance-schema": "value",
                    "--prediction-sampling-rate": "value",
                    "--region": "value",
                    "--sample-predict-request": "value",
                    "--target-field": "value",
                    "--training-sampling-rate": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "pause": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--analysis-instance-schema": "value",
                    "--anomaly-cloud-logging": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--emails": "value",
                    "--feature-attribution-thresholds": "value",
                    "--feature-thresholds": "value",
                    "--log-ttl": "value",
                    "--monitoring-config-from-file": "value",
                    "--monitoring-frequency": "value",
                    "--notification-channels": "value",
                    "--prediction-sampling-rate": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "copy": {
                  "commands": {},
                  "flags": {
                    "--destination-model-id": "value",
                    "--destination-parent-model": "value",
                    "--kms-key-name": "value",
                    "--region": "value",
                    "--source-model": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "delete-version": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-version": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--artifact-uri": "value",
                    "--container-args": "value",
                    "--container-command": "value",
                    "--container-deployment-timeout-seconds": "value",
                    "--container-env-vars": "value",
                    "--container-grpc-ports": "value",
                    "--container-health-probe-exec": "value",
                    "--container-health-probe-period-seconds": "value",
                    "--container-health-probe-timeout-seconds": "value",
                    "--container-health-route": "value",
                    "--container-image-uri": "value",
                    "--container-ports": "value",
                    "--container-predict-route": "value",
                    "--container-shared-memory-size-mb": "value",
                    "--container-startup-probe-exec": "value",
                    "--container-startup-probe-period-seconds": "value",
                    "--container-startup-probe-timeout-seconds": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--explanation-metadata-file": "value",
                    "--explanation-method": "value",
                    "--explanation-modality": "value",
                    "--explanation-nearest-neighbor-search-config-file": "value",
                    "--explanation-neighbor-count": "value",
                    "--explanation-path-count": "value",
                    "--explanation-query": "value",
                    "--explanation-step-count": "value",
                    "--labels": "value",
                    "--model-id": "value",
                    "--parent-model": "value",
                    "--region": "value",
                    "--smooth-grad-noise-sigma": "value",
                    "--smooth-grad-noise-sigma-by-feature": "value",
                    "--smooth-grad-noisy-sample-count": "value",
                    "--uris": "value",
                    "--version-aliases": "value",
                    "--version-description": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--index": "value",
                    "--index-endpoint": "value",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "persistent-resources": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config": "value",
                    "--display-name": "value",
                    "--enable-custom-service-account": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--network": "value",
                    "--persistent-resource-id": "value",
                    "--region": "value",
                    "--resource-pool-spec": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "reboot": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "tensorboard-experiments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--tensorboard-id": "dynamic",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tensorboard-runs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tensorboard-time-series": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--plugin-data": "value",
                    "--plugin-name": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--type": [
                      "blob-sequence",
                      "scalar",
                      "tensor"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic",
                    "--uri": "bool"
                  }
                },
                "read": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--max-data-points": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--plugin-data": "value",
                    "--plugin-name": "value",
                    "--region": "dynamic",
                    "--tensorboard-experiment-id": "dynamic",
                    "--tensorboard-id": "dynamic",
                    "--tensorboard-run-id": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "tensorboards": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "ai-platform": {
          "commands": {
            "explain": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--json-request": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--text-instances": "value"
              }
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--summarize": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "stream-logs": {
                  "commands": {},
                  "flags": {
                    "--allow-multiline-logs": "bool",
                    "--polling-interval": "value",
                    "--task-name": "value"
                  }
                },
                "submit": {
                  "commands": {
                    "prediction": {
                      "commands": {},
                      "flags": {
                        "--accelerator-count": "value",
                        "--accelerator-type": [
                          "nvidia-tesla-k80",
                          "nvidia-tesla-p100"
                        ],
                        "--batch-size": "value",
                        "--data-format": [
                          "text",
                          "tf-record",
                          "tf-record-gzip"
                        ],
                        "--input-paths": "value",
                        "--labels": "value",
                        "--max-worker-count": "value",
                        "--model": "value",
                        "--model-dir": "value",
                        "--output-path": "value",
                        "--region": "value",
                        "--runtime-version": "value",
                        "--signature-name": "value"
                      }
                    },
                    "training": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--config": "value",
                        "--enable-web-access": "bool",
                        "--job-dir": "value",
                        "--kms-key": "dynamic",
                        "--kms-keyring": "dynamic",
                        "--kms-location": "dynamic",
                        "--kms-project": "dynamic",
                        "--labels": "value",
                        "--master-accelerator": "value",
                        "--master-image-uri": "value",
                        "--master-machine-type": "value",
                        "--module-name": "value",
                        "--network": "value",
                        "--package-path": "value",
                        "--packages": "value",
                        "--parameter-server-accelerator": "value",
                        "--parameter-server-count": "value",
                        "--parameter-server-image-uri": "value",
                        "--parameter-server-machine-type": "value",
                        "--python-version": "value",
                        "--region": "dynamic",
                        "--runtime-version": "value",
                        "--scale-tier": [
                          "basic",
                          "basic-gpu",
                          "basic-tpu",
                          "custom",
                          "premium-1",
                          "standard-1"
                        ],
                        "--service-account": "value",
                        "--staging-bucket": "value",
                        "--stream-logs": "bool",
                        "--tpu-tf-version": "value",
                        "--use-chief-in-tf-config": "value",
                        "--worker-accelerator": "value",
                        "--worker-count": "value",
                        "--worker-image-uri": "value",
                        "--worker-machine-type": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "local": {
              "commands": {
                "predict": {
                  "commands": {},
                  "flags": {
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--json-instances": "value",
                    "--json-request": "value",
                    "--model-dir": "value",
                    "--signature-name": "value",
                    "--text-instances": "value"
                  }
                },
                "train": {
                  "commands": {},
                  "flags": {
                    "--distributed": "bool",
                    "--evaluator-count": "value",
                    "--job-dir": "value",
                    "--module-name": "value",
                    "--package-path": "value",
                    "--parameter-server-count": "value",
                    "--start-port": "value",
                    "--worker-count": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "models": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--enable-console-logging": "bool",
                    "--enable-logging": "bool",
                    "--labels": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--regions": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--role": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "predict": {
              "commands": {},
              "flags": {
                "--json-instances": "value",
                "--json-request": "value",
                "--model": "value",
                "--region": [
                  "asia-east1",
                  "asia-northeast1",
                  "asia-southeast1",
                  "australia-southeast1",
                  "europe-west1",
                  "europe-west2",
                  "europe-west3",
                  "europe-west4",
                  "global",
                  "northamerica-northeast1",
                  "us-central1",
                  "us-east1",
                  "us-east4",
                  "us-west1"
                ],
                "--signature-name": "value",
                "--text-instances": "value"
              }
            },
            "versions": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--args": "value",
                    "--async": "bool",
                    "--command": "value",
                    "--config": "value",
                    "--description": "value",
                    "--env-vars": "value",
                    "--explanation-method": [
                      "integrated-gradients",
                      "sampled-shapley",
                      "xrai"
                    ],
                    "--framework": [
                      "scikit-learn",
                      "tensorflow",
                      "xgboost"
                    ],
                    "--health-route": "value",
                    "--image": "value",
                    "--labels": "value",
                    "--machine-type": "value",
                    "--max-nodes": "value",
                    "--metric-targets": "value",
                    "--min-nodes": "value",
                    "--model": "value",
                    "--num-integral-steps": "value",
                    "--num-paths": "value",
                    "--origin": "value",
                    "--package-uris": "value",
                    "--ports": "value",
                    "--predict-route": "value",
                    "--prediction-class": "value",
                    "--python-version": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--runtime-version": "value",
                    "--service-account": "value",
                    "--staging-bucket": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--model": "value",
                    "--page-size": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-default": {
                  "commands": {},
                  "flags": {
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ]
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--bigquery-table-name": "value",
                    "--clear-labels": "bool",
                    "--config": "value",
                    "--description": "value",
                    "--model": "value",
                    "--region": [
                      "asia-east1",
                      "asia-northeast1",
                      "asia-southeast1",
                      "australia-southeast1",
                      "europe-west1",
                      "europe-west2",
                      "europe-west3",
                      "europe-west4",
                      "global",
                      "northamerica-northeast1",
                      "us-central1",
                      "us-east1",
                      "us-east4",
                      "us-west1"
                    ],
                    "--remove-labels": "value",
                    "--sampling-percentage": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "alloydb": {
          "commands": {
            "backups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--region": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--allocated-ip-range-name": "value",
                    "--async": "bool",
                    "--automated-backup-days-of-week": "value",
                    "--automated-backup-encryption-key": "dynamic",
                    "--automated-backup-encryption-key-keyring": "dynamic",
                    "--automated-backup-encryption-key-location": "dynamic",
                    "--automated-backup-encryption-key-project": "dynamic",
                    "--automated-backup-retention-count": "value",
                    "--automated-backup-retention-period": "value",
                    "--automated-backup-start-times": "value",
                    "--automated-backup-window": "value",
                    "--continuous-backup-encryption-key": "dynamic",
                    "--continuous-backup-encryption-key-keyring": "dynamic",
                    "--continuous-backup-encryption-key-location": "dynamic",
                    "--continuous-backup-encryption-key-project": "dynamic",
                    "--continuous-backup-recovery-window-days": "value",
                    "--database-version": [
                      "POSTGRES_14",
                      "POSTGRES_15",
                      "POSTGRES_16"
                    ],
                    "--disable-automated-backup": "bool",
                    "--enable-continuous-backup": "bool",
                    "--enable-private-service-connect": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--maintenance-window-day": [
                      "MONDAY",
                      "TUESDAY",
                      "WEDNESDAY",
                      "THURSDAY",
                      "FRIDAY",
                      "SATURDAY",
                      "SUNDAY"
                    ],
                    "--maintenance-window-hour": "value",
                    "--network": "value",
                    "--password": "value",
                    "--region": "value",
                    "--subscription-type": [
                      "STANDARD",
                      "TRIAL"
                    ],
                    "--tags": "value"
                  }
                },
                "create-secondary": {
                  "commands": {},
                  "flags": {
                    "--allocated-ip-range-name": "value",
                    "--async": "bool",
                    "--automated-backup-days-of-week": "value",
                    "--automated-backup-encryption-key": "dynamic",
                    "--automated-backup-encryption-key-keyring": "dynamic",
                    "--automated-backup-encryption-key-location": "dynamic",
                    "--automated-backup-encryption-key-project": "dynamic",
                    "--automated-backup-retention-count": "value",
                    "--automated-backup-retention-period": "value",
                    "--automated-backup-start-times": "value",
                    "--automated-backup-window": "value",
                    "--continuous-backup-encryption-key": "dynamic",
                    "--continuous-backup-encryption-key-keyring": "dynamic",
                    "--continuous-backup-encryption-key-location": "dynamic",
                    "--continuous-backup-encryption-key-project": "dynamic",
                    "--continuous-backup-recovery-window-days": "value",
                    "--enable-automated-backup": "bool",
                    "--enable-continuous-backup": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--primary-cluster": "value",
                    "--region": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--force": "bool",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clean-target-objects": "bool",
                    "--csv": "bool",
                    "--database": "value",
                    "--escape-character": "value",
                    "--field-delimiter": "value",
                    "--gcs-uri": "value",
                    "--if-exist-target-objects": "bool",
                    "--quote-character": "value",
                    "--region": "value",
                    "--schema-only": "bool",
                    "--select-query": "value",
                    "--sql": "bool",
                    "--tables": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--columns": "value",
                    "--csv": "bool",
                    "--database": "value",
                    "--escape-character": "value",
                    "--field-delimiter": "value",
                    "--gcs-uri": "value",
                    "--quote-character": "value",
                    "--region": "value",
                    "--sql": "bool",
                    "--table": "value",
                    "--user": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "migrate-cloud-sql": {
                  "commands": {},
                  "flags": {
                    "--allocated-ip-range-name": "value",
                    "--async": "bool",
                    "--automated-backup-days-of-week": "value",
                    "--automated-backup-encryption-key": "dynamic",
                    "--automated-backup-encryption-key-keyring": "dynamic",
                    "--automated-backup-encryption-key-location": "dynamic",
                    "--automated-backup-encryption-key-project": "dynamic",
                    "--automated-backup-retention-count": "value",
                    "--automated-backup-retention-period": "value",
                    "--automated-backup-start-times": "value",
                    "--automated-backup-window": "value",
                    "--cloud-sql-backup-id": "value",
                    "--cloud-sql-instance-id": "value",
                    "--cloud-sql-project-id": "value",
                    "--continuous-backup-encryption-key": "dynamic",
                    "--continuous-backup-encryption-key-keyring": "dynamic",
                    "--continuous-backup-encryption-key-location": "dynamic",
                    "--continuous-backup-encryption-key-project": "dynamic",
                    "--continuous-backup-recovery-window-days": "value",
                    "--database-version": [
                      "POSTGRES_14",
                      "POSTGRES_15",
                      "POSTGRES_16"
                    ],
                    "--disable-automated-backup": "bool",
                    "--enable-continuous-backup": "bool",
                    "--enable-private-service-connect": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--maintenance-window-day": [
                      "MONDAY",
                      "TUESDAY",
                      "WEDNESDAY",
                      "THURSDAY",
                      "FRIDAY",
                      "SATURDAY",
                      "SUNDAY"
                    ],
                    "--maintenance-window-hour": "value",
                    "--network": "value",
                    "--password": "value",
                    "--region": "value",
                    "--subscription-type": [
                      "STANDARD",
                      "TRIAL"
                    ],
                    "--tags": "value"
                  }
                },
                "promote": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--allocated-ip-range-name": "value",
                    "--async": "bool",
                    "--backup": "value",
                    "--enable-private-service-connect": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--network": "value",
                    "--point-in-time": "value",
                    "--region": "value",
                    "--source-cluster": "value",
                    "--tags": "value"
                  }
                },
                "switchover": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--automated-backup-days-of-week": "value",
                    "--automated-backup-encryption-key": "dynamic",
                    "--automated-backup-encryption-key-keyring": "dynamic",
                    "--automated-backup-encryption-key-location": "dynamic",
                    "--automated-backup-encryption-key-project": "dynamic",
                    "--automated-backup-retention-count": "value",
                    "--automated-backup-retention-period": "value",
                    "--automated-backup-start-times": "value",
                    "--automated-backup-window": "value",
                    "--clear-automated-backup": "bool",
                    "--clear-continuous-backup-encryption-key": "bool",
                    "--continuous-backup-encryption-key": "dynamic",
                    "--continuous-backup-encryption-key-keyring": "dynamic",
                    "--continuous-backup-encryption-key-location": "dynamic",
                    "--continuous-backup-encryption-key-project": "dynamic",
                    "--continuous-backup-recovery-window-days": "value",
                    "--disable-automated-backup": "bool",
                    "--enable-continuous-backup": "bool",
                    "--maintenance-window-any": "bool",
                    "--maintenance-window-day": [
                      "MONDAY",
                      "TUESDAY",
                      "WEDNESDAY",
                      "THURSDAY",
                      "FRIDAY",
                      "SATURDAY",
                      "SUNDAY"
                    ],
                    "--maintenance-window-hour": "value",
                    "--region": "value",
                    "--subscription-type": [
                      "STANDARD",
                      "TRIAL"
                    ]
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "value"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--allowed-psc-projects": "value",
                    "--assign-inbound-public-ip": "value",
                    "--async": "bool",
                    "--authorized-external-networks": "value",
                    "--availability-type": [
                      "REGIONAL",
                      "ZONAL"
                    ],
                    "--cluster": "value",
                    "--connection-pooling-ignore-startup-parameters": "value",
                    "--connection-pooling-max-client-connections": "value",
                    "--connection-pooling-max-pool-size": "value",
                    "--connection-pooling-min-pool-size": "value",
                    "--connection-pooling-pool-mode": [
                      "SESSION",
                      "TRANSACTION"
                    ],
                    "--connection-pooling-query-wait-timeout": "value",
                    "--connection-pooling-server-idle-timeout": "value",
                    "--connection-pooling-stats-users": "value",
                    "--cpu-count": [
                      1,
                      2,
                      4,
                      8,
                      16,
                      32,
                      48,
                      64,
                      72,
                      96,
                      128
                    ],
                    "--database-flags": "value",
                    "--enable-connection-pooling": "bool",
                    "--insights-config-query-plans-per-minute": "value",
                    "--insights-config-query-string-length": "value",
                    "--insights-config-record-application-tags": "bool",
                    "--insights-config-record-client-address": "bool",
                    "--instance-type": [
                      "PRIMARY",
                      "READ_POOL"
                    ],
                    "--machine-type": [
                      "c4a-highmem-1",
                      "c4a-highmem-16-lssd",
                      "c4a-highmem-32-lssd",
                      "c4a-highmem-4-lssd",
                      "c4a-highmem-48-lssd",
                      "c4a-highmem-64-lssd",
                      "c4a-highmem-72-lssd",
                      "c4a-highmem-8-lssd",
                      "n2-highmem-128",
                      "n2-highmem-16",
                      "n2-highmem-2",
                      "n2-highmem-32",
                      "n2-highmem-4",
                      "n2-highmem-64",
                      "n2-highmem-8",
                      "n2-highmem-96"
                    ],
                    "--observability-config-enabled": "bool",
                    "--observability-config-max-query-string-length": "value",
                    "--observability-config-preserve-comments": "bool",
                    "--observability-config-query-plans-per-minute": "value",
                    "--observability-config-record-application-tags": "bool",
                    "--observability-config-track-active-queries": "bool",
                    "--observability-config-track-wait-events": "bool",
                    "--outbound-public-ip": "bool",
                    "--psc-network-attachment-uri": "value",
                    "--read-pool-node-count": "value",
                    "--region": "value",
                    "--require-connectors": "bool",
                    "--ssl-mode": [
                      "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
                      "ENCRYPTED_ONLY"
                    ]
                  }
                },
                "create-secondary": {
                  "commands": {},
                  "flags": {
                    "--allowed-psc-projects": "value",
                    "--assign-inbound-public-ip": "value",
                    "--async": "bool",
                    "--authorized-external-networks": "value",
                    "--availability-type": [
                      "REGIONAL",
                      "ZONAL"
                    ],
                    "--cluster": "value",
                    "--database-flags": "value",
                    "--outbound-public-ip": "bool",
                    "--psc-network-attachment-uri": "value",
                    "--region": "value",
                    "--require-connectors": "bool",
                    "--ssl-mode": [
                      "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
                      "ENCRYPTED_ONLY"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--region": "value",
                    "--view": [
                      "basic",
                      "full"
                    ]
                  }
                },
                "failover": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--region": "value"
                  }
                },
                "inject-fault": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--fault-type": [
                      "stop-vm"
                    ],
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "restart": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "value",
                    "--node-ids": "value",
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--activation-policy": [
                      "ALWAYS",
                      "NEVER"
                    ],
                    "--allowed-psc-projects": "value",
                    "--assign-inbound-public-ip": "value",
                    "--async": "bool",
                    "--authorized-external-networks": "value",
                    "--availability-type": [
                      "REGIONAL",
                      "ZONAL"
                    ],
                    "--clear-psc-network-attachment-uri": "bool",
                    "--cluster": "value",
                    "--connection-pooling-ignore-startup-parameters": "value",
                    "--connection-pooling-max-client-connections": "value",
                    "--connection-pooling-max-pool-size": "value",
                    "--connection-pooling-min-pool-size": "value",
                    "--connection-pooling-pool-mode": [
                      "SESSION",
                      "TRANSACTION"
                    ],
                    "--connection-pooling-query-wait-timeout": "value",
                    "--connection-pooling-server-idle-timeout": "value",
                    "--connection-pooling-stats-users": "value",
                    "--cpu-count": [
                      1,
                      2,
                      4,
                      8,
                      16,
                      32,
                      48,
                      64,
                      72,
                      96,
                      128
                    ],
                    "--database-flags": "value",
                    "--enable-connection-pooling": "bool",
                    "--insights-config-query-plans-per-minute": "value",
                    "--insights-config-query-string-length": "value",
                    "--insights-config-record-application-tags": "bool",
                    "--insights-config-record-client-address": "bool",
                    "--machine-type": [
                      "c4a-highmem-1",
                      "c4a-highmem-16-lssd",
                      "c4a-highmem-32-lssd",
                      "c4a-highmem-4-lssd",
                      "c4a-highmem-48-lssd",
                      "c4a-highmem-64-lssd",
                      "c4a-highmem-72-lssd",
                      "c4a-highmem-8-lssd",
                      "n2-highmem-128",
                      "n2-highmem-16",
                      "n2-highmem-2",
                      "n2-highmem-32",
                      "n2-highmem-4",
                      "n2-highmem-64",
                      "n2-highmem-8",
                      "n2-highmem-96"
                    ],
                    "--observability-config-enabled": "bool",
                    "--observability-config-max-query-string-length": "value",
                    "--observability-config-preserve-comments": "bool",
                    "--observability-config-query-plans-per-minute": "value",
                    "--observability-config-record-application-tags": "bool",
                    "--observability-config-track-active-queries": "bool",
                    "--observability-config-track-wait-events": "bool",
                    "--outbound-public-ip": "bool",
                    "--psc-network-attachment-uri": "value",
                    "--read-pool-node-count": "value",
                    "--region": "value",
                    "--require-connectors": "bool",
                    "--ssl-mode": [
                      "ALLOW_UNENCRYPTED_AND_ENCRYPTED",
                      "ENCRYPTED_ONLY"
                    ],
                    "--update-mode": [
                      "FORCE_APPLY"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "users": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--db-roles": "value",
                    "--keep-extra-roles": "value",
                    "--password": "value",
                    "--region": "value",
                    "--superuser": "value",
                    "--type": [
                      "BUILT_IN",
                      "IAM_BASED"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-password": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--password": "value",
                    "--region": "value"
                  }
                },
                "set-roles": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--db-roles": "value",
                    "--keep-extra-roles": "value",
                    "--region": "value"
                  }
                },
                "set-superuser": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--region": "value",
                    "--superuser": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "anthos": {
          "commands": {
            "apply": {
              "commands": {},
              "flags": {}
            },
            "auth": {
              "commands": {
                "login": {
                  "commands": {},
                  "flags": {
                    "--cluster": "value",
                    "--dry-run": "bool",
                    "--kubeconfig": "value",
                    "--login-config": "value",
                    "--login-config-cert": "value",
                    "--no-browser": "bool",
                    "--remote-bootstrap": "value",
                    "--server": "value",
                    "--set-preferred-auth": "bool",
                    "--user": "value"
                  }
                }
              },
              "flags": {}
            },
            "config": {
              "commands": {
                "controller": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cluster-ipv4-cidr-block": "value",
                        "--cluster-named-range": "value",
                        "--experimental-features": "value",
                        "--full-management": "bool",
                        "--location": "dynamic",
                        "--man-block": "value",
                        "--man-blocks": "value",
                        "--master-ipv4-cidr-block": "value",
                        "--network": "value",
                        "--services-ipv4-cidr-block": "value",
                        "--services-named-range": "value",
                        "--subnet": "value",
                        "--use-private-endpoint": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic"
                      }
                    },
                    "get-config-connector-identity": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--full-name": "bool",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--experimental-features": "value",
                        "--location": "dynamic",
                        "--man-block": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "sync": {
                  "commands": {
                    "repo": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--cluster": "value",
                            "--managed-resources": "value",
                            "--source": "value",
                            "--sync-name": "value",
                            "--sync-namespace": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--membership": "value",
                            "--namespace": "value",
                            "--selector": "value",
                            "--status": "value",
                            "--targets": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "resources": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--cluster": "value",
                            "--membership": "value",
                            "--sync-name": "value",
                            "--sync-namespace": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "create-login-config": {
              "commands": {},
              "flags": {
                "--kubeconfig": "value",
                "--merge-from": "value",
                "--output": "value"
              }
            },
            "export": {
              "commands": {},
              "flags": {
                "--location": "value",
                "--output-directory": "value"
              }
            }
          },
          "flags": {}
        },
        "api-gateway": {
          "commands": {
            "api-configs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--async": "bool",
                    "--backend-auth-service-account": "value",
                    "--display-name": "value",
                    "--grpc-files": "value",
                    "--labels": "value",
                    "--openapi-spec": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--view": [
                      "BASIC",
                      "FULL"
                    ]
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "apis": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--display-name": "value",
                    "--labels": "value",
                    "--managed-service": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "gateways": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--api-config": "value",
                    "--async": "bool",
                    "--display-name": "value",
                    "--labels": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--api-config": "value",
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--display-name": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "apigee": {
          "commands": {
            "apis": {
              "commands": {
                "deploy": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--organization": "value",
                    "--override": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--revision": "value",
                    "--verbose": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "undeploy": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "applications": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--developer": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "archives": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--environment": "value",
                    "--organization": "value"
                  }
                },
                "deploy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--bundle-file": "value",
                    "--environment": "value",
                    "--labels": "value",
                    "--organization": "value",
                    "--source": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--environment": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--environment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--environment": "value",
                    "--organization": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "deployments": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--api": "value",
                    "--environment": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--revision": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "developers": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "environments": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "organizations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "provision": {
                  "commands": {},
                  "flags": {
                    "--analytics-region": "value",
                    "--async": "bool",
                    "--authorized-network": "value",
                    "--runtime-location": "value"
                  }
                }
              },
              "flags": {}
            },
            "products": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--all-environments": "bool",
                    "--all-proxies": "bool",
                    "--apis": "value",
                    "--attributes": "value",
                    "--description": "value",
                    "--display-name": "value",
                    "--environments": "value",
                    "--internal-access": "bool",
                    "--manual-approval": "bool",
                    "--oauth-scopes": "value",
                    "--organization": "value",
                    "--private-access": "bool",
                    "--public-access": "bool",
                    "--quota": "value",
                    "--quota-interval": "value",
                    "--quota-unit": [
                      "day",
                      "hour",
                      "minute",
                      "month"
                    ],
                    "--resources": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-api": "value",
                    "--add-attribute": "value",
                    "--add-environment": "value",
                    "--add-oauth-scope": "value",
                    "--add-resource": "value",
                    "--all-apis": "bool",
                    "--all-environments": "bool",
                    "--all-resources": "bool",
                    "--automatic-approval": "bool",
                    "--clear-attributes": "bool",
                    "--clear-description": "bool",
                    "--clear-oauth-scopes": "bool",
                    "--clear-quota": "bool",
                    "--description": "value",
                    "--display-name": "value",
                    "--internal-access": "bool",
                    "--manual-approval": "bool",
                    "--organization": "value",
                    "--private-access": "bool",
                    "--public-access": "bool",
                    "--quota": "value",
                    "--quota-interval": "value",
                    "--quota-unit": [
                      "day",
                      "hour",
                      "minute",
                      "month"
                    ],
                    "--remove-api": "value",
                    "--remove-attribute": "value",
                    "--remove-environment": "value",
                    "--remove-oauth-scope": "value",
                    "--remove-resource": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "app": {
          "commands": {
            "domain-mappings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate-id": "value",
                    "--certificate-management": [
                      "automatic",
                      "manual"
                    ],
                    "--no-certificate-id": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--display-name": "value",
                    "--private-key": "value"
                  }
                }
              },
              "flags": {}
            },
            "update": {
              "commands": {},
              "flags": {
                "--service-account": "value",
                "--split-health-checks": "bool",
                "--ssl-policy": [
                  "TLS_VERSION_1_0",
                  "TLS_VERSION_1_2"
                ]
              }
            }
          },
          "flags": {}
        },
        "apphub": {
          "commands": {
            "applications": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--business-owners": "value",
                    "--criticality-type": [
                      "HIGH",
                      "LOW",
                      "MEDIUM",
                      "MISSION_CRITICAL",
                      "TYPE_UNSPECIFIED"
                    ],
                    "--description": "value",
                    "--developer-owners": "value",
                    "--display-name": "value",
                    "--environment-type": [
                      "DEVELOPMENT",
                      "PRODUCTION",
                      "STAGING",
                      "TEST",
                      "TYPE_UNSPECIFIED"
                    ],
                    "--location": "value",
                    "--operator-owners": "value",
                    "--scope-type": [
                      "GLOBAL",
                      "REGIONAL"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--member": "value",
                    "--role": "value"
                  }
                },
                "services": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--async": "bool",
                        "--business-owners": "value",
                        "--criticality-type": [
                          "HIGH",
                          "LOW",
                          "MEDIUM",
                          "MISSION_CRITICAL",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--description": "value",
                        "--developer-owners": "value",
                        "--discovered-service": "value",
                        "--display-name": "value",
                        "--environment-type": [
                          "DEVELOPMENT",
                          "PRODUCTION",
                          "STAGING",
                          "TEST",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--location": "value",
                        "--operator-owners": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--async": "bool",
                        "--business-owners": "value",
                        "--criticality-type": [
                          "HIGH",
                          "LOW",
                          "MEDIUM",
                          "MISSION_CRITICAL",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--description": "value",
                        "--developer-owners": "value",
                        "--display-name": "value",
                        "--environment-type": [
                          "DEVELOPMENT",
                          "PRODUCTION",
                          "STAGING",
                          "TEST",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--location": "value",
                        "--operator-owners": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--business-owners": "value",
                    "--criticality-type": [
                      "HIGH",
                      "LOW",
                      "MEDIUM",
                      "MISSION_CRITICAL",
                      "TYPE_UNSPECIFIED"
                    ],
                    "--description": "value",
                    "--developer-owners": "value",
                    "--display-name": "value",
                    "--environment-type": [
                      "DEVELOPMENT",
                      "PRODUCTION",
                      "STAGING",
                      "TEST",
                      "TYPE_UNSPECIFIED"
                    ],
                    "--location": "value",
                    "--operator-owners": "value"
                  }
                },
                "workloads": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--async": "bool",
                        "--business-owners": "value",
                        "--criticality-type": [
                          "HIGH",
                          "LOW",
                          "MEDIUM",
                          "MISSION_CRITICAL",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--description": "value",
                        "--developer-owners": "value",
                        "--discovered-workload": "value",
                        "--display-name": "value",
                        "--environment-type": [
                          "DEVELOPMENT",
                          "PRODUCTION",
                          "STAGING",
                          "TEST",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--location": "value",
                        "--operator-owners": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--application": "value",
                        "--async": "bool",
                        "--business-owners": "value",
                        "--criticality-type": [
                          "HIGH",
                          "LOW",
                          "MEDIUM",
                          "MISSION_CRITICAL",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--description": "value",
                        "--developer-owners": "value",
                        "--display-name": "value",
                        "--environment-type": [
                          "DEVELOPMENT",
                          "PRODUCTION",
                          "STAGING",
                          "TEST",
                          "TYPE_UNSPECIFIED"
                        ],
                        "--location": "value",
                        "--operator-owners": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "discovered-services": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "find-unregistered": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "lookup": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--uri": "value"
                  }
                }
              },
              "flags": {}
            },
            "discovered-workloads": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "find-unregistered": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "lookup": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--uri": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "service-projects": {
              "commands": {
                "add": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "detach": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "lookup": {
                  "commands": {},
                  "flags": {}
                },
                "remove": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "artifacts": {
          "commands": {
            "apt": {
              "commands": {
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--gcs-source": "value",
                    "--location": "value"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            },
            "docker": {
              "commands": {
                "images": {
                  "commands": {
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--delete-tags": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--metadata-filter": "value",
                        "--show-all-metadata": "bool",
                        "--show-build-details": "bool",
                        "--show-deployment": "bool",
                        "--show-image-basis": "bool",
                        "--show-package-vulnerability": "bool",
                        "--show-provenance": "bool",
                        "--show-sbom-references": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--include-tags": "bool",
                        "--limit": "value",
                        "--occurrence-filter": "value",
                        "--page-size": "value",
                        "--show-occurrences": "bool",
                        "--show-occurrences-from": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "tags": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {}
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "files": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--package": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value",
                    "--tag": "value"
                  }
                }
              },
              "flags": {}
            },
            "generic": {
              "commands": {
                "download": {
                  "commands": {},
                  "flags": {
                    "--chunk-size": "value",
                    "--destination": "value",
                    "--location": "value",
                    "--name": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-path": "value",
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value",
                    "--skip-existing": "bool",
                    "--source": "value",
                    "--source-directory": "value"
                  }
                }
              },
              "flags": {}
            },
            "go": {
              "commands": {
                "upload": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--module-path": "value",
                    "--repository": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "packages": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "print-settings": {
              "commands": {
                "apt": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "gradle": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "mvn": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "npm": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value",
                    "--scope": "value"
                  }
                },
                "python": {
                  "commands": {},
                  "flags": {
                    "--json-key": "value",
                    "--location": "value",
                    "--repository": "value"
                  }
                },
                "yum": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--repository": "value"
                  }
                }
              },
              "flags": {}
            },
            "repositories": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--location": "value",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--allow-snapshot-overwrites": "bool",
                    "--async": "bool",
                    "--description": "value",
                    "--kms-key": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--repository-format": "value",
                    "--version-policy": [
                      "none",
                      "release",
                      "snapshot"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--location": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "settings": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "disable-upgrade-redirection": {
                  "commands": {},
                  "flags": {}
                },
                "enable-upgrade-redirection": {
                  "commands": {},
                  "flags": {
                    "--dry-run": "bool"
                  }
                }
              },
              "flags": {}
            },
            "tags": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--package": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                }
              },
              "flags": {}
            },
            "versions": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--delete-tags": "bool",
                    "--location": "value",
                    "--package": "value",
                    "--repository": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--package": "value",
                    "--page-size": "value",
                    "--repository": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpcsc-config": {
              "commands": {
                "allow": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "deny": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            },
            "yum": {
              "commands": {
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--gcs-source": "value",
                    "--location": "value"
                  }
                },
                "upload": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "asset": {
          "commands": {
            "analyze-iam-policy": {
              "commands": {},
              "flags": {
                "--access-time": "value",
                "--analyze-service-account-impersonation": "bool",
                "--execution-timeout": "value",
                "--expand-groups": "bool",
                "--expand-resources": "bool",
                "--expand-roles": "bool",
                "--folder": "value",
                "--full-resource-name": "value",
                "--identity": "value",
                "--include-deny-policy-analysis": "bool",
                "--organization": "value",
                "--output-group-edges": "bool",
                "--output-resource-edges": "bool",
                "--permissions": "value",
                "--roles": "value",
                "--saved-analysis-query": "value",
                "--show-response": "bool"
              }
            },
            "analyze-iam-policy-longrunning": {
              "commands": {},
              "flags": {
                "--access-time": "value",
                "--analyze-service-account-impersonation": "bool",
                "--bigquery-dataset": "value",
                "--bigquery-partition-key": [
                  "PARTITION_KEY_UNSPECIFIED",
                  "REQUEST_TIME"
                ],
                "--bigquery-table-prefix": "value",
                "--bigquery-write-disposition": "value",
                "--expand-groups": "bool",
                "--expand-resources": "bool",
                "--expand-roles": "bool",
                "--folder": "value",
                "--full-resource-name": "value",
                "--gcs-output-path": "value",
                "--identity": "value",
                "--include-deny-policy-analysis": "bool",
                "--organization": "value",
                "--output-group-edges": "bool",
                "--output-resource-edges": "bool",
                "--permissions": "value",
                "--roles": "value"
              }
            },
            "analyze-org-policies": {
              "commands": {},
              "flags": {
                "--constraint": "value",
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--scope": "value",
                "--sort-by": "value"
              }
            },
            "analyze-org-policy-governed-containers": {
              "commands": {},
              "flags": {
                "--constraint": "value",
                "--filter": "value",
                "--limit": "value",
                "--page-size": "value",
                "--scope": "value",
                "--sort-by": "value"
              }
            },
            "export": {
              "commands": {},
              "flags": {
                "--asset-types": "value",
                "--bigquery-dataset": "dynamic",
                "--bigquery-table": "dynamic",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "os-inventory",
                  "relationship",
                  "resource"
                ],
                "--folder": "value",
                "--organization": "value",
                "--output-bigquery-force": "bool",
                "--output-path": "value",
                "--output-path-prefix": "value",
                "--partition-key": [
                  "read-time",
                  "request-time"
                ],
                "--per-asset-type": "bool",
                "--relationship-types": "value",
                "--snapshot-time": "value"
              }
            },
            "feeds": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--asset-names": "value",
                    "--asset-types": "value",
                    "--condition-description": "value",
                    "--condition-expression": "value",
                    "--condition-title": "value",
                    "--content-type": [
                      "access-policy",
                      "iam-policy",
                      "org-policy",
                      "os-inventory",
                      "relationship",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value",
                    "--relationship-types": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-asset-names": "value",
                    "--add-asset-types": "value",
                    "--add-relationship-types": "value",
                    "--clear-asset-names": "bool",
                    "--clear-asset-types": "bool",
                    "--clear-condition-description": "bool",
                    "--clear-condition-expression": "bool",
                    "--clear-condition-title": "bool",
                    "--clear-content-type": "bool",
                    "--clear-relationship-types": "bool",
                    "--condition-description": "value",
                    "--condition-expression": "value",
                    "--condition-title": "value",
                    "--content-type": [
                      "access-policy",
                      "iam-policy",
                      "org-policy",
                      "os-inventory",
                      "relationship",
                      "resource"
                    ],
                    "--folder": "value",
                    "--organization": "value",
                    "--pubsub-topic": "value",
                    "--remove-asset-names": "value",
                    "--remove-asset-types": "value",
                    "--remove-relationship-types": "value"
                  }
                }
              },
              "flags": {}
            },
            "get-history": {
              "commands": {},
              "flags": {
                "--asset-names": "value",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "os-inventory",
                  "relationship",
                  "resource"
                ],
                "--end-time": "value",
                "--organization": "value",
                "--relationship-types": "value",
                "--start-time": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--asset-types": "value",
                "--content-type": [
                  "access-policy",
                  "iam-policy",
                  "org-policy",
                  "os-inventory",
                  "relationship",
                  "resource"
                ],
                "--filter": "value",
                "--folder": "value",
                "--limit": "value",
                "--organization": "value",
                "--page-size": "value",
                "--relationship-types": "value",
                "--snapshot-time": "value",
                "--sort-by": "value"
              }
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "query": {
              "commands": {},
              "flags": {
                "--bigquery-dataset": "dynamic",
                "--bigquery-table": "dynamic",
                "--end-time": "value",
                "--folder": "value",
                "--job-reference": "value",
                "--organization": "value",
                "--page-size": "value",
                "--page-token": "value",
                "--snapshot-time": "value",
                "--start-time": "value",
                "--statement": "value",
                "--timeout": "value",
                "--write-disposition": [
                  "write-append",
                  "write-empty",
                  "write-truncate"
                ]
              }
            },
            "saved-queries": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--folder": "value",
                    "--labels": "value",
                    "--organization": "value",
                    "--query-file-path": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--folder": "value",
                    "--organization": "value",
                    "--query-file-path": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "assured": {
          "commands": {
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "workloads": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--compliance-regime": [
                      "assured-workloads-for-partners",
                      "au-regions-and-us-support",
                      "ca-protected-b",
                      "ca-regions-and-support",
                      "canada-controlled-goods",
                      "cjis",
                      "eu-regions-and-support",
                      "fedramp-high",
                      "fedramp-moderate",
                      "healthcare-and-life-sciences-controls",
                      "healthcare-and-life-sciences-controls-us-support",
                      "hipaa",
                      "hitrust",
                      "il2",
                      "il4",
                      "il5",
                      "irs-1075",
                      "isr-regions",
                      "isr-regions-and-support",
                      "itar",
                      "jp-regions-and-support",
                      "ksa-regions-and-support-with-sovereignty-controls",
                      "regional-controls",
                      "us-regional-access"
                    ],
                    "--display-name": "value",
                    "--enable-sovereign-controls": "value",
                    "--external-identifier": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--next-rotation-time": "value",
                    "--organization": "value",
                    "--partner": [
                      "local-controls-by-s3ns",
                      "sovereign-controls-by-cntxt",
                      "sovereign-controls-by-cntxt-no-ekm",
                      "sovereign-controls-by-psn",
                      "sovereign-controls-by-sia-minsait",
                      "sovereign-controls-by-t-systems"
                    ],
                    "--partner-permissions": "value",
                    "--partner-services-billing-account": "value",
                    "--provisioned-resources-parent": "value",
                    "--resource-settings": "value",
                    "--rotation-period": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--etag": "value",
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "enable-resource-monitoring": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value",
                    "--etag": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--organization": "value",
                    "--violation-notifications-enabled": "value"
                  }
                },
                "violations": {
                  "commands": {
                    "acknowledge": {
                      "commands": {},
                      "flags": {
                        "--acknowledge-type": "value",
                        "--comment": "value",
                        "--location": "value",
                        "--organization": "value",
                        "--workload": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--organization": "value",
                        "--workload": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--workload": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "audit-manager": {
          "commands": {
            "audit-reports": {
              "commands": {
                "generate": {
                  "commands": {},
                  "flags": {
                    "--compliance-framework": "value",
                    "--folder": "value",
                    "--gcs-uri": "value",
                    "--location": "value",
                    "--report-format": [
                      "odf"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "audit-scopes": {
              "commands": {
                "generate": {
                  "commands": {},
                  "flags": {
                    "--compliance-framework": "value",
                    "--folder": "value",
                    "--location": "value",
                    "--output-directory": "value",
                    "--output-file-name": "value",
                    "--report-format": [
                      "odf"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "enrollments": {
              "commands": {
                "add": {
                  "commands": {},
                  "flags": {
                    "--eligible-gcs-buckets": "value",
                    "--folder": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "auth": {
          "commands": {
            "activate-service-account": {
              "commands": {},
              "flags": {
                "--key-file": "value",
                "--password-file": "value",
                "--prompt-for-password": "bool"
              }
            },
            "application-default": {
              "commands": {
                "login": {
                  "commands": {},
                  "flags": {
                    "--browser": "bool",
                    "--client-id-file": "value",
                    "--disable-quota-project": "bool",
                    "--launch-browser": "bool",
                    "--login-config": "value",
                    "--scopes": "value"
                  }
                },
                "print-access-token": {
                  "commands": {},
                  "flags": {
                    "--lifetime": "value",
                    "--scopes": "value"
                  }
                },
                "revoke": {
                  "commands": {},
                  "flags": {}
                },
                "set-quota-project": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "configure-docker": {
              "commands": {},
              "flags": {}
            },
            "enterprise-certificate-config": {
              "commands": {
                "create": {
                  "commands": {
                    "linux": {
                      "commands": {},
                      "flags": {
                        "--ecp": "value",
                        "--ecp-client": "value",
                        "--label": "value",
                        "--module": "value",
                        "--output-file": "value",
                        "--slot": "value",
                        "--tls-offload": "value",
                        "--user-pin": "value"
                      }
                    },
                    "macos": {
                      "commands": {},
                      "flags": {
                        "--ecp": "value",
                        "--ecp-client": "value",
                        "--issuer": "value",
                        "--keychain-type": "value",
                        "--output-file": "value",
                        "--tls-offload": "value"
                      }
                    },
                    "windows": {
                      "commands": {},
                      "flags": {
                        "--ecp": "value",
                        "--ecp-client": "value",
                        "--issuer": "value",
                        "--output-file": "value",
                        "--provider": "value",
                        "--store": "value",
                        "--tls-offload": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--filter-account": "value",
                "--limit": "value",
                "--page-size": "value",
                "--sort-by": "value"
              }
            },
            "login": {
              "commands": {},
              "flags": {
                "--activate": "bool",
                "--brief": "bool",
                "--browser": "bool",
                "--cred-file": "value",
                "--enable-gdrive-access": "bool",
                "--force": "bool",
                "--launch-browser": "bool",
                "--login-config": "value",
                "--update-adc": "bool"
              }
            },
            "print-access-token": {
              "commands": {},
              "flags": {
                "--lifetime": "value"
              }
            },
            "print-identity-token": {
              "commands": {},
              "flags": {
                "--audiences": "value",
                "--include-email": "bool",
                "--include-license": "bool",
                "--token-format": [
                  "full",
                  "standard"
                ]
              }
            },
            "revoke": {
              "commands": {},
              "flags": {
                "--all": "bool"
              }
            }
          },
          "flags": {}
        },
        "backup-dr": {
          "commands": {
            "backup-plan-associations": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-plan": "dynamic",
                    "--location": "dynamic",
                    "--resource": "value",
                    "--resource-type": "value",
                    "--workload-project": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic",
                    "--workload-project": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "trigger-backup": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-rule-id": "value",
                    "--location": "dynamic",
                    "--workload-project": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "backup-plans": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-rule": "value",
                    "--backup-vault": "dynamic",
                    "--description": "value",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--resource-type": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "backup-vaults": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-restriction": [
                      "unrestricted",
                      "within-org",
                      "within-org-but-unrestricted-for-ba",
                      "within-project"
                    ],
                    "--backup-min-enforced-retention": "value",
                    "--description": "value",
                    "--effective-time": "value",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--no-async": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--allow-missing": "bool",
                    "--ignore-backup-plan-references": "bool",
                    "--ignore-inactive-datasources": "bool",
                    "--location": "dynamic",
                    "--no-async": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backup-min-enforced-retention": "value",
                    "--description": "value",
                    "--effective-time": "value",
                    "--force-update": "bool",
                    "--location": "dynamic",
                    "--no-async": "bool",
                    "--unlock-backup-min-enforced-retention": "bool"
                  }
                }
              },
              "flags": {}
            },
            "backups": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-vault": "dynamic",
                    "--data-source": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--backup-vault": "dynamic",
                    "--data-source": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--backup-vault": "value",
                    "--data-source": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "restore": {
                  "commands": {
                    "compute": {
                      "commands": {},
                      "flags": {
                        "--accelerator": "value",
                        "--async": "bool",
                        "--backup-vault": "dynamic",
                        "--can-ip-forward": "bool",
                        "--confidential-compute": "bool",
                        "--create-disk": "value",
                        "--data-source": "dynamic",
                        "--deletion-protection": "bool",
                        "--description": "value",
                        "--enable-display-device": "bool",
                        "--enable-uefi-networking": "bool",
                        "--hostname": "value",
                        "--instance-kms-key": "value",
                        "--instance-termination-action": [
                          "DELETE",
                          "STOP"
                        ],
                        "--key-revocation-action-type": "value",
                        "--labels": "value",
                        "--local-ssd-recovery-timeout": "value",
                        "--location": "dynamic",
                        "--machine-type": "value",
                        "--maintenance-policy": [
                          "MIGRATE",
                          "TERMINATE"
                        ],
                        "--metadata": "value",
                        "--min-cpu-platform": "value",
                        "--min-node-cpu": "value",
                        "--name": "value",
                        "--network-interface": "value",
                        "--network-performance-configs": "value",
                        "--no-scopes": "bool",
                        "--preemptible": "bool",
                        "--private-ipv6-google-access-type": "value",
                        "--provisioning-model": [
                          "SPOT",
                          "STANDARD"
                        ],
                        "--reservation": "value",
                        "--reservation-affinity": [
                          "any",
                          "none",
                          "specific"
                        ],
                        "--resource-manager-tags": "value",
                        "--resource-policies": "value",
                        "--restart-on-failure": "bool",
                        "--scopes": "value",
                        "--service-account": "value",
                        "--tags": "value",
                        "--target-project": "value",
                        "--target-zone": "value",
                        "--threads-per-core": "value",
                        "--visible-core-count": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-vault": "dynamic",
                    "--data-source": "dynamic",
                    "--enforced-retention-end-time": "value",
                    "--location": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "data-sources": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--backup-vault": "dynamic",
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--backup-vault": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "locations": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "management-servers": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic",
                    "--network": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "resource-backup-config": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "batch": {
          "commands": {
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "submit": {
                  "commands": {},
                  "flags": {
                    "--config": "value",
                    "--container-commands-file": "value",
                    "--container-entrypoint": "value",
                    "--container-image-uri": "value",
                    "--job-prefix": "value",
                    "--location": "value",
                    "--machine-type": "value",
                    "--network": "value",
                    "--no-external-ip-address": "bool",
                    "--priority": "value",
                    "--provisioning-model": [
                      "SPOT",
                      "STANDARD"
                    ],
                    "--script-file-path": "value",
                    "--script-text": "value",
                    "--subnetwork": "value"
                  }
                }
              },
              "flags": {}
            },
            "resource-allowances": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--config": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--usage-limit": "value"
                  }
                }
              },
              "flags": {}
            },
            "tasks": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--job": "value",
                    "--location": "value",
                    "--task_group": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--job": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "beyondcorp": {
          "commands": {
            "app": {
              "commands": {
                "connections": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--application-endpoint": "value",
                        "--application-endpoint-host": "value",
                        "--application-endpoint-port": "value",
                        "--async": "bool",
                        "--connectors": "value",
                        "--display-name": "value",
                        "--labels": "value",
                        "--location": "dynamic",
                        "--type": [
                          "tcp"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--application-endpoint": "value",
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--connectors": "value",
                        "--display-name": "value",
                        "--location": "dynamic",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "connectors": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--display-name": "value",
                        "--labels": "value",
                        "--location": "dynamic",
                        "--member": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--details": "bool",
                        "--location": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--display-name": "value",
                        "--location": "dynamic",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "bigtable": {
          "commands": {
            "app-profiles": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--instance": "value",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--data-boost": "bool",
                    "--data-boost-compute-billing-owner": [
                      "HOST_PAYS"
                    ],
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--priority": [
                      "PRIORITY_HIGH",
                      "PRIORITY_LOW",
                      "PRIORITY_MEDIUM"
                    ],
                    "--restrict-to": "value",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--row-affinity": "bool",
                    "--standard": "bool",
                    "--transactional-writes": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--force": "bool",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--data-boost": "bool",
                    "--data-boost-compute-billing-owner": [
                      "HOST_PAYS"
                    ],
                    "--description": "value",
                    "--force": "bool",
                    "--instance": "dynamic",
                    "--priority": [
                      "PRIORITY_HIGH",
                      "PRIORITY_LOW",
                      "PRIORITY_MEDIUM"
                    ],
                    "--restrict-to": "value",
                    "--route-any": "bool",
                    "--route-to": "dynamic",
                    "--row-affinity": "bool",
                    "--standard": "bool",
                    "--transactional-writes": "bool"
                  }
                }
              },
              "flags": {}
            },
            "authorized-views": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic",
                    "--table": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--definition-file": "value",
                    "--instance": "dynamic",
                    "--pre-encoded": "bool",
                    "--table": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic",
                    "--table": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic",
                    "--table": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--table": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--table": "dynamic",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic",
                    "--table": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic",
                    "--table": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--definition-file": "value",
                    "--ignore-warnings": "bool",
                    "--instance": "dynamic",
                    "--interactive": "bool",
                    "--pre-encoded": "bool",
                    "--table": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "backups": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "copy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-backup": "dynamic",
                    "--destination-cluster": "dynamic",
                    "--destination-instance": "dynamic",
                    "--destination-project": "dynamic",
                    "--expiration-date": "value",
                    "--retention-period": "value",
                    "--source-backup": "dynamic",
                    "--source-cluster": "dynamic",
                    "--source-instance": "dynamic",
                    "--source-project": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--backup-type": [
                      "backup-type-unspecified",
                      "hot",
                      "standard"
                    ],
                    "--cluster": "dynamic",
                    "--expiration-date": "value",
                    "--hot-to-standard-time": "value",
                    "--instance": "dynamic",
                    "--retention-period": "value",
                    "--table": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--cluster": "dynamic",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--instance": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--cluster": "dynamic",
                    "--expiration-date": "value",
                    "--hot-to-standard-time": "value",
                    "--instance": "dynamic",
                    "--retention-period": "value"
                  }
                }
              },
              "flags": {}
            },
            "clusters": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--autoscaling-cpu-target": "value",
                    "--autoscaling-max-nodes": "value",
                    "--autoscaling-min-nodes": "value",
                    "--autoscaling-storage-target": "value",
                    "--instance": "dynamic",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--node-scaling-factor": [
                      "node-scaling-factor-1x",
                      "node-scaling-factor-2x"
                    ],
                    "--num-nodes": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instances": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--autoscaling-cpu-target": "value",
                    "--autoscaling-max-nodes": "value",
                    "--autoscaling-min-nodes": "value",
                    "--autoscaling-storage-target": "value",
                    "--disable-autoscaling": "bool",
                    "--instance": "dynamic",
                    "--num-nodes": "value"
                  }
                }
              },
              "flags": {}
            },
            "hot-tablets": {
              "commands": {
                "list": {
                  "commands": {},
                  "flags": {
                    "--end-time": "value",
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--start-time": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cluster": "dynamic",
                    "--cluster-config": "value",
                    "--cluster-num-nodes": "value",
                    "--cluster-storage-type": [
                      "hdd",
                      "ssd"
                    ],
                    "--cluster-zone": "value",
                    "--display-name": "value",
                    "--instance-type": [
                      "DEVELOPMENT",
                      "PRODUCTION"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "tables": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "config": {
                      "commands": {
                        "export": {
                          "commands": {},
                          "flags": {
                            "--all": "bool",
                            "--instance": "dynamic",
                            "--path": "value",
                            "--resource-format": [
                              "krm",
                              "terraform"
                            ]
                          }
                        }
                      },
                      "flags": {}
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--automated-backup-retention-period": "value",
                        "--change-stream-retention-period": "value",
                        "--column-families": "value",
                        "--deletion-protection": "bool",
                        "--enable-automated-backup": "bool",
                        "--instance": "dynamic",
                        "--row-key-schema-definition-file": "value",
                        "--row-key-schema-pre-encoded-bytes": "bool",
                        "--splits": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic",
                        "--view": [
                          "encryption",
                          "full",
                          "name",
                          "replication",
                          "schema",
                          "stats"
                        ]
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instances": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--instance": "dynamic",
                        "--member": "value",
                        "--role": "dynamic"
                      }
                    },
                    "restore": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--destination": "dynamic",
                        "--destination-instance": "dynamic",
                        "--source": "dynamic",
                        "--source-cluster": "dynamic",
                        "--source-instance": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--instance": "dynamic"
                      }
                    },
                    "undelete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--instance": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--automated-backup-retention-period": "value",
                        "--change-stream-retention-period": "value",
                        "--clear-change-stream-retention-period": "bool",
                        "--clear-row-key-schema": "bool",
                        "--deletion-protection": "bool",
                        "--disable-automated-backup": "bool",
                        "--enable-automated-backup": "bool",
                        "--instance": "dynamic",
                        "--row-key-schema-definition-file": "value",
                        "--row-key-schema-pre-encoded-bytes": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--display-name": "value"
                  }
                },
                "upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool"
                  }
                }
              },
              "flags": {}
            },
            "logical-views": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--query": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic",
                    "--query": "value"
                  }
                }
              },
              "flags": {}
            },
            "materialized-views": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--deletion-protection": "value",
                    "--instance": "dynamic",
                    "--query": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--deletion-protection": "value",
                    "--instance": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "tables": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--instance": "dynamic",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--automated-backup-retention-period": "value",
                    "--change-stream-retention-period": "value",
                    "--column-families": "value",
                    "--deletion-protection": "bool",
                    "--enable-automated-backup": "bool",
                    "--instance": "dynamic",
                    "--row-key-schema-definition-file": "value",
                    "--row-key-schema-pre-encoded-bytes": "bool",
                    "--splits": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic",
                    "--view": [
                      "encryption",
                      "full",
                      "name",
                      "replication",
                      "schema",
                      "stats"
                    ]
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instance": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--instances": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--instance": "dynamic",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination": "dynamic",
                    "--destination-instance": "dynamic",
                    "--source": "dynamic",
                    "--source-cluster": "dynamic",
                    "--source-instance": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--instance": "dynamic"
                  }
                },
                "undelete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--instance": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--automated-backup-retention-period": "value",
                    "--change-stream-retention-period": "value",
                    "--clear-change-stream-retention-period": "bool",
                    "--clear-row-key-schema": "bool",
                    "--deletion-protection": "bool",
                    "--disable-automated-backup": "bool",
                    "--enable-automated-backup": "bool",
                    "--instance": "dynamic",
                    "--row-key-schema-definition-file": "value",
                    "--row-key-schema-pre-encoded-bytes": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "billing": {
          "commands": {
            "accounts": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "projects": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "link": {
                      "commands": {},
                      "flags": {
                        "--account-id": "dynamic",
                        "--billing-account": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--billing-account": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "unlink": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "budgets": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--all-updates-rule-monitoring-notification-channels": "value",
                    "--all-updates-rule-pubsub-topic": "value",
                    "--billing-account": "value",
                    "--budget-amount": "value",
                    "--calendar-period": [
                      "calendar-period-unspecified",
                      "month",
                      "quarter",
                      "year"
                    ],
                    "--credit-types-treatment": [
                      "credit-types-treatment-unspecified",
                      "exclude-all-credits",
                      "include-all-credits",
                      "include-specified-credits"
                    ],
                    "--disable-default-iam-recipients": "bool",
                    "--display-name": "value",
                    "--end-date": "value",
                    "--filter-credit-types": "value",
                    "--filter-labels": "value",
                    "--filter-projects": "value",
                    "--filter-resource-ancestors": "value",
                    "--filter-services": "value",
                    "--filter-subaccounts": "value",
                    "--last-period-amount": "bool",
                    "--ownership-scope": [
                      "all-users",
                      "billing-account",
                      "ownership-scope-unspecified"
                    ],
                    "--start-date": "value",
                    "--threshold-rule": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-threshold-rule": "value",
                    "--all-updates-rule-monitoring-notification-channels": "value",
                    "--all-updates-rule-pubsub-topic": "value",
                    "--billing-account": "value",
                    "--budget-amount": "value",
                    "--calendar-period": [
                      "calendar-period-unspecified",
                      "month",
                      "quarter",
                      "year"
                    ],
                    "--clear-threshold-rules": "bool",
                    "--credit-types-treatment": [
                      "credit-types-treatment-unspecified",
                      "exclude-all-credits",
                      "include-all-credits",
                      "include-specified-credits"
                    ],
                    "--disable-default-iam-recipients": "bool",
                    "--display-name": "value",
                    "--end-date": "value",
                    "--filter-credit-types": "value",
                    "--filter-labels": "value",
                    "--filter-projects": "value",
                    "--filter-resource-ancestors": "value",
                    "--filter-services": "value",
                    "--filter-subaccounts": "value",
                    "--last-period-amount": "bool",
                    "--ownership-scope": [
                      "all-users",
                      "billing-account",
                      "ownership-scope-unspecified"
                    ],
                    "--start-date": "value",
                    "--threshold-rules-from-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "projects": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "link": {
                  "commands": {},
                  "flags": {
                    "--account-id": "dynamic",
                    "--billing-account": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--billing-account": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "unlink": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "blockchain-node-engine": {
          "commands": {
            "locations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "nodes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--blockchain-type": [
                      "ethereum"
                    ],
                    "--consensus-client": [
                      "lighthouse"
                    ],
                    "--execution-client": [
                      "geth"
                    ],
                    "--location": "dynamic",
                    "--network": [
                      "goerli",
                      "holesky",
                      "mainnet",
                      "sepolia"
                    ],
                    "--node-type": [
                      "full"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "dynamic",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "blockchain-validator": {
          "commands": {
            "blockchain-validator-configs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--blockchain-node-id": "value",
                    "--blockchain-type": [
                      "ethereum"
                    ],
                    "--ethereum-protocol-details-gas-limit": "value",
                    "--ethereum-protocol-details-graffiti": "value",
                    "--ethereum-protocol-details-suggested-fee-recipient": "value",
                    "--ethereum-protocol-details-use-block-builder-proposals": "bool",
                    "--existing-seed-phrase-reference-derivation-index": "value",
                    "--existing-seed-phrase-reference-secret": "value",
                    "--key-source": [
                      "existing-seed-phrase-reference",
                      "remote-web3-signer",
                      "seed-phrase-reference"
                    ],
                    "--labels": "value",
                    "--location": "value",
                    "--remote-web3-signer-timeout-duration": "value",
                    "--remote-web3-signer-voting-public-key": "value",
                    "--remote-web3-signer-web3signer-uri": "value",
                    "--request-id": "value",
                    "--seed-phrase-reference-export": "bool",
                    "--seed-phrase-reference-secret": "value",
                    "--validation-work-enabled": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic",
                    "--request-id": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--blockchain-node-id": "value",
                    "--clear-labels": "bool",
                    "--ethereum-protocol-details-graffiti": "value",
                    "--labels": "value",
                    "--location": "dynamic",
                    "--remote-web3-signer-timeout-duration": "value",
                    "--remote-web3-signer-web3signer-uri": "value",
                    "--remove-labels": "value",
                    "--request-id": "value",
                    "--update-labels": "value",
                    "--validation-work-enabled": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "bms": {
          "commands": {
            "instances": {
              "commands": {
                "auth-info": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "disable-hyperthreading": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "disable-serial-console": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "enable-hyperthreading": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "enable-serial-console": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "reimage": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--kms-crypto-key-version": "value",
                    "--os-image": "value",
                    "--region": "dynamic",
                    "--ssh-keys": "dynamic"
                  }
                },
                "rename": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--region": "dynamic"
                  }
                },
                "reset": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--clear-ssh-keys": "bool",
                    "--enable-hyperthreading": "bool",
                    "--kms-crypto-key-version": "value",
                    "--os-image": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--ssh-keys": "dynamic",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "networks": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "list-ip-reservations": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "rename": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-ip-range-reservation": "value",
                    "--async": "bool",
                    "--clear-ip-range-reservations": "bool",
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-ip-range-reservation": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "nfs-shares": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--allowed-client": "value",
                    "--async": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--size-gib": "value",
                    "--storage-type": [
                      "HDD",
                      "SSD"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "rename": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-allowed-client": "value",
                    "--async": "bool",
                    "--clear-allowed-clients": "bool",
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-allowed-client": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "os-images": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value"
                  }
                }
              },
              "flags": {}
            },
            "serial-console-ssh-keys": {
              "commands": {
                "add": {
                  "commands": {},
                  "flags": {
                    "--key": "value",
                    "--key-file": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value"
                  }
                },
                "remove": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "ssh-keys": {
              "commands": {
                "add": {
                  "commands": {},
                  "flags": {
                    "--key": "value",
                    "--key-file": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value"
                  }
                },
                "remove": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "volumes": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--region": "dynamic"
                  }
                },
                "luns": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--volume": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--region": "dynamic",
                        "--volume": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "rename": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--region": "dynamic"
                  }
                },
                "restore": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic",
                    "--snapshot": "value"
                  }
                },
                "snapshot": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--region": "dynamic",
                    "--snapshot-name": "value"
                  }
                },
                "snapshots": {
                  "commands": {
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--volume": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--volume": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--region": "dynamic",
                        "--volume": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "bq": {
          "commands": {
            "datasets": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--overwrite": "bool",
                    "--permissions-file": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--remove-tables": "bool"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--permissions-file": "value"
                  }
                }
              },
              "flags": {}
            },
            "jobs": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {}
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--show-all-users": "bool",
                    "--show-config": "bool",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "migration-workflows": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--config-file": "value",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "tables": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--dataset": "dynamic",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "copy": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination": "dynamic",
                    "--destination-dataset": "dynamic",
                    "--job-id": "value",
                    "--overwrite": "bool",
                    "--source": "dynamic",
                    "--source-dataset": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--description": "value",
                    "--expiration": "value",
                    "--overwrite": "bool",
                    "--schema": "value",
                    "--schema-file": "value",
                    "--use-legacy-sql": "bool",
                    "--view": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic"
                  }
                },
                "insert": {
                  "commands": {},
                  "flags": {
                    "--data": "value",
                    "--dataset": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "show-rows": {
                  "commands": {},
                  "flags": {
                    "--dataset": "dynamic",
                    "--limit": "value",
                    "--start": "value",
                    "--table": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-columns": "value",
                    "--add-columns-file": "value",
                    "--dataset": "dynamic",
                    "--description": "value",
                    "--expiration": "value",
                    "--relax-columns": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "builds": {
          "commands": {
            "approve": {
              "commands": {},
              "flags": {
                "--comment": "value",
                "--location": "value",
                "--url": "value"
              }
            },
            "cancel": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "connections": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {
                    "bitbucket-cloud": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--read-authorizer-token-secret-version": "value",
                        "--region": "dynamic",
                        "--webhook-secret-secret-version": "value",
                        "--workspace": "value"
                      }
                    },
                    "bitbucket-data-center": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--host-uri": "value",
                        "--read-authorizer-token-secret-version": "value",
                        "--region": "dynamic",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--app-installation-id": "value",
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--region": "dynamic"
                      }
                    },
                    "github-enterprise": {
                      "commands": {},
                      "flags": {
                        "--app-id": "value",
                        "--app-installation-id": "value",
                        "--app-slug": "value",
                        "--async": "bool",
                        "--host-uri": "value",
                        "--private-key-secret-version": "value",
                        "--region": "dynamic",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    },
                    "gitlab": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--host-uri": "value",
                        "--read-authorizer-token-secret-version": "value",
                        "--region": "dynamic",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {
                    "bitbucket-cloud": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--read-authorizer-token-secret-version": "value",
                        "--region": "dynamic",
                        "--webhook-secret-secret-version": "value",
                        "--workspace": "value"
                      }
                    },
                    "bitbucket-data-center": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--host-uri": "value",
                        "--read-authorizer-token-secret-version": "value",
                        "--region": "dynamic",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--app-installation-id": "value",
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--region": "dynamic"
                      }
                    },
                    "github-enterprise": {
                      "commands": {},
                      "flags": {
                        "--app-id": "value",
                        "--app-installation-id": "value",
                        "--app-slug": "value",
                        "--async": "bool",
                        "--host-uri": "value",
                        "--private-key-secret-version": "value",
                        "--region": "dynamic",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    },
                    "gitlab": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--authorizer-token-secret-version": "value",
                        "--host-uri": "value",
                        "--read-authorizer-token-secret-version": "value",
                        "--region": "dynamic",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "describe": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "enterprise-config": {
              "commands": {
                "bitbucketserver": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-access-token-secret-version": "value",
                        "--api-key": "value",
                        "--host-uri": "value",
                        "--name": "value",
                        "--peered-network": "value",
                        "--peered-network-ip-range": "value",
                        "--read-access-token-secret-version": "value",
                        "--region": "value",
                        "--ssl-ca-file": "value",
                        "--user-name": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--admin-access-token-secret-version": "value",
                        "--api-key": "value",
                        "--host-uri": "value",
                        "--read-access-token-secret-version": "value",
                        "--region": "value",
                        "--ssl-ca-file": "value",
                        "--user-name": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "github": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--app-id": "value",
                        "--gcs-bucket": "value",
                        "--gcs-object": "value",
                        "--generation": "value",
                        "--host-uri": "value",
                        "--name": "value",
                        "--oauth-client-id-name": "value",
                        "--oauth-client-id-version-name": "value",
                        "--oauth-secret-name": "value",
                        "--oauth-secret-version-name": "value",
                        "--peered-network": "value",
                        "--private-key-name": "value",
                        "--private-key-version-name": "value",
                        "--region": "value",
                        "--webhook-key": "value",
                        "--webhook-secret-name": "value",
                        "--webhook-secret-version-name": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--app-id": "value",
                        "--gcs-bucket": "value",
                        "--gcs-object": "value",
                        "--generation": "value",
                        "--host-uri": "value",
                        "--oauth-client-id-name": "value",
                        "--oauth-client-id-version-name": "value",
                        "--oauth-secret-name": "value",
                        "--oauth-secret-version-name": "value",
                        "--private-key-name": "value",
                        "--private-key-version-name": "value",
                        "--region": "value",
                        "--webhook-key": "value",
                        "--webhook-secret-name": "value",
                        "--webhook-secret-version-name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "gitlab": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--api-access-token-secret-version": "value",
                        "--api-key-secret-version": "value",
                        "--host-uri": "value",
                        "--name": "value",
                        "--read-access-token-secret-version": "value",
                        "--region": "value",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value",
                        "--user-name": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--api-access-token-secret-version": "value",
                        "--api-key-secret-version": "value",
                        "--host-uri": "value",
                        "--read-access-token-secret-version": "value",
                        "--region": "value",
                        "--service-directory-service": "value",
                        "--ssl-ca-file": "value",
                        "--user-name": "value",
                        "--webhook-secret-secret-version": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "get-default-service-account": {
              "commands": {},
              "flags": {
                "--region": "value"
              }
            },
            "list": {
              "commands": {},
              "flags": {
                "--filter": "value",
                "--limit": "value",
                "--ongoing": "bool",
                "--page-size": "value",
                "--region": "value",
                "--sort-by": "value",
                "--uri": "bool"
              }
            },
            "log": {
              "commands": {},
              "flags": {
                "--region": "value",
                "--stream": "bool"
              }
            },
            "reject": {
              "commands": {},
              "flags": {
                "--comment": "value",
                "--url": "value"
              }
            },
            "repositories": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--connection": "dynamic",
                    "--region": "dynamic",
                    "--remote-uri": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--connection": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--connection": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--connection": "dynamic",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "submit": {
              "commands": {},
              "flags": {
                "--async": "bool",
                "--config": "value",
                "--default-buckets-behavior": [
                  "default-logs-bucket-behavior-unspecified",
                  "legacy-bucket",
                  "regional-user-owned-bucket"
                ],
                "--dir": "value",
                "--disk-size": "value",
                "--gcs-log-dir": "value",
                "--gcs-source-staging-dir": "value",
                "--git-source-dir": "value",
                "--git-source-revision": "value",
                "--ignore-file": "value",
                "--machine-type": [
                  "e2-highcpu-32",
                  "e2-highcpu-8",
                  "e2-medium",
                  "n1-highcpu-32",
                  "n1-highcpu-8"
                ],
                "--no-cache": "bool",
                "--no-source": "bool",
                "--pack": "value",
                "--polling-interval": "value",
                "--region": "value",
                "--revision": "value",
                "--service-account": "value",
                "--substitutions": "value",
                "--suppress-logs": "bool",
                "--tag": "value",
                "--timeout": "value",
                "--worker-pool": "value"
              }
            },
            "triggers": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {
                    "bitbucket-cloud": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "bitbucket-data-center": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "bitbucketserver": {
                      "commands": {},
                      "flags": {
                        "--bitbucket-server-config-resource": "value",
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--project-key": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--repo-slug": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "cloud-source-repositories": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--region": "value",
                        "--repo": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "developer-connect": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--git-repository-link": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--enterprise-config": "value",
                        "--ignored-files": "value",
                        "--include-logs-with-status": "bool",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "gitlab": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "manual": {
                      "commands": {},
                      "flags": {
                        "--branch": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--github-enterprise-config": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--region": "value",
                        "--repo": "value",
                        "--repo-type": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--substitutions": "value",
                        "--tag": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "pubsub": {
                      "commands": {},
                      "flags": {
                        "--branch": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--github-enterprise-config": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--region": "value",
                        "--repo": "value",
                        "--repo-type": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--subscription-filter": "value",
                        "--substitutions": "value",
                        "--tag": "value",
                        "--topic": "value",
                        "--trigger-config": "value"
                      }
                    },
                    "webhook": {
                      "commands": {},
                      "flags": {
                        "--branch": "value",
                        "--build-config": "value",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--github-enterprise-config": "value",
                        "--inline-config": "value",
                        "--name": "value",
                        "--region": "value",
                        "--repo": "value",
                        "--repo-type": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--secret": "value",
                        "--service-account": "value",
                        "--subscription-filter": "value",
                        "--substitutions": "value",
                        "--tag": "value",
                        "--trigger-config": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--region": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--region": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--branch": "value",
                    "--region": "value",
                    "--sha": "value",
                    "--substitutions": "value",
                    "--tag": "value"
                  }
                },
                "update": {
                  "commands": {
                    "bitbucket-cloud": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "bitbucket-data-center": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "bitbucketserver": {
                      "commands": {},
                      "flags": {
                        "--bitbucket-server-config-resource": "value",
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--project-key": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--repo-slug": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "cloud-source-repositories": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--repo": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "developer-connect": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--git-repository-link": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "github": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--enterprise-config": "value",
                        "--ignored-files": "value",
                        "--include-logs-with-status": "bool",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--repo-name": "value",
                        "--repo-owner": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "gitlab": {
                      "commands": {},
                      "flags": {
                        "--branch-pattern": "value",
                        "--build-config": "value",
                        "--clear-substitutions": "bool",
                        "--comment-control": [
                          "COMMENTS_DISABLED",
                          "COMMENTS_ENABLED",
                          "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
                        ],
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--ignored-files": "value",
                        "--included-files": "value",
                        "--inline-config": "value",
                        "--pull-request-pattern": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--repository": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--tag-pattern": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "manual": {
                      "commands": {},
                      "flags": {
                        "--clear-substitutions": "bool",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--git-file-source-branch": "value",
                        "--git-file-source-github-enterprise-config": "value",
                        "--git-file-source-path": "value",
                        "--git-file-source-repo-type": "value",
                        "--git-file-source-tag": "value",
                        "--git-file-source-uri": "value",
                        "--inline-config": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--source-to-build-branch": "value",
                        "--source-to-build-github-enterprise-config": "value",
                        "--source-to-build-repo-type": "value",
                        "--source-to-build-tag": "value",
                        "--source-to-build-uri": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "pubsub": {
                      "commands": {},
                      "flags": {
                        "--clear-subscription-filter": "bool",
                        "--clear-substitutions": "bool",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--git-file-source-branch": "value",
                        "--git-file-source-github-enterprise-config": "value",
                        "--git-file-source-path": "value",
                        "--git-file-source-repo-type": "value",
                        "--git-file-source-tag": "value",
                        "--git-file-source-uri": "value",
                        "--inline-config": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--require-approval": "bool",
                        "--service-account": "value",
                        "--source-to-build-branch": "value",
                        "--source-to-build-github-enterprise-config": "value",
                        "--source-to-build-repo-type": "value",
                        "--source-to-build-tag": "value",
                        "--source-to-build-uri": "value",
                        "--subscription-filter": "value",
                        "--topic": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    },
                    "webhook": {
                      "commands": {},
                      "flags": {
                        "--clear-substitutions": "bool",
                        "--description": "value",
                        "--dockerfile": "value",
                        "--dockerfile-dir": "value",
                        "--dockerfile-image": "value",
                        "--git-file-source-branch": "value",
                        "--git-file-source-github-enterprise-config": "value",
                        "--git-file-source-path": "value",
                        "--git-file-source-repo-type": "value",
                        "--git-file-source-tag": "value",
                        "--git-file-source-uri": "value",
                        "--inline-config": "value",
                        "--region": "value",
                        "--remove-substitutions": "value",
                        "--require-approval": "bool",
                        "--secret": "value",
                        "--service-account": "value",
                        "--source-to-build-branch": "value",
                        "--source-to-build-github-enterprise-config": "value",
                        "--source-to-build-repo-type": "value",
                        "--source-to-build-tag": "value",
                        "--source-to-build-uri": "value",
                        "--subscription-filter": "value",
                        "--trigger-config": "value",
                        "--update-substitutions": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "worker-pools": {
              "commands": {
                "apply": {
                  "commands": {},
                  "flags": {
                    "--file": "value",
                    "--generation": "value",
                    "--region": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--disable-public-ip-address": "bool",
                    "--generation": "value",
                    "--network-attachment": "value",
                    "--no-public-egress": "bool",
                    "--peered-network": "value",
                    "--peered-network-ip-range": "value",
                    "--region": "value",
                    "--route-all-traffic": "bool",
                    "--worker-disk-size": "value",
                    "--worker-machine-type": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--generation": "value",
                    "--region": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--generation": "value",
                    "--region": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--generation": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--config-from-file": "value",
                    "--generation": "value",
                    "--public-egress": "bool",
                    "--region": "value",
                    "--worker-disk-size": "value",
                    "--worker-machine-type": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "certificate-manager": {
          "commands": {
            "certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--certificate-file": "value",
                    "--description": "value",
                    "--dns-authorizations": "value",
                    "--domains": "value",
                    "--issuance-config": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--private-key-file": "value",
                    "--scope": [
                      "all-regions",
                      "client-auth",
                      "default",
                      "edge-cache"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--certificate-file": "value",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "dynamic",
                    "--private-key-file": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "dns-authorizations": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--domain": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--type": [
                      "fixed-record",
                      "per-project-record",
                      "type-unspecified"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "issuance-configs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--ca-pool": "value",
                    "--description": "value",
                    "--key-algorithm": [
                      "ecdsa-p256",
                      "rsa-2048"
                    ],
                    "--labels": "value",
                    "--lifetime": "value",
                    "--location": "value",
                    "--rotation-window-percentage": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "maps": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value",
                    "--location": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "dynamic"
                  }
                },
                "entries": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--certificates": "dynamic",
                        "--description": "value",
                        "--hostname": "value",
                        "--labels": "value",
                        "--location": "dynamic",
                        "--map": "dynamic",
                        "--set-primary": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "dynamic",
                        "--map": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "dynamic",
                        "--map": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "dynamic",
                        "--map": "dynamic",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--certificates": "dynamic",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--location": "dynamic",
                        "--map": "dynamic",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "trust-configs": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--allowlisted-certificates": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--labels": "value",
                    "--location": "value",
                    "--trust-store": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--etag": "value",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--location": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value",
                    "--source": "value",
                    "--update-mask": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-allowlisted-certificates": "value",
                    "--async": "bool",
                    "--clear-allowlisted-certificates": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--location": "value",
                    "--remove-allowlisted-certificates": "value",
                    "--remove-labels": "value",
                    "--trust-store": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "cloud-shell": {
          "commands": {
            "get-mount-command": {
              "commands": {},
              "flags": {
                "--force-key-file-overwrite": "bool",
                "--ssh-key-file": "bool"
              }
            },
            "scp": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--recurse": "bool",
                "--scp-flag": "value",
                "--ssh-key-file": "bool"
              }
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--authorize-session": "bool",
                "--command": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--ssh-flag": "value",
                "--ssh-key-file": "bool"
              }
            }
          },
          "flags": {}
        },
        "code": {
          "commands": {
            "clean-up": {
              "commands": {},
              "flags": {
                "--minikube-profile": "value"
              }
            },
            "dev": {
              "commands": {},
              "flags": {
                "--allow-secret-manager": "bool",
                "--application-default-credential": "bool",
                "--builder": "value",
                "--cloudsql-instances": "value",
                "--cpu": "value",
                "--dockerfile": "value",
                "--env-vars": "value",
                "--env-vars-file": "value",
                "--image": "value",
                "--kube-context": "value",
                "--local-port": "value",
                "--memory": "value",
                "--minikube-profile": "value",
                "--minikube-vm-driver": "value",
                "--namespace": "value",
                "--secrets": "value",
                "--service-account": "value",
                "--service-name": "value",
                "--source": "value",
                "--stop-cluster": "bool"
              }
            }
          },
          "flags": {}
        },
        "composer": {
          "commands": {
            "environments": {
              "commands": {
                "check-upgrade": {
                  "commands": {},
                  "flags": {
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--image-version": "value",
                    "--location": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--airflow-configs": "value",
                    "--airflow-database-retention-days": "value",
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--cloud-sql-ipv4-cidr": "value",
                    "--cloud-sql-machine-type": "value",
                    "--cloud-sql-preferred-zone": "value",
                    "--cluster-ipv4-cidr": "value",
                    "--cluster-secondary-range-name": "value",
                    "--composer-internal-ipv4-cidr-block": "value",
                    "--composer-network-ipv4-cidr": "value",
                    "--connection-subnetwork": "value",
                    "--connection-type": [
                      "connection-type-unspecified",
                      "private-service-connect",
                      "vpc-peering"
                    ],
                    "--dag-processor-count": "value",
                    "--dag-processor-cpu": "value",
                    "--dag-processor-memory": "value",
                    "--dag-processor-storage": "value",
                    "--disable-cloud-data-lineage-integration": "bool",
                    "--disable-logs-in-cloud-logging-only": "bool",
                    "--disable-private-builds-only": "bool",
                    "--disk-size": "value",
                    "--enable-cloud-data-lineage-integration": "bool",
                    "--enable-high-resilience": "bool",
                    "--enable-ip-alias": "bool",
                    "--enable-ip-masq-agent": "bool",
                    "--enable-logs-in-cloud-logging-only": "bool",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-private-builds-only": "bool",
                    "--enable-private-endpoint": "bool",
                    "--enable-private-environment": "bool",
                    "--enable-privately-used-public-ips": "bool",
                    "--enable-scheduled-snapshot-creation": "bool",
                    "--enable-triggerer": "bool",
                    "--env-variables": "value",
                    "--environment-size": [
                      "large",
                      "medium",
                      "small",
                      "unspecified"
                    ],
                    "--image-version": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--location": "value",
                    "--machine-type": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-authorized-networks": "value",
                    "--master-ipv4-cidr": "value",
                    "--max-pods-per-node": "value",
                    "--max-workers": "value",
                    "--min-workers": "value",
                    "--network": "value",
                    "--network-attachment": "value",
                    "--node-count": "value",
                    "--oauth-scopes": "value",
                    "--python-version": [
                      "2",
                      "3"
                    ],
                    "--scheduler-count": "value",
                    "--scheduler-cpu": "value",
                    "--scheduler-memory": "value",
                    "--scheduler-storage": "value",
                    "--service-account": "value",
                    "--services-ipv4-cidr": "value",
                    "--services-secondary-range-name": "value",
                    "--snapshot-creation-schedule": "value",
                    "--snapshot-location": "value",
                    "--snapshot-schedule-timezone": "value",
                    "--storage-bucket": "value",
                    "--subnetwork": "value",
                    "--support-web-server-plugins": "bool",
                    "--tags": "value",
                    "--triggerer-count": "value",
                    "--triggerer-cpu": "value",
                    "--triggerer-memory": "value",
                    "--web-server-allow-all": "bool",
                    "--web-server-allow-ip": "value",
                    "--web-server-cpu": "value",
                    "--web-server-deny-all": "bool",
                    "--web-server-ipv4-cidr": "value",
                    "--web-server-machine-type": "value",
                    "--web-server-memory": "value",
                    "--web-server-storage": "value",
                    "--worker-cpu": "value",
                    "--worker-memory": "value",
                    "--worker-storage": "value",
                    "--zone": "value"
                  }
                },
                "database-failover": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "fetch-database-properties": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-packages": {
                  "commands": {},
                  "flags": {
                    "--location": "value",
                    "--tree": "bool"
                  }
                },
                "list-upgrades": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--location": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list-workloads": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "restart-web-server": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--location": "value"
                  }
                },
                "run": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "snapshots": {
                  "commands": {
                    "load": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value",
                        "--skip-airflow-overrides-setting": "bool",
                        "--skip-environment-variables-setting": "bool",
                        "--skip-gcs-data-copying": "bool",
                        "--skip-pypi-packages-installation": "bool",
                        "--snapshot-path": "value"
                      }
                    },
                    "save": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value",
                        "--snapshot-location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "storage": {
                  "commands": {
                    "dags": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "data": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "plugins": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        },
                        "export": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "import": {
                          "commands": {},
                          "flags": {
                            "--destination": "value",
                            "--environment": "value",
                            "--location": "value",
                            "--source": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--environment": "value",
                            "--location": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--airflow-database-retention-days": "value",
                    "--airflow-version": "value",
                    "--async": "bool",
                    "--clear-airflow-configs": "bool",
                    "--clear-env-variables": "bool",
                    "--clear-labels": "bool",
                    "--clear-maintenance-window": "bool",
                    "--clear-pypi-packages": "bool",
                    "--cloud-sql-machine-type": "value",
                    "--dag-processor-count": "value",
                    "--dag-processor-cpu": "value",
                    "--dag-processor-memory": "value",
                    "--dag-processor-storage": "value",
                    "--disable-cloud-data-lineage-integration": "bool",
                    "--disable-high-resilience": "bool",
                    "--disable-logs-in-cloud-logging-only": "bool",
                    "--disable-master-authorized-networks": "bool",
                    "--disable-private-builds-only": "bool",
                    "--disable-private-environment": "bool",
                    "--disable-scheduled-snapshot-creation": "bool",
                    "--disable-triggerer": "bool",
                    "--disable-vpc-connectivity": "bool",
                    "--enable-cloud-data-lineage-integration": "bool",
                    "--enable-high-resilience": "bool",
                    "--enable-logs-in-cloud-logging-only": "bool",
                    "--enable-master-authorized-networks": "bool",
                    "--enable-private-builds-only": "bool",
                    "--enable-private-environment": "bool",
                    "--enable-scheduled-snapshot-creation": "bool",
                    "--enable-triggerer": "bool",
                    "--environment-size": [
                      "large",
                      "medium",
                      "small",
                      "unspecified"
                    ],
                    "--image-version": "value",
                    "--location": "value",
                    "--maintenance-window-end": "value",
                    "--maintenance-window-recurrence": "value",
                    "--maintenance-window-start": "value",
                    "--master-authorized-networks": "value",
                    "--max-workers": "value",
                    "--min-workers": "value",
                    "--network": "value",
                    "--network-attachment": "value",
                    "--node-count": "value",
                    "--remove-airflow-configs": "value",
                    "--remove-env-variables": "value",
                    "--remove-labels": "value",
                    "--remove-pypi-packages": "value",
                    "--scheduler-count": "value",
                    "--scheduler-cpu": "value",
                    "--scheduler-memory": "value",
                    "--scheduler-storage": "value",
                    "--snapshot-creation-schedule": "value",
                    "--snapshot-location": "value",
                    "--snapshot-schedule-timezone": "value",
                    "--subnetwork": "value",
                    "--support-web-server-plugins": "bool",
                    "--triggerer-count": "value",
                    "--triggerer-cpu": "value",
                    "--triggerer-memory": "value",
                    "--update-airflow-configs": "value",
                    "--update-env-variables": "value",
                    "--update-labels": "value",
                    "--update-pypi-package": "value",
                    "--update-pypi-packages-from-file": "value",
                    "--update-web-server-allow-ip": "value",
                    "--web-server-allow-all": "bool",
                    "--web-server-cpu": "value",
                    "--web-server-deny-all": "bool",
                    "--web-server-machine-type": "value",
                    "--web-server-memory": "value",
                    "--web-server-storage": "value",
                    "--worker-cpu": "value",
                    "--worker-memory": "value",
                    "--worker-storage": "value"
                  }
                },
                "user-workloads-config-maps": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--config-map-file-path": "value",
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--config-map-file-path": "value",
                        "--environment": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "user-workloads-secrets": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value",
                        "--secret-file-path": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--environment": "value",
                        "--location": "value",
                        "--secret-file-path": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "delete": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--locations": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "wait": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "compute": {
          "commands": {
            "accelerator-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "addresses": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--addresses": "value",
                    "--description": "value",
                    "--endpoint-type": [
                      "NETLB",
                      "VM"
                    ],
                    "--global": "bool",
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--prefix-length": "value",
                    "--purpose": [
                      "GCE_ENDPOINT",
                      "IPSEC_INTERCONNECT",
                      "PRIVATE_SERVICE_CONNECT",
                      "SHARED_LOADBALANCER_VIP",
                      "VPC_PEERING"
                    ],
                    "--region": "dynamic",
                    "--subnet": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--new-name": "value",
                    "--region": "dynamic",
                    "--target-project": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-buckets": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-key-include-http-header": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--compression-mode": [
                      "AUTOMATIC",
                      "DISABLED"
                    ],
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--load-balancing-scheme": [
                      "INTERNAL_MANAGED"
                    ],
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--request-coalescing": "bool",
                    "--serve-while-stale": "value",
                    "--signed-url-cache-max-age": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-key-include-http-header": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--compression-mode": [
                      "AUTOMATIC",
                      "DISABLED"
                    ],
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--edge-security-policy": "dynamic",
                    "--enable-cdn": "bool",
                    "--gcs-bucket-name": "dynamic",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--no-bypass-cache-on-request-headers": "bool",
                    "--no-client-ttl": "bool",
                    "--no-custom-response-headers": "bool",
                    "--no-default-ttl": "bool",
                    "--no-max-ttl": "bool",
                    "--no-negative-caching-policies": "bool",
                    "--no-serve-while-stale": "bool",
                    "--request-coalescing": "bool",
                    "--serve-while-stale": "value",
                    "--signed-url-cache-max-age": "value"
                  }
                }
              },
              "flags": {}
            },
            "backend-services": {
              "commands": {
                "add-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "CUSTOM_METRICS",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--custom-metrics": "value",
                    "--custom-metrics-file": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--global-network-endpoint-group": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-region": "dynamic",
                    "--network-endpoint-group-zone": "dynamic",
                    "--preference": [
                      "DEFAULT",
                      "PREFERRED"
                    ],
                    "--region": "dynamic"
                  }
                },
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "value"
                  }
                },
                "add-service-bindings": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--service-bindings": "dynamic"
                  }
                },
                "add-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-file": "value",
                    "--key-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-name": "value",
                    "--affinity-cookie-path": "value",
                    "--affinity-cookie-ttl": "value",
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-http-header": "value",
                    "--cache-key-include-named-cookie": "value",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--client-ttl": "value",
                    "--compression-mode": [
                      "AUTOMATIC",
                      "DISABLED"
                    ],
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--connection-persistence-on-unhealthy-backends": [
                      "ALWAYS_PERSIST",
                      "DEFAULT_FOR_PROTOCOL",
                      "NEVER_PERSIST"
                    ],
                    "--custom-metrics": "value",
                    "--custom-metrics-file": "value",
                    "--custom-request-header": "value",
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--enable-strong-affinity": "bool",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--idle-timeout-sec": "value",
                    "--ip-address-selection-policy": [
                      "IPV4_ONLY",
                      "IPV6_ONLY",
                      "PREFER_IPV6"
                    ],
                    "--ip-port-dynamic-forwarding": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--locality-lb-policy": [
                      "INVALID_LB_POLICY",
                      "LEAST_REQUEST",
                      "MAGLEV",
                      "ORIGINAL_DESTINATION",
                      "RANDOM",
                      "RING_HASH",
                      "ROUND_ROBIN",
                      "WEIGHTED_MAGLEV",
                      "WEIGHTED_ROUND_ROBIN"
                    ],
                    "--logging-optional": [
                      "CUSTOM",
                      "EXCLUDE_ALL_OPTIONAL",
                      "INCLUDE_ALL_OPTIONAL"
                    ],
                    "--logging-optional-fields": "value",
                    "--logging-sample-rate": "value",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--network": "value",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--request-coalescing": "bool",
                    "--serve-while-stale": "value",
                    "--service-bindings": "dynamic",
                    "--service-lb-policy": "value",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_NO_DESTINATION",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE",
                      "STRONG_COOKIE_AFFINITY"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--subsetting-policy": [
                      "CONSISTENT_HASH_SUBSETTING",
                      "NONE"
                    ],
                    "--subsetting-subset-size": "value",
                    "--timeout": "value",
                    "--tls-settings": "dynamic",
                    "--tracking-mode": [
                      "PER_CONNECTION",
                      "PER_SESSION"
                    ],
                    "--zonal-affinity-spillover": [
                      "ZONAL_AFFINITY_DISABLED",
                      "ZONAL_AFFINITY_SPILL_CROSS_ZONE",
                      "ZONAL_AFFINITY_STAY_WITHIN_ZONE"
                    ],
                    "--zonal-affinity-spillover-ratio": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete-signed-url-key": {
                  "commands": {},
                  "flags": {
                    "--key-name": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "get-effective-security-policies": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-usable": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-backend": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--global-network-endpoint-group": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-region": "dynamic",
                    "--network-endpoint-group-zone": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--member": "value",
                    "--region": "dynamic",
                    "--role": "value"
                  }
                },
                "remove-service-bindings": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--service-bindings": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "set-security-policy": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--security-policy": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--affinity-cookie-name": "value",
                    "--affinity-cookie-path": "value",
                    "--affinity-cookie-ttl": "value",
                    "--bypass-cache-on-request-headers": "value",
                    "--cache-key-include-host": "bool",
                    "--cache-key-include-http-header": "value",
                    "--cache-key-include-named-cookie": "value",
                    "--cache-key-include-protocol": "bool",
                    "--cache-key-include-query-string": "bool",
                    "--cache-key-query-string-blacklist": "value",
                    "--cache-key-query-string-whitelist": "value",
                    "--cache-mode": [
                      "CACHE_ALL_STATIC",
                      "FORCE_CACHE_ALL",
                      "USE_ORIGIN_HEADERS"
                    ],
                    "--clear-custom-metrics": "bool",
                    "--clear-external-managed-migration-state": "bool",
                    "--client-ttl": "value",
                    "--compression-mode": [
                      "AUTOMATIC",
                      "DISABLED"
                    ],
                    "--connection-drain-on-failover": "bool",
                    "--connection-draining-timeout": "value",
                    "--connection-persistence-on-unhealthy-backends": [
                      "ALWAYS_PERSIST",
                      "DEFAULT_FOR_PROTOCOL",
                      "NEVER_PERSIST"
                    ],
                    "--custom-metrics": "value",
                    "--custom-metrics-file": "value",
                    "--custom-request-header": "value",
                    "--custom-response-header": "value",
                    "--default-ttl": "value",
                    "--description": "value",
                    "--drop-traffic-if-unhealthy": "bool",
                    "--edge-security-policy": "dynamic",
                    "--enable-cdn": "bool",
                    "--enable-logging": "bool",
                    "--enable-strong-affinity": "bool",
                    "--external-managed-migration-state": [
                      "PREPARE",
                      "TEST_ALL_TRAFFIC",
                      "TEST_BY_PERCENTAGE"
                    ],
                    "--external-managed-migration-testing-percentage": "value",
                    "--failover-ratio": "value",
                    "--global": "bool",
                    "--global-health-checks": "bool",
                    "--health-checks": "dynamic",
                    "--health-checks-region": "dynamic",
                    "--http-health-checks": "dynamic",
                    "--https-health-checks": "dynamic",
                    "--iap": "value",
                    "--idle-timeout-sec": "value",
                    "--ip-address-selection-policy": [
                      "IPV4_ONLY",
                      "IPV6_ONLY",
                      "PREFER_IPV6"
                    ],
                    "--ip-port-dynamic-forwarding": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED"
                    ],
                    "--locality-lb-policy": [
                      "INVALID_LB_POLICY",
                      "LEAST_REQUEST",
                      "MAGLEV",
                      "ORIGINAL_DESTINATION",
                      "RANDOM",
                      "RING_HASH",
                      "ROUND_ROBIN",
                      "WEIGHTED_MAGLEV",
                      "WEIGHTED_ROUND_ROBIN"
                    ],
                    "--logging-optional": [
                      "CUSTOM",
                      "EXCLUDE_ALL_OPTIONAL",
                      "INCLUDE_ALL_OPTIONAL"
                    ],
                    "--logging-optional-fields": "value",
                    "--logging-sample-rate": "value",
                    "--max-ttl": "value",
                    "--negative-caching": "bool",
                    "--negative-caching-policy": "value",
                    "--no-bypass-cache-on-request-headers": "bool",
                    "--no-client-ttl": "bool",
                    "--no-custom-request-headers": "bool",
                    "--no-custom-response-headers": "bool",
                    "--no-default-ttl": "bool",
                    "--no-health-checks": "bool",
                    "--no-max-ttl": "bool",
                    "--no-negative-caching-policies": "bool",
                    "--no-serve-while-stale": "bool",
                    "--no-service-bindings": "bool",
                    "--no-service-lb-policy": "bool",
                    "--no-tls-settings": "bool",
                    "--port-name": "value",
                    "--protocol": "value",
                    "--region": "dynamic",
                    "--request-coalescing": "bool",
                    "--security-policy": "dynamic",
                    "--serve-while-stale": "value",
                    "--service-bindings": "dynamic",
                    "--service-lb-policy": "value",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_NO_DESTINATION",
                      "CLIENT_IP_PORT_PROTO",
                      "CLIENT_IP_PROTO",
                      "GENERATED_COOKIE",
                      "HEADER_FIELD",
                      "HTTP_COOKIE",
                      "NONE",
                      "STRONG_COOKIE_AFFINITY"
                    ],
                    "--signed-url-cache-max-age": "value",
                    "--subsetting-policy": [
                      "CONSISTENT_HASH_SUBSETTING",
                      "NONE"
                    ],
                    "--subsetting-subset-size": "value",
                    "--timeout": "value",
                    "--tls-settings": "dynamic",
                    "--tracking-mode": [
                      "PER_CONNECTION",
                      "PER_SESSION"
                    ],
                    "--zonal-affinity-spillover": [
                      "ZONAL_AFFINITY_DISABLED",
                      "ZONAL_AFFINITY_SPILL_CROSS_ZONE",
                      "ZONAL_AFFINITY_STAY_WITHIN_ZONE"
                    ],
                    "--zonal-affinity-spillover-ratio": "value"
                  }
                },
                "update-backend": {
                  "commands": {},
                  "flags": {
                    "--balancing-mode": [
                      "CONNECTION",
                      "CUSTOM_METRICS",
                      "RATE",
                      "UTILIZATION"
                    ],
                    "--capacity-scaler": "value",
                    "--clear-custom-metrics": "bool",
                    "--custom-metrics": "value",
                    "--custom-metrics-file": "value",
                    "--description": "value",
                    "--failover": "bool",
                    "--global": "bool",
                    "--instance-group": "dynamic",
                    "--instance-group-region": "dynamic",
                    "--instance-group-zone": "dynamic",
                    "--max-connections": "value",
                    "--max-connections-per-endpoint": "value",
                    "--max-connections-per-instance": "value",
                    "--max-rate": "value",
                    "--max-rate-per-endpoint": "value",
                    "--max-rate-per-instance": "value",
                    "--max-utilization": "value",
                    "--network-endpoint-group": "value",
                    "--network-endpoint-group-zone": "dynamic",
                    "--preference": [
                      "DEFAULT",
                      "PREFERRED"
                    ],
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "commitments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--auto-renew": "bool",
                    "--custom-end-time": "value",
                    "--existing-reservation": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--maintenance-interval": [
                      "PERIODIC",
                      "RECURRENT"
                    ],
                    "--merge-source-commitments": "value",
                    "--min-cpu-platform": "value",
                    "--plan": [
                      "12-month",
                      "36-month"
                    ],
                    "--region": "dynamic",
                    "--require-specific-reservation": "bool",
                    "--reservation": "dynamic",
                    "--reservation-sharing-policy": [
                      "ALLOW_ALL",
                      "DISALLOW_ALL"
                    ],
                    "--reservation-zone": "dynamic",
                    "--reservations-from-file": "value",
                    "--resource-policies": "value",
                    "--resources": "value",
                    "--resources-accelerator": "value",
                    "--share-setting": [
                      "local",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--split-source-commitment": "value",
                    "--type": [
                      "accelerator-optimized",
                      "accelerator-optimized-a3",
                      "accelerator-optimized-a3-mega",
                      "accelerator-optimized-a3-ultra",
                      "accelerator-optimized-a4",
                      "compute-optimized",
                      "compute-optimized-c2d",
                      "compute-optimized-c3",
                      "compute-optimized-c3d",
                      "compute-optimized-h3",
                      "general-purpose",
                      "general-purpose-c4",
                      "general-purpose-c4a",
                      "general-purpose-e2",
                      "general-purpose-n2",
                      "general-purpose-n2d",
                      "general-purpose-n4",
                      "general-purpose-t2d",
                      "graphics-optimized",
                      "memory-optimized",
                      "memory-optimized-m3",
                      "memory-optimized-m4",
                      "memory-optimized-x4",
                      "memory-optimized-x4-16tb",
                      "memory-optimized-x4-24tb",
                      "memory-optimized-x4-32tb",
                      "storage-optimized-z3"
                    ],
                    "--vm-count": "value"
                  }
                },
                "create-license": {
                  "commands": {},
                  "flags": {
                    "--amount": "value",
                    "--cores-per-license": "value",
                    "--license": "value",
                    "--plan": [
                      "12-month",
                      "36-month"
                    ],
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--auto-renew": "bool",
                    "--custom-end-time": "value",
                    "--plan": [
                      "36-month"
                    ],
                    "--region": "dynamic"
                  }
                },
                "update-reservations": {
                  "commands": {},
                  "flags": {
                    "--dest-accelerator": "value",
                    "--dest-local-ssd": "value",
                    "--dest-reservation": "value",
                    "--dest-share-setting": [
                      "local",
                      "projects"
                    ],
                    "--dest-share-with": "value",
                    "--region": "dynamic",
                    "--reservations-from-file": "value",
                    "--source-accelerator": "value",
                    "--source-local-ssd": "value",
                    "--source-reservation": "value",
                    "--source-share-setting": [
                      "local",
                      "projects"
                    ],
                    "--source-share-with": "value"
                  }
                }
              },
              "flags": {}
            },
            "config-ssh": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--remove": "bool",
                "--ssh-config-file": "value",
                "--ssh-key-file": "value"
              }
            },
            "connect-to-serial-port": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--extra-args": "value",
                "--force-key-file-overwrite": "bool",
                "--location": "value",
                "--port": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--zone": "dynamic"
              }
            },
            "copy-files": {
              "commands": {},
              "flags": {
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--plain": "bool",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--zone": "value"
              }
            },
            "diagnose": {
              "commands": {
                "export-logs": {
                  "commands": {},
                  "flags": {
                    "--collect-process-traces": "bool",
                    "--zone": "dynamic"
                  }
                },
                "routes": {
                  "commands": {},
                  "flags": {
                    "--container": "value",
                    "--dry-run": "bool",
                    "--external-route-ip": "value",
                    "--force-key-file-overwrite": "bool",
                    "--plain": "bool",
                    "--regexp": "value",
                    "--reverse-traceroute": "bool",
                    "--ssh-flag": "value",
                    "--ssh-key-expiration": "value",
                    "--ssh-key-expire-after": "value",
                    "--ssh-key-file": "value",
                    "--strict-host-key-checking": [
                      "ask",
                      "no",
                      "yes"
                    ],
                    "--user": "value",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "disk-settings": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--access-location-policy": [
                      "all-regions",
                      "specific-regions"
                    ],
                    "--add-access-locations": "value",
                    "--region": "dynamic",
                    "--remove-access-locations": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "disk-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "disks": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "bulk": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--source-consistency-group-policy": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ],
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "convert": {
                  "commands": {},
                  "flags": {
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--region": "dynamic",
                    "--target-disk-type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--access-mode": [
                      "READ_ONLY_MANY",
                      "READ_WRITE_MANY",
                      "READ_WRITE_SINGLE"
                    ],
                    "--architecture": [
                      "ARM64",
                      "X86_64"
                    ],
                    "--confidential-compute": "bool",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--erase-windows-vss-signature": "bool",
                    "--global-source-snapshot": "bool",
                    "--guest-os-features": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-family-scope": [
                      "global",
                      "zonal"
                    ],
                    "--image-project": "value",
                    "--interface": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--multi-writer": "bool",
                    "--physical-block-size": [
                      "16384",
                      "4096"
                    ],
                    "--primary-disk": "dynamic",
                    "--primary-disk-project": "value",
                    "--primary-disk-region": "dynamic",
                    "--primary-disk-zone": "dynamic",
                    "--provisioned-iops": "value",
                    "--provisioned-throughput": "value",
                    "--region": "dynamic",
                    "--replica-zones": "value",
                    "--require-csek-key-create": "bool",
                    "--resource-policies": "value",
                    "--size": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-region": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--source-instant-snapshot": "dynamic",
                    "--source-snapshot": "dynamic",
                    "--source-snapshot-region": "dynamic",
                    "--storage-pool": "value",
                    "--type": "dynamic",
                    "--user-licenses": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-async-replication-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "resize": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--size": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "snapshot": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--chain-name": "value",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--labels": "value",
                    "--region": "dynamic",
                    "--snapshot-names": "value",
                    "--storage-location": "value",
                    "--zone": "dynamic"
                  }
                },
                "start-async-replication": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--secondary-disk": "dynamic",
                    "--secondary-disk-project": "value",
                    "--secondary-disk-region": "dynamic",
                    "--secondary-disk-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "stop-async-replication": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "stop-group-async-replication": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--access-mode": [
                      "READ_ONLY_MANY",
                      "READ_WRITE_MANY",
                      "READ_WRITE_SINGLE"
                    ],
                    "--add-guest-os-features": [
                      "GVNIC"
                    ],
                    "--append-licenses": "value",
                    "--clear-architecture": "bool",
                    "--clear-labels": "bool",
                    "--clear-user-licenses": "bool",
                    "--provisioned-iops": "value",
                    "--provisioned-throughput": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--remove-licenses": "value",
                    "--replace-license": "value",
                    "--size": "value",
                    "--update-architecture": [
                      "ARM64",
                      "X86_64"
                    ],
                    "--update-labels": "value",
                    "--update-user-licenses": "value",
                    "--zone": "dynamic"
                  }
                },
                "wait-for-replication-catchup": {
                  "commands": {},
                  "flags": {
                    "--max-wait-duration": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "external-vpn-gateways": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--interfaces": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "firewall-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--folder": "value",
                        "--name": "value",
                        "--organization": "value",
                        "--replace-association-on-target": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "clone-rules": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--source-firewall-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--folder": "value",
                    "--organization": "value",
                    "--short-name": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "export-rules": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--organization": "value"
                  }
                },
                "import-rules": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-rules": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "mirroring-rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "do_not_mirror",
                          "goto_next",
                          "mirror"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--firewall-policy": "value",
                        "--layer4-configs": "value",
                        "--organization": "value",
                        "--security-profile-group": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "do_not_mirror",
                          "goto_next",
                          "mirror"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--firewall-policy": "value",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--organization": "value",
                        "--security-profile-group": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "apply_security_profile_group",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-address-groups": "value",
                        "--dest-fqdns": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-network-type": "value",
                        "--dest-region-codes": "value",
                        "--dest-threat-intelligence": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--layer4-configs": "value",
                        "--organization": "value",
                        "--security-profile-group": "value",
                        "--src-address-groups": "value",
                        "--src-fqdns": "value",
                        "--src-ip-ranges": "value",
                        "--src-network-type": "value",
                        "--src-networks": "value",
                        "--src-region-codes": "value",
                        "--src-secure-tags": "value",
                        "--src-threat-intelligence": "value",
                        "--target-resources": "value",
                        "--target-secure-tags": "value",
                        "--target-service-accounts": "value",
                        "--tls-inspect": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--organization": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "apply_security_profile_group",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-address-groups": "value",
                        "--dest-fqdns": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-network-type": "value",
                        "--dest-region-codes": "value",
                        "--dest-threat-intelligence": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--organization": "value",
                        "--security-profile-group": "value",
                        "--src-address-groups": "value",
                        "--src-fqdns": "value",
                        "--src-ip-ranges": "value",
                        "--src-network-type": "value",
                        "--src-networks": "value",
                        "--src-region-codes": "value",
                        "--src-secure-tags": "value",
                        "--src-threat-intelligence": "value",
                        "--target-resources": "value",
                        "--target-secure-tags": "value",
                        "--target-service-accounts": "value",
                        "--tls-inspect": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--organization": "value"
                  }
                }
              },
              "flags": {}
            },
            "firewall-rules": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--action": [
                      "ALLOW",
                      "DENY"
                    ],
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--direction": [
                      "EGRESS",
                      "IN",
                      "INGRESS",
                      "OUT"
                    ],
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--logging-metadata": [
                      "exclude-all",
                      "include-all"
                    ],
                    "--network": "value",
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "migrate": {
                  "commands": {},
                  "flags": {
                    "--bind-tags-to-instances": "bool",
                    "--exclusion-patterns-file": "value",
                    "--export-exclusion-patterns": "bool",
                    "--export-tag-mapping": "bool",
                    "--export-terraform-script": "bool",
                    "--force": "bool",
                    "--skip-migrate-target-service-accounts-to-tags": "bool",
                    "--source-network": "dynamic",
                    "--tag-mapping-file": "value",
                    "--target-firewall-policy": "value",
                    "--terraform-script-output-file": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow": "value",
                    "--description": "value",
                    "--destination-ranges": "value",
                    "--disabled": "bool",
                    "--enable-logging": "bool",
                    "--logging-metadata": [
                      "exclude-all",
                      "include-all"
                    ],
                    "--priority": "value",
                    "--rules": "value",
                    "--source-ranges": "value",
                    "--source-service-accounts": "value",
                    "--source-tags": "value",
                    "--target-service-accounts": "value",
                    "--target-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "forwarding-rules": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--global": "bool",
                        "--path": "value",
                        "--region": "dynamic",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--address": "dynamic",
                    "--address-region": "dynamic",
                    "--allow-global-access": "bool",
                    "--allow-psc-global-access": "bool",
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--description": "value",
                    "--disable-automate-dns-zone": "bool",
                    "--global": "bool",
                    "--global-address": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--global-target-tcp-proxy": "bool",
                    "--ip-collection": "value",
                    "--ip-collection-region": "dynamic",
                    "--ip-protocol": [
                      "AH",
                      "ALL",
                      "ESP",
                      "ICMP",
                      "L3_DEFAULT",
                      "SCTP",
                      "TCP",
                      "UDP"
                    ],
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--is-mirroring-collector": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--network-tier": "value",
                    "--port-range": "value",
                    "--ports": "value",
                    "--region": "dynamic",
                    "--service-directory-registration": "value",
                    "--service-label": "value",
                    "--source-ip-ranges": "value",
                    "--subnet": "value",
                    "--subnet-region": "dynamic",
                    "--target-google-apis-bundle": "value",
                    "--target-grpc-proxy": "value",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-service-attachment": "value",
                    "--target-service-attachment-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-tcp-proxy-region": "dynamic",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-target": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "value",
                    "--backend-service-region": "dynamic",
                    "--global": "bool",
                    "--global-backend-service": "bool",
                    "--global-target-http-proxy": "bool",
                    "--global-target-https-proxy": "bool",
                    "--global-target-tcp-proxy": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED",
                      "INTERNAL",
                      "INTERNAL_MANAGED",
                      "INTERNAL_SELF_MANAGED"
                    ],
                    "--network": "value",
                    "--region": "dynamic",
                    "--subnet": "value",
                    "--subnet-region": "value",
                    "--target-grpc-proxy": "value",
                    "--target-http-proxy": "value",
                    "--target-http-proxy-region": "dynamic",
                    "--target-https-proxy": "value",
                    "--target-https-proxy-region": "dynamic",
                    "--target-instance": "value",
                    "--target-instance-zone": "dynamic",
                    "--target-pool": "value",
                    "--target-pool-region": "dynamic",
                    "--target-ssl-proxy": "value",
                    "--target-tcp-proxy": "value",
                    "--target-tcp-proxy-region": "dynamic",
                    "--target-vpn-gateway": "value",
                    "--target-vpn-gateway-region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--allow-global-access": "bool",
                    "--allow-psc-global-access": "bool",
                    "--clear-external-managed-backend-bucket-migration-state": "bool",
                    "--clear-labels": "bool",
                    "--external-managed-backend-bucket-migration-state": [
                      "PREPARE",
                      "TEST_ALL_TRAFFIC",
                      "TEST_BY_PERCENTAGE"
                    ],
                    "--external-managed-backend-bucket-migration-testing-percentage": "value",
                    "--global": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED"
                    ],
                    "--network-tier": "value",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--source-ip-ranges": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "future-reservations": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--auto-created-reservations-delete-time": "value",
                    "--auto-created-reservations-duration": "value",
                    "--auto-delete-auto-created-reservations": "bool",
                    "--chip-count": "value",
                    "--commitment-name": "value",
                    "--commitment-plan": [
                      "THIRTY_SIX_MONTH",
                      "TWELVE_MONTH"
                    ],
                    "--deployment-type": [
                      "DENSE",
                      "FLEXIBLE"
                    ],
                    "--description": "value",
                    "--duration": "value",
                    "--end-time": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--maintenance-freeze-duration": "value",
                    "--maintenance-interval": [
                      "PERIODIC",
                      "RECURRENT"
                    ],
                    "--min-cpu-platform": "value",
                    "--name-prefix": "value",
                    "--planning-status": [
                      "DRAFT",
                      "SUBMITTED"
                    ],
                    "--previous-commitment-terms": [
                      "EXTEND"
                    ],
                    "--require-specific-reservation": "bool",
                    "--reservation-mode": [
                      "CALENDAR",
                      "DEFAULT"
                    ],
                    "--reservation-name": "value",
                    "--scheduling-type": [
                      "GROUPED",
                      "INDEPENDENT"
                    ],
                    "--share-setting": [
                      "local",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--source-instance-template": "value",
                    "--start-time": "value",
                    "--total-count": "value",
                    "--tpu-version": [
                      "V5E",
                      "V5P",
                      "V6E"
                    ],
                    "--workload-type": [
                      "BATCH",
                      "SERVING"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--auto-created-reservations-delete-time": "value",
                    "--auto-created-reservations-duration": "value",
                    "--auto-delete-auto-created-reservations": "bool",
                    "--clear-accelerator": "bool",
                    "--clear-local-ssd": "bool",
                    "--clear-name-prefix": "bool",
                    "--clear-share-settings": "bool",
                    "--commitment-name": "value",
                    "--commitment-plan": [
                      "THIRTY_SIX_MONTH",
                      "TWELVE_MONTH"
                    ],
                    "--deployment-type": [
                      "DENSE",
                      "FLEXIBLE"
                    ],
                    "--description": "value",
                    "--duration": "value",
                    "--enable-emergent-maintenance": "bool",
                    "--end-time": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--maintenance-interval": [
                      "PERIODIC",
                      "RECURRENT"
                    ],
                    "--min-cpu-platform": "value",
                    "--name-prefix": "value",
                    "--planning-status": [
                      "DRAFT",
                      "SUBMITTED"
                    ],
                    "--previous-commitment-terms": [
                      "EXTEND"
                    ],
                    "--require-specific-reservation": "bool",
                    "--reservation-name": "value",
                    "--scheduling-type": [
                      "GROUPED",
                      "INDEPENDENT"
                    ],
                    "--share-setting": [
                      "local",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--start-time": "value",
                    "--total-count": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "health-checks": {
              "commands": {
                "create": {
                  "commands": {
                    "grpc": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--grpc-service-name": "value",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--source-regions": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--source-regions": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--source-regions": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--protocol": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {
                    "grpc": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--grpc-service-name": "value",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "http": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--source-regions": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "http2": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "https": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--host": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request-path": "value",
                        "--response": "value",
                        "--source-regions": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool",
                        "--weight-report-mode": [
                          "DISABLE",
                          "DRY_RUN",
                          "ENABLE"
                        ]
                      }
                    },
                    "ssl": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    },
                    "tcp": {
                      "commands": {},
                      "flags": {
                        "--check-interval": "value",
                        "--description": "value",
                        "--enable-logging": "bool",
                        "--global": "bool",
                        "--healthy-threshold": "value",
                        "--port": "value",
                        "--port-name": "value",
                        "--proxy-header": [
                          "NONE",
                          "PROXY_V1"
                        ],
                        "--region": "dynamic",
                        "--request": "value",
                        "--response": "value",
                        "--source-regions": "value",
                        "--timeout": "value",
                        "--unhealthy-threshold": "value",
                        "--use-serving-port": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "http-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "https-health-checks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--check-interval": "value",
                    "--description": "value",
                    "--healthy-threshold": "value",
                    "--host": "value",
                    "--port": "value",
                    "--request-path": "value",
                    "--timeout": "value",
                    "--unhealthy-threshold": "value"
                  }
                }
              },
              "flags": {}
            },
            "images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--architecture": [
                      "ARM64",
                      "X86_64"
                    ],
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--family": "value",
                    "--forbidden-database-file": "value",
                    "--force": "bool",
                    "--force-create": "bool",
                    "--guest-os-features": "value",
                    "--key-exchange-key-file": "value",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--licenses": "value",
                    "--platform-key-file": "value",
                    "--require-csek-key-create": "bool",
                    "--rollout-override": "value",
                    "--signature-database-file": "value",
                    "--source-disk": "dynamic",
                    "--source-disk-project": "value",
                    "--source-disk-zone": "dynamic",
                    "--source-image": "value",
                    "--source-image-family": "value",
                    "--source-image-project": "value",
                    "--source-snapshot": "dynamic",
                    "--source-uri": "value",
                    "--storage-location": "value",
                    "--user-licenses": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "deprecate": {
                  "commands": {},
                  "flags": {
                    "--delete-in": "value",
                    "--delete-on": "value",
                    "--deprecate-in": "value",
                    "--deprecate-on": "value",
                    "--obsolete-in": "value",
                    "--obsolete-on": "value",
                    "--replacement": "dynamic",
                    "--state": [
                      "ACTIVE",
                      "DELETED",
                      "DEPRECATED",
                      "OBSOLETE"
                    ]
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "describe-from-family": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--cloudbuild-service-account": "value",
                    "--compute-service-account": "value",
                    "--destination-uri": "value",
                    "--export-format": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--log-location": "value",
                    "--network": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--aws-access-key-id": "value",
                    "--aws-ami-export-location": "value",
                    "--aws-ami-id": "value",
                    "--aws-region": "value",
                    "--aws-secret-access-key": "value",
                    "--aws-session-token": "value",
                    "--aws-source-ami-file-path": "value",
                    "--byol": "bool",
                    "--cloudbuild-service-account": "value",
                    "--compute-service-account": "value",
                    "--data-disk": "bool",
                    "--description": "value",
                    "--family": "value",
                    "--guest-environment": "bool",
                    "--guest-os-features": "value",
                    "--log-location": "value",
                    "--network": "value",
                    "--no-address": "bool",
                    "--os": [
                      "centos-7",
                      "centos-stream-8",
                      "centos-stream-9",
                      "debian-10",
                      "debian-11",
                      "debian-8",
                      "debian-9",
                      "opensuse-15",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "rhel-8",
                      "rhel-8-byol",
                      "rhel-9",
                      "rhel-9-byol",
                      "rocky-8",
                      "rocky-9",
                      "sles-12",
                      "sles-12-byol",
                      "sles-15",
                      "sles-15-byol",
                      "sles-sap-12",
                      "sles-sap-12-byol",
                      "sles-sap-15",
                      "sles-sap-15-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "ubuntu-1804",
                      "ubuntu-2004",
                      "ubuntu-2204",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-11-x64-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-2022",
                      "windows-2022-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--source-file": "value",
                    "--source-image": "dynamic",
                    "--storage-location": "value",
                    "--subnet": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--image-zone": "dynamic",
                    "--limit": "value",
                    "--page-size": "value",
                    "--preview-images": "bool",
                    "--regexp": "value",
                    "--show-deprecated": "bool",
                    "--sort-by": "value",
                    "--standard-images": "bool",
                    "--uri": "bool"
                  }
                },
                "packages": {
                  "commands": {
                    "diff": {
                      "commands": {},
                      "flags": {
                        "--base-image": "dynamic",
                        "--base-project": "dynamic",
                        "--diff-image": "dynamic",
                        "--diff-project": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--show-added-packages": "bool",
                        "--show-removed-packages": "bool",
                        "--show-updated-packages": "bool",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--image": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--architecture": [
                      "ARM64",
                      "X86_64"
                    ],
                    "--clear-labels": "bool",
                    "--clear-user-licenses": "bool",
                    "--description": "value",
                    "--family": "value",
                    "--remove-labels": "value",
                    "--update-labels": "value",
                    "--update-user-licenses": "value"
                  }
                },
                "vulnerabilities": {
                  "commands": {
                    "describe-note": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--image": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-groups": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "get-named-ports": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-instances": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "managed": {
                  "commands": {
                    "abandon-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "all-instances-config": {
                      "commands": {
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--labels": "value",
                            "--metadata": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--labels": "value",
                            "--metadata": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action-on-vm-failed-health-check": [
                          "default-action",
                          "do-nothing",
                          "repair"
                        ],
                        "--base-instance-name": "value",
                        "--default-action-on-vm-failure": [
                          "delete",
                          "do-nothing",
                          "repair"
                        ],
                        "--description": "value",
                        "--force-update-on-repair": "bool",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "none",
                          "proactive"
                        ],
                        "--instance-selection": "value",
                        "--instance-selection-machine-types": "value",
                        "--list-managed-instances-results": [
                          "pageless",
                          "paginated"
                        ],
                        "--region": "dynamic",
                        "--resource-manager-tags": "value",
                        "--size": "value",
                        "--standby-policy-initial-delay": "value",
                        "--standby-policy-mode": [
                          "manual",
                          "scale-out-pool"
                        ],
                        "--stateful-disk": "value",
                        "--stateful-external-ip": "value",
                        "--stateful-internal-ip": "value",
                        "--stopped-size": "value",
                        "--suspended-size": "value",
                        "--target-distribution-shape": [
                          "any",
                          "any-single-zone",
                          "balanced",
                          "even"
                        ],
                        "--target-pool": "value",
                        "--target-size-policy-mode": [
                          "bulk",
                          "individual"
                        ],
                        "--template": "value",
                        "--update-policy-max-surge": "value",
                        "--update-policy-max-unavailable": "value",
                        "--update-policy-min-ready": "value",
                        "--update-policy-minimal-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--update-policy-most-disruptive-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--update-policy-replacement-method": [
                          "recreate",
                          "substitute"
                        ],
                        "--update-policy-type": [
                          "opportunistic",
                          "proactive"
                        ],
                        "--zone": "dynamic",
                        "--zones": "dynamic"
                      }
                    },
                    "create-instance": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--region": "dynamic",
                        "--stateful-disk": "value",
                        "--stateful-external-ip": "value",
                        "--stateful-internal-ip": "value",
                        "--stateful-metadata": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "delete-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--skip-instances-on-validation-error": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "describe-instance": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "export-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "instance-configs": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--instance": "value",
                            "--instance-update-minimal-action": [
                              "none",
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--region": "dynamic",
                            "--stateful-disk": "value",
                            "--stateful-external-ip": "value",
                            "--stateful-internal-ip": "value",
                            "--stateful-metadata": "value",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--instance-update-minimal-action": [
                              "none",
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--instances": "value",
                            "--region": "dynamic",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--region": "dynamic",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--instance": "value",
                            "--instance-update-minimal-action": [
                              "none",
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--region": "dynamic",
                            "--remove-stateful-disks": "value",
                            "--remove-stateful-external-ips": "value",
                            "--remove-stateful-internal-ips": "value",
                            "--remove-stateful-metadata": "value",
                            "--stateful-disk": "value",
                            "--stateful-external-ip": "value",
                            "--stateful-internal-ip": "value",
                            "--stateful-metadata": "value",
                            "--update-instance": "bool",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "value"
                      }
                    },
                    "list-errors": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "recreate-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "resize": {
                      "commands": {},
                      "flags": {
                        "--creation-retries": "bool",
                        "--region": "dynamic",
                        "--size": "value",
                        "--stopped-size": "value",
                        "--suspended-size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "resize-requests": {
                      "commands": {
                        "cancel": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--resize-request": "value",
                            "--resize-requests": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "create": {
                          "commands": {},
                          "flags": {
                            "--instances": "value",
                            "--region": "dynamic",
                            "--requested-run-duration": "value",
                            "--resize-by": "value",
                            "--resize-request": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--resize-requests": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--resize-request": "value",
                            "--zone": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--region": "dynamic",
                            "--sort-by": "value",
                            "--uri": "bool",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "resume-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "rolling-action": {
                      "commands": {
                        "replace": {
                          "commands": {},
                          "flags": {
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--replacement-method": [
                              "recreate",
                              "substitute"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "restart": {
                          "commands": {},
                          "flags": {
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        },
                        "start-update": {
                          "commands": {},
                          "flags": {
                            "--canary-version": "value",
                            "--force": "bool",
                            "--max-surge": "value",
                            "--max-unavailable": "value",
                            "--min-ready": "value",
                            "--minimal-action": [
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--most-disruptive-allowed-action": [
                              "refresh",
                              "replace",
                              "restart"
                            ],
                            "--region": "dynamic",
                            "--replacement-method": [
                              "recreate",
                              "substitute"
                            ],
                            "--type": [
                              "opportunistic",
                              "proactive"
                            ],
                            "--zone": "dynamic"
                          }
                        },
                        "stop-proactive-update": {
                          "commands": {},
                          "flags": {
                            "--region": "dynamic",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "set-autohealing": {
                      "commands": {},
                      "flags": {
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--autoscaling-file": "value",
                        "--cool-down-period": "value",
                        "--cpu-utilization-predictive-method": [
                          "none",
                          "optimize-availability",
                          "standard"
                        ],
                        "--custom-metric-utilization": "value",
                        "--description": "value",
                        "--max-num-replicas": "value",
                        "--min-num-replicas": "value",
                        "--mode": [
                          "off",
                          "on",
                          "only-scale-out",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--remove-stackdriver-metric": "value",
                        "--scale-based-on-cpu": "bool",
                        "--scale-based-on-load-balancing": "bool",
                        "--scale-in-control": "value",
                        "--schedule-cron": "value",
                        "--schedule-description": "value",
                        "--schedule-duration-sec": "value",
                        "--schedule-min-required-replicas": "value",
                        "--schedule-time-zone": "value",
                        "--set-schedule": "value",
                        "--stackdriver-metric-filter": "value",
                        "--stackdriver-metric-single-instance-assignment": "value",
                        "--stackdriver-metric-utilization-target": "value",
                        "--stackdriver-metric-utilization-target-type": [
                          "delta-per-minute",
                          "delta-per-second",
                          "gauge"
                        ],
                        "--target-cpu-utilization": "value",
                        "--target-load-balancing-utilization": "value",
                        "--update-stackdriver-metric": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-instance-template": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--template": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-standby-policy": {
                      "commands": {},
                      "flags": {
                        "--initial-delay": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "set-target-pools": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--target-pools": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "start-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "stop-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "stop-instances": {
                      "commands": {},
                      "flags": {
                        "--force": "bool",
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "suspend-instances": {
                      "commands": {},
                      "flags": {
                        "--force": "bool",
                        "--instances": "value",
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action-on-vm-failed-health-check": [
                          "default-action",
                          "do-nothing",
                          "repair"
                        ],
                        "--clear-autohealing": "bool",
                        "--default-action-on-vm-failure": [
                          "delete",
                          "do-nothing",
                          "repair"
                        ],
                        "--description": "value",
                        "--force-update-on-repair": "bool",
                        "--health-check": "dynamic",
                        "--http-health-check": "value",
                        "--https-health-check": "value",
                        "--initial-delay": "value",
                        "--instance-redistribution-type": [
                          "none",
                          "proactive"
                        ],
                        "--instance-selection": "value",
                        "--instance-selection-machine-types": "value",
                        "--list-managed-instances-results": [
                          "pageless",
                          "paginated"
                        ],
                        "--region": "dynamic",
                        "--remove-instance-selections": "value",
                        "--remove-instance-selections-all": "bool",
                        "--remove-stateful-disks": "value",
                        "--remove-stateful-external-ips": "value",
                        "--remove-stateful-internal-ips": "value",
                        "--size": "value",
                        "--standby-policy-initial-delay": "value",
                        "--standby-policy-mode": [
                          "manual",
                          "scale-out-pool"
                        ],
                        "--stateful-disk": "value",
                        "--stateful-external-ip": "value",
                        "--stateful-internal-ip": "value",
                        "--stopped-size": "value",
                        "--suspended-size": "value",
                        "--target-distribution-shape": [
                          "any",
                          "any-single-zone",
                          "balanced",
                          "even"
                        ],
                        "--update-policy-max-surge": "value",
                        "--update-policy-max-unavailable": "value",
                        "--update-policy-min-ready": "value",
                        "--update-policy-minimal-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--update-policy-most-disruptive-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--update-policy-replacement-method": [
                          "recreate",
                          "substitute"
                        ],
                        "--update-policy-type": [
                          "opportunistic",
                          "proactive"
                        ],
                        "--zone": "dynamic"
                      }
                    },
                    "update-autoscaling": {
                      "commands": {},
                      "flags": {
                        "--clear-scale-down-control": "bool",
                        "--clear-scale-in-control": "bool",
                        "--cpu-utilization-predictive-method": [
                          "none",
                          "optimize-availability",
                          "standard"
                        ],
                        "--disable-schedule": "value",
                        "--enable-schedule": "value",
                        "--max-num-replicas": "value",
                        "--min-num-replicas": "value",
                        "--mode": [
                          "off",
                          "on",
                          "only-scale-out",
                          "only-up"
                        ],
                        "--region": "dynamic",
                        "--remove-schedule": "value",
                        "--scale-in-control": "value",
                        "--schedule-cron": "value",
                        "--schedule-description": "value",
                        "--schedule-duration-sec": "value",
                        "--schedule-min-required-replicas": "value",
                        "--schedule-time-zone": "value",
                        "--set-schedule": "value",
                        "--update-schedule": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "update-instances": {
                      "commands": {},
                      "flags": {
                        "--all-instances": "bool",
                        "--instances": "value",
                        "--minimal-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--most-disruptive-allowed-action": [
                          "none",
                          "refresh",
                          "replace",
                          "restart"
                        ],
                        "--region": "dynamic",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until": {
                      "commands": {},
                      "flags": {
                        "--all-instances-config-effective": "bool",
                        "--region": "dynamic",
                        "--stable": "bool",
                        "--timeout": "value",
                        "--version-target-reached": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "wait-until-stable": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--timeout": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "set-named-ports": {
                  "commands": {},
                  "flags": {
                    "--named-ports": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "unmanaged": {
                  "commands": {
                    "add-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-named-ports": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "dynamic",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zones": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-instances": {
                      "commands": {},
                      "flags": {
                        "--instances": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "set-named-ports": {
                      "commands": {},
                      "flags": {
                        "--named-ports": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instance-templates": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-interface": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-provisioned-throughput": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--confidential-compute-type": [
                      "SEV",
                      "SEV_SNP",
                      "TDX"
                    ],
                    "--configure-disk": "value",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--discard-local-ssds-at-termination-timestamp": "value",
                    "--disk": "value",
                    "--enable-nested-virtualization": "bool",
                    "--enable-uefi-networking": "bool",
                    "--enable-watchdog-timer": "bool",
                    "--external-ipv6-address": "value",
                    "--external-ipv6-prefix-length": "value",
                    "--graceful-shutdown": "bool",
                    "--graceful-shutdown-max-duration": "value",
                    "--host-error-timeout-seconds": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--instance-template-region": "value",
                    "--instance-termination-action": [
                      "DELETE",
                      "STOP"
                    ],
                    "--internal-ipv6-address": "value",
                    "--internal-ipv6-prefix-length": "value",
                    "--ipv6-address": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--ipv6-prefix-length": "value",
                    "--key-revocation-action-type": [
                      "none",
                      "stop"
                    ],
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--local-ssd-recovery-timeout": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-interval": [
                      "PERIODIC"
                    ],
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--max-run-duration": "value",
                    "--mesh": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpu": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-performance-configs": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--partner-metadata": "value",
                    "--partner-metadata-from-file": "value",
                    "--performance-monitoring-unit": [
                      "architectural",
                      "enhanced",
                      "standard"
                    ],
                    "--post-key-revocation-action-type": [
                      "noop",
                      "shutdown"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--provisioning-model": [
                      "FLEX_START",
                      "RESERVATION_BOUND",
                      "SPOT",
                      "STANDARD"
                    ],
                    "--region": "dynamic",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific",
                      "specific-then-any-reservation",
                      "specific-then-no-reservation"
                    ],
                    "--resource-manager-tags": "value",
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--service-proxy": "value",
                    "--service-proxy-labels": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY",
                      "IPV6_ONLY"
                    ],
                    "--subnet": "value",
                    "--subnet-region": "value",
                    "--tags": "value",
                    "--termination-time": "value",
                    "--threads-per-core": "value",
                    "--turbo-mode": "value",
                    "--visible-core-count": "value"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-interface": "value",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-provisioned-throughput": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--disk": "value",
                    "--external-ipv6-address": "value",
                    "--external-ipv6-prefix-length": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--internal-ipv6-address": "value",
                    "--internal-ipv6-prefix-length": "value",
                    "--ipv6-address": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--ipv6-prefix-length": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--region": "dynamic",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific",
                      "specific-then-any-reservation",
                      "specific-then-no-reservation"
                    ],
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY",
                      "IPV6_ONLY"
                    ],
                    "--subnet": "value",
                    "--subnet-region": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--view": [
                      "BASIC",
                      "FULL"
                    ]
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--view": [
                      "BASIC",
                      "FULL"
                    ]
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instances": {
              "commands": {
                "add-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--address": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-partner-metadata": {
                  "commands": {},
                  "flags": {
                    "--partner-metadata": "value",
                    "--partner-metadata-from-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "add-tags": {
                  "commands": {},
                  "flags": {
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "attach-disk": {
                  "commands": {},
                  "flags": {
                    "--boot": "bool",
                    "--csek-key-file": "value",
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--force-attach": "bool",
                    "--interface": [
                      "NVME",
                      "SCSI"
                    ],
                    "--mode": [
                      "ro",
                      "rw"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "bulk": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator": "value",
                        "--async": "bool",
                        "--boot-disk-auto-delete": "bool",
                        "--boot-disk-device-name": "value",
                        "--boot-disk-interface": "value",
                        "--boot-disk-kms-key": "dynamic",
                        "--boot-disk-kms-keyring": "dynamic",
                        "--boot-disk-kms-location": "dynamic",
                        "--boot-disk-kms-project": "dynamic",
                        "--boot-disk-provisioned-iops": "value",
                        "--boot-disk-provisioned-throughput": "value",
                        "--boot-disk-size": "value",
                        "--boot-disk-type": "value",
                        "--can-ip-forward": "bool",
                        "--confidential-compute": "bool",
                        "--confidential-compute-type": [
                          "SEV",
                          "SEV_SNP",
                          "TDX"
                        ],
                        "--count": "value",
                        "--create-disk": "value",
                        "--custom-cpu": "value",
                        "--custom-extensions": "bool",
                        "--custom-memory": "value",
                        "--custom-vm-type": "value",
                        "--description": "value",
                        "--discard-local-ssds-at-termination-timestamp": "value",
                        "--disk": "value",
                        "--enable-display-device": "bool",
                        "--enable-nested-virtualization": "bool",
                        "--enable-uefi-networking": "bool",
                        "--enable-watchdog-timer": "bool",
                        "--erase-windows-vss-signature": "bool",
                        "--graceful-shutdown": "bool",
                        "--graceful-shutdown-max-duration": "value",
                        "--host-error-timeout-seconds": "value",
                        "--image": "value",
                        "--image-family": "value",
                        "--image-project": "value",
                        "--instance-termination-action": [
                          "DELETE",
                          "STOP"
                        ],
                        "--labels": "value",
                        "--local-ssd": "value",
                        "--local-ssd-recovery-timeout": "value",
                        "--location-policy": "value",
                        "--machine-type": "dynamic",
                        "--maintenance-interval": [
                          "PERIODIC",
                          "RECURRENT"
                        ],
                        "--maintenance-policy": [
                          "MIGRATE",
                          "TERMINATE"
                        ],
                        "--max-count-per-zone": "value",
                        "--max-run-duration": "value",
                        "--metadata": "value",
                        "--metadata-from-file": "value",
                        "--min-count": "value",
                        "--min-cpu-platform": "value",
                        "--min-node-cpu": "value",
                        "--name-pattern": "value",
                        "--network": "value",
                        "--network-interface": "value",
                        "--network-performance-configs": "value",
                        "--network-tier": "value",
                        "--no-address": "bool",
                        "--no-public-dns": "bool",
                        "--no-scopes": "bool",
                        "--no-service-account": "bool",
                        "--numa-node-count": "value",
                        "--on-host-maintenance": [
                          "MIGRATE",
                          "TERMINATE"
                        ],
                        "--per-instance-hostnames": "value",
                        "--performance-monitoring-unit": [
                          "architectural",
                          "enhanced",
                          "standard"
                        ],
                        "--post-key-revocation-action-type": [
                          "noop",
                          "shutdown"
                        ],
                        "--predefined-names": "value",
                        "--preemptible": "bool",
                        "--provisioning-model": [
                          "RESERVATION_BOUND",
                          "SPOT",
                          "STANDARD"
                        ],
                        "--public-dns": "bool",
                        "--region": "value",
                        "--reservation": "value",
                        "--reservation-affinity": [
                          "any",
                          "none",
                          "specific",
                          "specific-then-any-reservation",
                          "specific-then-no-reservation"
                        ],
                        "--resource-manager-tags": "value",
                        "--resource-policies": "value",
                        "--restart-on-failure": "bool",
                        "--scopes": "value",
                        "--secure-tags": "value",
                        "--service-account": "value",
                        "--shielded-integrity-monitoring": "bool",
                        "--shielded-secure-boot": "bool",
                        "--shielded-vtpm": "bool",
                        "--source-instance-template": "dynamic",
                        "--source-snapshot": "value",
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY",
                          "IPV6_ONLY"
                        ],
                        "--subnet": "value",
                        "--tags": "value",
                        "--target-distribution-shape": [
                          "ANY",
                          "ANY_SINGLE_ZONE",
                          "BALANCED"
                        ],
                        "--termination-time": "value",
                        "--threads-per-core": "value",
                        "--turbo-mode": "value",
                        "--visible-core-count": "value",
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ],
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--async": "bool",
                    "--availability-domain": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-interface": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-provisioned-throughput": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--confidential-compute-type": [
                      "SEV",
                      "SEV_SNP",
                      "TDX"
                    ],
                    "--create-disk": "value",
                    "--csek-key-file": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--discard-local-ssds-at-termination-timestamp": "value",
                    "--disk": "value",
                    "--enable-display-device": "bool",
                    "--enable-nested-virtualization": "bool",
                    "--enable-uefi-networking": "bool",
                    "--enable-watchdog-timer": "bool",
                    "--erase-windows-vss-signature": "bool",
                    "--external-ipv6-address": "value",
                    "--external-ipv6-prefix-length": "value",
                    "--graceful-shutdown": "bool",
                    "--graceful-shutdown-max-duration": "value",
                    "--host-error-timeout-seconds": "value",
                    "--hostname": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-family-scope": [
                      "global",
                      "zonal"
                    ],
                    "--image-project": "value",
                    "--instance-kms-key": "dynamic",
                    "--instance-kms-keyring": "dynamic",
                    "--instance-kms-location": "dynamic",
                    "--instance-kms-project": "dynamic",
                    "--instance-termination-action": [
                      "DELETE",
                      "STOP"
                    ],
                    "--internal-ipv6-address": "value",
                    "--internal-ipv6-prefix-length": "value",
                    "--ipv6-address": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--ipv6-prefix-length": "value",
                    "--ipv6-public-ptr-domain": "value",
                    "--key-revocation-action-type": [
                      "none",
                      "stop"
                    ],
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--local-ssd-recovery-timeout": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-freeze-duration": "value",
                    "--maintenance-interval": [
                      "PERIODIC",
                      "RECURRENT"
                    ],
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--max-run-duration": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpu": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-interface-from-file": "value",
                    "--network-interface-from-json-string": "value",
                    "--network-performance-configs": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--node-project": "value",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--partner-metadata": "value",
                    "--partner-metadata-from-file": "value",
                    "--performance-monitoring-unit": [
                      "architectural",
                      "enhanced",
                      "standard"
                    ],
                    "--post-key-revocation-action-type": [
                      "noop",
                      "shutdown"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--provisioning-model": [
                      "FLEX_START",
                      "RESERVATION_BOUND",
                      "SPOT",
                      "STANDARD"
                    ],
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--require-csek-key-create": "bool",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific",
                      "specific-then-any-reservation",
                      "specific-then-no-reservation"
                    ],
                    "--resource-manager-tags": "value",
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--secure-tags": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--source-instant-snapshot": "value",
                    "--source-machine-image": "dynamic",
                    "--source-machine-image-csek-key-file": "value",
                    "--source-snapshot": "value",
                    "--source-snapshot-region": "value",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY",
                      "IPV6_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value",
                    "--termination-time": "value",
                    "--threads-per-core": "value",
                    "--turbo-mode": "value",
                    "--visible-core-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "create-with-container": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--address": "value",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-interface": "value",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-provisioned-throughput": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--confidential-compute-type": [
                      "SEV",
                      "SEV_SNP",
                      "TDX"
                    ],
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--discard-local-ssds-at-termination-timestamp": "value",
                    "--disk": "value",
                    "--enable-nested-virtualization": "bool",
                    "--external-ipv6-address": "value",
                    "--external-ipv6-prefix-length": "value",
                    "--graceful-shutdown": "bool",
                    "--graceful-shutdown-max-duration": "value",
                    "--host-error-timeout-seconds": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--instance-termination-action": [
                      "DELETE",
                      "STOP"
                    ],
                    "--internal-ipv6-address": "value",
                    "--internal-ipv6-prefix-length": "value",
                    "--ipv6-address": "value",
                    "--ipv6-network-tier": [
                      "PREMIUM"
                    ],
                    "--ipv6-prefix-length": "value",
                    "--labels": "value",
                    "--local-nvdimm": "value",
                    "--local-ssd": "value",
                    "--local-ssd-recovery-timeout": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--max-run-duration": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-cpu-platform": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-performance-configs": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--private-ipv6-google-access-type": [
                      "enable-bidirectional-access",
                      "enable-outbound-vm-access",
                      "inherit-subnetwork"
                    ],
                    "--private-network-ip": "value",
                    "--provisioning-model": [
                      "FLEX_START",
                      "RESERVATION_BOUND",
                      "SPOT",
                      "STANDARD"
                    ],
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific",
                      "specific-then-any-reservation",
                      "specific-then-no-reservation"
                    ],
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY",
                      "IPV6_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value",
                    "--termination-time": "value",
                    "--threads-per-core": "value",
                    "--visible-core-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--delete-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--keep-disks": [
                      "all",
                      "boot",
                      "data"
                    ],
                    "--no-graceful-shutdown": "bool",
                    "--zone": "dynamic"
                  }
                },
                "delete-access-config": {
                  "commands": {},
                  "flags": {
                    "--access-config-name": "value",
                    "--network-interface": "value",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--guest-attributes": "value",
                    "--view": [
                      "BASIC",
                      "FULL"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "detach-disk": {
                  "commands": {},
                  "flags": {
                    "--device-name": "value",
                    "--disk": "value",
                    "--disk-scope": [
                      "regional",
                      "zonal"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--zone": "value"
                  }
                },
                "get-guest-attributes": {
                  "commands": {},
                  "flags": {
                    "--query-path": "value",
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "get-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--start": "value",
                    "--zone": "dynamic"
                  }
                },
                "get-shielded-identity": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--byol": "bool",
                    "--can-ip-forward": "bool",
                    "--cloudbuild-service-account": "value",
                    "--compute-service-account": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--deletion-protection": "bool",
                    "--description": "value",
                    "--guest-environment": "bool",
                    "--guest-os-features": "value",
                    "--hostname": "value",
                    "--labels": "value",
                    "--log-location": "value",
                    "--machine-type": "dynamic",
                    "--network": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--os": [
                      "centos-7",
                      "centos-stream-8",
                      "centos-stream-9",
                      "debian-10",
                      "debian-11",
                      "debian-8",
                      "debian-9",
                      "opensuse-15",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "rhel-8",
                      "rhel-8-byol",
                      "rhel-9",
                      "rhel-9-byol",
                      "rocky-8",
                      "rocky-9",
                      "sles-12",
                      "sles-12-byol",
                      "sles-15",
                      "sles-15-byol",
                      "sles-sap-12",
                      "sles-sap-12-byol",
                      "sles-sap-15",
                      "sles-sap-15-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "ubuntu-1804",
                      "ubuntu-2004",
                      "ubuntu-2204",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-11-x64-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-2022",
                      "windows-2022-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--private-network-ip": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--source-uri": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--view": [
                      "BASIC",
                      "FULL"
                    ],
                    "--zones": "dynamic"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--destination-zone": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "network-interfaces": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--address": "value",
                        "--aliases": "value",
                        "--external-ipv6-address": "value",
                        "--external-ipv6-prefix-length": "value",
                        "--igmp-query": [
                          "IGMP_QUERY_DISABLED",
                          "IGMP_QUERY_V2"
                        ],
                        "--internal-ipv6-address": "value",
                        "--internal-ipv6-prefix-length": "value",
                        "--ipv6-address": "value",
                        "--ipv6-network-tier": [
                          "PREMIUM"
                        ],
                        "--ipv6-prefix-length": "value",
                        "--network": "value",
                        "--network-attachment": "value",
                        "--network-tier": [
                          "FIXED_STANDARD",
                          "PREMIUM",
                          "STANDARD"
                        ],
                        "--no-address": "bool",
                        "--parent-nic-name": "value",
                        "--private-network-ip": "value",
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY"
                        ],
                        "--subnetwork": "value",
                        "--vlan": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--network-interface": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "get-effective-firewalls": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network-interface": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--aliases": "value",
                        "--external-ipv6-address": "value",
                        "--external-ipv6-prefix-length": "value",
                        "--igmp-query": [
                          "IGMP_QUERY_DISABLED",
                          "IGMP_QUERY_V2"
                        ],
                        "--internal-ipv6-address": "value",
                        "--internal-ipv6-prefix-length": "value",
                        "--ipv6-address": "value",
                        "--ipv6-network-tier": [
                          "PREMIUM"
                        ],
                        "--ipv6-prefix-length": "value",
                        "--network": "value",
                        "--network-interface": "value",
                        "--private-network-ip": "value",
                        "--security-policy": "dynamic",
                        "--security-policy-region": "dynamic",
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY"
                        ],
                        "--subnetwork": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "ops-agents": {
                  "commands": {
                    "policies": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--agent-rules": "value",
                            "--description": "value",
                            "--group-labels": "value",
                            "--instances": "value",
                            "--os-types": "value",
                            "--zones": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {}
                        },
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--agent-rules": "value",
                            "--clear-group-labels": "bool",
                            "--clear-instances": "bool",
                            "--clear-zones": "bool",
                            "--description": "value",
                            "--etag": "value",
                            "--group-labels": "value",
                            "--instances": "value",
                            "--os-types": "value",
                            "--zones": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "os-inventory": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list-instances": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--inventory-filter": "value",
                        "--kernel-version": "value",
                        "--limit": "value",
                        "--os-shortname": "value",
                        "--os-version": "value",
                        "--package-name": "value",
                        "--package-version": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "patch-partner-metadata": {
                  "commands": {},
                  "flags": {
                    "--partner-metadata": "value",
                    "--partner-metadata-from-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "perform-maintenance": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-partner-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-resource-policies": {
                  "commands": {},
                  "flags": {
                    "--resource-policies": "value",
                    "--zone": "dynamic"
                  }
                },
                "remove-tags": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--tags": "value",
                    "--zone": "dynamic"
                  }
                },
                "report-host-as-faulty": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--disruption-schedule": [
                      "IMMEDIATE"
                    ],
                    "--fault-reasons": "value",
                    "--zone": "dynamic"
                  }
                },
                "reset": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "resume": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "dynamic"
                  }
                },
                "send-diagnostic-interrupt": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "set-disk-auto-delete": {
                  "commands": {},
                  "flags": {
                    "--auto-delete": "bool",
                    "--device-name": "value",
                    "--disk": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "set-machine-type": {
                  "commands": {},
                  "flags": {
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--machine-type": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-min-cpu-platform": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--min-cpu-platform": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-name": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-scheduling": {
                  "commands": {},
                  "flags": {
                    "--clear-discard-local-ssds-at-termination-timestamp": "bool",
                    "--clear-instance-termination-action": "bool",
                    "--clear-max-run-duration": "bool",
                    "--clear-min-node-cpu": "bool",
                    "--clear-node-affinities": "bool",
                    "--clear-termination-time": "bool",
                    "--discard-local-ssds-at-termination-timestamp": "value",
                    "--graceful-shutdown": "bool",
                    "--graceful-shutdown-max-duration": "value",
                    "--host-error-timeout-seconds": "value",
                    "--instance-termination-action": [
                      "DELETE",
                      "STOP"
                    ],
                    "--local-ssd-recovery-timeout": "value",
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--max-run-duration": "value",
                    "--min-node-cpu": "value",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--preemptible": "bool",
                    "--provisioning-model": [
                      "RESERVATION_BOUND",
                      "SPOT",
                      "STANDARD"
                    ],
                    "--restart-on-failure": "bool",
                    "--termination-time": "value",
                    "--zone": "dynamic"
                  }
                },
                "set-scopes": {
                  "commands": {},
                  "flags": {
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--zone": "dynamic"
                  }
                },
                "simulate-maintenance-event": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--with-extended-notifications": "value",
                    "--zone": "dynamic"
                  }
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--csek-key-file": "value",
                    "--zone": "dynamic"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--discard-local-ssd": "value",
                    "--no-graceful-shutdown": "bool",
                    "--zone": "dynamic"
                  }
                },
                "suspend": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--discard-local-ssd": "value",
                    "--zone": "dynamic"
                  }
                },
                "tail-serial-port-output": {
                  "commands": {},
                  "flags": {
                    "--port": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--clear-node-affinities": "bool",
                    "--deletion-protection": "bool",
                    "--enable-display-device": "bool",
                    "--graceful-shutdown": "bool",
                    "--graceful-shutdown-max-duration": "value",
                    "--min-cpu-platform": "value",
                    "--node": "value",
                    "--node-affinity-file": "value",
                    "--node-group": "value",
                    "--partner-metadata": "value",
                    "--partner-metadata-from-file": "value",
                    "--remove-labels": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-learn-integrity-policy": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--update-labels": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-access-config": {
                  "commands": {},
                  "flags": {
                    "--ipv6-public-ptr-domain": "value",
                    "--network-interface": "value",
                    "--network-tier": "value",
                    "--no-ipv6-public-ptr": "bool",
                    "--no-public-dns": "bool",
                    "--no-public-ptr": "bool",
                    "--no-public-ptr-domain": "bool",
                    "--public-dns": "bool",
                    "--public-ptr": "bool",
                    "--public-ptr-domain": "value",
                    "--zone": "dynamic"
                  }
                },
                "update-container": {
                  "commands": {},
                  "flags": {
                    "--clear-container-args": "bool",
                    "--clear-container-command": "bool",
                    "--container-arg": "value",
                    "--container-command": "value",
                    "--container-env": "value",
                    "--container-env-file": "value",
                    "--container-image": "value",
                    "--container-mount-disk": "value",
                    "--container-mount-host-path": "value",
                    "--container-mount-tmpfs": "value",
                    "--container-privileged": "bool",
                    "--container-restart-policy": [
                      "always",
                      "never",
                      "on-failure"
                    ],
                    "--container-stdin": "bool",
                    "--container-tty": "bool",
                    "--remove-container-env": "value",
                    "--remove-container-mounts": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-learn-integrity-policy": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--zone": "dynamic"
                  }
                },
                "update-from-file": {
                  "commands": {},
                  "flags": {
                    "--clear-secure-tag": "bool",
                    "--minimal-action": "value",
                    "--most-disruptive-allowed-action": "value",
                    "--source": "value",
                    "--zone": "dynamic"
                  }
                },
                "vulnerabilities": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--instance": "dynamic",
                        "--instance-zone": "dynamic",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "instant-snapshots": {
              "commands": {
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--labels": "value",
                    "--region": "dynamic",
                    "--source-disk": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "interconnects": {
              "commands": {
                "application-awareness": {
                  "commands": {
                    "get-config": {
                      "commands": {},
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "attachments": {
                  "commands": {
                    "dedicated": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100g",
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--candidate-cloud-router-ip-address": "value",
                            "--candidate-cloud-router-ipv6-address": "value",
                            "--candidate-customer-router-ip-address": "value",
                            "--candidate-customer-router-ipv6-address": "value",
                            "--candidate-ipv6-subnets": "value",
                            "--candidate-subnets": "value",
                            "--cloud-router-ipv6-interface-id": "value",
                            "--customer-router-ipv6-interface-id": "value",
                            "--description": "value",
                            "--dry-run": "bool",
                            "--enable-admin": "bool",
                            "--enable-multicast": "bool",
                            "--encryption": [
                              "IPSEC",
                              "NONE"
                            ],
                            "--interconnect": "dynamic",
                            "--ipsec-internal-addresses": "value",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--stack-type": [
                              "IPV4_IPV6",
                              "IPV4_ONLY"
                            ],
                            "--subnet-length": [
                              29,
                              30
                            ],
                            "--vlan": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--bandwidth": [
                              "100g",
                              "100m",
                              "10g",
                              "1g",
                              "200m",
                              "20g",
                              "2g",
                              "300m",
                              "400m",
                              "500m",
                              "50g",
                              "50m",
                              "5g"
                            ],
                            "--candidate-cloud-router-ipv6-address": "value",
                            "--candidate-customer-router-ipv6-address": "value",
                            "--candidate-ipv6-subnets": "value",
                            "--clear-labels": "bool",
                            "--cloud-router-ipv6-interface-id": "value",
                            "--customer-router-ipv6-interface-id": "value",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--enable-multicast": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--stack-type": [
                              "IPV4_IPV6",
                              "IPV4_ONLY"
                            ],
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "groups": {
                      "commands": {
                        "add-members": {
                          "commands": {},
                          "flags": {
                            "--attachments": "value"
                          }
                        },
                        "create": {
                          "commands": {},
                          "flags": {
                            "--attachments": "value",
                            "--description": "value",
                            "--intended-availability-sla": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {}
                        },
                        "describe": {
                          "commands": {},
                          "flags": {}
                        },
                        "get-operational-status": {
                          "commands": {},
                          "flags": {}
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        },
                        "remove-members": {
                          "commands": {},
                          "flags": {
                            "--attachments": "value"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--attachments": "value",
                            "--description": "value",
                            "--intended-availability-sla": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "partner": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--candidate-cloud-router-ip-address": "value",
                            "--candidate-cloud-router-ipv6-address": "value",
                            "--candidate-customer-router-ip-address": "value",
                            "--candidate-customer-router-ipv6-address": "value",
                            "--description": "value",
                            "--dry-run": "bool",
                            "--edge-availability-domain": [
                              "any",
                              "availability-domain-1",
                              "availability-domain-2"
                            ],
                            "--enable-admin": "bool",
                            "--encryption": [
                              "IPSEC",
                              "NONE"
                            ],
                            "--ipsec-internal-addresses": "value",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--stack-type": [
                              "IPV4_IPV6",
                              "IPV4_ONLY"
                            ]
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--candidate-cloud-router-ipv6-address": "value",
                            "--candidate-customer-router-ipv6-address": "value",
                            "--clear-labels": "bool",
                            "--description": "value",
                            "--enable-admin": "bool",
                            "--mtu": "value",
                            "--region": "dynamic",
                            "--remove-labels": "value",
                            "--stack-type": [
                              "IPV4_IPV6",
                              "IPV4_ONLY"
                            ],
                            "--update-labels": "value"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--customer-name": "value",
                    "--description": "value",
                    "--interconnect-type": [
                      "DEDICATED",
                      "IT_PRIVATE",
                      "PARTNER"
                    ],
                    "--link-type": [
                      "LINK_TYPE_ETHERNET_100G_LR",
                      "LINK_TYPE_ETHERNET_10G_LR",
                      "LINK_TYPE_ETHERNET_400G_LR4"
                    ],
                    "--location": "dynamic",
                    "--noc-contact-email": "value",
                    "--remote-location": "dynamic",
                    "--requested-features": "value",
                    "--requested-link-count": "value"
                  }
                },
                "cross-site-networks": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--description": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-diagnostics": {
                  "commands": {},
                  "flags": {}
                },
                "groups": {
                  "commands": {
                    "add-members": {
                      "commands": {},
                      "flags": {
                        "--interconnects": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--intended-topology-capability": "value",
                        "--interconnects": "value"
                      }
                    },
                    "create-members": {
                      "commands": {},
                      "flags": {
                        "--admin-enabled": "bool",
                        "--customer-name": "value",
                        "--description": "value",
                        "--facility": "value",
                        "--intent-mismatch-behavior": [
                          "CREATE",
                          "REJECT"
                        ],
                        "--interconnect": "value",
                        "--interconnect-type": [
                          "DEDICATED",
                          "PARTNER"
                        ],
                        "--link-type": [
                          "LINK_TYPE_ETHERNET_100G_LR",
                          "LINK_TYPE_ETHERNET_10G_LR",
                          "LINK_TYPE_ETHERNET_400G_LR4"
                        ],
                        "--noc-contact-email": "value",
                        "--requested-features": "value",
                        "--requested-link-count": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {}
                    },
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "get-operational-status": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-members": {
                      "commands": {},
                      "flags": {
                        "--interconnects": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--intended-topology-capability": "value",
                        "--interconnects": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "macsec": {
                  "commands": {
                    "add-key": {
                      "commands": {},
                      "flags": {
                        "--key-name": "value",
                        "--start-time": "value"
                      }
                    },
                    "get-config": {
                      "commands": {},
                      "flags": {}
                    },
                    "remove-key": {
                      "commands": {},
                      "flags": {
                        "--key-name": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--enabled": "bool",
                        "--fail-open": "bool"
                      }
                    },
                    "update-key": {
                      "commands": {},
                      "flags": {
                        "--key-name": "value",
                        "--start-time": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "remote-locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--admin-enabled": "bool",
                    "--clear-labels": "bool",
                    "--description": "value",
                    "--noc-contact-email": "value",
                    "--remove-labels": "value",
                    "--requested-link-count": "value",
                    "--update-labels": "value"
                  }
                },
                "wire-groups": {
                  "commands": {
                    "add-endpoint": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic",
                        "--endpoint-label": "value"
                      }
                    },
                    "add-interconnect": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic",
                        "--endpoint-label": "value",
                        "--interconnect": "dynamic",
                        "--interconnect-label": "value",
                        "--vlan-tags": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-enabled": "bool",
                        "--bandwidth-allocation": [
                          "ALLOCATE_PER_WIRE",
                          "SHARED_WITH_WIRE_GROUP"
                        ],
                        "--bandwidth-metered": "value",
                        "--bandwidth-unmetered": "value",
                        "--cross-site-network": "dynamic",
                        "--description": "value",
                        "--fault-response": [
                          "DISABLE_PORT",
                          "NONE"
                        ],
                        "--network-service-class": [
                          "BRONZE",
                          "GOLD"
                        ],
                        "--type": [
                          "BOX_AND_CROSS",
                          "REDUNDANT",
                          "WIRE"
                        ],
                        "--validate-only": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-endpoint": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic",
                        "--endpoint-label": "value"
                      }
                    },
                    "remove-interconnect": {
                      "commands": {},
                      "flags": {
                        "--cross-site-network": "dynamic",
                        "--endpoint-label": "value",
                        "--interconnect-label": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--admin-enabled": "bool",
                        "--bandwidth-allocation": [
                          "ALLOCATE_PER_WIRE",
                          "SHARED_WITH_WIRE_GROUP"
                        ],
                        "--bandwidth-metered": "value",
                        "--bandwidth-unmetered": "value",
                        "--cross-site-network": "dynamic",
                        "--description": "value",
                        "--fault-response": [
                          "DISABLE_PORT",
                          "NONE"
                        ],
                        "--network-service-class": [
                          "BRONZE",
                          "GOLD"
                        ],
                        "--type": [
                          "BOX_AND_CROSS",
                          "REDUNDANT",
                          "WIRE"
                        ],
                        "--validate-only": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "machine-images": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--require-csek-key-create": "bool",
                    "--source-disk-csek-key": "value",
                    "--source-instance": "dynamic",
                    "--source-instance-zone": "dynamic",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--byol": "bool",
                    "--can-ip-forward": "bool",
                    "--cloudbuild-service-account": "value",
                    "--compute-service-account": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--guest-environment": "bool",
                    "--guest-flush": "bool",
                    "--guest-os-features": "value",
                    "--labels": "value",
                    "--log-location": "value",
                    "--machine-type": "dynamic",
                    "--network": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--os": [
                      "centos-7",
                      "centos-stream-8",
                      "centos-stream-9",
                      "debian-10",
                      "debian-11",
                      "debian-8",
                      "debian-9",
                      "opensuse-15",
                      "rhel-6",
                      "rhel-6-byol",
                      "rhel-7",
                      "rhel-7-byol",
                      "rhel-8",
                      "rhel-8-byol",
                      "rhel-9",
                      "rhel-9-byol",
                      "rocky-8",
                      "rocky-9",
                      "sles-12",
                      "sles-12-byol",
                      "sles-15",
                      "sles-15-byol",
                      "sles-sap-12",
                      "sles-sap-12-byol",
                      "sles-sap-15",
                      "sles-sap-15-byol",
                      "ubuntu-1404",
                      "ubuntu-1604",
                      "ubuntu-1804",
                      "ubuntu-2004",
                      "ubuntu-2204",
                      "windows-10-x64-byol",
                      "windows-10-x86-byol",
                      "windows-11-x64-byol",
                      "windows-2008r2",
                      "windows-2008r2-byol",
                      "windows-2012",
                      "windows-2012-byol",
                      "windows-2012r2",
                      "windows-2012r2-byol",
                      "windows-2016",
                      "windows-2016-byol",
                      "windows-2019",
                      "windows-2019-byol",
                      "windows-2022",
                      "windows-2022-byol",
                      "windows-7-x64-byol",
                      "windows-7-x86-byol",
                      "windows-8-x64-byol",
                      "windows-8-x86-byol"
                    ],
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--service-account": "value",
                    "--source-uri": "value",
                    "--storage-location": "value",
                    "--subnet": "value",
                    "--tags": "value",
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                }
              },
              "flags": {}
            },
            "machine-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-attachments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--connection-preference": [
                      "ACCEPT_AUTOMATIC",
                      "ACCEPT_MANUAL"
                    ],
                    "--description": "value",
                    "--producer-accept-list": "value",
                    "--producer-reject-list": "value",
                    "--region": "dynamic",
                    "--subnets": "dynamic",
                    "--subnets-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--producer-accept-list": "value",
                    "--producer-reject-list": "value",
                    "--region": "dynamic",
                    "--subnets": "dynamic",
                    "--subnets-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-edge-security-services": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--region": "dynamic",
                    "--security-policy": "dynamic",
                    "--security-policy-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--region": "dynamic",
                    "--security-policy": "dynamic",
                    "--security-policy-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-endpoint-groups": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--app-engine-app": "bool",
                    "--app-engine-service": "value",
                    "--app-engine-url-mask": "value",
                    "--app-engine-version": "value",
                    "--cloud-function-name": "value",
                    "--cloud-function-url-mask": "value",
                    "--cloud-run-service": "value",
                    "--cloud-run-tag": "value",
                    "--cloud-run-url-mask": "value",
                    "--default-port": "value",
                    "--global": "bool",
                    "--network": "value",
                    "--network-endpoint-type": [
                      "gce-vm-ip",
                      "gce-vm-ip-port",
                      "gce-vm-ip-portmap",
                      "internet-fqdn-port",
                      "internet-ip-port",
                      "non-gcp-private-ip-port",
                      "private-service-connect",
                      "serverless"
                    ],
                    "--producer-port": "value",
                    "--psc-target-service": "value",
                    "--region": "dynamic",
                    "--serverless-deployment-platform": "value",
                    "--serverless-deployment-resource": "value",
                    "--serverless-deployment-url-mask": "value",
                    "--serverless-deployment-version": "value",
                    "--subnet": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                },
                "list-network-endpoints": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--zone": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-endpoint": "value",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-endpoint": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-firewall-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--name": "value",
                        "--network": "value",
                        "--replace-association-on-target": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--name": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "clone-rules": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source-firewall-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export-rules": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "get-effective-firewalls": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--network": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "import-rules": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "mirroring-rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "do_not_mirror",
                          "goto_next",
                          "mirror"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--firewall-policy": "value",
                        "--global-firewall-policy": "bool",
                        "--layer4-configs": "value",
                        "--security-profile-group": "value",
                        "--src-ip-ranges": "value",
                        "--target-secure-tags": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--global-firewall-policy": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--global-firewall-policy": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "do_not_mirror",
                          "goto_next",
                          "mirror"
                        ],
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--firewall-policy": "value",
                        "--global-firewall-policy": "bool",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--security-profile-group": "value",
                        "--src-ip-ranges": "value",
                        "--target-secure-tags": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "apply_security_profile_group",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-address-groups": "value",
                        "--dest-fqdns": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-network-type": "value",
                        "--dest-region-codes": "value",
                        "--dest-threat-intelligence": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--layer4-configs": "value",
                        "--security-profile-group": "value",
                        "--src-address-groups": "value",
                        "--src-fqdns": "value",
                        "--src-ip-ranges": "value",
                        "--src-network-type": "value",
                        "--src-networks": "value",
                        "--src-region-codes": "value",
                        "--src-secure-tags": "value",
                        "--src-threat-intelligence": "value",
                        "--target-forwarding-rules": "value",
                        "--target-secure-tags": "value",
                        "--target-service-accounts": "value",
                        "--target-type": [
                          "INSTANCES",
                          "INTERNAL_MANAGED_LB"
                        ],
                        "--tls-inspect": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "apply_security_profile_group",
                          "deny",
                          "goto_next"
                        ],
                        "--description": "value",
                        "--dest-address-groups": "value",
                        "--dest-fqdns": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-network-type": "value",
                        "--dest-region-codes": "value",
                        "--dest-threat-intelligence": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--disabled": "bool",
                        "--enable-logging": "bool",
                        "--firewall-policy": "value",
                        "--firewall-policy-region": "dynamic",
                        "--global-firewall-policy": "bool",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--security-profile-group": "value",
                        "--src-address-groups": "value",
                        "--src-fqdns": "value",
                        "--src-ip-ranges": "value",
                        "--src-network-type": "value",
                        "--src-networks": "value",
                        "--src-region-codes": "value",
                        "--src-secure-tags": "value",
                        "--src-threat-intelligence": "value",
                        "--target-forwarding-rules": "value",
                        "--target-secure-tags": "value",
                        "--target-service-accounts": "value",
                        "--target-type": [
                          "INSTANCES",
                          "INTERNAL_MANAGED_LB"
                        ],
                        "--tls-inspect": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "network-profiles": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "networks": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--bgp-best-path-selection-mode": [
                      "LEGACY",
                      "STANDARD"
                    ],
                    "--bgp-bps-always-compare-med": "bool",
                    "--bgp-bps-inter-region-cost": [
                      "ADD_COST_TO_MED",
                      "DEFAULT"
                    ],
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--description": "value",
                    "--enable-ula-internal-ipv6": "bool",
                    "--internal-ipv6-range": "value",
                    "--mtu": "value",
                    "--network-firewall-policy-enforcement-order": [
                      "AFTER_CLASSIC_FIREWALL",
                      "BEFORE_CLASSIC_FIREWALL"
                    ],
                    "--network-profile": "dynamic",
                    "--range": "value",
                    "--subnet-mode": [
                      "auto",
                      "custom",
                      "legacy"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "get-effective-firewalls": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-ip-addresses": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--types": "value"
                  }
                },
                "list-ip-owners": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--ip-cidr-range": "value",
                    "--limit": "value",
                    "--owner-projects": "value",
                    "--owner-types": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--subnet-name": "value",
                    "--subnet-region": "value",
                    "--uri": "bool"
                  }
                },
                "peerings": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-create-routes": "bool",
                        "--export-custom-routes": "bool",
                        "--export-subnet-routes-with-public-ip": "bool",
                        "--import-custom-routes": "bool",
                        "--import-subnet-routes-with-public-ip": "bool",
                        "--network": "value",
                        "--peer-network": "value",
                        "--peer-project": "value",
                        "--stack-type": "value",
                        "--update-strategy": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--network": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-routes": {
                      "commands": {},
                      "flags": {
                        "--direction": [
                          "INCOMING",
                          "OUTGOING"
                        ],
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "request-delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--network": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--export-custom-routes": "bool",
                        "--export-subnet-routes-with-public-ip": "bool",
                        "--import-custom-routes": "bool",
                        "--import-subnet-routes-with-public-ip": "bool",
                        "--network": "value",
                        "--stack-type": "value",
                        "--update-strategy": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "subnets": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "config": {
                      "commands": {
                        "export": {
                          "commands": {},
                          "flags": {
                            "--all": "bool",
                            "--path": "value",
                            "--region": "value",
                            "--resource-format": [
                              "krm",
                              "terraform"
                            ]
                          }
                        }
                      },
                      "flags": {}
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--description": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-l2": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--external-ipv6-prefix": "value",
                        "--flow-sampling": "value",
                        "--internal-ipv6-prefix": "value",
                        "--ip-collection": "value",
                        "--ipv6-access-type": [
                          "EXTERNAL",
                          "INTERNAL"
                        ],
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-filter-expr": "value",
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "custom",
                          "exclude-all",
                          "include-all"
                        ],
                        "--logging-metadata-fields": "value",
                        "--metadata": [
                          "exclude-all-metadata",
                          "include-all-metadata"
                        ],
                        "--network": "dynamic",
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access"
                        ],
                        "--purpose": [
                          "AGGREGATE",
                          "CUSTOM_HARDWARE_LINK",
                          "GLOBAL_MANAGED_PROXY",
                          "INTERNAL_HTTPS_LOAD_BALANCER",
                          "PEER_MIGRATION",
                          "PRIVATE",
                          "PRIVATE_NAT",
                          "PRIVATE_SERVICE_CONNECT",
                          "REGIONAL_MANAGED_PROXY"
                        ],
                        "--range": "value",
                        "--region": "dynamic",
                        "--reserved-internal-range": "value",
                        "--role": [
                          "ACTIVE",
                          "BACKUP"
                        ],
                        "--secondary-range": "value",
                        "--secondary-range-with-reserved-internal-range": "value",
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY",
                          "IPV6_ONLY"
                        ],
                        "--vlan": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "expand-ip-range": {
                      "commands": {},
                      "flags": {
                        "--prefix-length": "value",
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--network": "value",
                        "--page-size": "value",
                        "--regexp": "value",
                        "--regions": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-usable": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--service-project": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-secondary-ranges": "value",
                        "--add-secondary-ranges-with-reserved-internal-range": "value",
                        "--aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--allow-cidr-routes-overlap": "bool",
                        "--drain-timeout": "value",
                        "--enable-flow-logs": "bool",
                        "--enable-private-ip-google-access": "bool",
                        "--external-ipv6-prefix": "value",
                        "--flow-sampling": "value",
                        "--internal-ipv6-prefix": "value",
                        "--ip-collection": "value",
                        "--ipv6-access-type": [
                          "EXTERNAL",
                          "INTERNAL"
                        ],
                        "--logging-aggregation-interval": [
                          "interval-1-min",
                          "interval-10-min",
                          "interval-15-min",
                          "interval-30-sec",
                          "interval-5-min",
                          "interval-5-sec"
                        ],
                        "--logging-filter-expr": "value",
                        "--logging-flow-sampling": "value",
                        "--logging-metadata": [
                          "custom",
                          "exclude-all",
                          "include-all"
                        ],
                        "--logging-metadata-fields": "value",
                        "--metadata": [
                          "exclude-all-metadata",
                          "include-all-metadata"
                        ],
                        "--private-ipv6-google-access-type": [
                          "disable",
                          "enable-bidirectional-access",
                          "enable-outbound-vm-access"
                        ],
                        "--purpose": [
                          "PRIVATE",
                          "REGIONAL_MANAGED_PROXY"
                        ],
                        "--region": "dynamic",
                        "--remove-secondary-ranges": "value",
                        "--role": [
                          "ACTIVE"
                        ],
                        "--stack-type": [
                          "IPV4_IPV6",
                          "IPV4_ONLY"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--bgp-best-path-selection-mode": [
                      "LEGACY",
                      "STANDARD"
                    ],
                    "--bgp-bps-always-compare-med": "bool",
                    "--bgp-bps-inter-region-cost": [
                      "ADD_COST_TO_MED",
                      "DEFAULT"
                    ],
                    "--bgp-routing-mode": [
                      "global",
                      "regional"
                    ],
                    "--enable-ula-internal-ipv6": "bool",
                    "--internal-ipv6-range": "value",
                    "--mtu": "value",
                    "--network-firewall-policy-enforcement-order": [
                      "AFTER_CLASSIC_FIREWALL",
                      "BEFORE_CLASSIC_FIREWALL"
                    ],
                    "--switch-to-custom-subnet-mode": "bool"
                  }
                }
              },
              "flags": {}
            },
            "operations": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "value"
                  }
                }
              },
              "flags": {}
            },
            "org-security-policies": {
              "commands": {
                "associations": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--excluded-folders": "value",
                        "--excluded-projects": "value",
                        "--folder": "value",
                        "--name": "value",
                        "--organization": "value",
                        "--project-number": "value",
                        "--replace-association-on-target": "bool",
                        "--security-policy": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--organization": "value",
                        "--security-policy": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "copy-rules": {
                  "commands": {},
                  "flags": {
                    "--organization": "value",
                    "--source-security-policy": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--display-name": "value",
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--folder": "value",
                    "--organization": "value",
                    "--short-name": "value",
                    "--type": [
                      "CLOUD_ARMOR",
                      "FIREWALL"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--organization": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--folder": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-rules": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--organization": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "move": {
                  "commands": {},
                  "flags": {
                    "--folder": "value",
                    "--organization": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-502",
                          "redirect"
                        ],
                        "--cloud-armor": "bool",
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-ports": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--enable-logging": "bool",
                        "--expression": "value",
                        "--layer4-configs": "value",
                        "--organization": "value",
                        "--preview": "bool",
                        "--security-policy": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value",
                        "--target-service-accounts": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--organization": "value",
                        "--security-policy": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--organization": "value",
                        "--security-policy": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-502",
                          "redirect"
                        ],
                        "--cloud-armor": "bool",
                        "--description": "value",
                        "--dest-ip-ranges": "value",
                        "--dest-ports": "value",
                        "--direction": [
                          "EGRESS",
                          "INGRESS"
                        ],
                        "--enable-logging": "bool",
                        "--expression": "value",
                        "--layer4-configs": "value",
                        "--new-priority": "value",
                        "--organization": "value",
                        "--preview": "bool",
                        "--security-policy": "value",
                        "--src-ip-ranges": "value",
                        "--target-resources": "value",
                        "--target-service-accounts": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--json-custom-content-types": "value",
                    "--json-parsing": [
                      "DISABLED",
                      "STANDARD",
                      "STANDARD_WITH_GRAPHQL"
                    ],
                    "--log-level": [
                      "NORMAL",
                      "VERBOSE"
                    ],
                    "--organization": "value",
                    "--user-ip-request-headers": "value"
                  }
                }
              },
              "flags": {}
            },
            "os-config": {
              "commands": {
                "instance-os-policies-compliances": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "inventories": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--view": [
                          "basic",
                          "full"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "os-policy-assignment-reports": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--instance": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--assignment-id": "value",
                        "--filter": "value",
                        "--instance": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "os-policy-assignments": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--file": "value",
                        "--location": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-revisions": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "operations": {
                      "commands": {
                        "cancel": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--os-policy-assignment": "value"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--location": "value",
                            "--os-policy-assignment": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--file": "value",
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "os-upgrade": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--auto-rollback": "bool",
                    "--create-machine-backup": "bool",
                    "--log-location": "value",
                    "--source-os": [
                      "windows-2008r2"
                    ],
                    "--target-os": [
                      "windows-2012r2"
                    ],
                    "--timeout": "value",
                    "--zone": "dynamic"
                  }
                },
                "policy-orchestrators": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "delete",
                          "upsert"
                        ],
                        "--async": "bool",
                        "--folder": "value",
                        "--include-folders": "value",
                        "--include-locations": "value",
                        "--include-projects": "value",
                        "--organization": "value",
                        "--policy-file": "value",
                        "--policy-id": "value",
                        "--policy-type": [
                          "os_policy_assignment_v1"
                        ],
                        "--state": [
                          "active",
                          "stopped"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--folder": "value",
                        "--organization": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--folder": "value",
                        "--limit": "value",
                        "--organization": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "delete",
                          "upsert"
                        ],
                        "--async": "bool",
                        "--clear-folders": "bool",
                        "--clear-locations": "bool",
                        "--clear-projects": "bool",
                        "--folder": "value",
                        "--include-folders": "value",
                        "--include-locations": "value",
                        "--include-projects": "value",
                        "--organization": "value",
                        "--policy-file": "value",
                        "--policy-id": "value",
                        "--state": [
                          "active",
                          "stopped"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "troubleshoot": {
                  "commands": {},
                  "flags": {
                    "--enable-log-analysis": "bool",
                    "--zone": "dynamic"
                  }
                },
                "vulnerability-reports": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "os-login": {
              "commands": {
                "describe-profile": {
                  "commands": {},
                  "flags": {}
                },
                "remove-profile": {
                  "commands": {},
                  "flags": {
                    "--operating-system": [
                      "linux",
                      "windows"
                    ]
                  }
                },
                "ssh-keys": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--key": "value",
                        "--key-file": "value",
                        "--ttl": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "packet-mirrorings": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--filter-cidr-ranges": "value",
                    "--filter-direction": [
                      "both",
                      "egress",
                      "ingress"
                    ],
                    "--filter-protocols": "value",
                    "--mirrored-instances": "value",
                    "--mirrored-subnets": "value",
                    "--mirrored-tags": "value",
                    "--network": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-filter-cidr-ranges": "value",
                    "--add-filter-protocols": "value",
                    "--add-mirrored-instances": "value",
                    "--add-mirrored-subnets": "value",
                    "--add-mirrored-tags": "value",
                    "--async": "bool",
                    "--clear-filter-cidr-ranges": "bool",
                    "--clear-filter-protocols": "bool",
                    "--clear-mirrored-instances": "bool",
                    "--clear-mirrored-subnets": "bool",
                    "--clear-mirrored-tags": "bool",
                    "--collector-ilb": "value",
                    "--description": "value",
                    "--enable": "bool",
                    "--filter-direction": [
                      "both",
                      "egress",
                      "ingress"
                    ],
                    "--region": "dynamic",
                    "--remove-filter-cidr-ranges": "value",
                    "--remove-filter-protocols": "value",
                    "--remove-mirrored-instances": "value",
                    "--remove-mirrored-subnets": "value",
                    "--remove-mirrored-tags": "value",
                    "--set-filter-cidr-ranges": "value",
                    "--set-filter-protocols": "value",
                    "--set-mirrored-instances": "value",
                    "--set-mirrored-subnets": "value",
                    "--set-mirrored-tags": "value"
                  }
                }
              },
              "flags": {}
            },
            "project-info": {
              "commands": {
                "add-metadata": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--metadata-from-file": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "remove-metadata": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value"
                  }
                },
                "set-default-service-account": {
                  "commands": {},
                  "flags": {
                    "--no-service-account": "bool",
                    "--service-account": "value"
                  }
                },
                "set-usage-bucket": {
                  "commands": {},
                  "flags": {
                    "--bucket": "value",
                    "--no-bucket": "bool",
                    "--prefix": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--cloud-armor-tier": [
                      "CA_ENTERPRISE_ANNUAL",
                      "CA_ENTERPRISE_PAYGO",
                      "CA_STANDARD"
                    ],
                    "--default-network-tier": [
                      "PREMIUM",
                      "STANDARD"
                    ],
                    "--managed-protection-tier": [
                      "CAMP_PLUS_ANNUAL",
                      "CAMP_PLUS_PAYGO",
                      "CA_STANDARD"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "project-zonal-metadata": {
              "commands": {
                "add": {
                  "commands": {},
                  "flags": {
                    "--metadata": "value",
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "remove": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--keys": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "public-advertised-prefixes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--dns-verification-ip": "value",
                    "--pdp-scope": [
                      "GLOBAL",
                      "REGIONAL"
                    ],
                    "--range": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--announce-prefix": "bool",
                    "--status": [
                      "ptr-configured"
                    ],
                    "--withdraw-prefix": "bool"
                  }
                }
              },
              "flags": {}
            },
            "public-delegated-prefixes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--allocatable-prefix-length": "value",
                    "--description": "value",
                    "--enable-live-migration": "bool",
                    "--global": "bool",
                    "--mode": [
                      "delegation",
                      "external-ipv6-forwarding-rule-creation",
                      "external-ipv6-subnetwork-creation"
                    ],
                    "--public-advertised-prefix": "value",
                    "--public-delegated-prefix": "value",
                    "--range": "value",
                    "--region": "dynamic"
                  }
                },
                "delegated-sub-prefixes": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--allocatable-prefix-length": "value",
                        "--create-addresses": "bool",
                        "--delegatee-project": "value",
                        "--description": "value",
                        "--global-public-delegated-prefix": "bool",
                        "--mode": [
                          "delegation",
                          "external-ipv6-forwarding-rule-creation",
                          "external-ipv6-subnetwork-creation"
                        ],
                        "--public-delegated-prefix": "value",
                        "--public-delegated-prefix-region": "dynamic",
                        "--range": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--global-public-delegated-prefix": "bool",
                        "--public-delegated-prefix": "value",
                        "--public-delegated-prefix-region": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--announce-prefix": "bool",
                    "--region": "dynamic",
                    "--withdraw-prefix": "bool"
                  }
                }
              },
              "flags": {}
            },
            "queued-resources": {
              "commands": {
                "cancel": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--async": "bool",
                    "--boot-disk-auto-delete": "bool",
                    "--boot-disk-device-name": "value",
                    "--boot-disk-interface": "value",
                    "--boot-disk-kms-key": "dynamic",
                    "--boot-disk-kms-keyring": "dynamic",
                    "--boot-disk-kms-location": "dynamic",
                    "--boot-disk-kms-project": "dynamic",
                    "--boot-disk-provisioned-iops": "value",
                    "--boot-disk-provisioned-throughput": "value",
                    "--boot-disk-size": "value",
                    "--boot-disk-type": "value",
                    "--can-ip-forward": "bool",
                    "--confidential-compute": "bool",
                    "--confidential-compute-type": [
                      "SEV",
                      "SEV_SNP",
                      "TDX"
                    ],
                    "--count": "value",
                    "--create-disk": "value",
                    "--custom-cpu": "value",
                    "--custom-extensions": "bool",
                    "--custom-memory": "value",
                    "--custom-vm-type": "value",
                    "--description": "value",
                    "--discard-local-ssds-at-termination-timestamp": "value",
                    "--disk": "value",
                    "--enable-display-device": "bool",
                    "--enable-nested-virtualization": "bool",
                    "--enable-uefi-networking": "bool",
                    "--enable-watchdog-timer": "bool",
                    "--erase-windows-vss-signature": "bool",
                    "--graceful-shutdown": "bool",
                    "--graceful-shutdown-max-duration": "value",
                    "--host-error-timeout-seconds": "value",
                    "--image": "value",
                    "--image-family": "value",
                    "--image-project": "value",
                    "--instance-termination-action": [
                      "DELETE",
                      "STOP"
                    ],
                    "--labels": "value",
                    "--local-ssd": "value",
                    "--local-ssd-recovery-timeout": "value",
                    "--location-policy": "value",
                    "--machine-type": "dynamic",
                    "--maintenance-interval": [
                      "PERIODIC",
                      "RECURRENT"
                    ],
                    "--maintenance-policy": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--max-run-duration": "value",
                    "--metadata": "value",
                    "--metadata-from-file": "value",
                    "--min-count": "value",
                    "--min-cpu-platform": "value",
                    "--min-node-cpu": "value",
                    "--name-pattern": "value",
                    "--network": "value",
                    "--network-interface": "value",
                    "--network-performance-configs": "value",
                    "--network-tier": "value",
                    "--no-address": "bool",
                    "--no-public-dns": "bool",
                    "--no-scopes": "bool",
                    "--no-service-account": "bool",
                    "--numa-node-count": "value",
                    "--on-host-maintenance": [
                      "MIGRATE",
                      "TERMINATE"
                    ],
                    "--per-instance-hostnames": "value",
                    "--performance-monitoring-unit": [
                      "architectural",
                      "enhanced",
                      "standard"
                    ],
                    "--post-key-revocation-action-type": [
                      "noop",
                      "shutdown"
                    ],
                    "--predefined-names": "value",
                    "--preemptible": "bool",
                    "--provisioning-model": [
                      "FLEX_START",
                      "RESERVATION_BOUND",
                      "SPOT",
                      "STANDARD"
                    ],
                    "--public-dns": "bool",
                    "--reservation": "value",
                    "--reservation-affinity": [
                      "any",
                      "none",
                      "specific",
                      "specific-then-any-reservation",
                      "specific-then-no-reservation"
                    ],
                    "--resource-manager-tags": "value",
                    "--resource-policies": "value",
                    "--restart-on-failure": "bool",
                    "--scopes": "value",
                    "--secure-tags": "value",
                    "--service-account": "value",
                    "--shielded-integrity-monitoring": "bool",
                    "--shielded-secure-boot": "bool",
                    "--shielded-vtpm": "bool",
                    "--source-instance-template": "dynamic",
                    "--source-snapshot": "value",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY",
                      "IPV6_ONLY"
                    ],
                    "--subnet": "value",
                    "--tags": "value",
                    "--target-distribution-shape": [
                      "ANY",
                      "ANY_SINGLE_ZONE",
                      "BALANCED"
                    ],
                    "--termination-time": "value",
                    "--threads-per-core": "value",
                    "--turbo-mode": "value",
                    "--valid-until-duration": "value",
                    "--valid-until-time": "value",
                    "--visible-core-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "regions": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "reservations": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "blocks": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--block-name": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "perform-maintenance": {
                      "commands": {},
                      "flags": {
                        "--block-name": "value",
                        "--scope": [
                          "all",
                          "running",
                          "unused"
                        ],
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator": "value",
                    "--delete-after-duration": "value",
                    "--delete-at-time": "value",
                    "--description": "value",
                    "--local-ssd": "value",
                    "--machine-type": "value",
                    "--maintenance-freeze-duration": "value",
                    "--maintenance-interval": [
                      "PERIODIC",
                      "RECURRENT"
                    ],
                    "--min-cpu-platform": "value",
                    "--require-specific-reservation": "bool",
                    "--reservation-sharing-policy": [
                      "ALLOW_ALL",
                      "DISALLOW_ALL"
                    ],
                    "--resource-policies": "value",
                    "--share-setting": [
                      "folders",
                      "local",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--source-instance-template": "value",
                    "--vm-count": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "perform-maintenance": {
                  "commands": {},
                  "flags": {
                    "--scope": [
                      "all",
                      "running",
                      "unused"
                    ],
                    "--zone": "dynamic"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic",
                    "--zone": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "sub-blocks": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--block-name": "value",
                        "--sub-block-name": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--block-name": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-share-with": "value",
                    "--delete-after-duration": "value",
                    "--delete-at-time": "value",
                    "--disable-auto-delete": "bool",
                    "--enable-emergent-maintenance": "bool",
                    "--remove-share-with": "value",
                    "--reservation-sharing-policy": [
                      "ALLOW_ALL",
                      "DISALLOW_ALL"
                    ],
                    "--share-setting": [
                      "local",
                      "projects"
                    ],
                    "--share-with": "value",
                    "--vm-count": "value",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "reset-windows-password": {
              "commands": {},
              "flags": {
                "--user": "value",
                "--zone": "dynamic"
              }
            },
            "resource-policies": {
              "commands": {
                "create": {
                  "commands": {
                    "disk-consistency-group": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--region": "dynamic"
                      }
                    },
                    "group-placement": {
                      "commands": {},
                      "flags": {
                        "--availability-domain-count": "value",
                        "--collocation": [
                          "clustered",
                          "collocated",
                          "unspecified-collocation"
                        ],
                        "--description": "value",
                        "--gpu-topology": "value",
                        "--max-distance": "value",
                        "--region": "dynamic",
                        "--scope": [
                          "host",
                          "unspecified-scope"
                        ],
                        "--tpu-topology": "value",
                        "--vm-count": "value"
                      }
                    },
                    "instance-schedule": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--end-date": "value",
                        "--initiation-date": "value",
                        "--region": "dynamic",
                        "--timezone": "value",
                        "--vm-start-schedule": "value",
                        "--vm-stop-schedule": "value"
                      }
                    },
                    "snapshot-schedule": {
                      "commands": {},
                      "flags": {
                        "--daily-schedule": "bool",
                        "--description": "value",
                        "--guest-flush": "bool",
                        "--hourly-schedule": "value",
                        "--max-retention-days": "value",
                        "--on-source-disk-delete": [
                          "apply-retention-policy",
                          "keep-auto-snapshots"
                        ],
                        "--region": "dynamic",
                        "--snapshot-labels": "value",
                        "--snapshot-region": "dynamic",
                        "--start-time": "value",
                        "--storage-location": "value",
                        "--weekly-schedule": [
                          "friday",
                          "monday",
                          "saturday",
                          "sunday",
                          "thursday",
                          "tuesday",
                          "wednesday"
                        ],
                        "--weekly-schedule-from-file": "value"
                      }
                    },
                    "vm-maintenance": {
                      "commands": {
                        "concurrency-limit": {
                          "commands": {},
                          "flags": {
                            "--description": "value",
                            "--max-percent": "value",
                            "--region": "dynamic"
                          }
                        },
                        "maintenance-window": {
                          "commands": {},
                          "flags": {
                            "--daily-window": "bool",
                            "--description": "value",
                            "--region": "dynamic",
                            "--start-time": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "workload-policy": {
                      "commands": {},
                      "flags": {
                        "--accelerator-topology": "value",
                        "--description": "value",
                        "--max-topology-distance": [
                          "BLOCK",
                          "CLUSTER",
                          "SUBBLOCK"
                        ],
                        "--region": "dynamic",
                        "--type": [
                          "HIGH_AVAILABILITY",
                          "HIGH_THROUGHPUT"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create-snapshot-schedule": {
                  "commands": {},
                  "flags": {
                    "--daily-schedule": "bool",
                    "--description": "value",
                    "--guest-flush": "bool",
                    "--hourly-schedule": "value",
                    "--max-retention-days": "value",
                    "--on-source-disk-delete": [
                      "apply-retention-policy",
                      "keep-auto-snapshots"
                    ],
                    "--region": "dynamic",
                    "--snapshot-labels": "value",
                    "--snapshot-region": "dynamic",
                    "--start-time": "value",
                    "--storage-location": "value",
                    "--weekly-schedule": [
                      "friday",
                      "monday",
                      "saturday",
                      "sunday",
                      "thursday",
                      "tuesday",
                      "wednesday"
                    ],
                    "--weekly-schedule-from-file": "value"
                  }
                },
                "create-vm-maintenance": {
                  "commands": {},
                  "flags": {
                    "--daily-window": "bool",
                    "--description": "value",
                    "--region": "dynamic",
                    "--start-time": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--region": "value"
                  }
                },
                "update": {
                  "commands": {
                    "instance-schedule": {
                      "commands": {},
                      "flags": {
                        "--description": "value",
                        "--end-date": "value",
                        "--initiation-date": "value",
                        "--region": "dynamic",
                        "--timezone": "value",
                        "--vm-start-schedule": "value",
                        "--vm-stop-schedule": "value"
                      }
                    },
                    "snapshot-schedule": {
                      "commands": {},
                      "flags": {
                        "--daily-schedule": "bool",
                        "--description": "value",
                        "--hourly-schedule": "value",
                        "--max-retention-days": "value",
                        "--on-source-disk-delete": [
                          "apply-retention-policy",
                          "keep-auto-snapshots"
                        ],
                        "--region": "dynamic",
                        "--snapshot-labels": "value",
                        "--start-time": "value",
                        "--weekly-schedule": [
                          "friday",
                          "monday",
                          "saturday",
                          "sunday",
                          "thursday",
                          "tuesday",
                          "wednesday"
                        ],
                        "--weekly-schedule-from-file": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "routers": {
              "commands": {
                "add-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--bfd-min-receive-interval": "value",
                    "--bfd-min-transmit-interval": "value",
                    "--bfd-multiplier": "value",
                    "--bfd-session-initialization-mode": [
                      "ACTIVE",
                      "DISABLED",
                      "PASSIVE"
                    ],
                    "--custom-learned-route-priority": "value",
                    "--enable-ipv4": "bool",
                    "--enable-ipv6": "bool",
                    "--enabled": "bool",
                    "--export-policies": "value",
                    "--import-policies": "value",
                    "--instance": "dynamic",
                    "--instance-zone": "dynamic",
                    "--interface": "value",
                    "--ipv4-nexthop-address": "value",
                    "--ipv6-nexthop-address": "value",
                    "--md5-authentication-key": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-ipv4-nexthop-address": "value",
                    "--peer-ipv6-nexthop-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value",
                    "--set-custom-learned-route-ranges": "value"
                  }
                },
                "add-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--mask-length": "value",
                    "--redundant-interface": "value",
                    "--region": "dynamic",
                    "--subnetwork": "dynamic",
                    "--subnetwork-region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                },
                "add-route-policy": {
                  "commands": {},
                  "flags": {
                    "--policy-name": "value",
                    "--policy-type": [
                      "EXPORT",
                      "IMPORT"
                    ],
                    "--region": "dynamic"
                  }
                },
                "add-route-policy-term": {
                  "commands": {},
                  "flags": {
                    "--actions": "value",
                    "--match": "value",
                    "--policy-name": "value",
                    "--priority": "value",
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--asn": "value",
                    "--async": "bool",
                    "--bgp-identifier-range": "value",
                    "--description": "value",
                    "--encrypted-interconnect-router": "bool",
                    "--keepalive-interval": "value",
                    "--ncc-gateway": "value",
                    "--network": "dynamic",
                    "--region": "dynamic",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "download-route-policy": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--policy-name": "value",
                    "--region": "dynamic"
                  }
                },
                "get-nat-ip-info": {
                  "commands": {},
                  "flags": {
                    "--nat-name": "value",
                    "--region": "dynamic"
                  }
                },
                "get-nat-mapping-info": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--nat-name": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value"
                  }
                },
                "get-route-policy": {
                  "commands": {},
                  "flags": {
                    "--policy-name": "value",
                    "--region": "dynamic"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-bgp-routes": {
                  "commands": {},
                  "flags": {
                    "--address-family": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--destination-range": "value",
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--peer": "value",
                    "--policy-applied": "bool",
                    "--region": "dynamic",
                    "--route-direction": [
                      "INBOUND",
                      "OUTBOUND"
                    ],
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-route-policies": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "dynamic",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "nats": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--auto-network-tier": [
                          "PREMIUM",
                          "STANDARD"
                        ],
                        "--enable-dynamic-port-allocation": "bool",
                        "--enable-endpoint-independent-mapping": "bool",
                        "--enable-logging": "bool",
                        "--endpoint-types": "value",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--max-ports-per-vm": "value",
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--nat64-all-v6-subnet-ip-ranges": "bool",
                        "--nat64-custom-v6-subnet-ip-ranges": "value",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--rules": "value",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-time-wait-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--type": [
                          "PRIVATE",
                          "PUBLIC"
                        ],
                        "--udp-idle-timeout": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--router": "dynamic"
                      }
                    },
                    "rules": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--match": "value",
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--source-nat-active-ips": "value",
                            "--source-nat-active-ranges": "value"
                          }
                        },
                        "delete": {
                          "commands": {},
                          "flags": {
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic"
                          }
                        },
                        "update": {
                          "commands": {},
                          "flags": {
                            "--async": "bool",
                            "--clear-source-nat-drain-ips": "bool",
                            "--clear-source-nat-drain-ranges": "bool",
                            "--match": "value",
                            "--nat": "value",
                            "--region": "dynamic",
                            "--router": "dynamic",
                            "--source-nat-active-ips": "value",
                            "--source-nat-active-ranges": "value",
                            "--source-nat-drain-ips": "value",
                            "--source-nat-drain-ranges": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--auto-allocate-nat-external-ips": "bool",
                        "--auto-network-tier": [
                          "PREMIUM",
                          "STANDARD"
                        ],
                        "--clear-icmp-idle-timeout": "bool",
                        "--clear-max-ports-per-vm": "bool",
                        "--clear-min-ports-per-vm": "bool",
                        "--clear-nat-external-drain-ip-pool": "bool",
                        "--clear-nat-subnet-ip-ranges": "bool",
                        "--clear-nat64-subnet-ip-ranges": "bool",
                        "--clear-tcp-established-idle-timeout": "bool",
                        "--clear-tcp-time-wait-timeout": "bool",
                        "--clear-tcp-transitory-idle-timeout": "bool",
                        "--clear-udp-idle-timeout": "bool",
                        "--enable-dynamic-port-allocation": "bool",
                        "--enable-endpoint-independent-mapping": "bool",
                        "--enable-logging": "bool",
                        "--icmp-idle-timeout": "value",
                        "--log-filter": [
                          "ALL",
                          "ERRORS_ONLY",
                          "TRANSLATIONS_ONLY"
                        ],
                        "--max-ports-per-vm": "value",
                        "--min-ports-per-vm": "value",
                        "--nat-all-subnet-ip-ranges": "bool",
                        "--nat-custom-subnet-ip-ranges": "value",
                        "--nat-external-drain-ip-pool": "value",
                        "--nat-external-ip-pool": "value",
                        "--nat-primary-subnet-ip-ranges": "bool",
                        "--nat64-all-v6-subnet-ip-ranges": "bool",
                        "--nat64-custom-v6-subnet-ip-ranges": "value",
                        "--region": "dynamic",
                        "--router": "dynamic",
                        "--rules": "value",
                        "--tcp-established-idle-timeout": "value",
                        "--tcp-time-wait-timeout": "value",
                        "--tcp-transitory-idle-timeout": "value",
                        "--udp-idle-timeout": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "remove-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--peer-name": "value",
                    "--peer-names": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-interface": {
                  "commands": {},
                  "flags": {
                    "--interface-name": "value",
                    "--interface-names": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-route-policy": {
                  "commands": {},
                  "flags": {
                    "--policy-name": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-route-policy-term": {
                  "commands": {},
                  "flags": {
                    "--policy-name": "value",
                    "--priority": "value",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--asn": "value",
                    "--async": "bool",
                    "--bgp-identifier-range": "value",
                    "--keepalive-interval": "value",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value"
                  }
                },
                "update-bgp-peer": {
                  "commands": {},
                  "flags": {
                    "--add-advertisement-groups": "value",
                    "--add-advertisement-ranges": "value",
                    "--add-custom-learned-route-ranges": "value",
                    "--advertised-route-priority": "value",
                    "--advertisement-mode": [
                      "CUSTOM",
                      "DEFAULT"
                    ],
                    "--async": "bool",
                    "--bfd-min-receive-interval": "value",
                    "--bfd-min-transmit-interval": "value",
                    "--bfd-multiplier": "value",
                    "--bfd-session-initialization-mode": [
                      "ACTIVE",
                      "DISABLED",
                      "PASSIVE"
                    ],
                    "--clear-md5-authentication-key": "bool",
                    "--custom-learned-route-priority": "value",
                    "--enable-ipv4": "bool",
                    "--enable-ipv6": "bool",
                    "--enabled": "bool",
                    "--export-policies": "value",
                    "--import-policies": "value",
                    "--interface": "value",
                    "--ip-address": "value",
                    "--ipv4-nexthop-address": "value",
                    "--ipv6-nexthop-address": "value",
                    "--md5-authentication-key": "value",
                    "--peer-asn": "value",
                    "--peer-ip-address": "value",
                    "--peer-ipv4-nexthop-address": "value",
                    "--peer-ipv6-nexthop-address": "value",
                    "--peer-name": "value",
                    "--region": "dynamic",
                    "--remove-advertisement-groups": "value",
                    "--remove-advertisement-ranges": "value",
                    "--remove-custom-learned-route-ranges": "value",
                    "--set-advertisement-groups": "value",
                    "--set-advertisement-ranges": "value",
                    "--set-custom-learned-route-ranges": "value"
                  }
                },
                "update-interface": {
                  "commands": {},
                  "flags": {
                    "--interconnect-attachment": "dynamic",
                    "--interconnect-attachment-region": "dynamic",
                    "--interface-name": "value",
                    "--ip-address": "value",
                    "--ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--mask-length": "value",
                    "--region": "dynamic",
                    "--vpn-tunnel": "dynamic",
                    "--vpn-tunnel-region": "dynamic"
                  }
                },
                "update-route-policy-term": {
                  "commands": {},
                  "flags": {
                    "--actions": "value",
                    "--match": "value",
                    "--policy-name": "value",
                    "--priority": "value",
                    "--region": "dynamic"
                  }
                },
                "upload-route-policy": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--policy-name": "value",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "routes": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--destination-range": "value",
                    "--network": "value",
                    "--next-hop-address": "value",
                    "--next-hop-gateway": "dynamic",
                    "--next-hop-ilb": "value",
                    "--next-hop-ilb-region": "value",
                    "--next-hop-instance": "value",
                    "--next-hop-instance-zone": "value",
                    "--next-hop-vpn-tunnel": "value",
                    "--next-hop-vpn-tunnel-region": "value",
                    "--priority": "value",
                    "--tags": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "scp": {
              "commands": {},
              "flags": {
                "--compress": "bool",
                "--dest-group": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--network": "value",
                "--plain": "bool",
                "--port": "value",
                "--recurse": "bool",
                "--region": "value",
                "--scp-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--tunnel-through-iap": "bool",
                "--zone": "value"
              }
            },
            "security-policies": {
              "commands": {
                "add-layer7-ddos-defense-threshold-config": {
                  "commands": {},
                  "flags": {
                    "--auto-deploy-confidence-threshold": "value",
                    "--auto-deploy-expiration-sec": "value",
                    "--auto-deploy-impacted-baseline-threshold": "value",
                    "--auto-deploy-load-threshold": "value",
                    "--detection-absolute-qps": "value",
                    "--detection-load-threshold": "value",
                    "--detection-relative-to-baseline-qps": "value",
                    "--threshold-config-name": "value",
                    "--traffic-granularity-configs": "value"
                  }
                },
                "add-user-defined-field": {
                  "commands": {},
                  "flags": {
                    "--base": [
                      "ipv4",
                      "ipv6",
                      "tcp",
                      "udp"
                    ],
                    "--mask": "value",
                    "--offset": "value",
                    "--region": "dynamic",
                    "--size": "value",
                    "--user-defined-field-name": "value"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--type": [
                      "CLOUD_ARMOR",
                      "CLOUD_ARMOR_EDGE",
                      "CLOUD_ARMOR_INTERNAL_SERVICE",
                      "CLOUD_ARMOR_NETWORK"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--file-format": [
                      "json",
                      "yaml"
                    ],
                    "--file-name": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-preconfigured-expression-sets": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "remove-layer7-ddos-defense-threshold-config": {
                  "commands": {},
                  "flags": {
                    "--threshold-config-name": "value"
                  }
                },
                "remove-user-defined-field": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--user-defined-field-name": "value"
                  }
                },
                "rules": {
                  "commands": {
                    "add-preconfig-waf-exclusion": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--request-cookie-to-exclude": "value",
                        "--request-header-to-exclude": "value",
                        "--request-query-param-to-exclude": "value",
                        "--request-uri-to-exclude": "value",
                        "--security-policy": "dynamic",
                        "--target-rule-ids": "value",
                        "--target-rule-set": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-502",
                          "fairshare",
                          "rate-based-ban",
                          "redirect",
                          "redirect-to-recaptcha",
                          "throttle"
                        ],
                        "--ban-duration-sec": "value",
                        "--ban-threshold-count": "value",
                        "--ban-threshold-interval-sec": "value",
                        "--conform-action": [
                          "allow"
                        ],
                        "--description": "value",
                        "--enforce-on-key": [
                          "all",
                          "http-cookie",
                          "http-header",
                          "http-path",
                          "ip",
                          "region-code",
                          "sni",
                          "tls-ja3-fingerprint",
                          "tls-ja4-fingerprint",
                          "user-ip",
                          "xff-ip"
                        ],
                        "--enforce-on-key-configs": "value",
                        "--enforce-on-key-name": "value",
                        "--exceed-action": [
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-429",
                          "deny-502",
                          "redirect"
                        ],
                        "--exceed-action-rpc-status-code": "value",
                        "--exceed-action-rpc-status-message": "value",
                        "--exceed-redirect-target": "value",
                        "--exceed-redirect-type": [
                          "external-302",
                          "google-recaptcha"
                        ],
                        "--expression": "value",
                        "--network-dest-ip-ranges": "value",
                        "--network-dest-ports": "value",
                        "--network-ip-protocols": "value",
                        "--network-src-asns": "value",
                        "--network-src-ip-ranges": "value",
                        "--network-src-ports": "value",
                        "--network-src-region-codes": "value",
                        "--network-user-defined-fields": "value",
                        "--preview": "bool",
                        "--rate-limit-threshold-count": "value",
                        "--rate-limit-threshold-interval-sec": "value",
                        "--recaptcha-action-site-keys": "value",
                        "--recaptcha-session-site-keys": "value",
                        "--redirect-target": "value",
                        "--redirect-type": [
                          "external-302",
                          "google-recaptcha"
                        ],
                        "--region": "dynamic",
                        "--request-headers-to-add": "value",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--security-policy": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--security-policy": "dynamic"
                      }
                    },
                    "remove-preconfig-waf-exclusion": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic",
                        "--request-cookie-to-exclude": "value",
                        "--request-header-to-exclude": "value",
                        "--request-query-param-to-exclude": "value",
                        "--request-uri-to-exclude": "value",
                        "--security-policy": "dynamic",
                        "--target-rule-ids": "value",
                        "--target-rule-set": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--action": [
                          "allow",
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-502",
                          "fairshare",
                          "rate-based-ban",
                          "redirect",
                          "redirect-to-recaptcha",
                          "throttle"
                        ],
                        "--ban-duration-sec": "value",
                        "--ban-threshold-count": "value",
                        "--ban-threshold-interval-sec": "value",
                        "--conform-action": [
                          "allow"
                        ],
                        "--description": "value",
                        "--enforce-on-key": [
                          "all",
                          "http-cookie",
                          "http-header",
                          "http-path",
                          "ip",
                          "region-code",
                          "sni",
                          "tls-ja3-fingerprint",
                          "tls-ja4-fingerprint",
                          "user-ip",
                          "xff-ip"
                        ],
                        "--enforce-on-key-configs": "value",
                        "--enforce-on-key-name": "value",
                        "--exceed-action": [
                          "deny",
                          "deny-403",
                          "deny-404",
                          "deny-429",
                          "deny-502",
                          "redirect"
                        ],
                        "--exceed-action-rpc-status-code": "value",
                        "--exceed-action-rpc-status-message": "value",
                        "--exceed-redirect-target": "value",
                        "--exceed-redirect-type": [
                          "external-302",
                          "google-recaptcha"
                        ],
                        "--expression": "value",
                        "--network-dest-ip-ranges": "value",
                        "--network-dest-ports": "value",
                        "--network-ip-protocols": "value",
                        "--network-src-asns": "value",
                        "--network-src-ip-ranges": "value",
                        "--network-src-ports": "value",
                        "--network-src-region-codes": "value",
                        "--network-user-defined-fields": "value",
                        "--preview": "bool",
                        "--rate-limit-threshold-count": "value",
                        "--rate-limit-threshold-interval-sec": "value",
                        "--recaptcha-action-site-keys": "value",
                        "--recaptcha-session-site-keys": "value",
                        "--redirect-target": "value",
                        "--redirect-type": [
                          "external-302",
                          "google-recaptcha"
                        ],
                        "--region": "dynamic",
                        "--request-headers-to-add": "value",
                        "--security-policy": "dynamic",
                        "--src-ip-ranges": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--ddos-protection": [
                      "ADVANCED",
                      "ADVANCED_PREVIEW",
                      "STANDARD"
                    ],
                    "--description": "value",
                    "--enable-layer7-ddos-defense": "bool",
                    "--enable-ml": "bool",
                    "--global": "bool",
                    "--json-custom-content-types": "value",
                    "--json-parsing": [
                      "DISABLED",
                      "STANDARD",
                      "STANDARD_WITH_GRAPHQL"
                    ],
                    "--layer7-ddos-defense-auto-deploy-confidence-threshold": "value",
                    "--layer7-ddos-defense-auto-deploy-expiration-sec": "value",
                    "--layer7-ddos-defense-auto-deploy-impacted-baseline-threshold": "value",
                    "--layer7-ddos-defense-auto-deploy-load-threshold": "value",
                    "--layer7-ddos-defense-rule-visibility": [
                      "PREMIUM",
                      "STANDARD"
                    ],
                    "--log-level": [
                      "NORMAL",
                      "VERBOSE"
                    ],
                    "--network-ddos-protection": [
                      "ADVANCED",
                      "ADVANCED_PREVIEW",
                      "STANDARD"
                    ],
                    "--recaptcha-redirect-site-key": "value",
                    "--region": "dynamic",
                    "--request-body-inspection-size": [
                      "128KB",
                      "8KB"
                    ],
                    "--user-ip-request-headers": "value"
                  }
                }
              },
              "flags": {}
            },
            "service-attachments": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--connection-preference": [
                      "ACCEPT_AUTOMATIC",
                      "ACCEPT_MANUAL"
                    ],
                    "--consumer-accept-list": "value",
                    "--consumer-reject-list": "value",
                    "--description": "value",
                    "--domain-names": "value",
                    "--enable-proxy-protocol": "bool",
                    "--nat-subnets": "dynamic",
                    "--nat-subnets-region": "dynamic",
                    "--producer-forwarding-rule": "dynamic",
                    "--producer-forwarding-rule-region": "dynamic",
                    "--propagated-connection-limit": "value",
                    "--reconcile-connections": "bool",
                    "--region": "dynamic",
                    "--target-service": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--show-nat-ips": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--connection-preference": [
                      "ACCEPT_AUTOMATIC",
                      "ACCEPT_MANUAL"
                    ],
                    "--consumer-accept-list": "value",
                    "--consumer-reject-list": "value",
                    "--description": "value",
                    "--enable-proxy-protocol": "bool",
                    "--nat-subnets": "dynamic",
                    "--nat-subnets-region": "dynamic",
                    "--propagated-connection-limit": "value",
                    "--reconcile-connections": "bool",
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "shared-vpc": {
              "commands": {
                "associated-projects": {
                  "commands": {
                    "add": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove": {
                      "commands": {},
                      "flags": {
                        "--host-project": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "disable": {
                  "commands": {},
                  "flags": {}
                },
                "enable": {
                  "commands": {},
                  "flags": {}
                },
                "get-host-project": {
                  "commands": {},
                  "flags": {}
                },
                "list-associated-resources": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "organizations": {
                  "commands": {
                    "list-host-projects": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "sign-url": {
              "commands": {},
              "flags": {
                "--expires-in": "value",
                "--key-file": "value",
                "--key-name": "value",
                "--validate": "bool"
              }
            },
            "snapshot-settings": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--access-location-policy": "value",
                    "--add-access-locations": "value",
                    "--async": "bool",
                    "--region": "dynamic",
                    "--remove-access-locations": "value",
                    "--storage-location-names": "value",
                    "--storage-location-policy": "value"
                  }
                }
              },
              "flags": {}
            },
            "snapshots": {
              "commands": {
                "add-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "add-labels": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--labels": "value",
                    "--region": "dynamic"
                  }
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--chain-name": "value",
                    "--csek-key-file": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--guest-flush": "bool",
                    "--kms-key": "dynamic",
                    "--kms-keyring": "dynamic",
                    "--kms-location": "dynamic",
                    "--kms-project": "dynamic",
                    "--labels": "value",
                    "--max-retention-days": "value",
                    "--region": "dynamic",
                    "--snapshot-type": [
                      "ARCHIVE",
                      "STANDARD"
                    ],
                    "--source-disk": "dynamic",
                    "--source-disk-for-recovery-checkpoint": "dynamic",
                    "--source-disk-for-recovery-checkpoint-region": "dynamic",
                    "--source-disk-key-file": "value",
                    "--source-disk-region": "dynamic",
                    "--source-disk-zone": "dynamic",
                    "--source-instant-snapshot": "dynamic",
                    "--source-instant-snapshot-key-file": "value",
                    "--source-instant-snapshot-region": "dynamic",
                    "--source-instant-snapshot-zone": "dynamic",
                    "--storage-location": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-iam-policy-binding": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--condition": "value",
                    "--condition-from-file": "value",
                    "--member": "value",
                    "--role": "dynamic"
                  }
                },
                "remove-labels": {
                  "commands": {},
                  "flags": {
                    "--all": "bool",
                    "--global": "bool",
                    "--labels": "value",
                    "--region": "dynamic"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {}
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--global": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "sole-tenancy": {
              "commands": {
                "node-groups": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--description": "value",
                        "--maintenance-interval": [
                          "as-needed",
                          "recurrent"
                        ],
                        "--maintenance-policy": [
                          "default",
                          "migrate-within-node-group",
                          "restart-in-place"
                        ],
                        "--maintenance-window-start-time": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--share-setting": [
                          "local",
                          "organization",
                          "projects"
                        ],
                        "--share-with": "value",
                        "--target-size": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--share-settings": "bool",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "list-nodes": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "perform-maintenance": {
                      "commands": {},
                      "flags": {
                        "--nodes": "value",
                        "--start-time": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--role": "dynamic",
                        "--zone": "value"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "simulate-maintenance-event": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--nodes": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-nodes": "value",
                        "--autoscaler-mode": [
                          "off",
                          "on",
                          "only-scale-out"
                        ],
                        "--delete-nodes": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-template": "value",
                        "--share-setting": [
                          "local",
                          "organization",
                          "projects"
                        ],
                        "--share-with": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-templates": {
                  "commands": {
                    "add-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator": "value",
                        "--cpu-overcommit-type": [
                          "enabled",
                          "none"
                        ],
                        "--description": "value",
                        "--disk": "value",
                        "--node-affinity-labels": "value",
                        "--node-requirements": "value",
                        "--node-type": "value",
                        "--region": "dynamic",
                        "--server-binding": [
                          "restart-node-on-any-server",
                          "restart-node-on-minimal-servers"
                        ]
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--region": "dynamic"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--region": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "remove-iam-policy-binding": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--condition": "value",
                        "--condition-from-file": "value",
                        "--member": "value",
                        "--region": "value",
                        "--role": "dynamic"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--region": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "node-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "ssh": {
              "commands": {},
              "flags": {
                "--command": "value",
                "--container": "value",
                "--dest-group": "value",
                "--dry-run": "bool",
                "--force-key-file-overwrite": "bool",
                "--internal-ip": "bool",
                "--network": "value",
                "--plain": "bool",
                "--region": "value",
                "--ssh-flag": "value",
                "--ssh-key-expiration": "value",
                "--ssh-key-expire-after": "value",
                "--ssh-key-file": "value",
                "--strict-host-key-checking": [
                  "ask",
                  "no",
                  "yes"
                ],
                "--troubleshoot": "bool",
                "--tunnel-through-iap": "bool",
                "--zone": "dynamic"
              }
            },
            "ssl-certificates": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate": "value",
                    "--description": "value",
                    "--domains": "value",
                    "--global": "bool",
                    "--private-key": "value",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "ssl-policies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ],
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-available-features": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--region": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--custom-features": "value",
                    "--global": "bool",
                    "--min-tls-version": [
                      "1.0",
                      "1.1",
                      "1.2"
                    ],
                    "--profile": [
                      "COMPATIBLE",
                      "CUSTOM",
                      "MODERN",
                      "RESTRICTED"
                    ],
                    "--region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "start-iap-tunnel": {
              "commands": {},
              "flags": {
                "--dest-group": "value",
                "--iap-tunnel-disable-connection-check": "bool",
                "--local-host-port": "value",
                "--network": "value",
                "--region": "value",
                "--zone": "dynamic"
              }
            },
            "storage-pool-types": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                }
              },
              "flags": {}
            },
            "storage-pools": {
              "commands": {
                "create": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--capacity-provisioning-type": [
                      "advanced",
                      "standard"
                    ],
                    "--description": "value",
                    "--performance-provisioning-type": [
                      "advanced",
                      "standard"
                    ],
                    "--provisioned-capacity": "value",
                    "--provisioned-iops": "value",
                    "--provisioned-throughput": "value",
                    "--storage-pool-type": "value",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "get-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--zone": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value"
                  }
                },
                "list-disks": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "set-iam-policy": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--description": "value",
                    "--provisioned-capacity": "value",
                    "--provisioned-iops": "value",
                    "--provisioned-throughput": "value",
                    "--zone": "value"
                  }
                }
              },
              "flags": {}
            },
            "target-grpc-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global-url-map": "bool",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic",
                    "--validate-for-proxyless": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            },
            "target-http-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--http-keep-alive-timeout-sec": "value",
                    "--proxy-bind": "bool",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-http-keep-alive-timeout-sec": "bool",
                    "--global": "bool",
                    "--global-url-map": "bool",
                    "--http-keep-alive-timeout-sec": "value",
                    "--region": "dynamic",
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-https-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--certificate-manager-certificates": "dynamic",
                    "--certificate-map": "dynamic",
                    "--description": "value",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-ssl-policy": "bool",
                    "--global-url-map": "bool",
                    "--http-keep-alive-timeout-sec": "value",
                    "--proxy-bind": "bool",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--server-tls-policy": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--ssl-policy-region": "dynamic",
                    "--tls-early-data": [
                      "DISABLED",
                      "PERMISSIVE",
                      "STRICT"
                    ],
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--certificate-manager-certificates": "dynamic",
                    "--certificate-map": "dynamic",
                    "--clear-certificate-map": "bool",
                    "--clear-http-keep-alive-timeout-sec": "bool",
                    "--clear-server-tls-policy": "bool",
                    "--clear-ssl-certificates": "bool",
                    "--clear-ssl-policy": "bool",
                    "--global": "bool",
                    "--global-ssl-certificates": "bool",
                    "--global-ssl-policy": "bool",
                    "--global-url-map": "bool",
                    "--http-keep-alive-timeout-sec": "value",
                    "--quic-override": [
                      "DISABLE",
                      "ENABLE",
                      "NONE"
                    ],
                    "--region": "dynamic",
                    "--server-tls-policy": "dynamic",
                    "--ssl-certificates": "dynamic",
                    "--ssl-certificates-region": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--ssl-policy-region": "dynamic",
                    "--tls-early-data": [
                      "DISABLED",
                      "PERMISSIVE",
                      "STRICT"
                    ],
                    "--url-map": "dynamic",
                    "--url-map-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-instances": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ],
                        "--zone": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--instance": "dynamic",
                    "--instance-zone": "dynamic",
                    "--network": "value",
                    "--zone": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zones": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--security-policy": "dynamic",
                    "--security-policy-region": "dynamic",
                    "--zone": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-pools": {
              "commands": {
                "add-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "add-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "value",
                    "--description": "value",
                    "--failover-ratio": "value",
                    "--health-check": "value",
                    "--http-health-check": "dynamic",
                    "--region": "dynamic",
                    "--session-affinity": [
                      "CLIENT_IP",
                      "CLIENT_IP_PROTO",
                      "NONE"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-health": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "remove-health-checks": {
                  "commands": {},
                  "flags": {
                    "--http-health-check": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "remove-instances": {
                  "commands": {},
                  "flags": {
                    "--instances": "dynamic",
                    "--instances-zone": "dynamic",
                    "--region": "dynamic",
                    "--zone": "dynamic"
                  }
                },
                "set-backup": {
                  "commands": {},
                  "flags": {
                    "--backup-pool": "dynamic",
                    "--failover-ratio": "value",
                    "--no-backup-pool": "bool",
                    "--region": "dynamic"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic",
                    "--security-policy": "dynamic",
                    "--security-policy-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-ssl-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--certificate-map": "dynamic",
                    "--description": "value",
                    "--global-ssl-policy": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--ssl-policy-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--certificate-map": "dynamic",
                    "--clear-certificate-map": "bool",
                    "--clear-ssl-certificates": "bool",
                    "--clear-ssl-policy": "bool",
                    "--global-ssl-policy": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--ssl-certificates": "dynamic",
                    "--ssl-policy": "dynamic",
                    "--ssl-policy-region": "dynamic"
                  }
                }
              },
              "flags": {}
            },
            "target-tcp-proxies": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--backend-service-region": "dynamic",
                    "--description": "value",
                    "--global": "bool",
                    "--global-backend-service": "bool",
                    "--proxy-bind": "bool",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ],
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--backend-service": "dynamic",
                    "--proxy-header": [
                      "NONE",
                      "PROXY_V1"
                    ]
                  }
                }
              },
              "flags": {}
            },
            "target-vpn-gateways": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--network": "dynamic",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "tpus": {
              "commands": {
                "accelerator-types": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--accelerator-type": "value",
                    "--async": "bool",
                    "--description": "value",
                    "--model-base-path": "value",
                    "--model-config-file": "value",
                    "--model-name": "value",
                    "--network": "value",
                    "--platform-config-file": "value",
                    "--preemptible": "bool",
                    "--range": "value",
                    "--reserved": "bool",
                    "--use-service-networking": "bool",
                    "--zone": "value"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--zone": "value"
                  }
                },
                "execution-groups": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--disk-size": "value",
                        "--dry-run": "bool",
                        "--forward-ports": "bool",
                        "--gce-image": "value",
                        "--machine-type": "value",
                        "--name": "value",
                        "--network": "value",
                        "--preemptible": "bool",
                        "--preemptible-vm": "bool",
                        "--tf-version": "value",
                        "--tpu-only": "bool",
                        "--use-dl-images": "bool",
                        "--use-with-notebook": "bool",
                        "--vm-only": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--tpu-only": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "resume": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--network": "value",
                        "--preemptible": "bool",
                        "--tf-version": "value",
                        "--vm-only": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "suspend": {
                      "commands": {},
                      "flags": {
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--sort-by": "value",
                    "--uri": "bool",
                    "--zone": "dynamic"
                  }
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "queued-resources": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--async": "bool",
                        "--autocheckpoint-enabled": "bool",
                        "--best-effort": "bool",
                        "--boot-disk": "value",
                        "--data-disk": "value",
                        "--description": "value",
                        "--guaranteed": "bool",
                        "--internal-ips": "bool",
                        "--labels": "value",
                        "--max-run-duration": "value",
                        "--metadata": "value",
                        "--metadata-from-file": "value",
                        "--network": "value",
                        "--network-config": "value",
                        "--node-count": "value",
                        "--node-id": "value",
                        "--node-prefix": "value",
                        "--provisioning-model": "value",
                        "--range": "value",
                        "--reservation": "value",
                        "--reservation-host-folder": "value",
                        "--reservation-host-organization": "value",
                        "--reservation-host-project": "value",
                        "--reserved": "bool",
                        "--runtime-version": "value",
                        "--scopes": "value",
                        "--service-account": "value",
                        "--shielded-secure-boot": "bool",
                        "--spot": "bool",
                        "--subnetwork": "value",
                        "--tags": "value",
                        "--topology": "value",
                        "--type": [
                          "v2",
                          "v3",
                          "v4",
                          "v5litepod",
                          "v5p",
                          "v6e"
                        ],
                        "--valid-after-duration": "value",
                        "--valid-after-time": "value",
                        "--valid-until-duration": "value",
                        "--valid-until-time": "value",
                        "--workload-type": "value",
                        "--zone": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--force": "bool",
                        "--zone": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "perform-maintenance": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--node-names": "value",
                        "--zone": "value"
                      }
                    },
                    "reset": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "scp": {
                      "commands": {},
                      "flags": {
                        "--batch-size": "value",
                        "--compress": "bool",
                        "--dry-run": "bool",
                        "--force-key-file-overwrite": "bool",
                        "--internal-ip": "bool",
                        "--node": "value",
                        "--plain": "bool",
                        "--recurse": "bool",
                        "--scp-flag": "value",
                        "--ssh-key-expiration": "value",
                        "--ssh-key-expire-after": "value",
                        "--ssh-key-file": "value",
                        "--strict-host-key-checking": [
                          "ask",
                          "no",
                          "yes"
                        ],
                        "--tunnel-through-iap": "bool",
                        "--worker": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "ssh": {
                      "commands": {},
                      "flags": {
                        "--batch-size": "value",
                        "--command": "value",
                        "--dry-run": "bool",
                        "--force-key-file-overwrite": "bool",
                        "--internal-ip": "bool",
                        "--node": "value",
                        "--output-directory": "value",
                        "--plain": "bool",
                        "--ssh-flag": "value",
                        "--ssh-key-expiration": "value",
                        "--ssh-key-expire-after": "value",
                        "--ssh-key-file": "value",
                        "--strict-host-key-checking": [
                          "ask",
                          "no",
                          "yes"
                        ],
                        "--tunnel-through-iap": "bool",
                        "--worker": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "reimage": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "reservations": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "start": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "stop": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--zone": "value"
                  }
                },
                "topologies": {
                  "commands": {
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                },
                "tpu-vm": {
                  "commands": {
                    "accelerator-types": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--zone": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "attach-disk": {
                      "commands": {},
                      "flags": {
                        "--disk": "value",
                        "--mode": [
                          "read-only",
                          "read-write"
                        ],
                        "--zone": "value"
                      }
                    },
                    "create": {
                      "commands": {},
                      "flags": {
                        "--accelerator-type": "value",
                        "--async": "bool",
                        "--autocheckpoint-enabled": "bool",
                        "--boot-disk": "value",
                        "--data-disk": "value",
                        "--description": "value",
                        "--internal-ips": "bool",
                        "--labels": "value",
                        "--metadata": "value",
                        "--metadata-from-file": "value",
                        "--network": "value",
                        "--preemptible": "bool",
                        "--provisioning-model": "value",
                        "--queue-count": "value",
                        "--range": "value",
                        "--reservation": "value",
                        "--reserved": "bool",
                        "--scopes": "value",
                        "--service-account": "value",
                        "--shielded-secure-boot": "bool",
                        "--spot": "bool",
                        "--subnetwork": "value",
                        "--tags": "value",
                        "--topology": "value",
                        "--type": [
                          "v2",
                          "v3",
                          "v4",
                          "v5litepod",
                          "v5p",
                          "v6e"
                        ],
                        "--zone": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "detach-disk": {
                      "commands": {},
                      "flags": {
                        "--disk": "value",
                        "--zone": "value"
                      }
                    },
                    "get-guest-attributes": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--query-path": "value",
                        "--sort-by": "value",
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool",
                        "--zone": "dynamic"
                      }
                    },
                    "perform-maintenance": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "scp": {
                      "commands": {},
                      "flags": {
                        "--batch-size": "value",
                        "--compress": "bool",
                        "--dry-run": "bool",
                        "--force-key-file-overwrite": "bool",
                        "--internal-ip": "bool",
                        "--plain": "bool",
                        "--recurse": "bool",
                        "--scp-flag": "value",
                        "--ssh-key-expiration": "value",
                        "--ssh-key-expire-after": "value",
                        "--ssh-key-file": "value",
                        "--strict-host-key-checking": [
                          "ask",
                          "no",
                          "yes"
                        ],
                        "--tunnel-through-iap": "bool",
                        "--worker": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "service-identity": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "simulate-maintenance-event": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--workers": "value",
                        "--zone": "value"
                      }
                    },
                    "ssh": {
                      "commands": {},
                      "flags": {
                        "--batch-size": "value",
                        "--command": "value",
                        "--dry-run": "bool",
                        "--force-key-file-overwrite": "bool",
                        "--internal-ip": "bool",
                        "--output-directory": "value",
                        "--plain": "bool",
                        "--ssh-flag": "value",
                        "--ssh-key-expiration": "value",
                        "--ssh-key-expire-after": "value",
                        "--ssh-key-file": "value",
                        "--strict-host-key-checking": [
                          "ask",
                          "no",
                          "yes"
                        ],
                        "--tunnel-through-iap": "bool",
                        "--worker": "value",
                        "--zone": "dynamic"
                      }
                    },
                    "start": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "stop": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--zone": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--add-tags": "value",
                        "--async": "bool",
                        "--attach-disk": "value",
                        "--clear-labels": "bool",
                        "--clear-metadata": "bool",
                        "--clear-tags": "bool",
                        "--description": "value",
                        "--detach-disk": "value",
                        "--internal-ips": "bool",
                        "--metadata-from-file": "value",
                        "--remove-labels": "value",
                        "--remove-metadata": "value",
                        "--remove-tags": "value",
                        "--update-labels": "value",
                        "--update-metadata": "value",
                        "--worker": "value",
                        "--zone": "value"
                      }
                    },
                    "versions": {
                      "commands": {
                        "describe": {
                          "commands": {},
                          "flags": {
                            "--zone": "value"
                          }
                        },
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--zone": "dynamic"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                },
                "versions": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--zone": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--zone": "dynamic"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "url-maps": {
              "commands": {
                "add-host-rule": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--global": "bool",
                    "--hosts": "value",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "add-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--backend-bucket-path-rules": "value",
                    "--backend-service-path-rules": "value",
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--delete-orphaned-path-matcher": "bool",
                    "--description": "value",
                    "--existing-host": "value",
                    "--global": "bool",
                    "--new-hosts": "value",
                    "--path-matcher-name": "value",
                    "--path-rules": "value",
                    "--region": "dynamic"
                  }
                },
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--global": "bool",
                        "--path": "value",
                        "--region": "dynamic",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--description": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "edit": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "export": {
                  "commands": {},
                  "flags": {
                    "--destination": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "import": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--region": "dynamic",
                    "--source": "value"
                  }
                },
                "invalidate-cdn-cache": {
                  "commands": {},
                  "flags": {
                    "--async": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--path": "value",
                    "--tags": "value"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--global": "bool",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "list-cdn-cache-invalidations": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--limit": "value"
                  }
                },
                "remove-host-rule": {
                  "commands": {},
                  "flags": {
                    "--delete-orphaned-path-matcher": "bool",
                    "--global": "bool",
                    "--host": "value",
                    "--region": "dynamic"
                  }
                },
                "remove-path-matcher": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--path-matcher-name": "value",
                    "--region": "dynamic"
                  }
                },
                "set-default-service": {
                  "commands": {},
                  "flags": {
                    "--default-backend-bucket": "value",
                    "--default-service": "value",
                    "--global": "bool",
                    "--region": "dynamic"
                  }
                },
                "validate": {
                  "commands": {},
                  "flags": {
                    "--global": "bool",
                    "--load-balancing-scheme": [
                      "EXTERNAL",
                      "EXTERNAL_MANAGED"
                    ],
                    "--region": "value",
                    "--source": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpn-gateways": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--gateway-ip-version": [
                      "IPV4",
                      "IPV6"
                    ],
                    "--interconnect-attachments": "value",
                    "--network": "dynamic",
                    "--region": "dynamic",
                    "--stack-type": [
                      "IPV4_IPV6",
                      "IPV4_ONLY",
                      "IPV6_ONLY"
                    ]
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "get-status": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "vpn-tunnels": {
              "commands": {
                "config": {
                  "commands": {
                    "export": {
                      "commands": {},
                      "flags": {
                        "--all": "bool",
                        "--path": "value",
                        "--region": "value",
                        "--resource-format": [
                          "krm",
                          "terraform"
                        ]
                      }
                    }
                  },
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--description": "value",
                    "--ike-version": [
                      1,
                      2
                    ],
                    "--interface": [
                      0,
                      1
                    ],
                    "--local-traffic-selector": "value",
                    "--peer-address": "value",
                    "--peer-external-gateway": "dynamic",
                    "--peer-external-gateway-interface": [
                      0,
                      1,
                      2,
                      3
                    ],
                    "--peer-gcp-gateway": "dynamic",
                    "--peer-gcp-gateway-region": "dynamic",
                    "--phase1-dh": "value",
                    "--phase1-encryption": "value",
                    "--phase1-integrity": "value",
                    "--phase1-prf": "value",
                    "--phase2-encryption": "value",
                    "--phase2-integrity": "value",
                    "--phase2-pfs": "value",
                    "--region": "dynamic",
                    "--remote-traffic-selector": "value",
                    "--router": "dynamic",
                    "--router-region": "dynamic",
                    "--shared-secret": "value",
                    "--target-vpn-gateway": "dynamic",
                    "--target-vpn-gateway-region": "dynamic",
                    "--vpn-gateway": "dynamic",
                    "--vpn-gateway-region": "dynamic"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--region": "dynamic"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--regions": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                },
                "update": {
                  "commands": {},
                  "flags": {
                    "--clear-labels": "bool",
                    "--region": "dynamic",
                    "--remove-labels": "value",
                    "--update-labels": "value"
                  }
                }
              },
              "flags": {}
            },
            "zones": {
              "commands": {
                "describe": {
                  "commands": {},
                  "flags": {}
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--page-size": "value",
                    "--regexp": "value",
                    "--sort-by": "value",
                    "--uri": "bool"
                  }
                }
              },
              "flags": {}
            }
          },
          "flags": {}
        },
        "config": {
          "commands": {
            "configurations": {
              "commands": {
                "activate": {
                  "commands": {},
                  "flags": {}
                },
                "create": {
                  "commands": {},
                  "flags": {
                    "--activate": "bool"
                  }
                },
                "delete": {
                  "commands": {},
                  "flags": {}
                },
                "describe": {
                  "commands": {},
                  "flags": {
                    "--all": "bool"
                  }
                },
                "list": {
                  "commands": {},
                  "flags": {
                    "--filter": "value",
                    "--limit": "value",
                    "--sort-by": "value"
                  }
                },
                "rename": {
                  "commands": {},
                  "flags": {
                    "--new-name": "value"
                  }
                }
              },
              "flags": {}
            },
            "get": {
              "commands": {},
              "flags": {}
            },
            "list": {
              "commands": {},
              "flags": {
                "--all": "bool",
                "--filter": "value",
                "--limit": "value",
                "--sort-by": "value"
              }
            },
            "set": {
              "commands": {},
              "flags": {
                "--installation": "bool"
              }
            },
            "unset": {
              "commands": {},
              "flags": {
                "--installation": "bool"
              }
            }
          },
          "flags": {}
        },
        "container": {
          "commands": {
            "ai": {
              "commands": {
                "recommender": {
                  "commands": {
                    "accelerators": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--max-ntpot-milliseconds": "value",
                            "--model": "value",
                            "--model-server": "value",
                            "--model-server-version": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "manifests": {
                      "commands": {
                        "create": {
                          "commands": {},
                          "flags": {
                            "--accelerator-type": "value",
                            "--model": "value",
                            "--model-server": "value",
                            "--model-server-version": "value",
                            "--namespace": "value",
                            "--output": [
                              "all",
                              "comments",
                              "manifest"
                            ],
                            "--output-path": "value",
                            "--target-ntpot-milliseconds": "value"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "model-and-server-combinations": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--model": "value",
                            "--model-server": "value",
                            "--model-server-version": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "model-server-versions": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--model": "value",
                            "--model-server": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "model-servers": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--model": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    },
                    "models": {
                      "commands": {
                        "list": {
                          "commands": {},
                          "flags": {
                            "--filter": "value",
                            "--limit": "value",
                            "--page-size": "value",
                            "--sort-by": "value",
                            "--uri": "bool"
                          }
                        }
                      },
                      "flags": {}
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "attached": {
              "commands": {
                "clusters": {
                  "commands": {
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--ignore-errors": "bool",
                        "--location": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "generate-install-manifest": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--output-file": "value",
                        "--platform-version": "value",
                        "--proxy-secret-name": "value",
                        "--proxy-secret-namespace": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "import": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--context": "value",
                        "--distribution": "value",
                        "--fleet-membership": "value",
                        "--fleet-membership-location": "value",
                        "--kubeconfig": "value",
                        "--location": "value",
                        "--platform-version": "value",
                        "--proxy-secret-name": "value",
                        "--proxy-secret-namespace": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "register": {
                      "commands": {},
                      "flags": {
                        "--admin-groups": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--context": "value",
                        "--description": "value",
                        "--disable-cloud-monitoring": "bool",
                        "--distribution": "value",
                        "--enable-cloud-monitoring": "bool",
                        "--enable-managed-prometheus": "bool",
                        "--fleet-project": "value",
                        "--has-private-issuer": "bool",
                        "--issuer-url": "value",
                        "--kubeconfig": "value",
                        "--location": "value",
                        "--logging": "value",
                        "--platform-version": "value",
                        "--proxy-secret-name": "value",
                        "--proxy-secret-namespace": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--admin-groups": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--async": "bool",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--clear-admin-groups": "bool",
                        "--clear-admin-users": "bool",
                        "--clear-description": "bool",
                        "--description": "value",
                        "--disable-cloud-monitoring": "bool",
                        "--disable-managed-prometheus": "bool",
                        "--enable-cloud-monitoring": "bool",
                        "--enable-managed-prometheus": "bool",
                        "--location": "value",
                        "--logging": "value",
                        "--platform-version": "value",
                        "--proxy-secret-name": "value",
                        "--proxy-secret-namespace": "value",
                        "--validate-only": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-server-config": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "aws": {
              "commands": {
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-groups": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--async": "bool",
                        "--aws-region": "value",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--cluster-version": "value",
                        "--config-encryption-kms-key-arn": "value",
                        "--database-encryption-kms-key-arn": "value",
                        "--description": "value",
                        "--disable-per-node-pool-sg-rules": "bool",
                        "--enable-managed-prometheus": "bool",
                        "--fleet-project": "value",
                        "--iam-instance-profile": "value",
                        "--instance-placement": [
                          "dedicated",
                          "default",
                          "host"
                        ],
                        "--instance-type": "value",
                        "--location": "value",
                        "--logging": "value",
                        "--main-volume-iops": "value",
                        "--main-volume-kms-key-arn": "value",
                        "--main-volume-size": "value",
                        "--main-volume-throughput": "value",
                        "--main-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--pod-address-cidr-blocks": "value",
                        "--proxy-secret-arn": "value",
                        "--proxy-secret-version-id": "value",
                        "--role-arn": "value",
                        "--role-session-name": "value",
                        "--root-volume-iops": "value",
                        "--root-volume-kms-key-arn": "value",
                        "--root-volume-size": "value",
                        "--root-volume-throughput": "value",
                        "--root-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--security-group-ids": "value",
                        "--service-address-cidr-blocks": "value",
                        "--ssh-ec2-key-pair": "value",
                        "--subnet-ids": "value",
                        "--tags": "value",
                        "--validate-only": "bool",
                        "--vpc-id": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--ignore-errors": "bool",
                        "--location": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--private-endpoint": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--admin-groups": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--async": "bool",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--clear-annotations": "bool",
                        "--clear-description": "bool",
                        "--clear-proxy-config": "bool",
                        "--clear-security-group-ids": "bool",
                        "--clear-ssh-ec2-key-pair": "bool",
                        "--clear-tags": "bool",
                        "--cluster-version": "value",
                        "--config-encryption-kms-key-arn": "value",
                        "--description": "value",
                        "--disable-managed-prometheus": "bool",
                        "--disable-per-node-pool-sg-rules": "bool",
                        "--enable-managed-prometheus": "bool",
                        "--enable-per-node-pool-sg-rules": "bool",
                        "--iam-instance-profile": "value",
                        "--instance-type": "value",
                        "--location": "value",
                        "--logging": "value",
                        "--proxy-secret-arn": "value",
                        "--proxy-secret-version-id": "value",
                        "--role-arn": "value",
                        "--role-session-name": "value",
                        "--root-volume-iops": "value",
                        "--root-volume-kms-key-arn": "value",
                        "--root-volume-size": "value",
                        "--root-volume-throughput": "value",
                        "--root-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--security-group-ids": "value",
                        "--ssh-ec2-key-pair": "value",
                        "--tags": "value",
                        "--validate-only": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-server-config": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "node-pools": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--annotations": "value",
                        "--async": "bool",
                        "--autoscaling-metrics": "value",
                        "--autoscaling-metrics-granularity": "value",
                        "--cluster": "value",
                        "--config-encryption-kms-key-arn": "value",
                        "--enable-autorepair": "bool",
                        "--iam-instance-profile": "value",
                        "--image-type": "value",
                        "--instance-placement": [
                          "dedicated",
                          "default",
                          "host"
                        ],
                        "--instance-type": "value",
                        "--kubelet-config-cpu-cfs-quota": "value",
                        "--kubelet-config-cpu-cfs-quota-period": "value",
                        "--kubelet-config-cpu-manager-policy": [
                          "none",
                          "static"
                        ],
                        "--kubelet-config-pod-pids-limit": "value",
                        "--location": "value",
                        "--max-nodes": "value",
                        "--max-pods-per-node": "value",
                        "--max-surge-update": "value",
                        "--max-unavailable-update": "value",
                        "--min-nodes": "value",
                        "--node-labels": "value",
                        "--node-taints": "value",
                        "--node-version": "value",
                        "--proxy-secret-arn": "value",
                        "--proxy-secret-version-id": "value",
                        "--root-volume-iops": "value",
                        "--root-volume-kms-key-arn": "value",
                        "--root-volume-size": "value",
                        "--root-volume-throughput": "value",
                        "--root-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--security-group-ids": "value",
                        "--spot-instance-types": "value",
                        "--ssh-ec2-key-pair": "value",
                        "--subnet-id": "value",
                        "--tags": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--cluster": "value",
                        "--ignore-errors": "bool",
                        "--location": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "rollback": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--cluster": "value",
                        "--location": "value",
                        "--respect-pdb": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--annotations": "value",
                        "--async": "bool",
                        "--autoscaling-metrics": "value",
                        "--autoscaling-metrics-granularity": "value",
                        "--clear-annotations": "bool",
                        "--clear-autoscaling-metrics": "bool",
                        "--clear-node-labels": "bool",
                        "--clear-proxy-config": "bool",
                        "--clear-security-group-ids": "bool",
                        "--clear-ssh-ec2-key-pair": "bool",
                        "--clear-tags": "bool",
                        "--cluster": "value",
                        "--config-encryption-kms-key-arn": "value",
                        "--enable-autorepair": "bool",
                        "--iam-instance-profile": "value",
                        "--instance-type": "value",
                        "--location": "value",
                        "--max-nodes": "value",
                        "--max-surge-update": "value",
                        "--max-unavailable-update": "value",
                        "--min-nodes": "value",
                        "--node-labels": "value",
                        "--node-version": "value",
                        "--proxy-secret-arn": "value",
                        "--proxy-secret-version-id": "value",
                        "--root-volume-iops": "value",
                        "--root-volume-kms-key-arn": "value",
                        "--root-volume-size": "value",
                        "--root-volume-throughput": "value",
                        "--root-volume-type": [
                          "gp2",
                          "gp3"
                        ],
                        "--security-group-ids": "value",
                        "--ssh-ec2-key-pair": "value",
                        "--tags": "value",
                        "--validate-only": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "cancel": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "azure": {
              "commands": {
                "clients": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--application-id": "value",
                        "--async": "bool",
                        "--location": "value",
                        "--tenant-id": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-public-cert": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--output-file": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-groups": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--async": "bool",
                        "--azure-application-id": "value",
                        "--azure-region": "value",
                        "--azure-tenant-id": "value",
                        "--client": "value",
                        "--cluster-version": "value",
                        "--config-encryption-key-id": "value",
                        "--config-encryption-public-key": "value",
                        "--database-encryption-key-id": "value",
                        "--description": "value",
                        "--enable-managed-prometheus": "bool",
                        "--endpoint-subnet-id": "value",
                        "--fleet-project": "value",
                        "--location": "value",
                        "--logging": "value",
                        "--main-volume-size": "value",
                        "--pod-address-cidr-blocks": "value",
                        "--proxy-resource-group-id": "value",
                        "--proxy-secret-id": "value",
                        "--replica-placements": "value",
                        "--resource-group-id": "value",
                        "--root-volume-size": "value",
                        "--service-address-cidr-blocks": "value",
                        "--service-load-balancer-subnet-id": "value",
                        "--ssh-public-key": "value",
                        "--subnet-id": "value",
                        "--tags": "value",
                        "--validate-only": "bool",
                        "--vm-size": "value",
                        "--vnet-id": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--ignore-errors": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-credentials": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--private-endpoint": "bool"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--admin-groups": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--async": "bool",
                        "--azure-application-id": "value",
                        "--azure-tenant-id": "value",
                        "--clear-annotations": "bool",
                        "--clear-client": "bool",
                        "--clear-description": "bool",
                        "--client": "value",
                        "--cluster-version": "value",
                        "--description": "value",
                        "--disable-managed-prometheus": "bool",
                        "--enable-managed-prometheus": "bool",
                        "--location": "value",
                        "--logging": "value",
                        "--ssh-public-key": "value",
                        "--validate-only": "bool",
                        "--vm-size": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "get-server-config": {
                  "commands": {},
                  "flags": {
                    "--location": "value"
                  }
                },
                "node-pools": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--annotations": "value",
                        "--async": "bool",
                        "--azure-availability-zone": "value",
                        "--cluster": "value",
                        "--config-encryption-key-id": "value",
                        "--config-encryption-public-key": "value",
                        "--enable-autorepair": "bool",
                        "--image-type": "value",
                        "--location": "value",
                        "--max-nodes": "value",
                        "--max-pods-per-node": "value",
                        "--min-nodes": "value",
                        "--node-labels": "value",
                        "--node-taints": "value",
                        "--node-version": "value",
                        "--proxy-resource-group-id": "value",
                        "--proxy-secret-id": "value",
                        "--root-volume-size": "value",
                        "--ssh-public-key": "value",
                        "--subnet-id": "value",
                        "--tags": "value",
                        "--validate-only": "bool",
                        "--vm-size": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--cluster": "value",
                        "--ignore-errors": "bool",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--cluster": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--annotations": "value",
                        "--async": "bool",
                        "--clear-annotations": "bool",
                        "--cluster": "value",
                        "--enable-autorepair": "bool",
                        "--location": "value",
                        "--max-nodes": "value",
                        "--min-nodes": "value",
                        "--node-version": "value",
                        "--ssh-public-key": "value",
                        "--validate-only": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "cancel": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "wait": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "backup-restore": {
              "commands": {
                "backup-channels": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--destination-project": "value",
                        "--labels": "value",
                        "--location": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--etag": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "backup-plan-bindings": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--backup-channel": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--backup-channel": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "backup-plans": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--backup-delete-lock-days": "value",
                        "--backup-retain-days": "value",
                        "--cluster": "value",
                        "--cron-schedule": "value",
                        "--deactivated": "bool",
                        "--description": "value",
                        "--encryption-key": "value",
                        "--exclusion-windows-file": "value",
                        "--include-secrets": "bool",
                        "--include-volume-data": "bool",
                        "--labels": "value",
                        "--location": "value",
                        "--locked": "bool",
                        "--paused": "bool",
                        "--permissive-mode": "bool",
                        "--selected-applications": "value",
                        "--selected-namespaces": "value",
                        "--target-rpo-minutes": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--backup-delete-lock-days": "value",
                        "--backup-retain-days": "value",
                        "--clear-labels": "bool",
                        "--cron-schedule": "value",
                        "--deactivated": "bool",
                        "--description": "value",
                        "--encryption-key": "value",
                        "--etag": "value",
                        "--exclusion-windows-file": "value",
                        "--include-secrets": "bool",
                        "--include-volume-data": "bool",
                        "--location": "value",
                        "--locked": "bool",
                        "--paused": "bool",
                        "--permissive-mode": "bool",
                        "--remove-labels": "value",
                        "--selected-applications": "value",
                        "--selected-namespaces": "value",
                        "--target-rpo-minutes": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "backups": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--delete-lock-days": "value",
                        "--description": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--retain-days": "value",
                        "--wait-for-completion": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "get-backup-index-download-url": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--clear-labels": "bool",
                        "--delete-lock-days": "value",
                        "--description": "value",
                        "--etag": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--retain-days": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "locations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {}
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "operations": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "restore-channels": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--description": "value",
                        "--destination-project": "value",
                        "--labels": "value",
                        "--location": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--etag": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "restore-plan-bindings": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--restore-channel": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--restore-channel": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "restore-plans": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--backup-plan": "value",
                        "--cluster": "value",
                        "--cluster-resource-conflict-policy": [
                          "use-backup-version",
                          "use-existing-version"
                        ],
                        "--cluster-resource-scope-all-group-kinds": "bool",
                        "--cluster-resource-scope-excluded-group-kinds": "value",
                        "--cluster-resource-scope-no-group-kinds": "bool",
                        "--cluster-resource-scope-selected-group-kinds": "value",
                        "--description": "value",
                        "--excluded-namespaces": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--namespaced-resource-restore-mode": [
                          "delete-and-restore",
                          "fail-on-conflict",
                          "merge-replace-on-conflict",
                          "merge-replace-volume-on-conflict",
                          "merge-skip-on-conflict"
                        ],
                        "--no-namespaces": "bool",
                        "--restore-order-file": "value",
                        "--selected-applications": "value",
                        "--selected-namespaces": "value",
                        "--substitution-rules-file": "value",
                        "--transformation-rules-file": "value",
                        "--volume-data-restore-policy": [
                          "no-volume-data-restoration",
                          "restore-volume-data-from-backup",
                          "reuse-volume-handle-from-backup"
                        ],
                        "--volume-data-restore-policy-bindings": "value"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--all-namespaces": "bool",
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--cluster-resource-conflict-policy": [
                          "use-backup-version",
                          "use-existing-version"
                        ],
                        "--cluster-resource-scope-all-group-kinds": "bool",
                        "--cluster-resource-scope-excluded-group-kinds": "value",
                        "--cluster-resource-scope-no-group-kinds": "bool",
                        "--cluster-resource-scope-selected-group-kinds": "value",
                        "--description": "value",
                        "--etag": "value",
                        "--excluded-namespaces": "value",
                        "--location": "value",
                        "--namespaced-resource-restore-mode": [
                          "delete-and-restore",
                          "fail-on-conflict",
                          "merge-replace-on-conflict",
                          "merge-replace-volume-on-conflict",
                          "merge-skip-on-conflict"
                        ],
                        "--no-namespaces": "bool",
                        "--remove-labels": "value",
                        "--restore-order-file": "value",
                        "--selected-applications": "value",
                        "--selected-namespaces": "value",
                        "--substitution-rules-file": "value",
                        "--transformation-rules-file": "value",
                        "--update-labels": "value",
                        "--volume-data-restore-policy": [
                          "no-volume-data-restoration",
                          "restore-volume-data-from-backup",
                          "reuse-volume-handle-from-backup"
                        ],
                        "--volume-data-restore-policy-bindings": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "restores": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--backup": "value",
                        "--description": "value",
                        "--filter-file": "value",
                        "--labels": "value",
                        "--location": "value",
                        "--restore-plan": "value",
                        "--volume-data-restore-policy-overrides-file": "value",
                        "--wait-for-completion": "bool"
                      }
                    },
                    "delete": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--etag": "value",
                        "--location": "value",
                        "--restore-plan": "value"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--restore-plan": "value"
                      }
                    },
                    "get-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--restore-plan": "value",
                        "--sort-by": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--restore-plan": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "set-iam-policy": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--restore-plan": "value"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--async": "bool",
                        "--clear-labels": "bool",
                        "--description": "value",
                        "--etag": "value",
                        "--location": "value",
                        "--remove-labels": "value",
                        "--restore-plan": "value",
                        "--update-labels": "value"
                      }
                    }
                  },
                  "flags": {}
                },
                "volume-backups": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--backup": "value",
                        "--backup-plan": "value",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--backup": "value",
                        "--backup-plan": "value",
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "volume-restores": {
                  "commands": {
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value",
                        "--restore": "value",
                        "--restore-plan": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--restore": "value",
                        "--restore-plan": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    }
                  },
                  "flags": {}
                }
              },
              "flags": {}
            },
            "bare-metal": {
              "commands": {
                "admin-clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--api-server-args": "value",
                        "--async": "bool",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--control-plane-load-balancer-port": "value",
                        "--control-plane-node-configs": "value",
                        "--control-plane-node-labels": "value",
                        "--control-plane-node-taints": "value",
                        "--control-plane-vip": "value",
                        "--description": "value",
                        "--enable-application-logs": "bool",
                        "--enable-manual-lb": "bool",
                        "--island-mode-pod-address-cidr-blocks": "value",
                        "--island-mode-service-address-cidr-blocks": "value",
                        "--location": "value",
                        "--login-user": "value",
                        "--lvp-node-mounts-config-path": "value",
                        "--lvp-node-mounts-config-storage-class": "value",
                        "--lvp-share-path": "value",
                        "--lvp-share-storage-class": "value",
                        "--maintenance-address-cidr-blocks": "value",
                        "--max-pods-per-node": "value",
                        "--no-proxy": "value",
                        "--shared-path-pv-count": "value",
                        "--uri": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "describe": {
                      "commands": {},
                      "flags": {
                        "--location": "value"
                      }
                    },
                    "enroll": {
                      "commands": {},
                      "flags": {
                        "--admin-cluster-membership": "value",
                        "--admin-cluster-membership-location": "value",
                        "--async": "bool",
                        "--location": "value"
                      }
                    },
                    "list": {
                      "commands": {},
                      "flags": {
                        "--filter": "value",
                        "--limit": "value",
                        "--location": "value",
                        "--page-size": "value",
                        "--sort-by": "value",
                        "--uri": "bool"
                      }
                    },
                    "query-version-config": {
                      "commands": {},
                      "flags": {
                        "--admin-cluster": "value",
                        "--location": "value"
                      }
                    },
                    "unenroll": {
                      "commands": {},
                      "flags": {
                        "--allow-missing": "bool",
                        "--async": "bool",
                        "--ignore-errors": "bool",
                        "--location": "value",
                        "--validate-only": "bool"
                      }
                    },
                    "update": {
                      "commands": {},
                      "flags": {
                        "--api-server-args": "value",
                        "--async": "bool",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--control-plane-node-configs": "value",
                        "--control-plane-node-labels": "value",
                        "--control-plane-node-taints": "value",
                        "--description": "value",
                        "--enable-application-logs": "bool",
                        "--island-mode-service-address-cidr-blocks": "value",
                        "--location": "value",
                        "--login-user": "value",
                        "--maintenance-address-cidr-blocks": "value",
                        "--max-pods-per-node": "value",
                        "--no-proxy": "value",
                        "--uri": "value",
                        "--validate-only": "bool"
                      }
                    }
                  },
                  "flags": {}
                },
                "clusters": {
                  "commands": {
                    "create": {
                      "commands": {},
                      "flags": {
                        "--admin-cluster-membership": "value",
                        "--admin-cluster-membership-location": "value",
                        "--admin-cluster-membership-project": "value",
                        "--admin-users": "value",
                        "--annotations": "value",
                        "--api-server-args": "value",
                        "--async": "bool",
                        "--bgp-address-pools": "value",
                        "--bgp-asn": "value",
                        "--bgp-load-balancer-node-configs": "value",
                        "--bgp-load-balancer-node-labels": "value",
                        "--bgp-load-balancer-node-taints": "value",
                        "--bgp-load-balancer-registry-burst": "value",
                        "--bgp-load-balancer-registry-pull-qps": "value",
                        "--bgp-peer-configs": "value",
                        "--binauthz-evaluation-mode": [
                          "DISABLED",
                          "PROJECT_SINGLETON_POLICY_ENFORCE"
                        ],
                        "--container-runtime": "value",
                        "--control-plane-load-balancer-port": "value",
                        "--control-plane-node-configs": "value",
                        "--control-plane-node-labels": "value",
                        "--control-plane-node-taints": "value",
                        "--control-plane-registry-burst": "value",
                        "--control-plane-registry-pull-qps": "value",
                        "--control-plane-vip": "value",
                        "--description": "value",
                        "--disable-bgp-load-balancer-serialize-image-pulls": "bool",
                        "--disable-control-plane-serialize-image-pulls": "bool",
                        "--disable-metal-lb-load-balancer-serialize-image-pulls": "bool",
                        "--enable-advanced-networking": "bool",
                        "--enable-application-logs": "bool",
                        "--enable-manual-lb": "bool",
                        "--enable-multi-nic-config": "bool",
                        "--enable-sr-iov-c