/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import com.google.common.collect.Interner;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.CompositeFileSystemSnapshot;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.PathUtil;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class FileSystemSnapshotSerializer
implements Serializer<FileSystemSnapshot> {
    private final Interner<String> stringInterner;

    public FileSystemSnapshotSerializer(Interner<String> stringInterner) {
        this.stringInterner = stringInterner;
    }

    public FileSystemSnapshot read(Decoder decoder) throws Exception {
        EntryType type;
        SnapshotStack stack = new SnapshotStack();
        stack.push();
        ArrayDeque<String> pathTracker = new ArrayDeque<String>();
        block5: while ((type = FileSystemSnapshotSerializer.readEntryType(decoder)) != EntryType.END) {
            String internedName;
            String internedAbsolutePath;
            if (type != EntryType.DIR_CLOSE) {
                String path = decoder.readString();
                String internedPath = (String)this.stringInterner.intern((Object)path);
                pathTracker.addLast(internedPath);
                if (type == EntryType.DIR_OPEN) {
                    stack.push();
                    continue;
                }
            }
            String path = (String)pathTracker.removeLast();
            if (pathTracker.isEmpty()) {
                internedAbsolutePath = path;
                internedName = (String)this.stringInterner.intern((Object)PathUtil.getFileName((String)internedAbsolutePath));
            } else {
                internedAbsolutePath = (String)this.stringInterner.intern((Object)FileSystemSnapshotSerializer.toAbsolutePath(pathTracker, path));
                internedName = path;
            }
            FileMetadata.AccessType accessType = FileSystemSnapshotSerializer.readAccessType(decoder);
            switch (type) {
                case REGULAR_FILE: {
                    HashCode contentHash = FileSystemSnapshotSerializer.readHashCode(decoder);
                    long lastModified = decoder.readSmallLong();
                    long length = decoder.readSmallLong();
                    stack.add((FileSystemLocationSnapshot)new RegularFileSnapshot(internedAbsolutePath, internedName, contentHash, DefaultFileMetadata.file((long)lastModified, (long)length, (FileMetadata.AccessType)accessType)));
                    continue block5;
                }
                case MISSING: {
                    stack.add((FileSystemLocationSnapshot)new MissingFileSnapshot(internedAbsolutePath, internedName, accessType));
                    continue block5;
                }
                case DIR_CLOSE: {
                    HashCode merkleHash = FileSystemSnapshotSerializer.readHashCode(decoder);
                    List<FileSystemLocationSnapshot> children = stack.pop();
                    stack.add((FileSystemLocationSnapshot)new DirectorySnapshot(internedAbsolutePath, internedName, accessType, merkleHash, children));
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        return CompositeFileSystemSnapshot.of(stack.pop());
    }

    public void write(final Encoder encoder, FileSystemSnapshot value) throws Exception {
        value.accept((FileSystemSnapshotHierarchyVisitor)new RootTrackingFileSystemSnapshotHierarchyVisitor(){

            public void enterDirectory(DirectorySnapshot directorySnapshot, boolean isRoot) {
                try {
                    FileSystemSnapshotSerializer.writeEntryType(encoder, EntryType.DIR_OPEN);
                    FileSystemSnapshotSerializer.writePath(encoder, isRoot, (FileSystemLocationSnapshot)directorySnapshot);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot, final boolean isRoot) {
                snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                    public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                        try {
                            FileSystemSnapshotSerializer.writeEntryType(encoder, EntryType.REGULAR_FILE);
                            FileSystemSnapshotSerializer.writePath(encoder, isRoot, (FileSystemLocationSnapshot)fileSnapshot);
                            FileSystemSnapshotSerializer.writeAccessType(encoder, fileSnapshot.getAccessType());
                            FileSystemSnapshotSerializer.writeHashCode(encoder, fileSnapshot.getHash());
                            FileMetadata metadata = fileSnapshot.getMetadata();
                            encoder.writeSmallLong(metadata.getLastModified());
                            encoder.writeSmallLong(metadata.getLength());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    public void visitMissing(MissingFileSnapshot missingSnapshot) {
                        try {
                            FileSystemSnapshotSerializer.writeEntryType(encoder, EntryType.MISSING);
                            FileSystemSnapshotSerializer.writePath(encoder, isRoot, (FileSystemLocationSnapshot)missingSnapshot);
                            FileSystemSnapshotSerializer.writeAccessType(encoder, missingSnapshot.getAccessType());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                });
                return SnapshotVisitResult.CONTINUE;
            }

            public void leaveDirectory(DirectorySnapshot directorySnapshot, boolean isRoot) {
                try {
                    FileSystemSnapshotSerializer.writeEntryType(encoder, EntryType.DIR_CLOSE);
                    FileSystemSnapshotSerializer.writeAccessType(encoder, directorySnapshot.getAccessType());
                    FileSystemSnapshotSerializer.writeHashCode(encoder, directorySnapshot.getHash());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        encoder.writeByte((byte)EntryType.END.ordinal());
    }

    private static void writePath(Encoder encoder, boolean isRoot, FileSystemLocationSnapshot snapshot) throws IOException {
        encoder.writeString((CharSequence)(isRoot ? snapshot.getAbsolutePath() : snapshot.getName()));
    }

    private static EntryType readEntryType(Decoder decoder) throws IOException {
        return EntryType.values()[decoder.readByte()];
    }

    private static void writeEntryType(Encoder encoder, EntryType type) throws IOException {
        encoder.writeByte((byte)type.ordinal());
    }

    private static FileMetadata.AccessType readAccessType(Decoder decoder) throws IOException {
        return FileMetadata.AccessType.values()[decoder.readByte()];
    }

    private static void writeAccessType(Encoder encoder, FileMetadata.AccessType accessType) throws IOException {
        encoder.writeByte((byte)accessType.ordinal());
    }

    private static HashCode readHashCode(Decoder decoder) throws IOException {
        return HashCode.fromBytes((byte[])decoder.readBinary());
    }

    private static void writeHashCode(Encoder encoder, HashCode hashCode) throws IOException {
        encoder.writeBinary(hashCode.toByteArray());
    }

    private static String toAbsolutePath(Collection<String> parents, String fileName) {
        int length = fileName.length() + parents.size() + parents.stream().mapToInt(String::length).sum();
        StringBuilder buffer = new StringBuilder(length);
        for (String parent : parents) {
            buffer.append(parent);
            buffer.append(File.separatorChar);
        }
        buffer.append(fileName);
        return buffer.toString();
    }

    private static enum EntryType {
        DIR_OPEN,
        REGULAR_FILE,
        MISSING,
        DIR_CLOSE,
        END;

    }

    private static class SnapshotStack {
        private final Deque<List<FileSystemLocationSnapshot>> stack = new ArrayDeque<List<FileSystemLocationSnapshot>>();

        private SnapshotStack() {
        }

        public void push() {
            this.stack.addLast(new ArrayList());
        }

        public void add(FileSystemLocationSnapshot entry) {
            List<FileSystemLocationSnapshot> current = this.stack.peekLast();
            if (current == null) {
                throw new IllegalStateException("Stack empty");
            }
            current.add(entry);
        }

        public List<FileSystemLocationSnapshot> pop() {
            List<FileSystemLocationSnapshot> popped = this.stack.pollLast();
            if (popped == null) {
                throw new IllegalStateException("Stack empty");
            }
            return popped;
        }
    }
}

