/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources.process;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.sources.process.ProcessOutputValueSource;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecResult;

public class DefaultExecOutput
implements ExecOutput {
    private final Provider<ProcessOutputValueSource.ExecOutputData> dataProvider;

    public DefaultExecOutput(Provider<ProcessOutputValueSource.ExecOutputData> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Provider<ExecResult> getResult() {
        return this.dataProvider.map(SerializableLambdas.transformer(ProcessOutputValueSource.ExecOutputData::getResult));
    }

    public ExecOutput.StandardStreamContent getStandardOutput() {
        return new DefaultStandardStreamContent((Provider<byte[]>)this.dataProvider.map(SerializableLambdas.transformer(ProcessOutputValueSource.ExecOutputData::getOutput)));
    }

    public ExecOutput.StandardStreamContent getStandardError() {
        return new DefaultStandardStreamContent((Provider<byte[]>)this.dataProvider.map(SerializableLambdas.transformer(ProcessOutputValueSource.ExecOutputData::getError)));
    }

    private static class DefaultStandardStreamContent
    implements ExecOutput.StandardStreamContent {
        private final Provider<byte[]> bytesProvider;

        public DefaultStandardStreamContent(Provider<byte[]> bytesProvider) {
            this.bytesProvider = bytesProvider;
        }

        public Provider<String> getAsText() {
            return this.getAsBytes().map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)bytes -> new String((byte[])bytes, Charset.defaultCharset())));
        }

        public Provider<byte[]> getAsBytes() {
            return this.bytesProvider;
        }
    }
}

