/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.plugins.AppEntryPoint;
import org.gradle.api.internal.plugins.ExecutableJar;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.tasks.wrapper.Wrapper;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.DistributionLocator;
import org.gradle.util.internal.GFileUtils;

@NonNullApi
public class WrapperGenerator {
    public static File getPropertiesFile(File jarFileDestination) {
        return new File(jarFileDestination.getParentFile(), jarFileDestination.getName().replaceAll("\\.jar$", ".properties"));
    }

    public static File getBatchScript(File scriptFile) {
        return new File(scriptFile.getParentFile(), scriptFile.getName().replaceFirst("(\\.[^\\.]+)?$", ".bat"));
    }

    public static String getDistributionUrl(GradleVersion gradleVersion, Wrapper.DistributionType distributionType) {
        String distType = distributionType.name().toLowerCase(Locale.ENGLISH);
        return new DistributionLocator().getDistributionFor(gradleVersion, distType).toASCIIString();
    }

    public static void generate(Wrapper.PathBase archiveBase, String archivePath, Wrapper.PathBase distributionBase, String distributionPath, @Nullable String distributionSha256Sum, File wrapperPropertiesOutputFile, File wrapperJarOutputFile, String jarFileRelativePath, File unixScript, File batchScript, @Nullable String distributionUrl, boolean validateDistributionUrl, @Nullable Integer networkTimeout) {
        WrapperGenerator.writeProperties(wrapperPropertiesOutputFile, distributionUrl, distributionSha256Sum, distributionBase, distributionPath, archiveBase, archivePath, networkTimeout, validateDistributionUrl);
        WrapperGenerator.writeWrapperJar(wrapperJarOutputFile);
        WrapperGenerator.writeScripts(jarFileRelativePath, unixScript, batchScript);
    }

    private static void writeProperties(File propertiesFileDestination, @Nullable String distributionUrl, @Nullable String distributionSha256Sum, Wrapper.PathBase distributionBase, String distributionPath, Wrapper.PathBase archiveBase, String archivePath, @Nullable Integer networkTimeout, boolean validateDistributionUrl) {
        Properties wrapperProperties = new Properties();
        wrapperProperties.put("distributionUrl", distributionUrl);
        if (distributionSha256Sum != null) {
            wrapperProperties.put("distributionSha256Sum", distributionSha256Sum);
        }
        wrapperProperties.put("distributionBase", distributionBase.toString());
        wrapperProperties.put("distributionPath", distributionPath);
        wrapperProperties.put("zipStoreBase", archiveBase.toString());
        wrapperProperties.put("zipStorePath", archivePath);
        if (networkTimeout != null) {
            wrapperProperties.put("networkTimeout", String.valueOf(networkTimeout));
        }
        wrapperProperties.put("validateDistributionUrl", String.valueOf(validateDistributionUrl));
        GFileUtils.parentMkdirs((File)propertiesFileDestination);
        try {
            PropertiesUtils.store((Properties)wrapperProperties, (File)propertiesFileDestination);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static void writeWrapperJar(File destination) {
        URL jarFileSource = Wrapper.class.getResource("/gradle-wrapper.jar");
        if (jarFileSource == null) {
            throw new GradleException("Cannot locate wrapper JAR resource.");
        }
        try (InputStream in = jarFileSource.openStream();
             OutputStream out = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write wrapper JAR to " + destination, (Throwable)e);
        }
    }

    private static void writeScripts(String jarFileRelativePath, File unixScript, File batchScript) {
        StartScriptGenerator generator = new StartScriptGenerator();
        generator.setApplicationName("Gradle");
        generator.setEntryPoint((AppEntryPoint)new ExecutableJar(jarFileRelativePath));
        generator.setClasspath(Collections.emptyList());
        generator.setOptsEnvironmentVar("GRADLE_OPTS");
        generator.setExitEnvironmentVar("GRADLE_EXIT_CONSOLE");
        generator.setAppNameSystemProperty("org.gradle.appname");
        generator.setScriptRelPath(unixScript.getName());
        generator.setDefaultJvmOpts((Iterable)ImmutableList.of((Object)"-Xmx64m", (Object)"-Xms64m"));
        generator.generateUnixScript(unixScript);
        generator.generateWindowsScript(batchScript);
    }
}

