/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractCopyTask
extends ConventionTask
implements CopySpec,
CopySpecSource {
    private final CopySpecInternal rootSpec = this.createRootSpec();
    private final CopySpecInternal mainSpec;

    protected AbstractCopyTask() {
        this.rootSpec.addChildSpecListener((path, spec) -> {
            if (this.getState().getExecuting()) {
                throw new GradleException("You cannot add child specs at execution time. Consider configuring this task during configuration time or using a separate task to do the configuration.");
            }
            StringBuilder specPropertyNameBuilder = new StringBuilder("rootSpec");
            CopySpecResolver parentResolver = path.unroll(specPropertyNameBuilder);
            CopySpecResolver resolver = spec.buildResolverRelativeToParent(parentResolver);
            String specPropertyName = specPropertyNameBuilder.toString();
            Object[] objectArray = new Object[1];
            objectArray[0] = () -> ((CopySpecResolver)resolver).getSource();
            this.getInputs().files(objectArray).withPropertyName(specPropertyName).withPathSensitivity(PathSensitivity.RELATIVE).ignoreEmptyDirectories(false).skipWhenEmpty();
            this.getInputs().property(specPropertyName + ".destPath", () -> resolver.getDestPath().getPathString());
            this.getInputs().property(specPropertyName + ".caseSensitive", () -> ((CopySpecInternal)spec).isCaseSensitive());
            this.getInputs().property(specPropertyName + ".includeEmptyDirs", () -> ((CopySpecInternal)spec).getIncludeEmptyDirs());
            this.getInputs().property(specPropertyName + ".duplicatesStrategy", () -> ((CopySpecInternal)spec).getDuplicatesStrategy());
            this.getInputs().property(specPropertyName + ".dirPermissions", spec.getDirPermissions().map(FilePermissions::toUnixNumeric)).optional(true);
            this.getInputs().property(specPropertyName + ".filePermissions", spec.getFilePermissions().map(FilePermissions::toUnixNumeric)).optional(true);
            this.getInputs().property(specPropertyName + ".filteringCharset", () -> ((CopySpecInternal)spec).getFilteringCharset());
        });
        this.getOutputs().doNotCacheIf("Has custom actions", SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)task -> this.rootSpec.hasCustomActions()));
        this.mainSpec = this.rootSpec.addChild();
    }

    protected CopySpecInternal createRootSpec() {
        return (CopySpecInternal)this.getProject().getObjects().newInstance(DefaultCopySpec.class, new Object[0]);
    }

    protected abstract CopyAction createCopyAction();

    @Inject
    protected abstract Instantiator getInstantiator();

    @Inject
    protected abstract FileSystem getFileSystem();

    @Inject
    protected abstract FileResolver getFileResolver();

    @Inject
    protected abstract FileLookup getFileLookup();

    @Inject
    protected abstract DirectoryFileTreeFactory getDirectoryFileTreeFactory();

    @Inject
    protected abstract DocumentationRegistry getDocumentationRegistry();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract PropertyFactory getPropertyFactory();

    @TaskAction
    protected void copy() {
        CopyActionExecuter copyActionExecuter = this.createCopyActionExecuter();
        CopyAction copyAction = this.createCopyAction();
        WorkResult didWork = copyActionExecuter.execute(this.rootSpec, copyAction);
        this.setDidWork(didWork.getDidWork());
    }

    protected CopyActionExecuter createCopyActionExecuter() {
        Instantiator instantiator = this.getInstantiator();
        FileSystem fileSystem = this.getFileSystem();
        return new CopyActionExecuter(instantiator, this.getPropertyFactory(), fileSystem, false, this.getDocumentationRegistry());
    }

    @Internal
    @NotToBeReplacedByLazyProperty(because="Read-only nested like property")
    public FileCollection getSource() {
        return this.rootSpec.buildRootResolver().getAllSource();
    }

    @Internal
    @NotToBeReplacedByLazyProperty(because="Read-only nested like property")
    public CopySpecInternal getRootSpec() {
        return this.rootSpec;
    }

    @Internal
    protected CopySpecInternal getMainSpec() {
        return this.mainSpec;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean isCaseSensitive() {
        return this.getMainSpec().isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.getMainSpec().setCaseSensitive(caseSensitive);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public boolean getIncludeEmptyDirs() {
        return this.getMainSpec().getIncludeEmptyDirs();
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.getMainSpec().setIncludeEmptyDirs(includeEmptyDirs);
    }

    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.getRootSpec().setDuplicatesStrategy(strategy);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.getRootSpec().getDuplicatesStrategy();
    }

    public AbstractCopyTask from(Object ... sourcePaths) {
        this.getMainSpec().from(sourcePaths);
        return this;
    }

    public AbstractCopyTask filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesMatching(pattern, action);
        return this;
    }

    public AbstractCopyTask filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesMatching(patterns, action);
        return this;
    }

    public AbstractCopyTask filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesNotMatching(pattern, action);
        return this;
    }

    public AbstractCopyTask filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        this.getMainSpec().filesNotMatching(patterns, action);
        return this;
    }

    public AbstractCopyTask from(Object sourcePath, Closure c) {
        this.getMainSpec().from(sourcePath, (Action)new ClosureBackedAction(c));
        return this;
    }

    public AbstractCopyTask from(Object sourcePath, Action<? super CopySpec> configureAction) {
        this.getMainSpec().from(sourcePath, configureAction);
        return this;
    }

    public CopySpec with(CopySpec ... sourceSpecs) {
        this.getMainSpec().with(sourceSpecs);
        return this;
    }

    public AbstractCopyTask into(Object destDir) {
        this.getRootSpec().into(destDir);
        return this;
    }

    public AbstractCopyTask into(Object destPath, Closure configureClosure) {
        this.getMainSpec().into(destPath, configureClosure);
        return this;
    }

    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        this.getMainSpec().into(destPath, copySpec);
        return this;
    }

    public AbstractCopyTask include(String ... includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    public AbstractCopyTask include(Iterable<String> includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    public AbstractCopyTask include(Spec<FileTreeElement> includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    public AbstractCopyTask include(Closure includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    public AbstractCopyTask exclude(String ... excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    public AbstractCopyTask exclude(Iterable<String> excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    public AbstractCopyTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    public AbstractCopyTask exclude(Closure excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    public AbstractCopyTask setIncludes(Iterable<String> includes) {
        this.getMainSpec().setIncludes(includes);
        return this;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Set<String> getIncludes() {
        return this.getMainSpec().getIncludes();
    }

    public AbstractCopyTask setExcludes(Iterable<String> excludes) {
        this.getMainSpec().setExcludes(excludes);
        return this;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Set<String> getExcludes() {
        return this.getMainSpec().getExcludes();
    }

    public AbstractCopyTask rename(Closure closure) {
        return this.rename((Transformer)new ClosureBackedTransformer(closure));
    }

    public AbstractCopyTask rename(Transformer<@Nullable String, String> renamer) {
        this.getMainSpec().rename(renamer);
        return this;
    }

    public AbstractCopyTask rename(String sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    public AbstractCopyTask rename(Pattern sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    public AbstractCopyTask filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter(properties, filterType);
        return this;
    }

    public AbstractCopyTask filter(Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter(filterType);
        return this;
    }

    public AbstractCopyTask filter(Closure closure) {
        this.getMainSpec().filter(closure);
        return this;
    }

    public AbstractCopyTask filter(Transformer<@Nullable String, String> transformer) {
        this.getMainSpec().filter(transformer);
        return this;
    }

    public AbstractCopyTask expand(Map<String, ?> properties) {
        this.getMainSpec().expand(properties);
        return this;
    }

    public AbstractCopyTask expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
        this.getMainSpec().expand(properties, action);
        return this;
    }

    @Internal
    public Property<ConfigurableFilePermissions> getFilePermissions() {
        return this.getMainSpec().getFilePermissions();
    }

    public CopyProcessingSpec filePermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.getMainSpec().filePermissions(configureAction);
    }

    @Internal
    public Property<ConfigurableFilePermissions> getDirPermissions() {
        return this.getMainSpec().getDirPermissions();
    }

    public CopyProcessingSpec dirPermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.getMainSpec().dirPermissions(configureAction);
    }

    public AbstractCopyTask eachFile(Action<? super FileCopyDetails> action) {
        this.getMainSpec().eachFile(action);
        return this;
    }

    public AbstractCopyTask eachFile(Closure closure) {
        this.getMainSpec().eachFile(closure);
        return this;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getFilteringCharset() {
        return this.getMainSpec().getFilteringCharset();
    }

    public void setFilteringCharset(String charset) {
        this.getMainSpec().setFilteringCharset(charset);
    }
}

