/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.net.URL;
import java.util.Properties;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ServiceScope(value={Scope.Global.class})
public class RuntimeApiInfo {
    private final ClassLoader classLoader;

    public static RuntimeApiInfo create(ClassPath apiInfoClasspath) {
        ClassLoader classLoader = new DefaultClassLoaderFactory().createIsolatedClassLoader("runtime-api-info", apiInfoClasspath);
        return new RuntimeApiInfo(classLoader);
    }

    public RuntimeApiInfo(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Properties getGradlePluginsProperties() {
        return GUtil.loadProperties((URL)this.getResource("gradle-plugins.properties"));
    }

    public Properties getGradleImplementationPluginsProperties() {
        return GUtil.loadProperties((URL)this.getResource("gradle-implementation-plugins.properties"));
    }

    public URL getDefaultImportsResource() {
        return this.getResource("default-imports.txt");
    }

    public URL getApiMappingResource() {
        return this.getResource("api-mapping.txt");
    }

    private URL getResource(String resource) {
        URL url = this.classLoader.getResource(resource);
        if (url == null) {
            throw new IllegalStateException("Cannot find resource '" + resource + "' in classloader " + this.classLoader);
        }
        return url;
    }
}

