/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.reflect.CachedInvokable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ReflectionCache;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.jspecify.annotations.Nullable;

public class DirectInstantiator
implements Instantiator {
    public static final Instantiator INSTANCE = new DirectInstantiator();
    private final ConstructorCache constructorCache = new ConstructorCache();

    public static <T> T instantiate(Class<? extends T> type, Object ... params) {
        return INSTANCE.newInstance(type, params);
    }

    private DirectInstantiator() {
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... params) {
        try {
            Class<?>[] argTypes = this.wrapArgs(params);
            Constructor match = null;
            while (match == null) {
                match = (Constructor)((CachedConstructor)this.constructorCache.get(type, argTypes)).getMethod();
            }
            return type.cast(match.newInstance(params));
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Throwable t) {
            throw new ObjectInstantiationException(type, t);
        }
    }

    private Class<?>[] wrapArgs(@Nullable Object[] params) {
        Class[] result = new Class[params.length];
        for (int i = 0; i < result.length; ++i) {
            Object param = params[i];
            if (param == null) continue;
            Class pType = param.getClass();
            if (pType.isPrimitive()) {
                pType = AsmClassGeneratorUtils.getWrapperTypeForPrimitiveType(pType);
            }
            result[i] = pType;
        }
        return result;
    }

    @VisibleForTesting
    public static class ConstructorCache
    extends ReflectionCache<CachedConstructor> {
        @Override
        protected CachedConstructor create(Class<?> receiver, Class<?>[] argumentTypes) {
            Constructor<?>[] constructors = receiver.getConstructors();
            Constructor<?> match = null;
            for (Constructor<?> constructor : constructors) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != argumentTypes.length || !this.isMatch(argumentTypes, parameterTypes)) continue;
                if (match != null) {
                    throw new IllegalArgumentException(String.format("Found multiple public constructors for %s which accept parameters [%s].", receiver, this.prettify(argumentTypes)));
                }
                match = constructor;
            }
            if (match == null) {
                throw new IllegalArgumentException(String.format("Could not find any public constructor for %s which accepts parameters [%s].", receiver, this.prettify(argumentTypes)));
            }
            return new CachedConstructor(match);
        }

        private String prettify(Class<?>[] argumentTypes) {
            return Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(argumentTypes), (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    if (input == null) {
                        return "null";
                    }
                    return input.getName();
                }
            }));
        }

        private boolean isMatch(Class<?>[] argumentTypes, Class<?>[] parameterTypes) {
            for (int i = 0; i < argumentTypes.length; ++i) {
                Class<?> argumentType = argumentTypes[i];
                Class parameterType = parameterTypes[i];
                boolean primitive = parameterType.isPrimitive();
                if (primitive) {
                    if (argumentType == null) {
                        return false;
                    }
                    parameterType = AsmClassGeneratorUtils.getWrapperTypeForPrimitiveType(parameterType);
                }
                if (argumentType == null || parameterType.isAssignableFrom(argumentType)) continue;
                return false;
            }
            return true;
        }
    }

    private static class CachedConstructor
    extends CachedInvokable<Constructor<?>> {
        public CachedConstructor(Constructor<?> ctor) {
            super(ctor);
        }
    }
}

