subroutine howto_comm(line,error,icode)
  use gkernel_interfaces
  use gbl_message
  use imager_interfaces, only : map_message
  !---------------------------------------------------------------------
  !! IMAGER -- Support for command HOW_TO
  !---------------------------------------------------------------------
  character(len=*), intent(inout) :: line  !! Command line
  logical, intent(out) :: error            !! Logical error flag
  integer, intent(inout) :: icode  !! Operation code: 0 examine ambiguities, 1 use unambiguous result
  !
  ! Constants
  character(len=*), parameter :: rname='HOW_TO'
  integer, parameter :: nuse=13
  character(len=8) :: useless(nuse)
  data useless /'?','a','all','and','at','do','i','it','my','some','the','to','we'/
  integer, parameter :: mkeys=10
  ! Local ---
  integer :: nkeys, lkeys(mkeys), ikey
  character(len=20) :: ckeys(mkeys),string,comm
  character(len=4) :: ch
  character(len=120) :: ligne,cmatch
  character(len=256) :: file
  integer, save :: luntem=0
  integer :: ier, i, j, itry, ifound, lt, nline, nfound, fline, lline
  logical :: found, used, lfound
  !
  ! Code ----
  error = .true.
  nkeys = sic_narg(0)
  if (nkeys.le.0) then
    call map_message(seve%e,rname,'Missing keywords')
    return
  endif
  !
  if (nkeys.gt.mkeys) then
    call map_message(seve%e,rname,'Too many keywords')
    return
  endif
  !
  ikey = 0
  do i=1,nkeys
    call sic_ch(line,0,i,string,lt,.true.,error)
    if (error) return
    if (nkeys.eq.1 .and. string.eq.'?') then
      ikey = 1
      exit
    endif
    !
    call sic_lower(string)
    used = .true.
    do j=1,nuse
      if (string.eq.useless(j)) then
        used = .false.
        exit
      endif
    enddo
    if (used) then
      ikey = ikey+1
      ckeys(ikey) = string
      if (string(lt:lt).eq.'*') then
        lkeys(ikey) = lt-1
        ckeys(ikey)(lt:) = ' '
      else
        lkeys(ikey) = lt+1
      endif
    endif
  enddo
  nkeys = ikey
  !
  ! Open file (in production, will use a rewind(luntem) statement)
  if (luntem.eq.0) then
    ier = sic_getlun(luntem)
    if (ier.ne.1) return
    call sic_parse_file('imager-howto','gag_pro:','.hlp',file)    
    ier = sic_open(luntem,file,'old',.true.)
    if (ier.ne.0) then
      call map_message(seve%e,'HOW_TO','No gag_pro:imager-howto.hlp file')
      error = .true.
      call sic_frelun(luntem)
      luntem = 0
    endif
  else    
    rewind(unit=luntem)
  endif
  !
  ! Special case HOWTO ?
  if (nkeys.eq.1 .and. string.eq.'?') then
    do 
      read(luntem,'(A)',iostat=ier) ligne
      if (ier.ne.0)  exit
      !
      if (ligne(1:1).eq.'1') then
        read(luntem,'(A)',iostat=ier) ligne
        if (ier.eq.0) write(*,'(A)') trim(ligne)
      endif
    enddo
    error = .false.
    return
  endif
  !
  ! Scan for Keywords
  found = .false.
  ifound = 0
  !
  ! First pass, look for ambiguities
  nline = 0
  nfound = 0
  fline = 0
  lline = 0
  do
    lfound = .false.
    ifound = 0
    do 
      read(luntem,'(A)',iostat=ier) ligne
      if (ier.ne.0)  then
        if (ifound.eq.nkeys) nfound = nfound+1
        exit
      endif
      nline = nline+1
      !
      if (ligne(1:1).eq.'1') then
        if (ifound.eq.nkeys) then
          lline = nline
          nfound = nfound+1
          !!Print *,'STARTing ',ifound, nkeys,nline,trim(ligne) 
        endif
        ! We check 1 more character in ligne, which should be blank
        ! for correct match
        ifound = 0  ! Nothing found so far
        lfound = .false.
        do i=1,nkeys
          lt = lkeys(i)
          if (index(ligne,ckeys(i)(1:lt)).ne.0) then
            error = .false.
            ifound = ifound+1
          endif
        enddo
        lfound = ifound.eq.nkeys
        if (lfound) then
          found = .true.
          fline = nline
          read(luntem,'(A)',iostat=ier) ligne
          if (ier.ne.0)  exit
          write(*,'(A)') trim(ligne)
        endif
        !!Print *,ifound,nkeys,nline,trim(ligne)
      endif
    enddo
    !!Print *,'NLINE ',nline
    if (ier.ne.0) exit
  enddo
  if (lline.eq.0) lline = nline
  !
  if (found) then
    !!Print *,'NFOUND ',nfound,' FLINE ',fline,' LLINE ',lline
    !
    ! Second pass to write if no ambiguity
    if (nfound.gt.1) then
      write(*,'(A,I0,A)') 'Sorry, found ',nfound, &
        & ' different results for "how '//trim(line(17:))//'"'
      write(*,'(A)') 'Please, specify additional keywords ' 
    else 
      rewind(luntem)
      do i=1,fline+1
        read(luntem,'(A)',iostat=ier) ch
      enddo
      do i=fline+2,lline
        read(luntem,'(A)',iostat=ier) ligne
        write(*,'(A)') trim(ligne)
      enddo    
    endif
    return
  endif
  !
  if (icode.eq.1) then
    Print *,'Autoguess failed...'
    error = .true.
    return
  endif
  !
  ! Third chance: list relevant HOW_TOs
  do itry=1,2
    if (itry.eq.2) then
      write(*,'(A)') 'Sorry, no result for '//trim(line)
      if (ifound.eq.0) return
      write(*,'(A)') '  Related information could be: '
    endif
    !
    ifound = 0
    rewind(luntem)
    do 
      read(luntem,'(A)',iostat=ier) ligne
      if (ier.ne.0)  exit
      !
      if (ligne(1:1).eq.'1') then
        if (ifound.eq.nkeys) exit  ! Every keyword has been found
        ! We check 1 more character in ligne, which should be blank
        ! for correct match
        found = .false.
        do i=1,nkeys
          lt = lkeys(i)
          if (index(ligne,ckeys(i)(1:lt)).ne.0) then
            found = itry.eq.2
            error = .false.
            ifound = ifound+1
            if (ifound.eq.1) cmatch = ligne(3:len_trim(ligne))
          endif
        enddo
        if (found) write(*,'(A)') ligne(3:len_trim(ligne))
      endif
    enddo
    !
    ! Automatic fall back to the only possible match
    if (ifound.eq.1) then
      icode = 1
      line = 'HOW_TO '//cmatch
      nline = len_trim(line)
      call sic_analyse(comm,line,nline,error)
      return
    endif
  enddo
end subroutine howto_comm
