subroutine display_check_uv(comm,chain,error)
  use clean_def
  use clean_arrays
  use clean_default
  use gkernel_interfaces
  use gkernel_types
  use gbl_message
  use iso_c_binding
  use imager_interfaces, only : map_message, uv_tri
  !---------------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER -- Support for commands SHOW UV and UV_FLAG
  !
  !   TIME-BASE sort the UV table before displaying it
  !!
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: comm     !! Command name 
  character(len=*), intent(inout) :: chain !! Arguments to be parsed
  logical, intent(out) :: error            !! Logical error flag
  !
  ! Local ---
  character(len=64) :: nname
  character(len=64), save :: oname
  logical :: do_tri
  type(gildas) :: hin
  type(sic_descriptor_t) :: desc
  type(c_ptr) :: cptr
  real(4), pointer :: r2ptr(:,:)
  integer(kind=4) :: ib
  !
  ! Code ----
  ib = index(chain,' ')
  if (ib.eq.0) ib = len_trim(chain)
  nname = chain(1:ib)
  call map_message(seve%d,comm,'Requesting sort on '//trim(nname))
  ! Check data presence in buffer - NOT APPROPRIATE AT THIS STAGE ...
  select case (nname)
  case ('UV','DATA_UV','RESIDUAL_UV','MODEL_UV')
    if (.not.associated(duv)) then
      call map_message(seve%e,comm,'No UV data')
      error = .true.
      return
    endif
    chain = 'UV'
  end select
  !
  ! Sort buffer (TIME-BASE) when needed and create the associated SIC buffer
  if (nname.eq.'MODEL_UV') then
    do_tri = uv_model_updated
    uv_model_updated = .false.
  else if (nname.eq.'RESIDUAL_UV') then
    do_tri = uv_resid_updated
    uv_resid_updated = .false.
  else    
    do_tri = .false.
  endif
  !
  if (.not.allocated(duvt)) then
    do_tri = .true.
  else if (oname.ne.nname) then
    do_tri = .true.
  endif
  !
  if (do_tri) then
    if (chain.eq.'UV') then
      call uv_tri(2,huv,duv,error)
    else
      call gildas_null(hin,type='UVT')
      call get_gildas(comm,nname,desc,hin,error)
      if (error) return
      call gdf_copy_header(desc%head,hin,error)
      if (error) return
      call adtoad(desc%addr,cptr,1)
      call c_f_pointer(cptr,r2ptr,hin%gil%dim(1:2))
      call uv_tri(2,hin,r2ptr,error)
    endif
  else
    call map_message(seve%d,comm,trim(nname)//' is already sorted')
  endif
  oname = nname
  !
end subroutine display_check_uv
!
subroutine select_uvdata(line,comm,error)
  use gkernel_interfaces
  use clean_default
  use clean_arrays
  use gbl_message
  use imager_interfaces, only : map_message
  !---------------------------------------------------------------------
  ! IMAGER
  !*
  ! @ private --  Support for command UV_SELECT [NewOne]
  !
  !   Select the UV_DATA to be Imaged (and Plotted ?)
  !!
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line    !! Command line
  character(len=*), intent(in) :: comm    !! Command name
  logical, intent(inout) :: error
  !
  ! Constants
  integer, parameter :: mcase=6
  character(len=12) :: uvcase(mcase)
  data uvcase /'DATA_UV','MODEL_UV','RESIDUAL_UV','UV_DATA','UV_MODEL','UV_RESIDUAL'/
  !
  ! Local ---
  character(len=12) :: old_uvdata, argum, ccase
  integer :: icase,jcase,n
  !
  ! Code ----
  if (sic_narg(0).eq.0) then
    call map_message(seve%i,comm,'Current UV data is '//current_uvdata)
    return
  endif
  !
  call sic_ke(line,0,1,argum,n,.true.,error)
  call sic_ambigs (comm,argum,ccase,icase,uvcase,mcase,error)
  if (error) return
  !
  old_uvdata = current_uvdata
  jcase = mod(icase-1,3)+1
  current_uvdata = uvcase(jcase) ! Use only the first 3 names.
  !
  if (old_uvdata.ne.current_uvdata) then
    huvc%loca%size = 0
    ! Note that subroutine uv_new_data should NOT be called here.
    ! We just select some data set, we do not modify it.
    !
    ! However, weight may have changed
    do_weig = .true.  
    ! This will not be the case in most cases, but can happen
    ! in the following circumstances
    ! 1) Reading directly by a READ MODEL command some data set 
    !    that may be inconsistent with the READ UV command
    ! 2) UV_RESIDUAL /FIELD  command
    !     To optimize this, a new information should be stored 
    !   which would say whether the weights of a MODEL or RESIDUAL
    !   UV data are just copies of that of the UV_DATA itself.
    !   It is easy to do in the MODEL and UV_RESIDUAL commands,
    !   but then any UV_RESAMPLE, UV_FLAG or what not would
    !   change this information too.
  endif
end subroutine select_uvdata
!
subroutine uvdata_select(comm,error)
  use clean_arrays
  use clean_default
  use gbl_message
  use imager_interfaces, only : map_message
  !----------------------------------------------------------------
  ! @ private
  !! IMAGER -- Display currently active UV Data name
  !----------------------------------------------------------------
  character(len=*), intent(in):: comm   !! Command name
  logical, intent(inout) :: error       !! Logical error flag
  !
  ! Code ----
  if (current_uvdata.eq.'DATA_UV') then
    if (huvi%loca%size.eq.0) then
      call map_message(seve%e,comm,'No UV_DATA available')
      error = .true.
      return
    endif
    call map_message(seve%i,comm,'Selecting UV data UV_DATA')
    continue
  else if (current_uvdata.eq.'MODEL_UV') then   
    if (huvm%loca%size.eq.0) then
      call map_message(seve%e,comm,'No UV_MODEL available')
      error = .true.
      return
    endif
    call gdf_copy_header(huvm,huv,error)
    duv => duvm
    call map_message(seve%i,comm,'Selecting UV data UV_MODEL')
  else if (current_uvdata.eq.'RESIDUAL_UV') then            
    if (huvf%loca%size.eq.0) then
      call map_message(seve%e,comm,'No UV_RESIDUAL available')
      error = .true.
      return
    endif
    call gdf_copy_header(huvf,huv,error)
    duv => duvf
    call map_message(seve%i,comm,'Selecting UV data UV_RESIDUAL')
  else
    call map_message(seve%w,comm,'Unknown UV_DATA '//current_uvdata)
    return
  endif
end subroutine uvdata_select
!
subroutine display_uv(chain,line,error)
  use clean_def
  use clean_arrays
  use gkernel_interfaces
  use imager_interfaces, only : display_check_uv
  !---------------------------------------------------------------------
  ! @ private
  !*
  ! IMAGER -- Support for command
  !     SHOW UV
  !   Display current uv data as requested.
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: chain   !! Argument
  character(len=*), intent(in) :: line    !! Command line
  logical, intent(out) :: error           !! Logical error flag
  !
  ! Constants
  integer, parameter :: o_dir=1 ! /DIRECTORY option number
  !
  ! Local ---
  character(len=32) :: string, keyw, cval
  character(len=256) :: exec_chain
  integer :: n
  !
  ! Check data presence in buffer
  string = chain
  call display_check_uv('SHOW',string,error)
  if (error) return
  if (sic_narg(0).gt.1) then
    call sic_ke(line,0,2,keyw,n,.true.,error)
    cval = ' '
    call sic_ch(line,0,3,cval,n,.false.,error)
    exec_chain = '@ p_uvshow_sub '//string//keyw//cval
  else
    exec_chain = '@ p_uvshow_sub '//string
  endif
  !
  call get_topdir(line,o_dir)
  call exec_program(exec_chain)
end subroutine display_uv
!
