/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.deploy.maven;

import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.deploy.maven.ArtifactDeployers;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.MavenDeployer;

public class ProjectMavenDeployer {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> deployer;

    private ProjectMavenDeployer(JReleaserContext context, org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> deployer) {
        this.context = context;
        this.deployer = deployer;
    }

    public org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> getMavenDeployer() {
        return this.deployer;
    }

    public boolean deploy() throws DeployException {
        if (!this.deployer.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"deployers.skip.deploy", (Object[])new Object[0]), new Object[]{this.deployer.getName()});
            return false;
        }
        MavenDeployer artifactMavenDeployer = ArtifactDeployers.findMavenDeployer(this.context, this.deployer);
        this.context.getLogger().info(RB.$((String)"deployers.deploy.to", (Object[])new Object[0]), new Object[]{this.deployer.getName()});
        artifactMavenDeployer.deploy(this.deployer.getName());
        return true;
    }

    public static ProjectMavenDeployerBuilder builder() {
        return new ProjectMavenDeployerBuilder();
    }

    public static class ProjectMavenDeployerBuilder {
        private JReleaserContext context;
        private org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> deployer;

        public ProjectMavenDeployerBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public ProjectMavenDeployerBuilder deployer(org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> deployer) {
            this.deployer = Objects.requireNonNull(deployer, "'deployer' must not be null");
            return this;
        }

        public ProjectMavenDeployer build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            Objects.requireNonNull(this.deployer, "'deployer' must not be null");
            return new ProjectMavenDeployer(this.context, this.deployer);
        }
    }
}

