/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.text.CoreTextContentNodeRenderer;
import org.commonmark.renderer.text.TextContentNodeRendererContext;
import org.commonmark.renderer.text.TextContentRenderer;
import org.commonmark.renderer.text.TextContentWriter;

public final class MarkdownUtils {
    private MarkdownUtils() {
    }

    public static Parser createMarkdownParser() {
        Parser.Builder builder = Parser.builder();
        ((AutolinkExtension)AutolinkExtension.create()).extend(builder);
        return builder.build();
    }

    public static TextContentRenderer createTextContentRenderer() {
        return TextContentRenderer.builder().nodeRendererFactory(MyCoreTextContentNodeRenderer::new).build();
    }

    private static class MyCoreTextContentNodeRenderer
    extends CoreTextContentNodeRenderer {
        private final TextContentWriter textContent;

        public MyCoreTextContentNodeRenderer(TextContentNodeRendererContext context) {
            super(context);
            this.textContent = context.getWriter();
        }

        public void visit(Link link) {
            this.rewriteLink((Node)link, link.getTitle(), link.getDestination());
        }

        private void rewriteLink(Node node, String title, String destination) {
            boolean hasDestination;
            boolean hasChild = node.getFirstChild() != null;
            boolean hasTitle = title != null && !title.equals(destination);
            boolean bl = hasDestination = destination != null && !destination.equals("");
            if (hasChild) {
                this.textContent.write('[');
                this.visitChildren(node);
                this.textContent.write(']');
                if (hasTitle || hasDestination) {
                    this.textContent.write('(');
                }
            }
            if (hasTitle) {
                this.textContent.write(title);
                if (hasDestination) {
                    this.textContent.colon();
                    this.textContent.whitespace();
                }
            }
            if (hasDestination) {
                this.textContent.write(destination);
            }
            if (hasChild && (hasTitle || hasDestination)) {
                this.textContent.write(')');
            }
        }
    }
}

