/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public final class Matrix
extends AbstractModelObject<Matrix>
implements Domain {
    private static final long serialVersionUID = -3894675341354234809L;
    private final Map<String, List<String>> vars = new LinkedHashMap<String, List<String>>();
    private final List<Map<String, String>> rows = new ArrayList<Map<String, String>>();
    @JsonIgnore
    private final org.jreleaser.model.api.common.Matrix immutable = new org.jreleaser.model.api.common.Matrix(){
        private static final long serialVersionUID = 5995028202549998151L;

        public Map<String, List<String>> getVars() {
            return Collections.unmodifiableMap(Matrix.this.vars);
        }

        public List<Map<String, String>> getRows() {
            return Collections.unmodifiableList(Matrix.this.rows);
        }

        public List<Map<String, String>> resolved() {
            return Matrix.this.resolve();
        }

        public Map<String, Object> asMap(boolean full) {
            return Matrix.this.asMap(full);
        }
    };

    public org.jreleaser.model.api.common.Matrix asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Matrix source) {
        this.setVars(this.merge(this.vars, source.vars));
        this.setRows(this.merge(this.rows, source.rows));
    }

    public Map<String, List<String>> getVars() {
        return this.vars;
    }

    public void setVars(Map<String, List<String>> vars) {
        this.vars.clear();
        this.vars.putAll(vars);
    }

    public List<Map<String, String>> getRows() {
        return this.rows;
    }

    public void setRows(List<Map<String, String>> rows) {
        this.rows.clear();
        this.rows.addAll(rows);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        return Collections.emptyMap();
    }

    public Map<String, Object> asMap(Map<String, Object> props) {
        if (!this.isEmpty()) {
            if (this.hasVars()) {
                props.put("matrix", this.vars);
            }
            if (this.hasRows()) {
                int[] count = new int[]{0};
                props.put("matrix", this.rows.stream().map(item -> {
                    Object[] objectArray = new Object[2];
                    int n = count[0];
                    count[0] = n + 1;
                    objectArray[0] = "row " + n;
                    objectArray[1] = item;
                    return CollectionUtils.mapOf((Object[])objectArray);
                }).collect(Collectors.toList()));
            }
        }
        return props;
    }

    public boolean isEmpty() {
        return this.vars.isEmpty() && this.rows.isEmpty();
    }

    public boolean hasVars() {
        return !this.vars.isEmpty();
    }

    public boolean hasRows() {
        return !this.rows.isEmpty();
    }

    public List<Map<String, String>> resolve() {
        if (this.hasVars()) {
            return Collections.unmodifiableList(this.combinations(this.vars.values()).stream().map(values -> this.zip((Collection)this.vars.keySet(), (Collection)values)).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(this.rows);
    }

    private <T> List<List<T>> combinations(Collection<List<T>> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        return input.stream().filter(list -> list != null && list.size() > 0).map(list -> list.stream().map(Collections::singletonList).collect(Collectors.toList())).reduce((l1, l2) -> l1.stream().flatMap(i1 -> l2.stream().map(i2 -> Stream.of(i1, i2).flatMap(Collection::stream).collect(Collectors.toList()))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        Iterator<K> i1 = keys.iterator();
        Iterator<V> i2 = values.iterator();
        while (i1.hasNext() || i2.hasNext()) {
            map.put(i1.next(), i2.next());
        }
        return map;
    }

    public static TemplateContext asTemplateContext(Map<String, String> matrix) {
        TemplateContext props = new TemplateContext();
        props.setAll(CollectionUtils.mapOf((Object[])new Object[]{"matrix", matrix}));
        return props;
    }

    public static String replaceWithMatrix(Object value, Map<String, String> matrix) {
        if (null == value) {
            return null;
        }
        String input = String.valueOf(value);
        if (StringUtils.isBlank((String)input)) {
            return "";
        }
        for (Map.Entry<String, String> e : matrix.entrySet()) {
            input = input.replaceAll("\\{\\{\\s*matrix." + e.getKey() + "\\s*}}", e.getValue());
        }
        return input;
    }
}

