/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import org.bouncycastle.tls.SSL3Utils;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CombinedHash
implements TlsHash {
    protected TlsContext context;
    protected TlsCrypto crypto;
    protected TlsHash md5;
    protected TlsHash sha1;

    CombinedHash(TlsContext tlsContext, TlsHash tlsHash, TlsHash tlsHash2) {
        this.context = tlsContext;
        this.crypto = tlsContext.getCrypto();
        this.md5 = tlsHash;
        this.sha1 = tlsHash2;
    }

    public CombinedHash(TlsCrypto tlsCrypto) {
        this.crypto = tlsCrypto;
        this.md5 = tlsCrypto.createHash((short)1);
        this.sha1 = tlsCrypto.createHash((short)2);
    }

    public CombinedHash(CombinedHash combinedHash) {
        this.context = combinedHash.context;
        this.crypto = combinedHash.crypto;
        this.md5 = (TlsHash)combinedHash.md5.clone();
        this.sha1 = (TlsHash)combinedHash.sha1.clone();
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.md5.update(byArray, n, n2);
        this.sha1.update(byArray, n, n2);
    }

    @Override
    public byte[] calculateHash() {
        if (null != this.context && TlsUtils.isSSL(this.context)) {
            SSL3Utils.completeCombinedHash(this.context, this.md5, this.sha1);
        }
        return Arrays.concatenate((byte[])this.md5.calculateHash(), (byte[])this.sha1.calculateHash());
    }

    @Override
    public Object clone() {
        return new CombinedHash(this);
    }

    @Override
    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

