/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JRubyExecutionContextLocal
extends RubyObject {
    private IRubyObject default_value;
    private RubyProc default_proc;

    public JRubyExecutionContextLocal(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.default_value = runtime2.getNil();
        this.default_proc = null;
    }

    @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            if (args2.length != 0) {
                throw context.runtime.newArgumentError("wrong number of arguments");
            }
            this.default_proc = block.getProcObject();
            if (this.default_proc == null) {
                this.default_proc = RubyProc.newProc(context.runtime, block, block.type);
            }
        } else if (args2.length == 1) {
            this.default_value = args2[0];
        } else if (args2.length != 0) {
            throw context.runtime.newArgumentError("wrong number of arguments");
        }
        return context.nil;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject getDefault() {
        return this.default_value;
    }

    @JRubyMethod(name={"default_proc"})
    public IRubyObject getDefaultProc() {
        return this.default_proc != null ? this.default_proc : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"value"}, required=0)
    public IRubyObject getValue(ThreadContext context) {
        Map<Object, IRubyObject> contextVariables = this.getContextVariables(context);
        IRubyObject value2 = contextVariables.get(this);
        if (value2 != null) {
            return value2;
        }
        if (this.default_proc != null) {
            contextVariables.put(this, context.nil);
            IRubyObject new_value = this.default_proc.call(context, IRubyObject.NULL_ARRAY);
            contextVariables.put(this, new_value);
            return new_value;
        }
        return this.default_value;
    }

    @JRubyMethod(name={"value="}, required=1)
    public IRubyObject setValue(ThreadContext context, IRubyObject value2) {
        this.getContextVariables(context).put(this, value2);
        return value2;
    }

    protected final Map<Object, IRubyObject> getContextVariables(ThreadContext context) {
        return this.getExecutionContext(context).getContextVariables();
    }

    protected abstract ExecutionContext getExecutionContext(ThreadContext var1);
}

