/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import java.math.RoundingMode;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Integer"}, parent="Numeric", overrides={RubyFixnum.class, RubyBignum.class})
public abstract class RubyInteger
extends RubyNumeric {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    static final ByteList[] SINGLE_CHAR_BYTELISTS;
    @Deprecated
    public static final ByteList[] SINGLE_CHAR_BYTELISTS19;
    static final ByteList[] SINGLE_CHAR_UTF8_BYTELISTS;
    private static final long HALF_LONG_MSB = 0x80000000L;

    public static RubyClass createIntegerClass(Ruby runtime2) {
        RubyClass integer = runtime2.defineClass("Integer", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        integer.setClassIndex(ClassIndex.INTEGER);
        integer.setReifiedClass(RubyInteger.class);
        integer.kindOf = new RubyModule.JavaClassKindOf(RubyInteger.class);
        integer.getSingletonClass().undefineMethod("new");
        integer.defineAnnotatedMethods(RubyInteger.class);
        return integer;
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyInteger(RubyClass rubyClass) {
        super(rubyClass);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime2, rubyClass, useObjectSpace);
    }

    @Deprecated
    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, rubyClass, useObjectSpace, canBeTainted);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.metaClass.runtime, this.getDoubleValue());
    }

    public int signum() {
        return this.getBigIntegerValue().signum();
    }

    public RubyInteger negate() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return RubyInteger.sites((ThreadContext)context).op_uminus.call(context, this, this).convertToInteger();
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isNegative());
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isPositive());
    }

    @Override
    public boolean isNegative() {
        return this.signum() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.signum() > 0;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject sqrt(ThreadContext context, IRubyObject self2, IRubyObject num) {
        return num.convertToInteger().sqrt(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject self2, IRubyObject num) {
        return TypeConverter.checkIntegerType(context, num);
    }

    public abstract IRubyObject sqrt(ThreadContext var1);

    public static final long floorSqrt(long x) {
        if ((x & 0xFFF0000000000000L) == 0L) {
            return (long)StrictMath.sqrt(x);
        }
        long result2 = (long)StrictMath.sqrt(2.0 * (double)(x >>> 1));
        return result2 * result2 - x > 0L ? result2 - 1L : result2;
    }

    public static final BigInteger floorSqrt(BigInteger x) {
        if (x == null) {
            return null;
        }
        int zeroCompare = x.compareTo(BigInteger.ZERO);
        if (zeroCompare < 0) {
            return null;
        }
        if (zeroCompare == 0) {
            return BigInteger.ZERO;
        }
        int bit = Math.max(0, x.bitLength() - 63 & 0xFFFFFFFE);
        BigInteger result2 = BigInteger.valueOf(RubyInteger.floorSqrt(x.shiftRight(bit).longValue()) & 0xFFFFFFFFL);
        result2 = result2.shiftLeft(bit >>>= 1);
        while (bit != 0) {
            BigInteger resultHigh;
            if ((resultHigh = result2.setBit(--bit)).multiply(resultHigh).compareTo(x) > 0) continue;
            result2 = resultHigh;
        }
        return result2;
    }

    @Override
    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.metaClass.runtime.getTrue();
    }

    @JRubyMethod
    public IRubyObject upto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumUpto(context, ((RubyFixnum)this).value, ((RubyFixnum)to).value, block);
            } else {
                RubyInteger.duckUpto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "upto", new IRubyObject[]{to}, RubyInteger::uptoSize);
    }

    static void fixnumUpto(ThreadContext context, long from, long to, Block block) {
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = context.nil;
            for (i2 = from; i2 < to; ++i2) {
                block.yield(context, nil);
                context.pollThreadEvents();
            }
            if (i2 <= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            Ruby runtime2 = context.runtime;
            for (i3 = from; i3 < to; ++i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
                context.pollThreadEvents();
            }
            if (i3 <= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
            }
        }
    }

    static void duckUpto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime2 = context.runtime;
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(runtime2);
        while (!RubyInteger.sites((ThreadContext)context).op_gt.call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            i2 = RubyInteger.sites((ThreadContext)context).op_plus.call(context, i2, i2, (IRubyObject)one);
        }
    }

    private static IRubyObject uptoSize(ThreadContext context, IRubyObject from, IRubyObject[] args2) {
        return RubyInteger.intervalStepSize(context, from, args2[0], RubyFixnum.one(context.runtime), false);
    }

    @JRubyMethod
    public IRubyObject downto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumDownto(context, ((RubyFixnum)this).value, ((RubyFixnum)to).value, block);
            } else {
                RubyInteger.duckDownto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "downto", new IRubyObject[]{to}, RubyInteger::downtoSize);
    }

    private static void fixnumDownto(ThreadContext context, long from, long to, Block block) {
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = context.nil;
            for (i2 = from; i2 > to; --i2) {
                block.yield(context, nil);
            }
            if (i2 >= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            Ruby runtime2 = context.runtime;
            for (i3 = from; i3 > to; --i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
            }
            if (i3 >= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i3));
            }
        }
    }

    private static void duckDownto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(context.runtime);
        while (!RubyInteger.sites((ThreadContext)context).op_lt.call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            i2 = RubyInteger.sites((ThreadContext)context).op_minus.call(context, i2, i2, (IRubyObject)one);
        }
    }

    private static IRubyObject downtoSize(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyInteger.intervalStepSize(context, recv2, args2[0], RubyFixnum.newFixnum(context.runtime, -1L), false);
    }

    @JRubyMethod
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            Ruby runtime2 = context.runtime;
            IRubyObject i2 = RubyFixnum.zero(runtime2);
            RubyFixnum one = RubyFixnum.one(runtime2);
            while (((RubyInteger)i2).op_lt(context, this).isTrue()) {
                block.yield(context, i2);
                i2 = ((RubyInteger)i2).op_plus(context, one);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "times", RubyInteger::timesSize);
    }

    protected static IRubyObject timesSize(ThreadContext context, RubyInteger recv2, IRubyObject[] args2) {
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        if (recv2 instanceof RubyFixnum && recv2.getLongValue() < 0L || RubyInteger.sites((ThreadContext)context).op_lt.call(context, (IRubyObject)recv2, (IRubyObject)recv2, (IRubyObject)zero).isTrue()) {
            return zero;
        }
        return recv2;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        if (this instanceof RubyFixnum) {
            return ((RubyFixnum)this).op_plus_one(context);
        }
        if (this instanceof RubyBignum) {
            return ((RubyBignum)this).op_plus(context, 1L);
        }
        return RubyInteger.numFuncall(context, this, RubyInteger.sites((ThreadContext)context).op_plus, RubyFixnum.one(context.runtime));
    }

    public static ByteList singleCharByteList(byte index2) {
        return SINGLE_CHAR_BYTELISTS[index2 & 0xFF];
    }

    public static ByteList singleCharUTF8ByteList(byte index2) {
        return SINGLE_CHAR_UTF8_BYTELISTS[index2 & 0xFF];
    }

    public static RubyString singleCharString(Ruby runtime2, byte b2, RubyClass meta, Encoding enc) {
        ByteList bytes2;
        if (enc == USASCIIEncoding.INSTANCE) {
            bytes2 = RubyInteger.singleCharByteList(b2);
        } else if ((b2 & 0xFF) < 128 && enc == RubyString.UTF8) {
            bytes2 = RubyInteger.singleCharUTF8ByteList(b2);
        } else {
            return new RubyString(runtime2, meta, new ByteList(new byte[]{b2}, enc));
        }
        return RubyString.newStringShared(runtime2, meta, bytes2);
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        long i2 = this.getLongValue() & 0xFFFFFFFFL;
        int c = (int)i2;
        if (i2 > 255L) {
            Encoding enc = runtime2.getDefaultInternalEncoding();
            if (enc == null) {
                throw runtime2.newRangeError(this.toString() + " out of char range");
            }
            return this.chrCommon(context, c, enc);
        }
        return RubyString.newStringShared(runtime2, SINGLE_CHAR_BYTELISTS[c]);
    }

    @Deprecated
    public final RubyString chr19(ThreadContext context) {
        return this.chr(context);
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        long i2 = this.getLongValue() & 0xFFFFFFFFL;
        Encoding enc = arg2 instanceof RubyEncoding ? ((RubyEncoding)arg2).getEncoding() : arg2.convertToString().toEncoding(runtime2);
        return this.chrCommon(context, i2, enc);
    }

    @Deprecated
    public RubyString chr19(ThreadContext context, IRubyObject arg2) {
        return this.chr(context, arg2);
    }

    private RubyString chrCommon(ThreadContext context, long value2, Encoding enc) {
        if (value2 > 0xFFFFFFFFL) {
            throw context.runtime.newRangeError(this + " out of char range");
        }
        int c = (int)value2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        return EncodingUtils.encUintChr(context, c, enc);
    }

    @JRubyMethod(name={"ord"})
    public IRubyObject ord(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_i", "to_int"})
    public IRubyObject to_i() {
        return this;
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"ceil"}, required=1)
    public abstract IRubyObject ceil(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"floor"}, required=1)
    public abstract IRubyObject floor(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public abstract IRubyObject truncate(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject _digits) {
        return this.round(context, _digits, context.nil);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject digits2, IRubyObject _opts) {
        Ruby runtime2 = context.runtime;
        IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, _opts);
        int ndigits = RubyInteger.num2int(digits2);
        RoundingMode roundingMode = RubyInteger.getRoundingMode(context, opts);
        if (ndigits >= 0) {
            return this;
        }
        return this.roundShared(context, ndigits, roundingMode);
    }

    public IRubyObject round(ThreadContext context, int ndigits) {
        return this.roundShared(context, ndigits, RoundingMode.HALF_UP);
    }

    public RubyNumeric roundShared(ThreadContext context, int ndigits, RoundingMode roundingMode) {
        Ruby runtime2 = context.runtime;
        if (this.int_round_zero_p(context, ndigits)) {
            return RubyFixnum.zero(runtime2);
        }
        RubyNumeric f = Numeric.int_pow(context, 10L, -ndigits);
        if (this instanceof RubyFixnum && f instanceof RubyFixnum) {
            boolean neg;
            long x = RubyInteger.fix2long(this);
            long y = RubyInteger.fix2long(f);
            boolean bl = neg = x < 0L;
            if (neg) {
                x = -x;
            }
            x = RubyInteger.doRound(context, roundingMode, x, y);
            if (neg) {
                x = -x;
            }
            return RubyFixnum.newFixnum(runtime2, x);
        }
        if (f instanceof RubyFloat) {
            return RubyFixnum.zero(runtime2);
        }
        RubyNumeric h = (RubyNumeric)f.idiv(context, 2L);
        RubyNumeric r = (RubyNumeric)this.op_mod(context, f);
        RubyNumeric n = (RubyNumeric)this.op_minus(context, r);
        if ((r = (RubyNumeric)r.op_cmp(context, h)).isPositive(context).isTrue() || r.isZero() && RubyInteger.doRoundCheck(context, roundingMode, this, n, f)) {
            n = (RubyNumeric)n.op_plus(context, f);
        }
        return n;
    }

    private static long doRound(ThreadContext context, RoundingMode roundingMode, long n, long f) {
        switch (roundingMode) {
            case HALF_UP: {
                return RubyInteger.int_round_half_up(n, f);
            }
            case HALF_DOWN: {
                return RubyInteger.int_round_half_down(n, f);
            }
            case HALF_EVEN: {
                return RubyInteger.int_round_half_even(n, f);
            }
        }
        throw context.runtime.newArgumentError("invalid rounding mode: " + (Object)((Object)roundingMode));
    }

    private static boolean doRoundCheck(ThreadContext context, RoundingMode roundingMode, RubyInteger num, RubyNumeric n, IRubyObject f) {
        switch (roundingMode) {
            case HALF_UP: {
                return RubyInteger.int_half_p_half_up(context, num, n, f);
            }
            case HALF_DOWN: {
                return RubyInteger.int_half_p_half_down(context, num, n, f);
            }
            case HALF_EVEN: {
                return RubyInteger.int_half_p_half_even(context, num, n, f);
            }
        }
        throw context.runtime.newArgumentError("invalid rounding mode: " + (Object)((Object)roundingMode));
    }

    protected boolean int_round_zero_p(ThreadContext context, int ndigits) {
        long bytes2 = RubyInteger.num2long(RubyInteger.sites((ThreadContext)context).size.call(context, this, this));
        return -0.415241 * (double)ndigits - 0.125 > (double)bytes2;
    }

    protected static long int_round_half_even(long x, long y) {
        long z = (x + y / 2L) / y;
        if ((z * y - x) * 2L == y) {
            z &= 0xFFFFFFFFFFFFFFFEL;
        }
        return z * y;
    }

    protected static long int_round_half_up(long x, long y) {
        return (x + y / 2L) / y * y;
    }

    protected static long int_round_half_down(long x, long y) {
        return (x + y / 2L - 1L) / y * y;
    }

    protected static boolean int_half_p_half_even(ThreadContext context, RubyInteger num, RubyNumeric n, IRubyObject f) {
        return n.div(context, f).convertToInteger().odd_p(context).isTrue();
    }

    protected static boolean int_half_p_half_up(ThreadContext context, RubyInteger num, RubyNumeric n, IRubyObject f) {
        return num.isPositive(context).isTrue();
    }

    protected static boolean int_half_p_half_down(ThreadContext context, RubyInteger num, RubyNumeric n, IRubyObject f) {
        return num.isNegative(context).isTrue();
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this);
    }

    @JRubyMethod(name={"rationalize"}, optional=1)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        return this.to_r(context);
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p(ThreadContext context) {
        return RubyInteger.op_mod_two(context, this) != 0L ? context.tru : context.fals;
    }

    @JRubyMethod(name={"even?"})
    public RubyBoolean even_p(ThreadContext context) {
        return RubyInteger.op_mod_two(context, this) == 0L ? context.tru : context.fals;
    }

    private static long op_mod_two(ThreadContext context, RubyInteger self2) {
        return ((RubyInteger)RubyInteger.sites((ThreadContext)context).op_mod.call(context, (IRubyObject)self2, (IRubyObject)self2, (IRubyObject)RubyFixnum.two(context.runtime))).getLongValue();
    }

    @JRubyMethod(name={"allbits?"})
    public IRubyObject allbits_p(ThreadContext context, IRubyObject other) {
        IRubyObject mask = TypeConverter.checkToInteger(context, other);
        return ((RubyInteger)this.op_and(context, mask)).op_equal(context, mask);
    }

    @JRubyMethod(name={"anybits?"})
    public IRubyObject anybits_p(ThreadContext context, IRubyObject other) {
        IRubyObject mask = TypeConverter.checkToInteger(context, other);
        return ((RubyInteger)this.op_and(context, mask)).zero_p(context).isTrue() ? context.fals : context.tru;
    }

    @JRubyMethod(name={"nobits?"})
    public IRubyObject nobits_p(ThreadContext context, IRubyObject other) {
        IRubyObject mask = TypeConverter.checkToInteger(context, other);
        return ((RubyInteger)this.op_and(context, mask)).zero_p(context);
    }

    @JRubyMethod(name={"pred"})
    public IRubyObject pred(ThreadContext context) {
        return RubyInteger.numFuncall(context, this, RubyInteger.sites((ThreadContext)context).op_minus, RubyFixnum.one(context.runtime));
    }

    @JRubyMethod(name={"gcd"})
    public IRubyObject gcd(ThreadContext context, IRubyObject other) {
        return Numeric.f_gcd(context, this, RubyInteger.intValue(context, other));
    }

    @Override
    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject y) {
        IRubyObject gcd2;
        RubyInteger x = this;
        if (y instanceof RubyInteger && !Numeric.f_zero_p(context, y) && !Numeric.f_zero_p(context, gcd2 = this.gcd(context, y))) {
            x = (RubyInteger)x.idiv(context, gcd2);
            y = ((RubyInteger)y).idiv(context, gcd2);
        }
        return x.fdivDouble(context, y);
    }

    public abstract IRubyObject fdivDouble(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"lcm"})
    public IRubyObject lcm(ThreadContext context, IRubyObject other) {
        return Numeric.f_lcm(context, this, RubyInteger.intValue(context, other));
    }

    @JRubyMethod(name={"gcdlcm"})
    public IRubyObject gcdlcm(ThreadContext context, IRubyObject other) {
        RubyInteger otherInt = RubyInteger.intValue(context, other);
        return context.runtime.newArray((IRubyObject)Numeric.f_gcd(context, this, otherInt), Numeric.f_lcm(context, this, otherInt));
    }

    static RubyInteger intValue(ThreadContext context, IRubyObject num) {
        RubyInteger i2 = RubyInteger.toInteger(context, num);
        if (i2 == null) {
            throw context.runtime.newTypeError("not an integer");
        }
        return i2;
    }

    static RubyInteger toInteger(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyInteger) {
            return (RubyInteger)num;
        }
        if (num instanceof RubyNumeric && !RubyInteger.integer_p(context).call(context, num, num).isTrue()) {
            return null;
        }
        if (num instanceof RubyString) {
            return null;
        }
        return (RubyInteger)num.checkCallMethod(context, RubyInteger.sites((ThreadContext)context).to_i_checked);
    }

    @JRubyMethod(name={"digits"})
    public RubyArray digits(ThreadContext context) {
        return this.digits(context, RubyFixnum.newFixnum(context.runtime, 10L));
    }

    @JRubyMethod(name={"digits"})
    public abstract RubyArray digits(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    @Override
    @JRubyMethod(name={"to_s", "inspect"})
    public abstract RubyString to_s();

    @JRubyMethod(name={"to_s"})
    public abstract RubyString to_s(IRubyObject var1);

    @Override
    @JRubyMethod(name={"-@"})
    public abstract IRubyObject op_uminus(ThreadContext var1);

    @Override
    @JRubyMethod(name={"+"})
    public abstract IRubyObject op_plus(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_plus(ThreadContext context, long other) {
        return this.op_plus(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @Override
    @JRubyMethod(name={"-"})
    public abstract IRubyObject op_minus(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_minus(ThreadContext context, long other) {
        return this.op_minus(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @JRubyMethod(name={"*"})
    public abstract IRubyObject op_mul(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_mul(ThreadContext context, long other) {
        return this.op_mul(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @Override
    @JRubyMethod(name={"div"})
    public abstract IRubyObject idiv(ThreadContext var1, IRubyObject var2);

    public final IRubyObject div_div(ThreadContext context, IRubyObject other) {
        return this.div(context, other);
    }

    @JRubyMethod(name={"/"})
    public abstract IRubyObject op_div(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"%", "modulo"})
    public abstract IRubyObject op_mod(ThreadContext var1, IRubyObject var2);

    public IRubyObject op_mod(ThreadContext context, long other) {
        return this.op_mod(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @JRubyMethod(name={"**"})
    public abstract IRubyObject op_pow(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"pow"})
    public IRubyObject pow(ThreadContext context, IRubyObject other) {
        return RubyInteger.sites((ThreadContext)context).op_pow.call(context, (IRubyObject)this, (IRubyObject)this, other);
    }

    @JRubyMethod(name={"pow"})
    public IRubyObject pow(ThreadContext context, IRubyObject b2, IRubyObject m) {
        Ruby runtime2 = context.runtime;
        boolean negaFlg = false;
        if (!(b2 instanceof RubyInteger)) {
            throw runtime2.newTypeError("Integer#pow() 2nd argument not allowed unless a 1st argument is integer");
        }
        if (((RubyInteger)b2).isNegative()) {
            throw runtime2.newRangeError("Integer#pow() 1st argument cannot be negative when 2nd argument specified");
        }
        if (!(m instanceof RubyInteger)) {
            throw runtime2.newTypeError("Integer#pow() 2nd argument not allowed unless all arguments are integers");
        }
        if (((RubyInteger)m).isNegative()) {
            m = ((RubyInteger)m).negate();
            negaFlg = true;
        }
        if (!((RubyInteger)m).isPositive()) {
            throw runtime2.newZeroDivisionError();
        }
        if (m instanceof RubyFixnum) {
            long mm = ((RubyFixnum)m).value;
            if (mm == 1L) {
                return RubyFixnum.zero(runtime2);
            }
            RubyFixnum modulo2 = (RubyFixnum)this.modulo(context, m);
            if (mm <= 0x80000000L) {
                return modulo2.intPowTmp1(context, (RubyInteger)b2, mm, negaFlg);
            }
            return modulo2.intPowTmp2(context, (RubyInteger)b2, mm, negaFlg);
        }
        if (m instanceof RubyBignum) {
            if (((RubyBignum)m).value == BigInteger.ONE) {
                return RubyFixnum.zero(runtime2);
            }
            return ((RubyInteger)this.modulo(context, m)).intPowTmp3(context, (RubyInteger)b2, (RubyBignum)m, negaFlg);
        }
        throw new AssertionError((Object)("BUG: unexpected type " + m.getType()));
    }

    protected IRubyObject intPowTmp3(ThreadContext context, RubyInteger y, RubyBignum m, boolean negaFlg) {
        BigInteger mn;
        BigInteger yn;
        BigInteger xn = this.getBigIntegerValue();
        BigInteger zn = xn.modPow(yn = y.getBigIntegerValue(), mn = m.getBigIntegerValue());
        if (negaFlg & zn.signum() == 1) {
            zn = zn.negate();
        }
        return RubyBignum.bignorm(context.runtime, zn);
    }

    @Override
    @JRubyMethod(name={"abs"})
    public abstract IRubyObject abs(ThreadContext var1);

    @Override
    @JRubyMethod(name={"magnitude"})
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    @JRubyMethod(name={"==", "==="})
    public abstract IRubyObject op_equal(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"<=>"})
    public abstract IRubyObject op_cmp(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"~"})
    public abstract IRubyObject op_neg(ThreadContext var1);

    @JRubyMethod(name={"&"})
    public abstract IRubyObject op_and(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"|"})
    public abstract IRubyObject op_or(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"^"})
    public abstract IRubyObject op_xor(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject index2) {
        if (index2 instanceof RubyRange) {
            RubyRange range = (RubyRange)index2;
            IRubyObject beg = range.begin(context);
            IRubyObject end2 = range.end(context);
            boolean isExclusive = range.isExcludeEnd();
            if (!end2.isNil()) {
                end2 = end2.convertToInteger();
            }
            if (beg.isNil()) {
                if (!RubyInteger.negativeInt(context, end2)) {
                    RubyInteger mask;
                    if (!isExclusive) {
                        end2 = ((RubyInteger)end2).op_plus(context, context.runtime.newFixnum(1));
                    }
                    if (((RubyInteger)this.op_and(context, mask = this.generateMask(context, end2))).isZero()) {
                        return context.runtime.newFixnum(0);
                    }
                    throw context.runtime.newArgumentError("The beginless range for Integer#[] results in infinity");
                }
                return context.runtime.newFixnum(0);
            }
            beg = beg.convertToInteger();
            IRubyObject num = this.op_rshift(context, beg);
            long cmp2 = RubyInteger.compareIndexes(context, beg, end2);
            if (!end2.isNil() && cmp2 < 0L) {
                IRubyObject length2 = ((RubyInteger)end2).op_minus(context, beg);
                if (!isExclusive) {
                    length2 = ((RubyInteger)length2).op_plus(context, context.runtime.newFixnum(1));
                }
                RubyInteger mask = this.generateMask(context, length2);
                num = ((RubyInteger)num).op_and(context, mask);
                return num;
            }
            if (cmp2 == 0L) {
                if (isExclusive) {
                    return context.runtime.newFixnum(0);
                }
                index2 = beg;
            } else {
                return num;
            }
        }
        return this.op_aref_subclass(context, index2);
    }

    private static long compareIndexes(ThreadContext context, IRubyObject beg, IRubyObject end2) {
        IRubyObject r = beg.callMethod(context, "<=>", end2);
        if (r.isNil()) {
            return Long.MAX_VALUE;
        }
        JavaSites.IntegerSites sites = RubyInteger.sites(context);
        return RubyComparable.cmpint(context, sites.op_gt, sites.op_lt, r, beg, end2);
    }

    protected abstract IRubyObject op_aref_subclass(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject index2, IRubyObject length2) {
        IRubyObject num = this.op_rshift(context, index2);
        RubyInteger mask = this.generateMask(context, length2);
        return ((RubyInteger)num).op_and(context, mask);
    }

    RubyInteger generateMask(ThreadContext context, IRubyObject length2) {
        RubyFixnum one = context.runtime.newFixnum(1);
        return (RubyInteger)((RubyInteger)one.op_lshift(context, length2)).op_minus(context, one);
    }

    @JRubyMethod(name={"<<"})
    public abstract IRubyObject op_lshift(ThreadContext var1, IRubyObject var2);

    public RubyInteger op_lshift(ThreadContext context, long other) {
        return (RubyInteger)this.op_lshift(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @JRubyMethod(name={">>"})
    public abstract IRubyObject op_rshift(ThreadContext var1, IRubyObject var2);

    public RubyInteger op_rshift(ThreadContext context, long other) {
        return (RubyInteger)this.op_rshift(context, RubyFixnum.newFixnum(context.runtime, other));
    }

    @JRubyMethod(name={"to_f"})
    public abstract IRubyObject to_f(ThreadContext var1);

    @JRubyMethod(name={"size"})
    public abstract IRubyObject size(ThreadContext var1);

    @Override
    @JRubyMethod(name={"zero?"})
    public abstract IRubyObject zero_p(ThreadContext var1);

    @JRubyMethod(name={"bit_length"})
    public abstract IRubyObject bit_length(ThreadContext var1);

    boolean isOne() {
        return this.getBigIntegerValue().equals(BigInteger.ONE);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_lt(context, this, other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return RubyComparable.op_le(context, this, other);
    }

    @Override
    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject dividend) {
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    public IRubyObject op_uminus() {
        return this.op_uminus(this.getRuntime().getCurrentContext());
    }

    public IRubyObject op_neg() {
        return this.to_f(this.getRuntime().getCurrentContext());
    }

    public IRubyObject op_aref(IRubyObject other) {
        return this.op_aref(this.getRuntime().getCurrentContext(), other);
    }

    @Deprecated
    public IRubyObject op_lshift(IRubyObject other) {
        return this.op_lshift(this.getRuntime().getCurrentContext(), other);
    }

    @Deprecated
    public IRubyObject op_rshift(IRubyObject other) {
        return this.op_rshift(this.getRuntime().getCurrentContext(), other);
    }

    public IRubyObject to_f() {
        return this.to_f(this.getRuntime().getCurrentContext());
    }

    public IRubyObject size() {
        return this.size(this.getRuntime().getCurrentContext());
    }

    private static CallSite integer_p(ThreadContext context) {
        return context.sites.Numeric.integer;
    }

    private static JavaSites.IntegerSites sites(ThreadContext context) {
        return context.sites.Integer;
    }

    @Deprecated
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return other.callMethod(context, "to_i");
        }
        throw context.runtime.newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }

    @Override
    @Deprecated
    public IRubyObject round() {
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject ceil() {
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject floor() {
        return this;
    }

    @Override
    @Deprecated
    public IRubyObject truncate() {
        return this;
    }

    @Deprecated
    public final IRubyObject round19() {
        return this.round(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public final IRubyObject round19(ThreadContext context, IRubyObject arg2) {
        return this.round(context, arg2);
    }

    @Deprecated
    public final IRubyObject op_idiv(ThreadContext context, IRubyObject arg2) {
        return this.div(context, arg2);
    }

    static {
        ByteList bytes2;
        int i2;
        SINGLE_CHAR_BYTELISTS = new ByteList[256];
        for (i2 = 0; i2 < 256; ++i2) {
            RubyInteger.SINGLE_CHAR_BYTELISTS[i2] = bytes2 = new ByteList(new byte[]{(byte)i2}, false);
            bytes2.setEncoding(i2 < 128 ? USASCIIEncoding.INSTANCE : ASCIIEncoding.INSTANCE);
        }
        SINGLE_CHAR_BYTELISTS19 = SINGLE_CHAR_BYTELISTS;
        SINGLE_CHAR_UTF8_BYTELISTS = new ByteList[128];
        for (i2 = 0; i2 < 128; ++i2) {
            RubyInteger.SINGLE_CHAR_UTF8_BYTELISTS[i2] = bytes2 = new ByteList(new byte[]{(byte)i2}, false);
            bytes2.setEncoding(UTF8Encoding.INSTANCE);
        }
    }
}

