/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.SplitSuperState;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.ReifiedJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ConcreteJavaProxy
extends JavaProxy {
    public ConcreteJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public ConcreteJavaProxy(Ruby runtime2, RubyClass klazz, Object object) {
        super(runtime2, klazz, object);
    }

    public static RubyClass createConcreteJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass JavaProxy2 = runtime2.getJavaSupport().getJavaProxyClass();
        RubyClass ConcreteJavaProxy2 = runtime2.defineClass("ConcreteJavaProxy", JavaProxy2, ConcreteJavaProxy::new);
        ConcreteJavaProxy.initialize(ConcreteJavaProxy2);
        return ConcreteJavaProxy2;
    }

    public static int findSuperLine(Ruby runtime2, DynamicMethod dm, int start2) {
        return start2;
    }

    public SplitCtorData splitInitialized(RubyClass base, IRubyObject[] args2, Block blk, Java.JCtorCache jcc) {
        DynamicMethod dm1;
        String name2 = base.getClassConfig().javaCtorMethodName;
        DynamicMethod dm = base.searchMethod(name2);
        if (dm instanceof StaticJCreateMethod) {
            dm = ((StaticJCreateMethod)dm).oldInit;
        }
        if ((dm1 = base.searchMethodLateral(name2)) != null && !(dm instanceof InitializeMethod) && !(dm instanceof StaticJCreateMethod)) {
            AbstractIRMethod air = (AbstractIRMethod)dm;
            SplitSuperState state2 = air.startSplitSuperCall(this.getRuntime().getCurrentContext(), this, this.getMetaClass(), name2, args2, blk);
            if (state2 == null) {
                return new SplitCtorData(this.getRuntime(), args2, jcc, air, name2, blk);
            }
            return new SplitCtorData(this.getRuntime(), state2.callArrayArgs.toJavaArrayMaybeUnsafe(), jcc, air, state2, blk);
        }
        return new SplitCtorData(this.getRuntime(), args2, jcc);
    }

    public void finishInitialize(SplitCtorData returned) {
        if (returned.method != null) {
            if (returned.state != null) {
                returned.method.finishSplitCall(returned.state);
            } else {
                returned.method.call(this.getRuntime().getCurrentContext(), (IRubyObject)this, (RubyModule)this.getMetaClass(), returned.name, returned.rbarguments, returned.block);
            }
        }
    }

    public void ensureThis(Object self2) {
        if (this.getObject() == null) {
            this.setObject(self2);
        }
    }

    protected static void initialize(RubyClass concreteJavaProxy) {
        concreteJavaProxy.addMethod("initialize", new InitializeMethod(concreteJavaProxy));
        RubyClass singleton = concreteJavaProxy.getSingletonClass();
        singleton.addMethod("new", new NewMethod(singleton));
    }

    @Override
    public IRubyObject id() {
        return this.getRuntime().newFixnum(System.identityHashCode(this.getObject()));
    }

    @Override
    public <T> T toJava(Class<T> type2) {
        Object object = this.getObject();
        if (object == null) {
            throw this.getRuntime().newRuntimeError("Java proxy not initialized. Did you call super() yet?");
        }
        Class<?> clazz = object.getClass();
        if (type2.isPrimitive()) {
            if (type2 == Void.TYPE) {
                return null;
            }
            if (object instanceof Number && type2 != Boolean.TYPE || object instanceof Character && type2 == Character.TYPE || object instanceof Boolean && type2 == Boolean.TYPE) {
                return (T)object;
            }
        } else {
            if (type2.isAssignableFrom(clazz)) {
                if (Java.OBJECT_PROXY_CACHE || this.metaClass.getCacheProxy()) {
                    this.getRuntime().getJavaSupport().getObjectProxyCache().put(object, this);
                }
                return type2.cast(object);
            }
            if (type2.isAssignableFrom(this.getClass())) {
                return type2.cast(this);
            }
        }
        throw this.getRuntime().newTypeError("failed to coerce " + clazz.getName() + " to " + type2.getName());
    }

    public static final class SplitCtorData {
        public final Object[] arguments;
        public final int ctorIndex;
        public final IRubyObject[] rbarguments;
        public final Block block;
        private final AbstractIRMethod method;
        private final String name;
        private final SplitSuperState<?> state;

        SplitCtorData(Ruby runtime2, IRubyObject[] args2, Java.JCtorCache cache) {
            this(runtime2, args2, cache, null, null, null, Block.NULL_BLOCK);
        }

        SplitCtorData(Ruby runtime2, IRubyObject[] args2, Java.JCtorCache cache, AbstractIRMethod method2, SplitSuperState<?> state2, Block block) {
            this(runtime2, args2, cache, method2, null, state2, block);
        }

        SplitCtorData(Ruby runtime2, IRubyObject[] args2, Java.JCtorCache cache, AbstractIRMethod method2, String name2, Block block) {
            this(runtime2, args2, cache, method2, name2, null, block);
        }

        private SplitCtorData(Ruby runtime2, IRubyObject[] args2, Java.JCtorCache cache, AbstractIRMethod method2, String name2, SplitSuperState<?> state2, Block block) {
            this.rbarguments = args2;
            if (cache == null) {
                this.ctorIndex = -1;
                this.arguments = null;
            } else {
                this.ctorIndex = Java.JCreateMethod.forTypes(runtime2, args2, cache);
                this.arguments = RubyToJavaInvoker.convertArguments(cache.constructors[this.ctorIndex], args2);
            }
            this.method = method2;
            this.name = name2;
            this.state = state2;
            this.block = block;
        }
    }

    public static final class NewMethodReified
    extends JavaMethod.JavaMethodNBlock {
        private final DynamicMethod initialize;
        private final Constructor<? extends ReifiedJavaProxy> ctor;

        public NewMethodReified(RubyClass clazz, Class<? extends ReifiedJavaProxy> reified) {
            super((RubyModule)clazz, Visibility.PUBLIC, "new");
            Constructor<? extends ReifiedJavaProxy> withBlock;
            this.initialize = clazz.searchMethod("__jcreate!");
            try {
                Class _clazz = Map.class.isAssignableFrom(reified) ? MapJavaProxy.class : ConcreteJavaProxy.class;
                withBlock = reified.getConstructor(_clazz, IRubyObject[].class, Block.class, Ruby.class, RubyClass.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                withBlock = null;
            }
            this.ctor = withBlock;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block blk) {
            if (self2 != this.implementationClass) {
                return new NewMethod((RubyClass)self2).call(context, self2, clazz, name2, args2, blk);
            }
            if (this.ctor == null) {
                ReifiedJavaProxy proxy2 = (ReifiedJavaProxy)JavaUtil.unwrapJava(this.initialize.call(context, self2, clazz, "new", args2));
                return proxy2.___jruby$rubyObject();
            }
            ConcreteJavaProxy object = new ConcreteJavaProxy(context.runtime, (RubyClass)self2);
            try {
                this.ctor.newInstance(object, args2, blk, context.runtime, self2);
                return object;
            }
            catch (InstantiationException | InvocationTargetException e) {
                throw JavaProxyConstructor.throwInstantiationExceptionCause(context.runtime, e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw JavaProxyConstructor.mapInstantiationException(context.runtime, e);
            }
        }
    }

    public static class StaticJCreateMethod
    extends JavaMethod.JavaMethodNBlock {
        private final Constructor<? extends ReifiedJavaProxy> withBlock;
        final DynamicMethod oldInit;

        StaticJCreateMethod(RubyModule cls, Constructor<? extends ReifiedJavaProxy> withBlock, DynamicMethod oldInit) {
            super(cls, Visibility.PUBLIC, "__jcreate_static!");
            this.withBlock = withBlock;
            this.oldInit = oldInit;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            try {
                ConcreteJavaProxy cjp = (ConcreteJavaProxy)self2;
                if (cjp.getObject() == null) {
                    this.withBlock.newInstance(cjp, args2, block, context.runtime, clazz);
                }
            }
            catch (InstantiationException | InvocationTargetException e) {
                throw JavaProxyConstructor.throwInstantiationExceptionCause(context.runtime, e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw JavaProxyConstructor.mapInstantiationException(context.runtime, e);
            }
            return self2;
        }

        public static void tryInstall(Ruby runtime2, RubyClass clazz, JavaProxyClass proxyClass, Class<? extends ReifiedJavaProxy> reified, boolean overwriteInitialize) {
            try {
                Constructor<? extends ReifiedJavaProxy> withBlock = reified.getConstructor(ConcreteJavaProxy.class, IRubyObject[].class, Block.class, Ruby.class, RubyClass.class);
                if (overwriteInitialize) {
                    clazz.addMethod("initialize", new StaticJCreateMethod((RubyModule)clazz, withBlock, clazz.searchMethod("initialize")));
                }
                clazz.addMethod("__jallocate!", new StaticJCreateMethod((RubyModule)clazz, withBlock, null));
            }
            catch (NoSuchMethodException | SecurityException exception2) {
                // empty catch block
            }
        }
    }

    private static final class NewMethod
    extends JavaMethod {
        final DynamicMethod newMethod;

        NewMethod(RubyClass clazz) {
            super((RubyModule)clazz, Visibility.PUBLIC, "new");
            this.newMethod = clazz.searchMethod("new");
        }

        private DynamicMethod reifyAndNewMethod(IRubyObject clazz) {
            RubyClass parent = (RubyClass)clazz;
            if (parent.getJavaProxy()) {
                return this.newMethod;
            }
            if (parent.getReifiedClass() == null) {
                parent.reifyWithAncestors();
                if (parent.getReifiedClass() == null) {
                    throw clazz.getRuntime().newTypeError("requested class " + parent.getName() + " was not reifiable");
                }
            }
            return new NewMethodReified(parent, parent.getReifiedJavaClass());
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new_proxy", args2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", arg0, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", arg0, arg1, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", arg0, arg1, arg2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", args2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new_proxy");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new_proxy", arg0);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", arg0, arg1);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.reifyAndNewMethod(self2).call(context, self2, clazz, "new", arg0, arg1, arg2);
        }
    }

    private static final class InitializeMethod
    extends JavaMethod {
        private final CallSite jcreateSite = MethodIndex.getFunctionalCallSite("__jcreate!");

        InitializeMethod(RubyClass clazz) {
            super((RubyModule)clazz, Visibility.PRIVATE, "initialize");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.jcreateSite.call(context, self2, self2, args2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return this.jcreateSite.call(context, self2, self2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            return this.jcreateSite.call(context, self2, self2, arg0, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.jcreateSite.call(context, self2, self2, arg0, arg1, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.jcreateSite.call(context, self2, self2, arg0, arg1, arg2, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
            return this.jcreateSite.call(context, self2, self2, args2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return this.jcreateSite.call(context, self2, self2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
            return this.jcreateSite.call(context, self2, self2, arg0);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
            return this.jcreateSite.call(context, self2, self2, arg0, arg1);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.jcreateSite.call(context, self2, self2, arg0, arg1, arg2);
        }
    }
}

