/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.Exception;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.RubyStringBuilder;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;
    private final Backtrace backtrace = new Backtrace();
    IRubyObject message;
    private IRubyObject cause = null;
    private RaiseException throwable;
    public static final ObjectAllocator EXCEPTION_ALLOCATOR = RubyException::new;
    private static final ObjectMarshal<RubyException> EXCEPTION_MARSHAL = new ObjectMarshal<RubyException>(){

        @Override
        public void marshalTo(Ruby runtime2, RubyException exc, RubyClass type2, MarshalStream marshalStream) throws IOException {
            marshalStream.registerLinkTarget(exc);
            List<Variable<Object>> attrs = exc.getMarshalVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.getMessage()));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public RubyException unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream input) throws IOException {
            RubyException exc = (RubyException)input.entry(type2.allocate());
            input.ivar(null, exc, null);
            exc.setMessage((IRubyObject)exc.removeInternalVariable("mesg"));
            exc.set_backtrace((IRubyObject)exc.removeInternalVariable("bt"));
            return exc;
        }
    };

    protected RubyException(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyException(Ruby runtime2, RubyClass rubyClass, String message2) {
        super(runtime2, rubyClass);
        this.setMessage(message2 == null ? runtime2.getNil() : runtime2.newString(message2));
    }

    @JRubyMethod(name={"exception"}, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return ((RubyClass)recv2).newInstance(context, args2, block);
    }

    @JRubyMethod(name={"==="}, meta=true)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        Object object;
        Ruby runtime2 = context.runtime;
        if (other instanceof ConcreteJavaProxy && (recv2 == runtime2.getException() || recv2 == runtime2.getStandardError()) && (object = ((ConcreteJavaProxy)other).getObject()) instanceof Throwable && !(object instanceof JumpException.FlowControlException) && (recv2 == runtime2.getException() || object instanceof java.lang.Exception)) {
            return context.tru;
        }
        return ((RubyClass)recv2).op_eqq(context, other);
    }

    protected RaiseException constructThrowable(String message2) {
        return new Exception(message2, this);
    }

    public static RubyClass createExceptionClass(Ruby runtime2) {
        RubyClass exceptionClass = runtime2.defineClass("Exception", runtime2.getObject(), EXCEPTION_ALLOCATOR);
        exceptionClass.setClassIndex(ClassIndex.EXCEPTION);
        exceptionClass.setReifiedClass(RubyException.class);
        exceptionClass.setMarshal(EXCEPTION_MARSHAL);
        exceptionClass.defineAnnotatedMethods(RubyException.class);
        return exceptionClass;
    }

    public static RubyException newException(Ruby runtime2, RubyClass exceptionClass, String msg) {
        if (msg == null) {
            msg = "No message available";
        }
        return (RubyException)exceptionClass.newInstance(runtime2.getCurrentContext(), RubyString.newString(runtime2, msg), Block.NULL_BLOCK);
    }

    public static RubyException newException(ThreadContext context, RubyClass exceptionClass, RubyString message2) {
        return (RubyException)exceptionClass.newInstance(context, message2, Block.NULL_BLOCK);
    }

    public static RubyException newException(ThreadContext context, RubyClass exceptionClass, IRubyObject ... args2) {
        return (RubyException)exceptionClass.newInstance(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject full_message(ThreadContext context) {
        return this.full_message(context, null);
    }

    @JRubyMethod
    public IRubyObject full_message(ThreadContext context, IRubyObject opts) {
        return RubyString.newString(context.runtime, TraceType.printFullMessage(context, this, opts));
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        this.setMessage(arg0);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this;
    }

    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.initialize(this.getRuntime().getCurrentContext());
            }
            case 1: {
                return this.initialize(this.getRuntime().getCurrentContext(), args2[0]);
            }
            case 2: {
                return this.initialize(this.getRuntime().getCurrentContext(), args2[0], args2[1]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 0, 2);
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject obj) {
        this.setBacktrace(obj);
        return this.backtrace();
    }

    public void setBacktrace(IRubyObject obj) {
        if (obj.isNil() || this.isArrayOfStrings(obj)) {
            this.backtrace.backtraceObject = obj;
        } else if (obj instanceof RubyString) {
            this.backtrace.backtraceObject = RubyArray.newArray(this.getRuntime(), obj);
        } else {
            throw this.getRuntime().newTypeError("backtrace must be Array of String");
        }
    }

    @JRubyMethod(omit=true)
    public IRubyObject backtrace_locations(ThreadContext context) {
        IRubyObject backtraceLocations = this.backtrace.backtraceLocations;
        if (backtraceLocations != null) {
            return backtraceLocations;
        }
        return this.backtrace.backtraceLocations = this.backtrace.generateBacktraceLocations(context);
    }

    @JRubyMethod(optional=1, checkArity=false)
    public RubyException exception(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args2[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args2, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        IRubyObject msg = this.getMessage();
        if (!msg.isNil()) {
            return msg.asString();
        }
        return context.runtime.newString(this.getMetaClass().getRealClass().getName());
    }

    @Deprecated
    public IRubyObject to_s19(ThreadContext context) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"message"})
    public IRubyObject message(ThreadContext context) {
        return this.callMethod(context, "to_s");
    }

    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        RubyString rubyClass = this.getMetaClass().getRealClass().rubyName();
        RubyString exception2 = RubyString.objAsString(context, this);
        if (exception2.isEmpty()) {
            return rubyClass;
        }
        return RubyString.newString(context.runtime, RubyStringBuilder.str(context.runtime, "#<", rubyClass, ": ", exception2, ">"));
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        boolean equal = context.runtime.getException().isInstance(other) && this.getMetaClass().getRealClass() == other.getMetaClass().getRealClass() && this.callMethod(context, "message").equals(other.callMethod(context, "message")) && this.callMethod(context, "backtrace").equals(other.callMethod(context, "backtrace"));
        return RubyBoolean.newBoolean(context, equal);
    }

    @JRubyMethod(name={"cause"})
    public IRubyObject cause(ThreadContext context) {
        return this.cause == null ? context.nil : this.cause;
    }

    @Override
    public <T> T toJava(Class<T> target) {
        if (target.isAssignableFrom(RaiseException.class)) {
            return target.cast(this.toThrowable());
        }
        return super.toJava(target);
    }

    public RaiseException toThrowable() {
        if (this.throwable == null) {
            this.throwable = this.constructThrowable(this.getMessageAsJavaString());
            return this.throwable;
        }
        return this.throwable;
    }

    public void setCause(IRubyObject cause2) {
        this.cause = cause2;
        if (cause2 == null || cause2.isNil()) {
            return;
        }
        RaiseException t = this.toThrowable();
        if (((Throwable)t).getCause() == null) {
            Object javaCause;
            if (cause2 instanceof RubyException) {
                t.initCause(((RubyException)cause2).toThrowable());
            } else if (cause2 instanceof ConcreteJavaProxy && (javaCause = ((ConcreteJavaProxy)cause2).getObject()) instanceof Throwable) {
                t.initCause((Throwable)javaCause);
            }
        }
    }

    public Object getCause() {
        return this.cause == this ? null : this.cause;
    }

    public RubyStackTraceElement[] getBacktraceElements() {
        if (this.backtrace.backtraceData == null) {
            return RubyStackTraceElement.EMPTY_ARRAY;
        }
        return this.backtrace.backtraceData.getBacktrace(this.getRuntime());
    }

    public void captureBacktrace(ThreadContext context) {
        this.backtrace.backtraceData = context.runtime.getInstanceConfig().getTraceType().getBacktrace(context);
    }

    public IRubyObject getBacktrace() {
        IRubyObject backtraceObject = this.backtrace.backtraceObject;
        if (backtraceObject != null) {
            return backtraceObject;
        }
        return this.backtrace.backtraceObject = this.backtrace.generateBacktrace(this.getRuntime());
    }

    public static IRubyObject retrieveBacktrace(RubyException exception2) {
        return exception2.backtrace.backtraceObject;
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyException exception2 = (RubyException)clone2;
        exception2.backtrace.copy(this.backtrace);
        exception2.message = this.message;
    }

    public void printBacktrace(PrintStream errorStream) {
        this.printBacktrace(errorStream, 0);
    }

    public void printBacktrace(PrintStream errorStream, int skip2) {
        IRubyObject trace2 = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        TraceType.printBacktraceToStream(trace2, errorStream, skip2);
    }

    private boolean isArrayOfStrings(IRubyObject backtrace2) {
        if (!(backtrace2 instanceof RubyArray)) {
            return false;
        }
        RubyArray rTrace = (RubyArray)backtrace2;
        for (int i2 = 0; i2 < rTrace.getLength(); ++i2) {
            if (rTrace.eltInternal(i2) instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    public IRubyObject getMessage() {
        return this.message == null ? this.getRuntime().getNil() : this.message;
    }

    public void setMessage(IRubyObject message2) {
        this.message = message2;
    }

    public String getMessageAsJavaString() {
        IRubyObject msg = this.getMessage();
        return msg.isNil() ? null : msg.toString();
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        List<Variable<Object>> attrs = super.getVariableList();
        attrs.add(new VariableEntry<IRubyObject>("mesg", this.getMessage()));
        IRubyObject backtrace2 = this.getBacktrace();
        attrs.add(new VariableEntry<IRubyObject>("bt", backtrace2));
        return attrs;
    }

    @Override
    public List<String> getVariableNameList() {
        List<String> names2 = super.getVariableNameList();
        names2.add("mesg");
        names2.add("bt");
        return names2;
    }

    @Deprecated
    public void prepareIntegratedBacktrace(ThreadContext context, StackTraceElement[] javaTrace) {
        if (this.backtrace.backtraceData == null) {
            this.backtrace.backtraceData = context.runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        }
    }

    @Deprecated
    public static IRubyObject newException(ThreadContext context, RubyClass exceptionClass, IRubyObject message2) {
        return RubyException.newException(context, exceptionClass, message2.convertToString());
    }

    private static class Backtrace {
        private BacktraceData backtraceData;
        private IRubyObject backtraceObject;
        private IRubyObject backtraceLocations;

        private Backtrace() {
        }

        public void copy(Backtrace clone2) {
            this.backtraceData = clone2.backtraceData;
            this.backtraceObject = clone2.backtraceObject;
            this.backtraceLocations = clone2.backtraceLocations;
        }

        public IRubyObject generateBacktrace(Ruby runtime2) {
            BacktraceData backtraceData = this.backtraceData;
            if (backtraceData == null || backtraceData == BacktraceData.EMPTY) {
                return runtime2.getNil();
            }
            return TraceType.generateMRIBacktrace(runtime2, backtraceData.getBacktrace(runtime2));
        }

        public IRubyObject generateBacktraceLocations(ThreadContext context) {
            BacktraceData backtraceData = this.backtraceData;
            if (backtraceData == null) {
                return context.nil;
            }
            Ruby runtime2 = context.runtime;
            return RubyThread.Location.newLocationArray(runtime2, backtraceData.getBacktrace(runtime2));
        }
    }
}

