/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import java.util.Objects;
import org.jruby.Ruby;
import org.jruby.ast.LiteralValue;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NumericNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.runtime.builtin.IRubyObject;

public class FloatNode
extends NumericNode
implements ILiteralNode,
LiteralValue,
SideEffectFree {
    private double value;

    public FloatNode(int line, double value2) {
        super(line);
        this.value = value2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FLOATNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitFloatNode(this);
    }

    @Override
    public NumericNode negate() {
        return new FloatNode(this.getLine(), -this.value);
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatNode floatNode = (FloatNode)o;
        return Double.compare(floatNode.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public void setValue(double value2) {
        this.value = value2;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject literalValue(Ruby runtime2) {
        return runtime2.newFloat(this.value);
    }
}

