/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Digest
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static ObjectAllocator DIGEST_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Digest(runtime, klass);
        }
    };
    private MessageDigest algo = null;
    private String name = null;

    public static void createDigest(Ruby runtime, RubyModule mOSSL) {
        runtime.getLoadService().require("digest");
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestClass = mDigest.getClass("Class");
        RubyClass cDigest = mOSSL.defineClassUnder("Digest", cDigestClass, DIGEST_ALLOCATOR);
        cDigest.defineAnnotatedMethods(Digest.class);
        RubyClass openSSLError = mOSSL.getClass("OpenSSLError");
        mOSSL.defineClassUnder("DigestError", openSSLError, openSSLError.getAllocator());
    }

    static MessageDigest getDigest(String name2, Ruby runtime) {
        String algorithm = Digest.transformDigest(name2);
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                return OpenSSLReal.getMessageDigestBC(algorithm);
            }
            catch (GeneralSecurityException ignore) {
                throw runtime.newNotImplementedError("Unsupported digest algorithm (" + name2 + ")");
            }
        }
    }

    private static String transformDigest(String inp) {
        String[] sp = inp.split("::");
        if (sp.length > 1) {
            inp = sp[sp.length - 1];
        }
        if ("DSS".equalsIgnoreCase(inp)) {
            return "SHA";
        }
        if ("DSS1".equalsIgnoreCase(inp)) {
            return "SHA-1";
        }
        if (inp.toUpperCase().startsWith("SHA") && inp.length() > 3 && inp.charAt(3) != '-') {
            inp = "SHA-" + inp.substring(3);
        }
        return inp;
    }

    public Digest(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public String getRealName() {
        return Digest.transformDigest(this.name);
    }

    public String getName() {
        return this.name;
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject type = args[0];
        IRubyObject data = this.getRuntime().getNil();
        if (args.length > 1) {
            data = args[1];
        }
        this.name = type.toString();
        this.algo = Digest.getDigest(this.name, this.getRuntime());
        if (!data.isNil()) {
            this.update((IRubyObject)data.convertToString());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        this.checkFrozen();
        if (this == obj) {
            return this;
        }
        this.name = ((Digest)obj).algo.getAlgorithm();
        try {
            this.algo = (MessageDigest)((Digest)obj).algo.clone();
        }
        catch (CloneNotSupportedException e) {
            throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + this.name + ")");
        }
        return this;
    }

    @JRubyMethod(name={"update", "<<"})
    public IRubyObject update(IRubyObject obj) {
        ByteList bytes = obj.convertToString().getByteList();
        this.algo.update(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize());
        return this;
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.algo.reset();
        return this;
    }

    @JRubyMethod
    public IRubyObject finish() {
        RubyString digest2 = RubyString.newStringNoCopy((Ruby)this.getRuntime(), (byte[])this.algo.digest());
        this.algo.reset();
        return digest2;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    @JRubyMethod
    public IRubyObject digest_length() {
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.algo.getDigestLength());
    }

    @JRubyMethod
    public IRubyObject block_length(ThreadContext context) {
        Ruby runtime = context.runtime;
        BlockLength bl = BlockLength.forAlgorithm(this.algo.getAlgorithm());
        if (bl.getLength() != -1) {
            return runtime.newFixnum(bl.getLength());
        }
        throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
    }

    String getAlgorithm() {
        return this.algo.getAlgorithm();
    }

    String getShortAlgorithm() {
        return this.getAlgorithm().replace("-", "");
    }

    private static enum BlockLength {
        DUMMY(-1),
        SHA(64),
        MD5(64),
        SHA_256(64),
        SHA_384(128),
        SHA_512(128);

        private final int length;

        public static BlockLength forAlgorithm(String algorithm) {
            if (algorithm.equalsIgnoreCase("SHA-1")) {
                return SHA;
            }
            if (algorithm.equalsIgnoreCase("MD5")) {
                return MD5;
            }
            if (algorithm.equalsIgnoreCase("SHA-256")) {
                return SHA_256;
            }
            if (algorithm.equalsIgnoreCase("SHA-384")) {
                return SHA_384;
            }
            if (algorithm.equalsIgnoreCase("SHA-512")) {
                return SHA_512;
            }
            return DUMMY;
        }

        public int getLength() {
            return this.length;
        }

        private BlockLength(int length) {
            this.length = length;
        }
    }
}

