/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.MemBIO;
import org.jruby.ext.openssl.impl.Mime;
import org.jruby.ext.openssl.impl.NotVerifiedPKCS7Exception;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.RecipInfo;
import org.jruby.ext.openssl.impl.SMIME;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class PKCS7
extends RubyObject {
    private static final long serialVersionUID = -3925104500966826973L;
    private static ObjectAllocator PKCS7_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKCS7(runtime, klass);
        }
    };
    private org.jruby.ext.openssl.impl.PKCS7 p7;

    public static void createPKCS7(Ruby runtime, RubyModule mOSSL) {
        RubyClass cPKCS7 = mOSSL.defineClassUnder("PKCS7", runtime.getObject(), PKCS7_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        cPKCS7.defineClassUnder("PKCS7Error", openSSLError, openSSLError.getAllocator());
        cPKCS7.addReadWriteAttribute(runtime.getCurrentContext(), "data");
        cPKCS7.addReadWriteAttribute(runtime.getCurrentContext(), "error_string");
        cPKCS7.defineAnnotatedMethods(PKCS7.class);
        cPKCS7.defineAnnotatedMethods(ModuleMethods.class);
        SignerInfo.createSignerInfo(runtime, (RubyModule)cPKCS7);
        RecipientInfo.createRecipientInfo(runtime, (RubyModule)cPKCS7);
        cPKCS7.setConstant("TEXT", (IRubyObject)runtime.newFixnum(1));
        cPKCS7.setConstant("NOCERTS", (IRubyObject)runtime.newFixnum(2));
        cPKCS7.setConstant("NOSIGS", (IRubyObject)runtime.newFixnum(4));
        cPKCS7.setConstant("NOCHAIN", (IRubyObject)runtime.newFixnum(8));
        cPKCS7.setConstant("NOINTERN", (IRubyObject)runtime.newFixnum(16));
        cPKCS7.setConstant("NOVERIFY", (IRubyObject)runtime.newFixnum(32));
        cPKCS7.setConstant("DETACHED", (IRubyObject)runtime.newFixnum(64));
        cPKCS7.setConstant("BINARY", (IRubyObject)runtime.newFixnum(128));
        cPKCS7.setConstant("NOATTR", (IRubyObject)runtime.newFixnum(256));
        cPKCS7.setConstant("NOSMIMECAP", (IRubyObject)runtime.newFixnum(512));
    }

    public static BIO obj2bio(IRubyObject obj) {
        if (obj instanceof RubyFile) {
            throw new IllegalArgumentException("TODO: handle RubyFile correctly");
        }
        RubyString str = obj.convertToString();
        ByteList bl = str.getByteList();
        return BIO.memBuf(bl.getUnsafeBytes(), bl.getBegin(), bl.getRealSize());
    }

    public static PKCS7 wrap(RubyClass klass, org.jruby.ext.openssl.impl.PKCS7 p7) {
        PKCS7 wrapped = new PKCS7(klass.getRuntime(), klass);
        wrapped.p7 = p7;
        return wrapped;
    }

    public static IRubyObject membio2str(Ruby runtime, BIO bio) {
        return runtime.newString(new ByteList(((MemBIO)bio).getMemCopy(), false));
    }

    private static List<X509AuxCertificate> x509_ary2sk(IRubyObject ary) {
        ArrayList<X509AuxCertificate> certs = new ArrayList<X509AuxCertificate>();
        RubyArray arr = (RubyArray)ary;
        for (int i2 = 0; i2 < arr.size(); ++i2) {
            certs.add(((X509Cert)arr.eltInternal(i2)).getAuxCert());
        }
        return certs;
    }

    public PKCS7(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public void setData(IRubyObject object) {
        this.setInstanceVariable("@data", object);
    }

    public IRubyObject getData() {
        return this.getInstanceVariable("@data");
    }

    @JRubyMethod(name={"initialize"}, rest=true)
    public IRubyObject _initialize(IRubyObject[] args) {
        IRubyObject arg = null;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)1) == 0) {
            this.p7 = new org.jruby.ext.openssl.impl.PKCS7();
            try {
                this.p7.setType(0);
            }
            catch (PKCS7Exception pkcs7e) {
                throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
            }
            return this;
        }
        arg = args[0];
        arg = OpenSSLImpl.to_der_if_possible(arg);
        BIO input = PKCS7.obj2bio(arg);
        try {
            this.p7 = org.jruby.ext.openssl.impl.PKCS7.readPEM(input);
            if (this.p7 == null) {
                input.reset();
                this.p7 = org.jruby.ext.openssl.impl.PKCS7.fromASN1(input);
            }
        }
        catch (IOException ioe) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), ioe.getMessage());
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
        }
        this.setData(this.getRuntime().getNil());
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#init_copy");
        return this;
    }

    @JRubyMethod(name={"type="})
    public IRubyObject set_type(IRubyObject obj) {
        int typeId = 0;
        String type = obj.convertToString().asJavaString();
        if ("signed".equals(type)) {
            typeId = 22;
        } else if ("data".equals(type)) {
            typeId = 21;
        } else if ("signedAndEnveloped".equals(type)) {
            typeId = 24;
        } else if ("enveloped".equals(type)) {
            typeId = 23;
        } else if ("encrypted".equals(type)) {
            typeId = 26;
        }
        try {
            this.p7.setType(typeId);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
        }
        return obj;
    }

    @JRubyMethod(name={"type"})
    public IRubyObject get_type() {
        if (this.p7.isSigned()) {
            return this.getRuntime().newSymbol("signed");
        }
        if (this.p7.isEncrypted()) {
            return this.getRuntime().newSymbol("encrypted");
        }
        if (this.p7.isEnveloped()) {
            return this.getRuntime().newSymbol("enveloped");
        }
        if (this.p7.isSignedAndEnveloped()) {
            return this.getRuntime().newSymbol("signedAndEnveloped");
        }
        if (this.p7.isData()) {
            return this.getRuntime().newSymbol("data");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"detached="})
    public IRubyObject set_detached(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#detached=");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject detached() {
        System.err.println("WARNING: unimplemented method called PKCS7#detached");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"detached?"})
    public IRubyObject detached_p() {
        System.err.println("WARNING: unimplemented method called PKCS7#detached?");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"cipher="})
    public IRubyObject set_cipher(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#cipher=");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject add_signer(IRubyObject obj) {
        SignerInfoWithPkey p7si = ((SignerInfo)obj).getSignerInfo().dup();
        try {
            this.p7.addSigner(p7si);
        }
        catch (PKCS7Exception pkcse) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcse);
        }
        if (this.p7.isSigned()) {
            p7si.addSignedAttribute(50, (ASN1Encodable)ASN1Registry.nid2obj(21));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject signers() {
        Collection<SignerInfoWithPkey> sk = this.p7.getSignerInfo();
        RubyArray ary = this.getRuntime().newArray(sk.size());
        for (SignerInfoWithPkey si : sk) {
            ary.append((IRubyObject)SignerInfo.create(this.getRuntime(), si));
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject add_recipient(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#add_recipient");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject recipients() {
        Collection<RecipInfo> sk = null;
        sk = this.p7.isEnveloped() ? this.p7.getEnveloped().getRecipientInfo() : (this.p7.isSignedAndEnveloped() ? this.p7.getSignedAndEnveloped().getRecipientInfo() : null);
        if (sk == null) {
            return this.getRuntime().newArray();
        }
        RubyArray ary = this.getRuntime().newArray(sk.size());
        for (RecipInfo ri : sk) {
            ary.append((IRubyObject)RecipientInfo.create(this.getRuntime(), ri));
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject add_certificate(IRubyObject obj) {
        try {
            this.p7.addCertificate(((X509Cert)obj).getAuxCert());
        }
        catch (PKCS7Exception pkcse) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcse);
        }
        return this;
    }

    @JRubyMethod(name={"certificates="})
    public IRubyObject set_certificates(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#certificates=");
        return this.getRuntime().getNil();
    }

    private Collection<X509AuxCertificate> getCertificates() {
        HashSet<X509AuxCertificate> certs;
        int i2 = this.p7.getType();
        switch (i2) {
            case 22: {
                certs = this.p7.getSign().getCert();
                break;
            }
            case 24: {
                certs = this.p7.getSignedAndEnveloped().getCert();
                break;
            }
            default: {
                certs = new HashSet();
            }
        }
        return certs;
    }

    private RubyArray certsToArray(Collection<X509AuxCertificate> certs) throws CertificateEncodingException {
        RubyArray ary = this.getRuntime().newArray(certs.size());
        for (X509AuxCertificate x509 : certs) {
            ary.append(X509Cert.wrap(this.getRuntime(), x509));
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject certificates() {
        try {
            return this.certsToArray(this.getCertificates());
        }
        catch (CertificateEncodingException cee) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), cee.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject add_crl(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#add_crl");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"crls="})
    public IRubyObject set_crls(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called PKCS7#crls=");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject crls() {
        System.err.println("WARNING: unimplemented method called PKCS7#crls");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"add_data", "data="})
    public IRubyObject add_data(IRubyObject obj) {
        if (this.p7.isSigned()) {
            try {
                this.p7.contentNew(21);
            }
            catch (PKCS7Exception pkcs7e) {
                throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
            }
        }
        BIO in = PKCS7.obj2bio(obj);
        BIO out = null;
        try {
            out = this.p7.dataInit(null);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
        }
        byte[] buf = new byte[4096];
        try {
            int i2;
            while ((i2 = in.read(buf, 0, buf.length)) > 0) {
                if (out == null) continue;
                out.write(buf, 0, i2);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        try {
            this.p7.dataFinal(out);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
        }
        this.setData(this.getRuntime().getNil());
        return obj;
    }

    @JRubyMethod(rest=true)
    public IRubyObject verify(IRubyObject[] args) {
        int flg;
        IRubyObject certs = null;
        IRubyObject store = null;
        IRubyObject indata = this.getRuntime().getNil();
        IRubyObject vflags = this.getRuntime().getNil();
        switch (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)2, (int)4)) {
            case 4: {
                vflags = args[3];
            }
            case 3: {
                indata = args[2];
            }
        }
        store = args[1];
        certs = args[0];
        int n = flg = vflags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)vflags);
        if (indata.isNil()) {
            indata = this.getData();
        }
        BIO in = indata.isNil() ? null : PKCS7.obj2bio(indata);
        List<X509AuxCertificate> x509s = certs.isNil() ? null : PKCS7.x509_ary2sk(certs);
        Store x509st = ((X509Store)store).getStore();
        BIO out = BIO.mem();
        boolean result = false;
        try {
            this.p7.verify(x509s, x509st, in, out, flg);
            result = true;
        }
        catch (NotVerifiedPKCS7Exception e) {
            result = false;
        }
        catch (PKCS7Exception pkcs7e) {
            if (this.getRuntime().isDebug()) {
                System.err.println(pkcs7e.toString());
                pkcs7e.printStackTrace(System.err);
            }
            result = false;
        }
        IRubyObject data = PKCS7.membio2str(this.getRuntime(), out);
        this.setData(data);
        return result ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(rest=true)
    public IRubyObject decrypt(IRubyObject[] args) {
        IRubyObject dflags = this.getRuntime().getNil();
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)2, (int)3) == 3) {
            dflags = args[2];
        }
        IRubyObject pkey = args[0];
        IRubyObject cert2 = args[1];
        PrivateKey key = ((PKey)pkey).getPrivateKey();
        X509AuxCertificate x509 = ((X509Cert)cert2).getAuxCert();
        int flg = dflags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)dflags);
        BIO out = BIO.mem();
        try {
            this.p7.decrypt(key, x509, out, flg);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Exception(this.getRuntime(), pkcs7e);
        }
        return PKCS7.membio2str(this.getRuntime(), out);
    }

    public static RaiseException newPKCS7Exception(Ruby ruby, PKCS7Exception pkcs7e) {
        if (ruby.isDebug()) {
            System.err.println(pkcs7e.toString());
            pkcs7e.printStackTrace(System.err);
        }
        return Utils.newError(ruby, "OpenSSL::PKCS7::PKCS7Error", pkcs7e.getMessage());
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        try {
            StringWriter w = new StringWriter();
            PEMInputOutput.writePKCS7((Writer)w, this.p7.toASN1());
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return this.getRuntime().newString(new ByteList(this.p7.toASN1(), false));
        }
        catch (IOException ioe) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), ioe.getMessage());
        }
    }

    private static RaiseException newPKCS7Error(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::PKCS7::PKCS7Error", message);
    }

    public static class RecipientInfo
    extends RubyObject {
        private static final long serialVersionUID = 6977793206950149902L;
        private static ObjectAllocator RECIPIENTINFO_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RecipientInfo(runtime, klass);
            }
        };
        private RecipInfo info;

        public static void createRecipientInfo(Ruby runtime, RubyModule cPKCS7) {
            RubyClass cPKCS7Recipient = cPKCS7.defineClassUnder("RecipientInfo", runtime.getObject(), RECIPIENTINFO_ALLOCATOR);
            cPKCS7Recipient.defineAnnotatedMethods(RecipientInfo.class);
        }

        public RecipientInfo(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static RecipientInfo create(Ruby runtime, RecipInfo info) {
            RecipientInfo rinfo = new RecipientInfo(runtime, Utils.getClassFromPath(runtime, "OpenSSL::PKCS7::RecipientInfo"));
            rinfo.initWithRecipientInformation(info);
            return rinfo;
        }

        private void initWithRecipientInformation(RecipInfo info) {
            this.info = info;
        }

        @JRubyMethod
        public IRubyObject initialize(IRubyObject arg) {
            System.err.println("WARNING: unimplemented method called RecipientInfo#initialize");
            return this;
        }

        @JRubyMethod
        public IRubyObject issuer() {
            return X509Name.create(this.getRuntime(), this.info.getIssuerAndSerial().getName());
        }

        @JRubyMethod
        public IRubyObject serial() {
            return RubyBignum.bignorm((Ruby)this.getRuntime(), (BigInteger)this.info.getIssuerAndSerial().getCertificateSerialNumber().getValue());
        }

        @JRubyMethod
        public IRubyObject enc_key() {
            System.err.println("WARNING: unimplemented method called RecipientInfo#enc_key");
            return this.getRuntime().getNil();
        }
    }

    public static class SignerInfo
    extends RubyObject {
        private static final long serialVersionUID = -3799397032272738848L;
        private static ObjectAllocator SIGNERINFO_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SignerInfo(runtime, klass);
            }
        };
        private SignerInfoWithPkey info;

        public static void createSignerInfo(Ruby runtime, RubyModule cPKCS7) {
            RubyClass cPKCS7Signer = cPKCS7.defineClassUnder("SignerInfo", runtime.getObject(), SIGNERINFO_ALLOCATOR);
            cPKCS7.defineConstant("Signer", (IRubyObject)cPKCS7Signer);
            cPKCS7Signer.defineAnnotatedMethods(SignerInfo.class);
        }

        public static SignerInfo create(Ruby runtime, SignerInfoWithPkey info) {
            SignerInfo sinfo = new SignerInfo(runtime, Utils.getClassFromPath(runtime, "OpenSSL::PKCS7::SignerInfo"));
            sinfo.initWithSignerInformation(info);
            return sinfo;
        }

        public SignerInfo(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        private void initWithSignerInformation(SignerInfoWithPkey info) {
            this.info = info;
        }

        SignerInfoWithPkey getSignerInfo() {
            return this.info;
        }

        @JRubyMethod
        public IRubyObject initialize(IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            System.err.println("WARNING: unimplemented method called SignerInfo#initialize");
            return this;
        }

        @JRubyMethod(name={"issuer", "name"})
        public IRubyObject issuer() {
            return X509Name.create(this.getRuntime(), this.info.getIssuerAndSerialNumber().getName());
        }

        @JRubyMethod
        public IRubyObject serial() {
            return RubyBignum.bignorm((Ruby)this.getRuntime(), (BigInteger)this.info.getIssuerAndSerialNumber().getCertificateSerialNumber().getValue());
        }

        @JRubyMethod
        public IRubyObject signed_time() {
            System.err.println("WARNING: unimplemented method called SignerInfo#signed_time");
            return this.getRuntime().getNil();
        }
    }

    public static class ModuleMethods {
        @JRubyMethod(meta=true)
        public static IRubyObject read_smime(IRubyObject klass, IRubyObject arg) {
            BIO in = PKCS7.obj2bio(arg);
            BIO[] out = new BIO[]{null};
            org.jruby.ext.openssl.impl.PKCS7 pkcs7 = null;
            try {
                pkcs7 = new SMIME(Mime.DEFAULT).readPKCS7(in, out);
            }
            catch (IOException ioe) {
                throw PKCS7.newPKCS7Error(klass.getRuntime(), ioe.getMessage());
            }
            catch (PKCS7Exception pkcs7e) {
                throw PKCS7.newPKCS7Exception(klass.getRuntime(), pkcs7e);
            }
            if (pkcs7 == null) {
                throw PKCS7.newPKCS7Error(klass.getRuntime(), null);
            }
            IRubyObject data = out[0] != null ? PKCS7.membio2str(klass.getRuntime(), out[0]) : klass.getRuntime().getNil();
            PKCS7 ret = PKCS7.wrap(Utils.getClassFromPath(klass.getRuntime(), "OpenSSL::PKCS7"), pkcs7);
            ret.setData(data);
            return ret;
        }

        @JRubyMethod(meta=true, rest=true)
        public static IRubyObject write_smime(IRubyObject recv, IRubyObject[] args) {
            Ruby runtime = recv.getRuntime();
            IRubyObject pkcs7 = runtime.getNil();
            IRubyObject data = runtime.getNil();
            IRubyObject flags = runtime.getNil();
            switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)3)) {
                case 3: {
                    flags = args[2];
                }
                case 2: {
                    data = args[1];
                }
                case 1: {
                    pkcs7 = args[0];
                }
            }
            PKCS7 pk7 = (PKCS7)pkcs7;
            int flg = flags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)flags);
            String smimeStr = "";
            try {
                smimeStr = new SMIME().writePKCS7(pk7.p7, data.asJavaString(), flg);
            }
            catch (PKCS7Exception e) {
                throw PKCS7.newPKCS7Exception(recv.getRuntime(), e);
            }
            catch (IOException e) {
                throw PKCS7.newPKCS7Error(recv.getRuntime(), e.getMessage());
            }
            return RubyString.newString((Ruby)recv.getRuntime(), (String)smimeStr);
        }

        @JRubyMethod(meta=true, rest=true)
        public static IRubyObject sign(IRubyObject recv, IRubyObject[] args) {
            Ruby runtime = recv.getRuntime();
            IRubyObject cert2 = runtime.getNil();
            IRubyObject key = runtime.getNil();
            IRubyObject data = runtime.getNil();
            IRubyObject certs = runtime.getNil();
            IRubyObject flags = runtime.getNil();
            switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)3, (int)5)) {
                case 5: {
                    flags = args[4];
                }
                case 4: {
                    certs = args[3];
                }
                case 3: {
                    cert2 = args[0];
                    key = args[1];
                    data = args[2];
                }
            }
            X509AuxCertificate x509 = ((X509Cert)cert2).getAuxCert();
            PrivateKey pkey = ((PKey)key).getPrivateKey();
            int flg = flags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)flags);
            BIO in = PKCS7.obj2bio(data);
            List x509s = certs.isNil() ? null : PKCS7.x509_ary2sk(certs);
            try {
                org.jruby.ext.openssl.impl.PKCS7 p7 = org.jruby.ext.openssl.impl.PKCS7.sign(x509, pkey, x509s, in, flg);
                PKCS7 ret = PKCS7.wrap(Utils.getClassFromPath(recv.getRuntime(), "OpenSSL::PKCS7"), p7);
                ret.setData(data);
                return ret;
            }
            catch (PKCS7Exception pkcs7e) {
                throw PKCS7.newPKCS7Exception(recv.getRuntime(), pkcs7e);
            }
        }

        @JRubyMethod(meta=true, rest=true)
        public static IRubyObject encrypt(IRubyObject recv, IRubyObject[] args) {
            IRubyObject cipher2 = recv.getRuntime().getNil();
            IRubyObject flags = recv.getRuntime().getNil();
            switch (Arity.checkArgumentCount((Ruby)recv.getRuntime(), (IRubyObject[])args, (int)2, (int)4)) {
                case 4: {
                    flags = args[3];
                }
                case 3: {
                    cipher2 = args[2];
                }
            }
            IRubyObject data = args[1];
            IRubyObject certs = args[0];
            CipherSpec ciph = null;
            if (cipher2.isNil()) {
                try {
                    ciph = new CipherSpec(javax.crypto.Cipher.getInstance("RC2/CBC/PKCS5Padding"), Cipher.Algorithm.jsseToOssl("RC2/CBC/PKCS5Padding", 40), 40);
                }
                catch (GeneralSecurityException gse) {
                    throw PKCS7.newPKCS7Error(recv.getRuntime(), gse.getMessage());
                }
            } else {
                Cipher c = (Cipher)cipher2;
                ciph = new CipherSpec(c.getCipher(), c.getName(), c.getGenerateKeyLen() * 8);
            }
            int flg = flags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)flags);
            byte[] in = data.convertToString().getBytes();
            List x509s = PKCS7.x509_ary2sk(certs);
            try {
                org.jruby.ext.openssl.impl.PKCS7 p7 = org.jruby.ext.openssl.impl.PKCS7.encrypt(x509s, in, ciph, flg);
                PKCS7 ret = PKCS7.wrap(Utils.getClassFromPath(recv.getRuntime(), "OpenSSL::PKCS7"), p7);
                ret.setData(data);
                return ret;
            }
            catch (PKCS7Exception pkcs7e) {
                throw PKCS7.newPKCS7Exception(recv.getRuntime(), pkcs7e);
            }
        }
    }
}

