/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.spec.DHParameterSpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class PKeyDH
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 293266329939132250L;
    private static final BigInteger GEN_2_ADD_PARAM = BigInteger.valueOf(24L);
    private static final BigInteger GEN_2_REM_PARAM = BigInteger.valueOf(11L);
    private static final BigInteger GEN_5_ADD_PARAM = BigInteger.valueOf(10L);
    private static final BigInteger GEN_5_REM_PARAM = BigInteger.valueOf(3L);
    private static final BigInteger DEFAULT_ADD_PARAM = BigInteger.valueOf(2L);
    private static final BigInteger DEFAULT_REM_PARAM = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final int OPENSSL_DH_MAX_MODULUS_BITS = 10000;
    private static ObjectAllocator PKEYDH_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyDH(runtime, klass);
        }
    };
    private static SecureRandom _secureRandom;
    private volatile transient BigInteger dh_p;
    private volatile transient BigInteger dh_g;
    private volatile transient BigInteger dh_pub_key;
    private volatile transient BigInteger dh_priv_key;

    public static void createPKeyDH(Ruby runtime, RubyModule pkeyModule, RubyClass pkeyClass) {
        RubyClass dh = pkeyModule.defineClassUnder("DH", pkeyClass, PKEYDH_ALLOCATOR);
        RubyClass pkeyError = pkeyModule.getClass("PKeyError");
        pkeyModule.defineClassUnder("DHError", pkeyError, pkeyError.getAllocator());
        dh.defineAnnotatedMethods(PKeyDH.class);
    }

    public static RaiseException newDHError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::PKey::DHError", message);
    }

    private static SecureRandom getSecureRandom() {
        SecureRandom rand = _secureRandom;
        if (rand != null) {
            return rand;
        }
        _secureRandom = new SecureRandom();
        return _secureRandom;
    }

    public PKeyDH(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
    }

    @JRubyMethod(name={"initialize"}, rest=true)
    public synchronized IRubyObject dh_initialize(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        if (this.dh_p != null || this.dh_g != null || this.dh_pub_key != null || this.dh_priv_key != null) {
            throw PKeyDH.newDHError(runtime, "illegal initialization");
        }
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2);
        if (argc > 0) {
            BigInteger p;
            IRubyObject arg0 = args[0];
            if (argc == 1 && arg0 instanceof RubyString) {
                try {
                    DHParameterSpec spec = PEMInputOutput.readDHParameters(new StringReader(arg0.toString()));
                    if (spec == null) {
                        spec = PKey.readDHParameter(arg0.asString().getByteList().bytes());
                    }
                    if (spec == null) {
                        throw runtime.newArgumentError("invalid DH PARAMETERS");
                    }
                    this.dh_p = spec.getP();
                    this.dh_g = spec.getG();
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw PKeyDH.newDHError(runtime, OpenSSLReal.bcExceptionMessage(ncdfe));
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
            }
            int bits = RubyNumeric.fix2int((IRubyObject)arg0);
            int gval = argc == 2 ? RubyNumeric.fix2int((IRubyObject)args[1]) : 2;
            try {
                p = PKeyDH.generateP(bits, gval);
            }
            catch (IllegalArgumentException e) {
                throw runtime.newArgumentError(e.getMessage());
            }
            BigInteger g = BigInteger.valueOf(gval);
            BigInteger x = PKeyDH.generateX(p);
            BigInteger y = PKeyDH.generateY(p, g, x);
            this.dh_p = p;
            this.dh_g = g;
            this.dh_priv_key = x;
            this.dh_pub_key = y;
        }
        return this;
    }

    public static BigInteger generateP(int bits, int g) {
        if (bits < 2) {
            throw new IllegalArgumentException("invalid bit length");
        }
        if (g < 2) {
            throw new IllegalArgumentException("invalid generator");
        }
        switch (g) {
            case 2: {
                return BN.generatePrime(bits, true, GEN_2_ADD_PARAM, GEN_2_REM_PARAM);
            }
            case 5: {
                return BN.generatePrime(bits, true, GEN_5_ADD_PARAM, GEN_5_REM_PARAM);
            }
        }
        return BN.generatePrime(bits, true, DEFAULT_ADD_PARAM, DEFAULT_REM_PARAM);
    }

    public static BigInteger generateX(BigInteger p, int limit) {
        BigInteger x;
        if (limit < 0) {
            throw new IllegalArgumentException("invalid limit");
        }
        SecureRandom secureRandom = PKeyDH.getSecureRandom();
        if (limit == 0) {
            BigInteger pSub2 = p.subtract(TWO);
            while ((x = BN.getRandomBIInRange(pSub2, secureRandom)).equals(BigInteger.ZERO)) {
            }
        } else {
            while ((x = new BigInteger(limit, 0, secureRandom)).equals(BigInteger.ZERO)) {
            }
        }
        return x;
    }

    public static BigInteger generateX(BigInteger p) {
        return PKeyDH.generateX(p, p.bitLength() - 1);
    }

    public static BigInteger generateY(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }

    public static BigInteger generateY(BigInteger p, int g, BigInteger x) {
        return PKeyDH.generateY(p, BigInteger.valueOf(g), x);
    }

    @JRubyMethod(name={"generate_key!"})
    public synchronized IRubyObject dh_generate_key() {
        BigInteger g;
        BigInteger p = this.dh_p;
        if (p == null || (g = this.dh_g) == null) {
            throw PKeyDH.newDHError(this.getRuntime(), "can't generate key");
        }
        BigInteger x = this.dh_priv_key;
        if (x == null) {
            x = PKeyDH.generateX(p);
        }
        BigInteger y = PKeyDH.generateY(p, g, x);
        this.dh_priv_key = x;
        this.dh_pub_key = y;
        return this;
    }

    @JRubyMethod(name={"compute_key"})
    public synchronized IRubyObject dh_compute_key(IRubyObject other_pub_key) {
        BigInteger p;
        BigInteger y = BN.getBigInteger(other_pub_key);
        if (y == null) {
            throw this.getRuntime().newArgumentError("invalid public key");
        }
        BigInteger x = this.dh_priv_key;
        if (x == null || (p = this.dh_p) == null) {
            throw PKeyDH.newDHError(this.getRuntime(), "can't compute key");
        }
        int plen = p.bitLength();
        if (plen == 0 || plen > 10000) {
            throw PKeyDH.newDHError(this.getRuntime(), "can't compute key");
        }
        return this.getRuntime().newString(new ByteList(PKeyDH.computeKey(y, x, p), false));
    }

    public static byte[] computeKey(BigInteger y, BigInteger x, BigInteger p) {
        return y.modPow(x, p).toByteArray();
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject dh_is_public() {
        return this.getRuntime().newBoolean(this.dh_pub_key != null);
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject dh_is_private() {
        return this.getRuntime().newBoolean(this.dh_priv_key != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"export", "to_pem", "to_s"})
    public IRubyObject dh_export() {
        BigInteger g;
        BigInteger p;
        PKeyDH pKeyDH = this;
        synchronized (pKeyDH) {
            p = this.dh_p;
            g = this.dh_g;
        }
        StringWriter w = new StringWriter();
        try {
            PEMInputOutput.writeDHParameters(w, new DHParameterSpec(p, g));
            w.flush();
            w.close();
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDH.newDHError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this.getRuntime().newString(w.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"to_der"})
    public IRubyObject dh_to_der() {
        BigInteger g;
        BigInteger p;
        PKeyDH pKeyDH = this;
        synchronized (pKeyDH) {
            p = this.dh_p;
            g = this.dh_g;
        }
        try {
            byte[] bytes = PKey.toDerDHKey(p, g);
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])bytes);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDH.newDHError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyDH.newDHError(this.getRuntime(), ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"params"})
    public IRubyObject dh_get_params() {
        BigInteger y;
        BigInteger x;
        BigInteger g;
        BigInteger p;
        PKeyDH pKeyDH = this;
        synchronized (pKeyDH) {
            p = this.dh_p;
            g = this.dh_g;
            x = this.dh_priv_key;
            y = this.dh_pub_key;
        }
        Ruby runtime = this.getRuntime();
        HashMap<RubyString, BN> params2 = new HashMap<RubyString, BN>();
        params2.put(runtime.newString("p"), BN.newBN(runtime, p));
        params2.put(runtime.newString("g"), BN.newBN(runtime, g));
        params2.put(runtime.newString("pub_key"), BN.newBN(runtime, x));
        params2.put(runtime.newString("priv_key"), BN.newBN(runtime, y));
        return RubyHash.newHash((Ruby)runtime, params2, (IRubyObject)runtime.getNil());
    }

    @JRubyMethod(name={"p"})
    public IRubyObject dh_get_p() {
        return this.getBN(this.dh_p);
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject dh_set_p(IRubyObject arg) {
        this.dh_p = BN.getBigInteger(arg);
        return arg;
    }

    @JRubyMethod(name={"g"})
    public IRubyObject dh_get_g() {
        return this.getBN(this.dh_g);
    }

    @JRubyMethod(name={"g="})
    public synchronized IRubyObject dh_set_g(IRubyObject arg) {
        this.dh_g = BN.getBigInteger(arg);
        return arg;
    }

    @JRubyMethod(name={"pub_key"})
    public IRubyObject dh_get_pub_key() {
        return this.getBN(this.dh_pub_key);
    }

    @JRubyMethod(name={"pub_key="})
    public synchronized IRubyObject dh_set_pub_key(IRubyObject arg) {
        this.dh_pub_key = BN.getBigInteger(arg);
        return arg;
    }

    @JRubyMethod(name={"priv_key"})
    public IRubyObject dh_get_priv_key() {
        return this.getBN(this.dh_priv_key);
    }

    @JRubyMethod(name={"priv_key="})
    public synchronized IRubyObject dh_set_priv_key(IRubyObject arg) {
        this.dh_priv_key = BN.getBigInteger(arg);
        return arg;
    }

    private IRubyObject getBN(BigInteger value2) {
        if (value2 != null) {
            return BN.newBN(this.getRuntime(), value2);
        }
        return this.getRuntime().getNil();
    }

    @Override
    public IRubyObject to_der() {
        return this.dh_to_der();
    }
}

