/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.ext.openssl.x509store.CRL;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Lookup;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.PolicyTree;
import org.jruby.ext.openssl.x509store.Purpose;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.Trust;
import org.jruby.ext.openssl.x509store.VerifyParameter;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.ext.openssl.x509store.X509Utils;

public class StoreContext {
    public Store ctx;
    public int currentMethod;
    public X509AuxCertificate certificate;
    public List<X509AuxCertificate> untrusted;
    public List<X509CRL> crls;
    public VerifyParameter param;
    public List<X509AuxCertificate> otherContext;
    public Store.VerifyFunction verify;
    public Store.VerifyCallbackFunction verifyCallback;
    public Store.GetIssuerFunction getIssuer;
    public Store.CheckIssuedFunction checkIssued;
    public Store.CheckRevocationFunction checkRevocation;
    public Store.GetCRLFunction getCRL;
    public Store.CheckCRLFunction checkCRL;
    public Store.CertificateCRLFunction certificateCRL;
    public CheckPolicyFunction checkPolicy;
    public Store.CleanupFunction cleanup;
    public boolean isValid;
    public int lastUntrusted;
    public List<X509AuxCertificate> chain;
    public PolicyTree tree;
    public int explicitPolicy;
    public int errorDepth;
    public int error;
    public X509AuxCertificate currentCertificate;
    public X509AuxCertificate currentIssuer;
    public java.security.cert.CRL currentCRL;
    public List<Object> extraData;
    private static final Set<String> CRITICAL_EXTENSIONS = new HashSet<String>();
    public static final Store.GetIssuerFunction getIssuerStack;
    public static final Store.CheckIssuedFunction defaultCheckIssued;
    public static final Store.VerifyCallbackFunction NullCallback;
    public static final Store.VerifyFunction internalVerify;
    public static final Store.CheckRevocationFunction defaultCheckRevocation;
    public static final Store.GetCRLFunction defaultGetCRL;
    public static final Store.CheckCRLFunction defaultCheckCRL;
    public static final Store.CertificateCRLFunction defaultCertificateCRL;
    public static final CheckPolicyFunction defaultCheckPolicy;

    public void setDepth(int depth) {
        this.param.setDepth(depth);
    }

    public void setApplicationData(Object data) {
        this.setExtraData(0, data);
    }

    public Object getApplicationData() {
        return this.getExtraData(0);
    }

    public int getFirstIssuer(X509AuxCertificate[] issuer2, X509AuxCertificate x) throws Exception {
        int ok;
        Name xn = new Name(x.getIssuerX500Principal());
        X509Object[] s_obj = new X509Object[1];
        int n = ok = this.ctx == null ? 0 : this.getBySubject(1, xn, s_obj);
        if (ok != 1) {
            if (ok == -1) {
                X509Error.addError(106);
                return -1;
            }
            if (ok != 0) {
                return -1;
            }
            return 0;
        }
        X509Object obj = s_obj[0];
        if (this.checkIssued.call(this, x, ((Certificate)obj).x509) != 0) {
            issuer2[0] = ((Certificate)obj).x509;
            return 1;
        }
        int idx = X509Object.indexBySubject(this.ctx.objs, 1, xn);
        if (idx == -1) {
            return 0;
        }
        for (int i2 = idx; i2 < this.ctx.objs.size(); ++i2) {
            X509Object pobj = this.ctx.objs.get(i2);
            if (pobj.type() != 1) {
                return 0;
            }
            if (!xn.isEqual(((Certificate)pobj).x509.getSubjectX500Principal())) {
                return 0;
            }
            if (this.checkIssued.call(this, x, ((Certificate)pobj).x509) == 0) continue;
            issuer2[0] = ((Certificate)pobj).x509;
            return 1;
        }
        return 0;
    }

    public static List<X509AuxCertificate> ensureAux(Collection<X509Certificate> inp) {
        if (inp == null) {
            return null;
        }
        ArrayList<X509AuxCertificate> out = new ArrayList<X509AuxCertificate>();
        for (X509Certificate o : inp) {
            out.add(StoreContext.ensureAux(o));
        }
        return out;
    }

    public static List<X509AuxCertificate> ensureAux(X509Certificate[] inp) {
        if (inp == null) {
            return null;
        }
        ArrayList<X509AuxCertificate> o = new ArrayList<X509AuxCertificate>();
        for (X509Certificate c : inp) {
            o.add(StoreContext.ensureAux(c));
        }
        return o;
    }

    public static X509AuxCertificate ensureAux(X509Certificate i2) {
        if (i2 == null) {
            return null;
        }
        if (i2 instanceof X509AuxCertificate) {
            return (X509AuxCertificate)i2;
        }
        return new X509AuxCertificate(i2);
    }

    public int init(Store store, X509AuxCertificate x509, List<X509AuxCertificate> chain2) {
        int ret = 1;
        this.ctx = store;
        this.currentMethod = 0;
        this.certificate = x509;
        this.untrusted = chain2;
        this.crls = null;
        this.lastUntrusted = 0;
        this.otherContext = null;
        this.isValid = false;
        this.chain = null;
        this.error = 0;
        this.explicitPolicy = 0;
        this.errorDepth = 0;
        this.currentCertificate = null;
        this.currentIssuer = null;
        this.tree = null;
        this.param = new VerifyParameter();
        if (store != null) {
            ret = this.param.inherit(store.param);
        } else {
            this.param.flags |= 0x11L;
        }
        if (store != null) {
            this.verifyCallback = store.verifyCallback;
            this.cleanup = store.cleanup;
        } else {
            this.cleanup = Store.CleanupFunction.EMPTY;
        }
        if (ret != 0) {
            ret = this.param.inherit(VerifyParameter.lookup("default"));
        }
        if (ret == 0) {
            X509Error.addError(65);
            return 0;
        }
        this.checkIssued = store != null && store.checkIssued != null && store.checkIssued != Store.CheckIssuedFunction.EMPTY ? store.checkIssued : defaultCheckIssued;
        this.getIssuer = store != null && store.getIssuer != null && store.getIssuer != Store.GetIssuerFunction.EMPTY ? store.getIssuer : new Store.GetIssuerFunction(){

            @Override
            public int call(Object arg1, Object arg2, Object arg3) throws Exception {
                return ((StoreContext)arg2).getFirstIssuer((X509AuxCertificate[])arg1, (X509AuxCertificate)arg3);
            }
        };
        this.verifyCallback = store != null && store.verifyCallback != null && store.verifyCallback != Store.VerifyCallbackFunction.EMPTY ? store.verifyCallback : NullCallback;
        this.verify = store != null && store.verify != null && store.verify != Store.VerifyFunction.EMPTY ? store.verify : internalVerify;
        this.checkRevocation = store != null && store.checkRevocation != null && store.checkRevocation != Store.CheckRevocationFunction.EMPTY ? store.checkRevocation : defaultCheckRevocation;
        this.getCRL = store != null && store.getCRL != null && store.getCRL != Store.GetCRLFunction.EMPTY ? store.getCRL : defaultGetCRL;
        this.checkCRL = store != null && store.checkCRL != null && store.checkCRL != Store.CheckCRLFunction.EMPTY ? store.checkCRL : defaultCheckCRL;
        this.certificateCRL = store != null && store.certificateCRL != null && store.certificateCRL != Store.CertificateCRLFunction.EMPTY ? store.certificateCRL : defaultCertificateCRL;
        this.checkPolicy = defaultCheckPolicy;
        this.extraData = new ArrayList<Object>();
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        return 1;
    }

    public void trustedStack(List<X509AuxCertificate> sk) {
        this.otherContext = sk;
        this.getIssuer = getIssuerStack;
    }

    public void cleanup() throws Exception {
        if (this.cleanup != null && this.cleanup != Store.CleanupFunction.EMPTY) {
            this.cleanup.call(this);
        }
        this.param = null;
        this.tree = null;
        this.chain = null;
        this.extraData = null;
    }

    public X509AuxCertificate findIssuer(List<X509AuxCertificate> sk, X509AuxCertificate x) throws Exception {
        for (X509AuxCertificate issuer2 : sk) {
            if (this.checkIssued.call(this, x, issuer2) == 0) continue;
            return issuer2;
        }
        return null;
    }

    public int setExtraData(int idx, Object data) {
        this.extraData.set(idx, data);
        return 1;
    }

    public Object getExtraData(int idx) {
        return this.extraData.get(idx);
    }

    public int getError() {
        return this.error;
    }

    public void setError(int s2) {
        this.error = s2;
    }

    public int getErrorDepth() {
        return this.errorDepth;
    }

    public X509AuxCertificate getCurrentCertificate() {
        return this.currentCertificate;
    }

    public List<X509AuxCertificate> getChain() {
        return this.chain;
    }

    public List<X509AuxCertificate> getFirstChain() {
        if (null == this.chain) {
            return null;
        }
        return new ArrayList<X509AuxCertificate>(this.chain);
    }

    public void setCertificate(X509AuxCertificate x) {
        this.certificate = x;
    }

    public void setCertificate(X509Certificate x) {
        this.certificate = StoreContext.ensureAux(x);
    }

    public void setChain(List<X509Certificate> sk) {
        this.untrusted = StoreContext.ensureAux(sk);
    }

    public void setChain(X509Certificate[] sk) {
        this.untrusted = StoreContext.ensureAux(sk);
    }

    public void setCRLs(List<X509CRL> sk) {
        this.crls = sk;
    }

    public int setPurpose(int purpose) {
        return this.purposeInherit(0, purpose, 0);
    }

    public int setTrust(int trust) {
        return this.purposeInherit(0, 0, trust);
    }

    private void resetSettingsToWithoutStore() {
        this.ctx = null;
        this.param = new VerifyParameter();
        this.param.flags |= 0x11L;
        this.param.inherit(VerifyParameter.lookup("default"));
        this.cleanup = Store.CleanupFunction.EMPTY;
        this.checkIssued = defaultCheckIssued;
        this.getIssuer = new Store.GetIssuerFunction(){

            @Override
            public int call(Object arg1, Object arg2, Object arg3) throws Exception {
                return ((StoreContext)arg2).getFirstIssuer((X509AuxCertificate[])arg1, (X509AuxCertificate)arg3);
            }
        };
        this.verifyCallback = NullCallback;
        this.verify = internalVerify;
        this.checkRevocation = defaultCheckRevocation;
        this.getCRL = defaultGetCRL;
        this.checkCRL = defaultCheckCRL;
        this.certificateCRL = defaultCertificateCRL;
    }

    public int loadVerifyLocations(String CAfile, String CApath) {
        boolean reset2 = false;
        try {
            int ret;
            if (this.ctx == null) {
                reset2 = true;
                this.ctx = new Store();
                this.param.inherit(this.ctx.param);
                this.param.inherit(VerifyParameter.lookup("default"));
                this.cleanup = this.ctx.cleanup;
                if (this.ctx.checkIssued != null && this.ctx.checkIssued != Store.CheckIssuedFunction.EMPTY) {
                    this.checkIssued = this.ctx.checkIssued;
                }
                if (this.ctx.getIssuer != null && this.ctx.getIssuer != Store.GetIssuerFunction.EMPTY) {
                    this.getIssuer = this.ctx.getIssuer;
                }
                if (this.ctx.verifyCallback != null && this.ctx.verifyCallback != Store.VerifyCallbackFunction.EMPTY) {
                    this.verifyCallback = this.ctx.verifyCallback;
                }
                if (this.ctx.verify != null && this.ctx.verify != Store.VerifyFunction.EMPTY) {
                    this.verify = this.ctx.verify;
                }
                if (this.ctx.checkRevocation != null && this.ctx.checkRevocation != Store.CheckRevocationFunction.EMPTY) {
                    this.checkRevocation = this.ctx.checkRevocation;
                }
                if (this.ctx.getCRL != null && this.ctx.getCRL != Store.GetCRLFunction.EMPTY) {
                    this.getCRL = this.ctx.getCRL;
                }
                if (this.ctx.checkCRL != null && this.ctx.checkCRL != Store.CheckCRLFunction.EMPTY) {
                    this.checkCRL = this.ctx.checkCRL;
                }
                if (this.ctx.certificateCRL != null && this.ctx.certificateCRL != Store.CertificateCRLFunction.EMPTY) {
                    this.certificateCRL = this.ctx.certificateCRL;
                }
            }
            if ((ret = this.ctx.loadLocations(CAfile, CApath)) == 0 && reset2) {
                this.resetSettingsToWithoutStore();
            }
            return ret;
        }
        catch (Exception e) {
            if (reset2) {
                this.resetSettingsToWithoutStore();
            }
            return 0;
        }
    }

    public int purposeInherit(int defaultPurpose, int purpose, int trust) {
        int idx;
        if (purpose == 0) {
            purpose = defaultPurpose;
        }
        if (purpose != 0) {
            idx = Purpose.getByID(purpose);
            if (idx == -1) {
                X509Error.addError(121);
                return 0;
            }
            Purpose ptmp = Purpose.getFirst(idx);
            if (ptmp.trust == -1) {
                idx = Purpose.getByID(defaultPurpose);
                if (idx == -1) {
                    X509Error.addError(121);
                    return 0;
                }
                ptmp = Purpose.getFirst(idx);
            }
            if (trust == 0) {
                trust = ptmp.trust;
            }
        }
        if (trust != 0 && (idx = Trust.getByID(trust)) == -1) {
            X509Error.addError(120);
            return 0;
        }
        if (purpose != 0 && this.param.purpose == 0) {
            this.param.purpose = purpose;
        }
        if (trust != 0 && this.param.trust == 0) {
            this.param.trust = trust;
        }
        return 1;
    }

    public void setFlags(long flags) {
        this.param.setFlags(flags);
    }

    public void setTime(long flags, Date t) {
        this.param.setTime(t);
    }

    public void setVerifyCallback(Store.VerifyCallbackFunction verifyCallback) {
        this.verifyCallback = verifyCallback;
    }

    PolicyTree getPolicyTree() {
        return this.tree;
    }

    public int getExplicitPolicy() {
        return this.explicitPolicy;
    }

    public VerifyParameter getParam() {
        return this.param;
    }

    public void setParam(VerifyParameter param) {
        this.param = param;
    }

    public int setDefault(String name2) {
        VerifyParameter p = VerifyParameter.lookup(name2);
        if (p == null) {
            return 0;
        }
        return this.param.inherit(p);
    }

    public int getBySubject(int type, Name name2, X509Object[] ret) throws Exception {
        Store c = this.ctx;
        X509Object tmp = X509Object.retrieveBySubject(c.objs, type, name2);
        if (tmp == null) {
            for (int i2 = this.currentMethod; i2 < c.certificateMethods.size(); ++i2) {
                X509Object[] stmp;
                Lookup lu = c.certificateMethods.get(i2);
                int j = lu.bySubject(type, name2, stmp = new X509Object[1]);
                if (j < 0) {
                    this.currentMethod = i2;
                    return j;
                }
                if (j <= 0) continue;
                tmp = stmp[0];
                break;
            }
            this.currentMethod = 0;
            if (tmp == null) {
                return 0;
            }
        }
        ret[0] = tmp;
        return 1;
    }

    public int verifyCertificate() throws Exception {
        X509AuxCertificate[] p_xtmp;
        int num;
        X509AuxCertificate xtmp = null;
        X509AuxCertificate chain_ss = null;
        boolean bad_chain = false;
        int ok = 0;
        ArrayList<X509AuxCertificate> sktmp = null;
        if (this.certificate == null) {
            X509Error.addError(105);
            return -1;
        }
        Store.VerifyCallbackFunction cb = this.verifyCallback;
        if (null == this.chain) {
            this.chain = new ArrayList<X509AuxCertificate>();
            this.chain.add(this.certificate);
            this.lastUntrusted = 1;
        }
        if (this.untrusted != null) {
            sktmp = new ArrayList<X509AuxCertificate>(this.untrusted);
        }
        X509AuxCertificate x = this.chain.get(num - 1);
        int depth = this.param.depth;
        for (num = this.chain.size(); depth >= num && this.checkIssued.call(this, x, x) == 0 && this.untrusted != null && (xtmp = this.findIssuer(sktmp, x)) != null; ++num) {
            this.chain.add(xtmp);
            sktmp.remove(xtmp);
            ++this.lastUntrusted;
            x = xtmp;
        }
        int i2 = this.chain.size();
        x = this.chain.get(i2 - 1);
        if (this.checkIssued.call(this, x, x) != 0) {
            if (this.chain.size() == 1) {
                p_xtmp = new X509AuxCertificate[]{xtmp};
                ok = this.getIssuer.call(p_xtmp, this, x);
                xtmp = p_xtmp[0];
                if (ok <= 0 || !x.equals(xtmp)) {
                    this.error = 18;
                    this.currentCertificate = x;
                    this.errorDepth = i2 - 1;
                    bad_chain = true;
                    ok = cb.call(new Integer(0), this);
                    if (ok == 0) {
                        return ok;
                    }
                } else {
                    x = xtmp;
                    this.chain.set(i2 - 1, x);
                    this.lastUntrusted = 0;
                }
            } else {
                chain_ss = this.chain.remove(this.chain.size() - 1);
                --this.lastUntrusted;
                x = this.chain.get(--num - 1);
            }
        }
        while (depth >= num && this.checkIssued.call(this, x, x) == 0) {
            p_xtmp = new X509AuxCertificate[]{xtmp};
            ok = this.getIssuer.call(p_xtmp, this, x);
            xtmp = p_xtmp[0];
            if (ok < 0) {
                return ok;
            }
            if (ok == 0) break;
            x = xtmp;
            this.chain.add(x);
            ++num;
        }
        if (this.checkIssued.call(this, x, x) == 0) {
            if (chain_ss == null || this.checkIssued.call(this, x, chain_ss) == 0) {
                this.error = this.lastUntrusted >= num ? 20 : 2;
                this.currentCertificate = x;
            } else {
                this.chain.add(chain_ss);
                this.lastUntrusted = ++num;
                this.currentCertificate = chain_ss;
                this.error = 19;
                chain_ss = null;
            }
            this.errorDepth = num - 1;
            bad_chain = true;
            ok = cb.call(new Integer(0), this);
            if (ok == 0) {
                return ok;
            }
        }
        if ((ok = this.checkChainExtensions()) == 0) {
            return ok;
        }
        if (this.param.trust > 0) {
            ok = this.checkTrust();
        }
        if (ok == 0) {
            return ok;
        }
        ok = this.checkRevocation.call(this);
        if (ok == 0) {
            return ok;
        }
        ok = this.verify != null && this.verify != Store.VerifyFunction.EMPTY ? this.verify.call(this) : internalVerify.call(this);
        if (ok == 0) {
            return ok;
        }
        if (!bad_chain && (this.param.flags & 0x80L) != 0L) {
            ok = this.checkPolicy.call(this);
        }
        return ok;
    }

    private static boolean supportsCriticalExtension(String oid2) {
        return CRITICAL_EXTENSIONS.contains(oid2);
    }

    private static boolean unhandledCritical(X509Extension xx) {
        if (xx.getCriticalExtensionOIDs() == null || xx.getCriticalExtensionOIDs().size() == 0) {
            return false;
        }
        for (String ss : xx.getCriticalExtensionOIDs()) {
            if (StoreContext.supportsCriticalExtension(ss)) continue;
            return true;
        }
        return false;
    }

    public int checkChainExtensions() throws Exception {
        int ok = 0;
        int proxy_path_length = 0;
        boolean allow_proxy_certs = (this.param.flags & 0x40L) != 0L;
        Store.VerifyCallbackFunction cb = this.verifyCallback;
        int must_be_ca = -1;
        try {
            if (System.getenv("OPENSSL_ALLOW_PROXY_CERTS") != null && !"false".equalsIgnoreCase(System.getenv("OPENSSL_ALLOW_PROXY_CERTS"))) {
                allow_proxy_certs = true;
            }
        }
        catch (Error e) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.lastUntrusted; ++i2) {
            X509AuxCertificate x = this.chain.get(i2);
            if ((this.param.flags & 0x10L) == 0L && StoreContext.unhandledCritical(x)) {
                this.error = 34;
                this.errorDepth = i2;
                this.currentCertificate = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (!allow_proxy_certs && x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                this.error = 40;
                this.errorDepth = i2;
                this.currentCertificate = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            int ret = Purpose.checkCA(x);
            switch (must_be_ca) {
                case -1: {
                    if ((this.param.flags & 0x20L) != 0L && ret != 1 && ret != 0) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case 0: {
                    if (ret != 0) {
                        ret = 0;
                        this.error = 37;
                        break;
                    }
                    ret = 1;
                    break;
                }
                default: {
                    if (ret == 0 || (this.param.flags & 0x20L) != 0L && ret != 1) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                }
            }
            if (ret == 0) {
                this.errorDepth = i2;
                this.currentCertificate = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (this.param.purpose > 0 && ((ret = Purpose.checkPurpose(x, this.param.purpose, must_be_ca > 0 ? 1 : 0)) == 0 || (this.param.flags & 0x20L) != 0L && ret != 1)) {
                this.error = 26;
                this.errorDepth = i2;
                this.currentCertificate = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (i2 > 1 && x.getBasicConstraints() != -1 && x.getBasicConstraints() != Integer.MAX_VALUE && i2 > x.getBasicConstraints() + proxy_path_length + 1) {
                this.error = 25;
                this.errorDepth = i2;
                this.currentCertificate = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                int pcpathlen;
                ASN1Sequence pci = (ASN1Sequence)new ASN1InputStream(x.getExtensionValue("1.3.6.1.5.5.7.1.14")).readObject();
                if (pci.size() > 0 && pci.getObjectAt(0) instanceof ASN1Integer && i2 > (pcpathlen = ((ASN1Integer)pci.getObjectAt(0)).getValue().intValue())) {
                    this.error = 38;
                    this.errorDepth = i2;
                    this.currentCertificate = x;
                    ok = cb.call(new Integer(0), this);
                    if (ok == 0) {
                        return ok;
                    }
                }
                ++proxy_path_length;
                must_be_ca = 0;
                continue;
            }
            must_be_ca = 1;
        }
        return 1;
    }

    public int checkTrust() throws Exception {
        Store.VerifyCallbackFunction cb = this.verifyCallback;
        int i2 = this.chain.size() - 1;
        X509AuxCertificate x = this.chain.get(i2);
        int ok = Trust.checkTrust(x, this.param.trust, 0);
        if (ok == 1) {
            return 1;
        }
        this.errorDepth = 1;
        this.currentCertificate = x;
        this.error = ok == 2 ? 28 : 27;
        return cb.call(new Integer(0), this);
    }

    public int checkCertificateTime(X509AuxCertificate x) throws Exception {
        Date ptime = null;
        ptime = (this.param.flags & 2L) != 0L ? this.param.checkTime : Calendar.getInstance().getTime();
        if (!x.getNotBefore().before(ptime)) {
            this.error = 9;
            this.currentCertificate = x;
            if (this.verifyCallback.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        if (!x.getNotAfter().after(ptime)) {
            this.error = 10;
            this.currentCertificate = x;
            if (this.verifyCallback.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        return 1;
    }

    public int checkCertificate() throws Exception {
        X509AuxCertificate x;
        X509CRL[] crl = new X509CRL[1];
        int cnum = this.errorDepth;
        this.currentCertificate = x = this.chain.get(cnum);
        int ok = this.getCRL.call(this, crl, x);
        if (ok == 0) {
            this.error = 3;
            ok = this.verifyCallback.call(new Integer(0), this);
            this.currentCRL = null;
            return ok;
        }
        this.currentCRL = crl[0];
        ok = this.checkCRL.call(this, crl[0]);
        if (ok == 0) {
            this.currentCRL = null;
            return ok;
        }
        ok = this.certificateCRL.call(this, crl[0], x);
        this.currentCRL = null;
        return ok;
    }

    public int checkCRLTime(X509CRL crl, int notify) throws Exception {
        this.currentCRL = crl;
        Date ptime = null;
        ptime = (this.param.flags & 2L) != 0L ? this.param.checkTime : Calendar.getInstance().getTime();
        if (!crl.getThisUpdate().before(ptime)) {
            this.error = 11;
            if (notify == 0 || this.verifyCallback.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        if (crl.getNextUpdate() != null && !crl.getNextUpdate().after(ptime)) {
            this.error = 12;
            if (notify == 0 || this.verifyCallback.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        this.currentCRL = null;
        return 1;
    }

    public int getCRLStack(X509CRL[] pcrl, Name nm, List<X509CRL> crls2) throws Exception {
        X509CRL best_crl = null;
        if (null != crls2) {
            for (X509CRL crl : crls2) {
                if (!nm.isEqual(crl.getIssuerX500Principal())) continue;
                if (this.checkCRLTime(crl, 0) != 0) {
                    pcrl[0] = crl;
                    return 1;
                }
                best_crl = crl;
            }
        }
        if (best_crl != null) {
            pcrl[0] = best_crl;
        }
        return 0;
    }

    static {
        CRITICAL_EXTENSIONS.add("2.16.840.1.113730.1.1");
        CRITICAL_EXTENSIONS.add("2.5.29.15");
        CRITICAL_EXTENSIONS.add("2.5.29.17");
        CRITICAL_EXTENSIONS.add("2.5.29.19");
        CRITICAL_EXTENSIONS.add("2.5.29.37");
        CRITICAL_EXTENSIONS.add("1.3.6.1.5.5.7.1.14");
        getIssuerStack = new Store.GetIssuerFunction(){

            @Override
            public int call(Object a1, Object a2, Object a3) throws Exception {
                X509AuxCertificate[] issuer2 = (X509AuxCertificate[])a1;
                StoreContext ctx = (StoreContext)a2;
                X509AuxCertificate x = (X509AuxCertificate)a3;
                issuer2[0] = ctx.findIssuer(ctx.otherContext, x);
                if (issuer2[0] != null) {
                    return 1;
                }
                return 0;
            }
        };
        defaultCheckIssued = new Store.CheckIssuedFunction(){

            @Override
            public int call(Object a1, Object a2, Object a3) throws Exception {
                StoreContext ctx = (StoreContext)a1;
                X509AuxCertificate issuer2 = (X509AuxCertificate)a3;
                X509AuxCertificate x = (X509AuxCertificate)a2;
                int ret = X509Utils.checkIfIssuedBy(issuer2, x);
                if (ret == 0) {
                    return 1;
                }
                if ((ctx.param.flags & 1L) == 0L) {
                    return 0;
                }
                ctx.error = ret;
                ctx.currentCertificate = x;
                ctx.currentIssuer = issuer2;
                return ctx.verifyCallback.call(new Integer(0), ctx);
            }
        };
        NullCallback = new Store.VerifyCallbackFunction(){

            @Override
            public int call(Object a1, Object a2) {
                return (Integer)a1;
            }
        };
        internalVerify = new Store.VerifyFunction(){

            @Override
            public int call(Object a1) throws Exception {
                StoreContext ctx = (StoreContext)a1;
                Store.VerifyCallbackFunction cb = ctx.verifyCallback;
                int n = ctx.chain.size();
                ctx.errorDepth = n - 1;
                X509AuxCertificate xi = ctx.chain.get(--n);
                X509AuxCertificate xs = null;
                int ok = 0;
                if (ctx.checkIssued.call(ctx, xi, xi) != 0) {
                    xs = xi;
                } else {
                    if (n <= 0) {
                        ctx.error = 21;
                        ctx.currentCertificate = xi;
                        ok = cb.call(new Integer(0), ctx);
                        return ok;
                    }
                    ctx.errorDepth = --n;
                    xs = ctx.chain.get(n);
                }
                while (n >= 0) {
                    block9: {
                        ctx.errorDepth = n;
                        if (!xs.isValid()) {
                            try {
                                xs.verify(xi.getPublicKey());
                            }
                            catch (Exception e) {
                                ctx.error = 7;
                                ctx.currentCertificate = xs;
                                ok = cb.call(new Integer(0), ctx);
                                if (ok != 0) break block9;
                                return ok;
                            }
                        }
                    }
                    xs.setValid(true);
                    ok = ctx.checkCertificateTime(xs);
                    if (ok == 0) {
                        return ok;
                    }
                    ctx.currentIssuer = xi;
                    ctx.currentCertificate = xs;
                    ok = cb.call(new Integer(1), ctx);
                    if (ok == 0) {
                        return ok;
                    }
                    if (--n < 0) continue;
                    xi = xs;
                    xs = ctx.chain.get(n);
                }
                ok = 1;
                return ok;
            }
        };
        defaultCheckRevocation = new Store.CheckRevocationFunction(){

            @Override
            public int call(Object a1) throws Exception {
                StoreContext ctx = (StoreContext)a1;
                int ok = 0;
                if ((ctx.param.flags & 4L) == 0L) {
                    return 1;
                }
                int last = (ctx.param.flags & 8L) != 0L ? ctx.chain.size() - 1 : 0;
                int i2 = 0;
                while (i2 <= last) {
                    ctx.errorDepth = i2++;
                    ok = ctx.checkCertificate();
                    if (ok != 0) continue;
                    return 0;
                }
                return 1;
            }
        };
        defaultGetCRL = new Store.GetCRLFunction(){

            @Override
            public int call(Object a1, Object a2, Object a3) throws Exception {
                StoreContext ctx = (StoreContext)a1;
                X509CRL[] pcrl = (X509CRL[])a2;
                X509CRL[] crl = new X509CRL[1];
                X509AuxCertificate x = (X509AuxCertificate)a3;
                Name nm = new Name(x.getIssuerX500Principal());
                int ok = ctx.getCRLStack(crl, nm, ctx.crls);
                if (ok != 0) {
                    pcrl[0] = crl[0];
                    return 1;
                }
                X509Object[] xobj = new X509Object[1];
                ok = ctx.getBySubject(2, nm, xobj);
                if (ok == 0) {
                    if (crl[0] != null) {
                        pcrl[0] = crl[0];
                        return 1;
                    }
                    return 0;
                }
                pcrl[0] = (X509CRL)((CRL)xobj[0]).crl;
                return 1;
            }
        };
        defaultCheckCRL = new Store.CheckCRLFunction(){

            @Override
            public int call(Object a1, Object a2) throws Exception {
                int ok;
                X509CRL crl;
                StoreContext ctx;
                block13: {
                    ctx = (StoreContext)a1;
                    crl = (X509CRL)a2;
                    X509AuxCertificate issuer2 = null;
                    ok = 0;
                    int cnum = ctx.errorDepth;
                    int chnum = ctx.chain.size() - 1;
                    if (cnum < chnum) {
                        issuer2 = ctx.chain.get(cnum + 1);
                    } else {
                        issuer2 = ctx.chain.get(chnum);
                        if (ctx.checkIssued.call(ctx, issuer2, issuer2) == 0) {
                            ctx.error = 33;
                            ok = ctx.verifyCallback.call(new Integer(0), ctx);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                    }
                    if (issuer2 != null) {
                        PublicKey ikey;
                        if (issuer2.getKeyUsage() != null && !issuer2.getKeyUsage()[6]) {
                            ctx.error = 35;
                            ok = ctx.verifyCallback.call(new Integer(0), ctx);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                        if ((ikey = issuer2.getPublicKey()) == null) {
                            ctx.error = 6;
                            ok = ctx.verifyCallback.call(new Integer(0), ctx);
                            if (ok == 0) {
                                return ok;
                            }
                        } else {
                            try {
                                crl.verify(ikey);
                            }
                            catch (Exception ignored) {
                                ctx.error = 8;
                                ok = ctx.verifyCallback.call(new Integer(0), ctx);
                                if (ok != 0) break block13;
                                return ok;
                            }
                        }
                    }
                }
                if ((ok = ctx.checkCRLTime(crl, 1)) == 0) {
                    return ok;
                }
                return 1;
            }
        };
        defaultCertificateCRL = new Store.CertificateCRLFunction(){

            @Override
            public int call(Object a1, Object a2, Object a3) throws Exception {
                int ok;
                StoreContext ctx = (StoreContext)a1;
                X509CRL crl = (X509CRL)a2;
                X509AuxCertificate x = (X509AuxCertificate)a3;
                if (crl.getRevokedCertificate(x.getSerialNumber()) != null) {
                    ctx.error = 23;
                    ok = ctx.verifyCallback.call(new Integer(0), ctx);
                    if (ok == 0) {
                        return 0;
                    }
                }
                if ((ctx.param.flags & 0x10L) != 0L) {
                    return 1;
                }
                if (crl.getCriticalExtensionOIDs() != null && crl.getCriticalExtensionOIDs().size() > 0) {
                    ctx.error = 36;
                    ok = ctx.verifyCallback.call(new Integer(0), ctx);
                    if (ok == 0) {
                        return 0;
                    }
                }
                return 1;
            }
        };
        defaultCheckPolicy = new CheckPolicyFunction(){

            @Override
            public int call(Object a1) throws Exception {
                return 1;
            }
        };
    }

    public static interface CheckPolicyFunction
    extends Function1 {
        public static final CheckPolicyFunction EMPTY = new CheckPolicyFunction(){

            @Override
            public int call(Object arg0) {
                return -1;
            }
        };
    }
}

