/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.ArrayList;
import java.util.List;

public class X509Error {
    private static ThreadLocal<List<ErrorException>> errors = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addError(int reason) {
        ThreadLocal<List<ErrorException>> threadLocal = errors;
        synchronized (threadLocal) {
            List<ErrorException> errs = errors.get();
            if (errs == null) {
                errs = new ArrayList<ErrorException>();
                errors.set(errs);
            }
            errs.add(new ErrorException(reason));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearErrors() {
        ThreadLocal<List<ErrorException>> threadLocal = errors;
        synchronized (threadLocal) {
            List<ErrorException> errs = errors.get();
            if (errs != null) {
                errs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ErrorException> getErrors() {
        ThreadLocal<List<ErrorException>> threadLocal = errors;
        synchronized (threadLocal) {
            List<ErrorException> errs = errors.get();
            if (errs == null) {
                errs = new ArrayList<ErrorException>();
                errors.set(errs);
            }
            return errs;
        }
    }

    public static class ErrorException
    extends Exception {
        private static final long serialVersionUID = -3214495184277468063L;
        private int reason;

        public ErrorException(int reason) {
            this.reason = reason;
        }

        public int getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            switch (this.reason) {
                case 100: {
                    return "bad x509 filetype";
                }
                case 118: {
                    return "base64 decode error";
                }
                case 114: {
                    return "cant check dh key";
                }
                case 101: {
                    return "cert already in hash table";
                }
                case 102: {
                    return "err asn1 lib";
                }
                case 113: {
                    return "invalid directory";
                }
                case 119: {
                    return "invalid field name";
                }
                case 123: {
                    return "invalid trust";
                }
                case 115: {
                    return "key type mismatch";
                }
                case 116: {
                    return "key values mismatch";
                }
                case 103: {
                    return "loading cert dir";
                }
                case 104: {
                    return "loading defaults";
                }
                case 124: {
                    return "method not supported";
                }
                case 105: {
                    return "no cert set for us to verify";
                }
                case 125: {
                    return "public key decode error";
                }
                case 126: {
                    return "public key encode error";
                }
                case 106: {
                    return "should retry";
                }
                case 107: {
                    return "unable to find parameters in chain";
                }
                case 108: {
                    return "unable to get certs public key";
                }
                case 117: {
                    return "unknown key type";
                }
                case 109: {
                    return "unknown nid";
                }
                case 121: {
                    return "unknown purpose id";
                }
                case 120: {
                    return "unknown trust id";
                }
                case 111: {
                    return "unsupported algorithm";
                }
                case 112: {
                    return "wrong lookup type";
                }
                case 122: {
                    return "wrong type";
                }
            }
            return "(unknown X509 error)";
        }
    }
}

