/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaDragRecognitionSupport;
import org.violetlib.aqua.AquaTreeUI;

public class AquaTreeMouseBehavior
extends MouseInputAdapter
implements AquaDragRecognitionSupport.BeforeDrag {
    protected JTree tree;
    protected AquaTreeUI ui;
    private boolean mouseReleaseDeselects;
    private boolean mouseDragSelects;
    private boolean isMouseReleaseStartsEditing;
    private boolean isDragRecognitionOngoing;

    public AquaTreeMouseBehavior(JTree jTree) {
        this.tree = jTree;
        this.ui = (AquaTreeUI)jTree.getUI();
    }

    @Override
    public void dragStarting(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
            boolean bl;
            TreePath treePath;
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            this.ui.completeEditing();
            if (this.tree.isRequestFocusEnabled()) {
                this.tree.requestFocusInWindow();
            }
            if (this.ui.isLocationInExpandControl(treePath = this.getMouseClickedClosestPathForLocation(this.tree, mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getX(), mouseEvent.getY())) {
                this.ui.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            int n = this.tree.getRowForPath(treePath);
            this.mouseDragSelects = false;
            this.mouseReleaseDeselects = false;
            this.isMouseReleaseStartsEditing = true;
            this.isDragRecognitionOngoing = false;
            if (!(n == -1 || (bl = this.tree.isRowSelected(n)) && mouseEvent.isPopupTrigger())) {
                int n2 = this.tree.getRowForPath(this.tree.getAnchorSelectionPath());
                if ((mouseEvent.getModifiersEx() & 0x1900) == 256) {
                    if (bl) {
                        this.tree.removeSelectionInterval(n, n);
                    } else {
                        this.tree.addSelectionInterval(n, n);
                        this.mouseDragSelects = true;
                        this.isMouseReleaseStartsEditing = false;
                    }
                } else if ((mouseEvent.getModifiersEx() & 0x1840) == 64 && n2 != -1) {
                    this.tree.setSelectionInterval(n2, n);
                    this.ui.setLeadSelectionPath(treePath);
                    this.mouseDragSelects = true;
                    this.isMouseReleaseStartsEditing = false;
                } else if ((mouseEvent.getModifiersEx() & 0x140) == 0) {
                    if (bl) {
                        if (this.tree.getDragEnabled()) {
                            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mousePressed(mouseEvent);
                            this.mouseReleaseDeselects = false;
                            this.mouseDragSelects = false;
                        } else {
                            this.mouseReleaseDeselects = this.tree.isFocusOwner();
                        }
                    } else {
                        this.tree.setSelectionInterval(n, n);
                        if (this.tree.getDragEnabled() && this.ui.getPathBounds(this.tree, treePath).contains(mouseEvent.getPoint())) {
                            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mousePressed(mouseEvent);
                            this.mouseReleaseDeselects = false;
                            this.mouseDragSelects = false;
                            this.isMouseReleaseStartsEditing = false;
                        } else {
                            this.mouseDragSelects = true;
                            this.isMouseReleaseStartsEditing = false;
                        }
                    }
                    this.ui.setAnchorSelectionPath(treePath);
                    this.ui.setLeadSelectionPath(treePath);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
            int n;
            if (this.tree.getDragEnabled() && this.isDragRecognitionOngoing) {
                AquaDragRecognitionSupport.mouseDragged(mouseEvent, this);
            }
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            TreePath treePath = this.ui.getClosestPathForLocation(this.tree, mouseEvent.getX(), mouseEvent.getY());
            if (this.tree.getCellEditor() != null) {
                this.tree.getCellEditor().isCellEditable(new EventObject(this));
            }
            this.mouseReleaseDeselects = false;
            this.isMouseReleaseStartsEditing = false;
            if (this.mouseDragSelects && (n = this.tree.getRowForPath(treePath)) != -1) {
                Rectangle rectangle = this.tree.getRowBounds(n);
                this.tree.scrollRectToVisible(rectangle);
                TreePath treePath2 = this.tree.getAnchorSelectionPath();
                int n2 = this.tree.getRowForPath(treePath2);
                if (this.tree.getSelectionModel().getSelectionMode() == 1) {
                    this.tree.setSelectionInterval(n, n);
                } else {
                    if (n2 < n) {
                        this.tree.setSelectionInterval(n2, n);
                    } else {
                        this.tree.setSelectionInterval(n, n2);
                    }
                    this.ui.setAnchorSelectionPath(treePath2);
                    this.ui.setLeadSelectionPath(treePath);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.isMouseReleaseStartsEditing = false;
        if (this.tree.getCellEditor() != null) {
            this.tree.getCellEditor().isCellEditable(new EventObject(this));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            TreePath treePath = this.getMouseClickedClosestPathForLocation(this.tree, mouseEvent.getX(), mouseEvent.getY());
            if (this.startEditingOnRelease(treePath, mouseEvent, mouseEvent)) {
                return;
            }
            this.mouseDragSelects = false;
            if (this.mouseReleaseDeselects) {
                int n = this.tree.getRowForPath(treePath);
                this.tree.setSelectionInterval(n, n);
            }
        }
        if (this.tree.isRequestFocusEnabled()) {
            this.tree.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.isMouseReleaseStartsEditing = false;
    }

    private boolean startEditingOnRelease(TreePath treePath, MouseEvent mouseEvent, MouseEvent mouseEvent2) {
        if (this.isMouseReleaseStartsEditing) {
            return this.ui.startEditing(treePath, mouseEvent);
        }
        return false;
    }

    private TreePath getMouseClickedClosestPathForLocation(JTree jTree, int n, int n2) {
        TreePath treePath = this.ui.getClosestPathForLocation(jTree, n, n2);
        if (treePath == null) {
            return null;
        }
        Rectangle rectangle = this.ui.getPathBounds(jTree, treePath);
        if (n2 > rectangle.y + rectangle.height) {
            return null;
        }
        return treePath;
    }
}

