/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.BasicRendererRenderer;
import org.violetlib.jnr.impl.CompositeBasicRenderer;
import org.violetlib.jnr.impl.CompositeRenderer;
import org.violetlib.jnr.impl.NullBasicRenderer;
import org.violetlib.jnr.impl.NullRenderer;
import org.violetlib.jnr.impl.OffsetRasterRendererX;
import org.violetlib.jnr.impl.OffsetRendererX;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.PainterExtensionRenderer;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.jnr.impl.ReusableCompositor;
import org.violetlib.jnr.impl.TrivialRendererDescription;

public abstract class Renderer
implements ReusableCompositor.PixelSource {
    private static final Renderer NULL_RENDERER = new NullRenderer();
    private static final BasicRenderer NULL_BASIC_RENDERER = new NullBasicRenderer();

    @NotNull
    public static Renderer create(@NotNull BasicRenderer basicRenderer, @Nullable RendererDescription rendererDescription) {
        if (rendererDescription == null) {
            rendererDescription = TrivialRendererDescription.getInstance();
        }
        return new BasicRendererRenderer(basicRenderer, rendererDescription);
    }

    @NotNull
    public static Renderer create(@NotNull PainterExtension painterExtension) {
        return new PainterExtensionRenderer(painterExtension);
    }

    @NotNull
    public static Renderer createCompositeRenderer(Renderer ... rendererArray) {
        if (rendererArray == null || rendererArray.length == 0) {
            return NULL_RENDERER;
        }
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        for (Renderer renderer : rendererArray) {
            if (renderer == null) continue;
            arrayList.add(renderer);
        }
        switch (arrayList.size()) {
            case 0: {
                return NULL_RENDERER;
            }
            case 1: {
                return (Renderer)arrayList.get(0);
            }
        }
        return new CompositeRenderer(arrayList);
    }

    @NotNull
    public static BasicRenderer createCompositeBasicRenderer(BasicRenderer ... basicRendererArray) {
        if (basicRendererArray == null || basicRendererArray.length == 0) {
            return NULL_BASIC_RENDERER;
        }
        ArrayList<BasicRenderer> arrayList = new ArrayList<BasicRenderer>();
        for (BasicRenderer basicRenderer : basicRendererArray) {
            if (basicRenderer == null) continue;
            arrayList.add(basicRenderer);
        }
        switch (arrayList.size()) {
            case 0: {
                return NULL_BASIC_RENDERER;
            }
            case 1: {
                return (BasicRenderer)arrayList.get(0);
            }
        }
        return new CompositeBasicRenderer(arrayList);
    }

    @NotNull
    public static Renderer createOffsetRenderer(@NotNull Renderer renderer, float f, float f2, float f3, float f4) {
        return new OffsetRendererX(renderer, f, f2, f3, f4);
    }

    @NotNull
    public static Renderer createOffsetRenderer(@NotNull Renderer renderer, double d, double d2, double d3, double d4) {
        return new OffsetRendererX(renderer, (float)d, (float)d2, (float)d3, (float)d4);
    }

    @NotNull
    public static Renderer createOffsetRenderer(@NotNull Renderer renderer, @NotNull Rectangle2D rectangle2D) {
        return new OffsetRendererX(renderer, (float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    @NotNull
    public static Renderer createRasterOffsetRenderer(@NotNull Renderer renderer, int n, int n2, int n3, int n4) {
        return new OffsetRasterRendererX(renderer, n, n2, n3, n4);
    }

    @Nullable
    public BasicRenderer getBasicRenderer() {
        return null;
    }

    @Nullable
    public RendererDescription getRendererDescription() {
        return null;
    }
}

