/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class AquaColorChooserDialog
extends JDialog {
    private Color initialColor;
    private JColorChooser chooserPane;

    public AquaColorChooserDialog(Dialog dialog, String string, boolean bl, Component component, JColorChooser jColorChooser) throws HeadlessException {
        super(dialog, string, bl);
        this.initColorChooserDialog(component, jColorChooser);
    }

    public AquaColorChooserDialog(Frame frame, String string, boolean bl, Component component, JColorChooser jColorChooser) throws HeadlessException {
        super(frame, string, bl);
        this.initColorChooserDialog(component, jColorChooser);
    }

    protected void initColorChooserDialog(Component component, JColorChooser jColorChooser) {
        this.setResizable(false);
        this.chooserPane = jColorChooser;
        Locale locale = this.getLocale();
        String string = UIManager.getString((Object)"ColorChooser.resetText", locale);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jColorChooser, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AquaColorChooserDialog.this.setVisible(false);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = jColorChooser.getInputMap(2);
        ActionMap actionMap = jColorChooser.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        JButton jButton = new JButton(string);
        jButton.getAccessibleContext().setAccessibleDescription(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AquaColorChooserDialog.this.reset();
            }
        });
        int n = AquaColorChooserDialog.getUIDefaultsInt("ColorChooser.resetMnemonic", locale, -1);
        if (n != -1) {
            jButton.setMnemonic(n);
        }
        jPanel.add(jButton);
        container.add((Component)jPanel, "South");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.putClientProperty("Window.style", "small");
        this.applyComponentOrientation((component == null ? jRootPane : component).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(component);
    }

    @Override
    public void show() {
        this.initialColor = this.chooserPane.getColor();
        super.show();
    }

    public void reset() {
        this.chooserPane.setColor(this.initialColor);
    }

    private static int getUIDefaultsInt(Object object, Locale locale, int n) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

