/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class ColorWellRenderer
extends Renderer {
    @NotNull
    private final ButtonConfiguration bg;
    @NotNull
    private final Renderer basic;

    public ColorWellRenderer(@NotNull ButtonConfiguration buttonConfiguration, @NotNull Renderer renderer) {
        this.bg = buttonConfiguration;
        this.basic = renderer;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        int n;
        int n2 = reusableCompositor.getRasterWidth();
        int n3 = reusableCompositor.getRasterHeight();
        int n4 = n = reusableCompositor.getScaleFactor();
        int n5 = 4 * n;
        int n6 = n4 * 2 + n5;
        this.basic.composeTo(reusableCompositor);
        BorderPainter borderPainter = new BorderPainter(n);
        reusableCompositor.renderFrom(borderPainter);
        int n7 = n6;
        int n8 = n6;
        int n9 = n2 - 2 * n6;
        int n10 = n3 - 2 * n6;
        reusableCompositor.erase(n7, n8, n9, n10);
    }

    protected class BorderPainter
    implements PainterExtension,
    BasicRenderer {
        private final Color outer;
        private final Color inner;
        private final int scaleFactor;

        public BorderPainter(int n) {
            this.scaleFactor = n;
            switch (ColorWellRenderer.this.bg.getState()) {
                case DISABLED: 
                case DISABLED_INACTIVE: {
                    this.outer = new Color(170, 170, 170, 127);
                    this.inner = new Color(168, 168, 168);
                    break;
                }
                case PRESSED: {
                    this.outer = new Color(175, 175, 175);
                    this.inner = new Color(86, 86, 86);
                    break;
                }
                default: {
                    this.outer = new Color(175, 175, 175);
                    this.inner = new Color(138, 138, 138);
                }
            }
        }

        @Override
        public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
            int n = (int)f;
            int n2 = (int)f2;
            graphics2D.setColor(this.outer);
            graphics2D.drawRect(0, 0, n, n2);
            graphics2D.setColor(this.inner);
            graphics2D.drawRect(5, 5, n - 10, n2 - 10);
        }

        @Override
        public void render(@NotNull int[] nArray, int n, int n2, float f, float f2) {
            this.drawRect(nArray, n, n2, this.outer, 0, 0, n, n2);
            this.drawRect(nArray, n, n2, this.inner, 5 * this.scaleFactor, 5 * this.scaleFactor, n - 10 * this.scaleFactor, n2 - 10 * this.scaleFactor);
        }

        protected void drawRect(int[] nArray, int n, int n2, Color color, int n3, int n4, int n5, int n6) {
            if (n5 > 0 && n6 > 0) {
                ColorModel colorModel = ReusableCompositor.getColorModel();
                ColorSpace colorSpace = colorModel.getColorSpace();
                float[] fArray = color.getComponents(colorSpace, null);
                float f = fArray[3];
                int n7 = 0;
                while (n7 < 3) {
                    int n8 = n7++;
                    fArray[n8] = fArray[n8] * f;
                }
                n7 = colorModel.getDataElement(fArray, 0);
                for (int i = 0; i < this.scaleFactor; ++i) {
                    this.drawRect1(nArray, n, n2, n7, n3 + i, n4 + i, n5 - 2 * i, n6 - 2 * i);
                }
            }
        }

        protected void drawRect1(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            if (n6 > 0 && n7 > 0) {
                int n8;
                for (n8 = n4; n8 < n4 + n6; ++n8) {
                    nArray[n5 * n + n8] = n3;
                    nArray[(n5 + n7 - 1) * n + n8] = n3;
                }
                for (n8 = n5 + 1; n8 < n5 + n7 - 1; ++n8) {
                    nArray[n8 * n + n4] = n3;
                    nArray[n8 * n + n4 + n6 - 1] = n3;
                }
            }
        }
    }
}

