/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import org.jetbrains.annotations.NotNull;

public class ImageUtils {
    @NotNull
    public static Image invertForDarkMode(@NotNull Image image) {
        return ImageUtils.createFilteredImage(image, new InvertImageForDarkModeFilter());
    }

    private static Image createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return ImageUtils.waitForImage(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Image waitForImage(@NotNull Image image2) {
        boolean[] blArray = new boolean[]{false};
        ImageObserver imageObserver = (image, n, n2, n3, n4, n5) -> {
            if (n4 != -1 && n5 != -1 && (n & 0x20) != 0 || (n & 0x80) != 0) {
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    blArray.notify();
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return false;
                }
            }
            return true;
        };
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            while (!blArray[0] && image2.getWidth(imageObserver) == -1) {
                try {
                    blArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return image2;
        }
    }

    private static class InvertImageForDarkModeFilter
    extends RGBImageFilter {
        public InvertImageForDarkModeFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = (int)((0.3 * (double)(n3 >> 16 & 0xFF) + 0.59 * (double)(n3 >> 8 & 0xFF) + 0.11 * (double)(n3 & 0xFF)) / 3.0);
            if ((n4 = (int)((double)(255 - n4) * 0.7)) < 0) {
                n4 = 0;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            return n3 & 0xFF000000 | n4 << 16 | n4 << 8 | n4 << 0;
        }
    }
}

