/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JavaSupport;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public abstract class RendererPainter
implements Painter {
    @NotNull
    protected final Renderer r;
    protected final float width;
    protected final float height;

    public RendererPainter(@NotNull Renderer renderer, float f, float f2) {
        this.r = renderer;
        this.width = f;
        this.height = f2;
    }

    @Override
    public void paint(@NotNull Graphics graphics, float f, float f2) {
        Graphics2D graphics2D;
        int n;
        int n2;
        int n3 = JavaSupport.getScaleFactor(graphics);
        Image image = this.getImage(n3, n2 = (int)Math.ceil(this.width), n = (int)Math.ceil(this.height));
        if (image != null && (graphics2D = JNRPlatformUtils.toGraphics2D(graphics)) != null) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
            graphics2D2.drawImage(image, affineTransform, null);
            graphics2D2.dispose();
        }
    }

    @Nullable
    protected Image getImage(int n, int n2, int n3) {
        return this.createImage(n, n2, n3);
    }

    @Nullable
    protected Image createImage(int n, int n2, int n3) {
        ReusableCompositor reusableCompositor = new ReusableCompositor();
        int n4 = n2 * n;
        int n5 = n3 * n;
        reusableCompositor.reset(n4, n5, n);
        this.r.composeTo(reusableCompositor);
        BufferedImage bufferedImage = reusableCompositor.getImage();
        return bufferedImage != null ? JavaSupport.createMultiResolutionImage(n2, n3, bufferedImage) : null;
    }
}

