/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.jnr.aqua.AquaUIPainter;

class AquaComboBoxButton
extends JButton {
    protected final JComboBox<Object> comboBox;
    protected final AquaComboBoxUI ui;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isRollover;

    protected AquaComboBoxButton(AquaComboBoxUI aquaComboBoxUI, JComboBox<Object> jComboBox) {
        super("");
        this.ui = aquaComboBoxUI;
        this.comboBox = jComboBox;
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() || bl);
            }
        });
        this.setEnabled(jComboBox.isEnabled());
        this.addMouseListener(new RolloverMouseListener());
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox == null || this.comboBox.isEnabled();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
    }

    private class RolloverMouseListener
    extends MouseAdapter {
        private RolloverMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AquaComboBoxButton.this.isRollover = true;
            AquaComboBoxButton.this.comboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AquaComboBoxButton.this.isRollover = false;
            AquaComboBoxButton.this.comboBox.repaint();
        }
    }
}

