/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class AquaDragRecognitionSupport {
    private int motionThreshold;
    private MouseEvent dndArmedEvent;
    private JComponent component;
    private static AquaDragRecognitionSupport instance;

    private static AquaDragRecognitionSupport getDragRecognitionSupport() {
        if (instance == null) {
            instance = new AquaDragRecognitionSupport();
        }
        return instance;
    }

    public static boolean mousePressed(MouseEvent mouseEvent) {
        return AquaDragRecognitionSupport.getDragRecognitionSupport().mousePressedImpl(mouseEvent);
    }

    public static MouseEvent mouseReleased(MouseEvent mouseEvent) {
        return AquaDragRecognitionSupport.getDragRecognitionSupport().mouseReleasedImpl(mouseEvent);
    }

    public static boolean mouseDragged(MouseEvent mouseEvent, BeforeDrag beforeDrag) {
        return AquaDragRecognitionSupport.getDragRecognitionSupport().mouseDraggedImpl(mouseEvent, beforeDrag);
    }

    private void clearState() {
        this.dndArmedEvent = null;
        this.component = null;
    }

    public static int mapDragOperationFromModifiers(MouseEvent mouseEvent, TransferHandler transferHandler) {
        if (transferHandler == null || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return 0;
        }
        return AquaDragRecognitionSupport.convertModifiersToDropAction(mouseEvent.getModifiersEx(), transferHandler.getSourceActions((JComponent)mouseEvent.getSource()));
    }

    private boolean mousePressedImpl(MouseEvent mouseEvent) {
        this.component = (JComponent)mouseEvent.getSource();
        if (AquaDragRecognitionSupport.mapDragOperationFromModifiers(mouseEvent, this.component.getTransferHandler()) != 0) {
            this.motionThreshold = DragSource.getDragThreshold();
            this.dndArmedEvent = mouseEvent;
            return true;
        }
        this.clearState();
        return false;
    }

    private MouseEvent mouseReleasedImpl(MouseEvent mouseEvent) {
        if (this.dndArmedEvent == null) {
            return null;
        }
        MouseEvent mouseEvent2 = null;
        if (mouseEvent.getSource() == this.component) {
            mouseEvent2 = this.dndArmedEvent;
        }
        this.clearState();
        return mouseEvent2;
    }

    private boolean mouseDraggedImpl(MouseEvent mouseEvent, BeforeDrag beforeDrag) {
        TransferHandler transferHandler;
        int n;
        int n2;
        if (this.dndArmedEvent == null) {
            return false;
        }
        if (mouseEvent.getSource() != this.component) {
            this.clearState();
            return false;
        }
        int n3 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
        if (Math.sqrt(n3 * n3 + (n2 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY())) * n2) > (double)this.motionThreshold && (n = AquaDragRecognitionSupport.mapDragOperationFromModifiers(mouseEvent, transferHandler = this.component.getTransferHandler())) != 0) {
            if (beforeDrag != null) {
                beforeDrag.dragStarting(this.dndArmedEvent);
            }
            transferHandler.exportAsDrag(this.component, this.dndArmedEvent, n);
            this.clearState();
        }
        return true;
    }

    private static int convertModifiersToDropAction(int n, int n2) {
        int n3;
        if (0 != (n & 0x2200)) {
            n3 = 1 & n2;
            if (n3 == 0) {
                n3 = 2 & n2;
            }
        } else if (0 != (n & 0x2200) && 0 != (n & 0x100)) {
            n3 = 0x40000000 & n2;
            if (n3 == 0) {
                n3 = 2 & n2;
            }
        } else {
            n3 = 2 & n2;
            if (n3 == 0) {
                n3 = 1 & n2;
            }
        }
        return n3;
    }

    public static interface BeforeDrag {
        public void dragStarting(MouseEvent var1);
    }
}

