/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.function.Function;
import org.violetlib.aqua.JavaSupport;

public abstract class AquaMultiResolutionImage
extends Image {
    protected final Image baseImage;
    protected final int baseImageWidth;
    protected final int baseImageHeight;

    public static Image createImage(int n, int n2, int[] nArray, int[] nArray2) {
        BufferedImage bufferedImage = JavaSupport.createImage(n, n2, nArray);
        if (nArray2 != null) {
            BufferedImage bufferedImage2 = JavaSupport.createImage(n * 2, n2 * 2, nArray2);
            return JavaSupport.createMultiResolutionImage(bufferedImage, bufferedImage2);
        }
        return JavaSupport.createMultiResolutionImage(bufferedImage);
    }

    public static Image apply(Image image, Function<Image, Image> function) {
        return JavaSupport.applyMapper(image, function);
    }

    public static Image apply(Image image, Mapper mapper) {
        return JavaSupport.applyMapper(image, mapper);
    }

    public static Image apply(Image image, ImageFilter imageFilter) {
        return JavaSupport.applyFilter(image, imageFilter);
    }

    protected AquaMultiResolutionImage(Image image) {
        this.baseImage = image;
        this.baseImageWidth = image.getWidth(null);
        this.baseImageHeight = image.getHeight(null);
    }

    protected AquaMultiResolutionImage(Image image, int n, int n2) {
        this.baseImage = image;
        this.baseImageWidth = n;
        this.baseImageHeight = n2;
    }

    public abstract AquaMultiResolutionImage map(Function<Image, Image> var1);

    public abstract AquaMultiResolutionImage map(Mapper var1);

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.baseImageWidth;
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.baseImageHeight;
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        return this.baseImage.getProperty(string, imageObserver);
    }

    @Override
    public ImageProducer getSource() {
        return this.baseImage.getSource();
    }

    @Override
    public Graphics getGraphics() {
        throw new UnsupportedOperationException();
    }

    public static interface Mapper {
        public BufferedImage map(Image var1, int var2);
    }
}

