/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaScrollPaneUI;
import org.violetlib.aqua.AquaUtils;

public class AquaOverlayScrollPaneLayout
extends ScrollPaneLayout
implements UIResource {
    protected boolean isHorizontalScrollBarNeeded;
    protected boolean isVerticalScrollBarNeeded;

    public boolean isHorizontalScrollBarNeeded() {
        return this.isHorizontalScrollBarNeeded;
    }

    public boolean isVerticalScrollBarNeeded() {
        return this.isVerticalScrollBarNeeded;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.sync(container);
        return super.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.sync(container);
        return super.minimumLayoutSize(container);
    }

    protected void sync(Container container) {
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        this.vsb = jScrollPane.getVerticalScrollBar();
        this.hsb = jScrollPane.getHorizontalScrollBar();
        this.viewport = jScrollPane.getViewport();
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Insets insets;
        Border border;
        Object object;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.sync(container);
        ScrollPaneUI scrollPaneUI = jScrollPane.getUI();
        if (scrollPaneUI instanceof AquaScrollPaneUI) {
            object = (AquaScrollPaneUI)scrollPaneUI;
            ((AquaScrollPaneUI)object).syncOverlayScrollPaneViewportHolderSize();
        }
        object = jScrollPane.getBounds();
        ((Rectangle)object).y = 0;
        ((Rectangle)object).x = 0;
        Insets insets2 = container.getInsets();
        ((Rectangle)object).x = insets2.left;
        ((Rectangle)object).y = insets2.top;
        ((Rectangle)object).width -= insets2.left + insets2.right;
        ((Rectangle)object).height -= insets2.top + insets2.bottom;
        boolean bl = !AquaScrollPaneUI.isRTLSupported || AquaUtils.isLeftToRight(jScrollPane);
        Rectangle rectangle = new Rectangle(0, ((Rectangle)object).y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int n2;
            rectangle.height = n2 = Math.min(((Rectangle)object).height, this.colHead.getPreferredSize().height);
            ((Rectangle)object).y += n2;
            ((Rectangle)object).height -= n2;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n3;
            rectangle2.width = n3 = Math.min(((Rectangle)object).width, this.rowHead.getPreferredSize().width);
            ((Rectangle)object).width -= n3;
            if (bl) {
                rectangle2.x = ((Rectangle)object).x;
                ((Rectangle)object).x += n3;
            } else {
                rectangle2.x = ((Rectangle)object).x + ((Rectangle)object).width;
            }
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            ((Rectangle)object).x += insets.left;
            ((Rectangle)object).y += insets.top;
            ((Rectangle)object).width -= insets.left + insets.right;
            ((Rectangle)object).height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        this.determineScrollBarsNeeded((Rectangle)object);
        if (this.viewport != null) {
            this.viewport.setBounds((Rectangle)object);
        }
        rectangle2.height = ((Rectangle)object).height + insets.top + insets.bottom;
        rectangle2.y = ((Rectangle)object).y - insets.top;
        rectangle.width = ((Rectangle)object).width + insets.left + insets.right;
        rectangle.x = ((Rectangle)object).x - insets.left;
        if (this.rowHead != null) {
            this.rowHead.setBounds(rectangle2);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(rectangle);
        }
        if (this.vsb != null) {
            if (this.isVerticalScrollBarNeeded) {
                n = this.vsb.getPreferredSize().width;
                this.vsb.setBounds(bl ? ((Rectangle)object).x + ((Rectangle)object).width - n : ((Rectangle)object).x, ((Rectangle)object).y, n, ((Rectangle)object).height);
            } else {
                this.vsb.setBounds(0, 0, 0, 0);
            }
        }
        if (this.hsb != null) {
            if (this.isHorizontalScrollBarNeeded) {
                n = this.hsb.getPreferredSize().height;
                this.hsb.setBounds(((Rectangle)object).x, ((Rectangle)object).y + ((Rectangle)object).height - n, ((Rectangle)object).width, n);
            } else {
                this.hsb.setBounds(0, 0, 0, 0);
            }
        }
        int n4 = n = this.rowHead != null && this.colHead != null && this.rowHead.isVisible() && this.colHead.isVisible() ? 1 : 0;
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(0, 0, 0, 0);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(0, 0, 0, 0);
        }
        if (this.upperLeft != null) {
            if (n != 0 && bl) {
                this.upperLeft.setBounds(rectangle2.x, rectangle.y, rectangle2.width, rectangle.height);
            } else {
                this.upperLeft.setBounds(0, 0, 0, 0);
            }
        }
        if (this.upperRight != null) {
            if (n != 0 && !bl) {
                this.upperRight.setBounds(rectangle2.x, rectangle.y, rectangle2.width, rectangle.height);
            } else {
                this.upperRight.setBounds(0, 0, 0, 0);
            }
        }
    }

    protected void determineScrollBarsNeeded(Rectangle rectangle) {
        boolean bl;
        Component component = this.viewport != null ? SwingUtilities.getUnwrappedView(this.viewport) : null;
        Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl = rectangle.width < 0 || rectangle.height < 0;
        if (!bl && component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            bl2 = scrollable.getScrollableTracksViewportWidth();
            bl3 = scrollable.getScrollableTracksViewportHeight();
        }
        this.isVerticalScrollBarNeeded = false;
        this.isHorizontalScrollBarNeeded = false;
        if (this.vsb != null && !bl && this.vsbPolicy != 21) {
            boolean bl5 = this.isVerticalScrollBarNeeded = !bl3 && dimension.height > dimension2.height;
        }
        if (this.hsb != null && !bl && this.hsbPolicy != 31) {
            this.isHorizontalScrollBarNeeded = !bl2 && dimension.width > dimension2.width;
        }
    }
}

